/*
 *	Copyright (c) 1999 RISS-Telecom Networking Center
 *	
 *	Copyright (c) 1993 The CAD lab of the
 *	Novosibirsk Institute of Broadcasting and Telecommunication
 *
 *	BPFT $Id: trafstatd.c,v 1.2 1993/11/01 12:07:15 bob Exp $
 *
 *	$Log: trafstatd.c,v $
 * Revision 1.2  1993/11/01  12:07:15  bob
 * Extended log file records
 *
 * Revision 1.1  1993/10/20  16:06:02  bob
 * Initial revision
 *
 *
 * Redistribution and use in source forms, with and without modification,
 * are permitted provided that this entire comment appears intact.
 * Redistribution in binary form may occur without any restrictions.
 *
 * THIS SOFTWARE IS PROVIDED ``AS IS'' WITHOUT ANY WARRANTIES OF ANY KIND.
 */

/*	trafstatd.c - traffic statictics daemon, invoke only via inetd	*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <errno.h>
#include <sys/socket.h>
#include <sys/time.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <netdb.h>

#include "pathnames.h"

#define	LINELEN		1024
#define	ENTRIES		50

void
main()
{
	register FILE *fp;
	register char *lp;
	char **ap, *av[ENTRIES + 1], line[LINELEN + 1];
	struct sockaddr_in sin;
	int sval = sizeof sin;
	struct hostent *hp;
	FILE *fplog;
	void error();

	if (getpeername(0, (struct sockaddr *)&sin, &sval) < 0)
		error("getpeername");

	if (!fgets(line, sizeof(line), stdin))
		exit(1);

	/*
	 * PATH_TRAFSTAT_LOG must exist & be owned by whoever this process
	 * runs as defined inetd.conf for this fopen to succeed.
	 */
	if ((fplog = fopen(PATH_TRAFSTAT_LOG, "a")) != NULL) {
		struct timeval tp;
		char *lastp = &line[strlen(line)];

		gettimeofday(&tp, (struct timezone *)NULL);
		hp = gethostbyaddr((char *) &sin.sin_addr,
		     sizeof(sin.sin_addr), sin.sin_family);
		(void) fprintf(fplog, "%.15s %s: ", ctime(&tp.tv_sec) + 4,
			       (hp == NULL) ? inet_ntoa(sin.sin_addr):
					     hp->h_name);
		if (lastp[-2] == 0xd) {
			lastp--;
			*(lastp-1) = '\n';
			*lastp = 0;
			fprintf(fplog, "telnet: ");
		} else
			fprintf(fplog, "trafstat: ");
		if (lastp[-1] != '\n')
			*lastp++ = '\n';
		fwrite(line, sizeof line[0], lastp - line, fplog);
		(void) fclose(fplog);
	}

	av[0] = "trafstat";
	for (lp = line, ap = &av[1];;) {
		*ap = strtok(lp, " \t\r\n");
		if (!*ap)
			break;
		if (++ap == av + ENTRIES)
			break;
		lp = NULL;
	}

	switch (fork()) {
		case 0:
		execv(PATH_TRAFSTAT, av);
		_exit(1);

		case -1:
		error("fork");
	}

	exit(0);
}

void
error(msg)
	const char *msg;
{

	fprintf(stderr, "trafstatd: %s: %s\n", msg, strerror(errno));
	exit(1);
}
