/*
 *	Copyright (c) 1999 RISS-Telecom Networking Center
 *
 *	Copyright (c) 1993 The CAD lab of the
 *	Novosibirsk Institute of Broadcasting and Telecommunication
 *
 *	BPFT $Id: traffic.h,v 1.4 1994/01/14 11:20:23 bob Exp $
 *
 *	$Log: traffic.h,v $
 * Revision 1.4  1994/01/14  11:20:23  bob
 * Little game with MAX params
 *
 * Revision 1.3  1994/01/06  14:54:00  bob
 * Modifications for new hash table format, removed any restriction.
 *
 * Revision 1.2  1993/12/05  13:45:24  bob
 * Increased limit of bytes up to MTU on loopback
 *
 * Revision 1.1  1993/10/20  16:03:10  bob
 * Initial revision
 *
 *
 * Redistribution and use in source forms, with and without modification,
 * are permitted provided that this entire comment appears intact.
 * Redistribution in binary form may occur without any restrictions.
 *
 * THIS SOFTWARE IS PROVIDED ``AS IS'' WITHOUT ANY WARRANTIES OF ANY KIND.
 */

/*	File with major definitions	*/

/*
 * Maximum size of the hashing memory table.
 * If you have big network traffic for example more then MAX_T_ENTRIES
 * records daily and you want backup it to file one per day then increase
 * it value.
 */
#define	MAX_T_ENTRIES		104800

/*
 * Maximum numder of the stored data records for autobackup to disk.
 */
#define MAX_TO_SAVE		MAX_T_ENTRIES - 75

/*
 * Magic number, this is offset used in hash algoritm to moved on
 * hash table. Do not edit, this is the nice numder.
 */
#define	E_OFFSET		7	/* XXX */

/*
 * This is the main hash function definition, produce start index
 * for begin hash table scan procedure. Very scientific formula. :)
 */
#define	HASHFUNC(p)	(((p)^((p)>>7)^((p)>>15)^((p)>>23)) % MAX_T_ENTRIES)

/*
 * Definition of the global counters.
 */
int n_entry = 0;		/* counter for number of records */

/*
 * Single record's format description.
 */
struct t_entry {
	struct in_addr	in_ip, out_ip;	/* src ip addr and dst ip addr */
	u_char	ip_protocol;	/* which protocol been used (/etc/protocols) */
	u_char	who_srv;	/* who was server flag */
	u_short	p_port;		/* which port been used (/etc/services) */
	u_long	n_psize;	/* how many bytes in ip datagrams passed */
	u_long	n_bytes;	/* how many data bytes passed */
} *entries;

#ifndef	IPPROTO_OSPF
#define	IPPROTO_OSPF	89
#endif
#ifndef	IPPROTO_IGMP
#define	IPPROTO_IGMP	2
#endif
