/*
 * Decompiled with CFR 0.152.
 */
package org.openide.modules;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import java.util.StringTokenizer;
import org.openide.modules.SpecificationVersion;
import org.openide.util.Utilities;

public final class Dependency {
    public static final int TYPE_MODULE = 1;
    public static final int TYPE_PACKAGE = 2;
    public static final int TYPE_JAVA = 3;
    public static final int TYPE_IDE = 4;
    public static final int TYPE_REQUIRES = 5;
    public static final int COMPARE_SPEC = 1;
    public static final int COMPARE_IMPL = 2;
    public static final int COMPARE_ANY = 3;
    public static final String IDE_NAME = System.getProperty("org.openide.major.version", "IDE");
    public static final SpecificationVersion IDE_SPEC = Dependency.makeSpec(System.getProperty("org.openide.specification.version"));
    public static final String IDE_IMPL = System.getProperty("org.openide.version");
    public static final String JAVA_NAME = "Java";
    public static final SpecificationVersion JAVA_SPEC = Dependency.makeSpec(System.getProperty("java.specification.version"));
    public static final String JAVA_IMPL = System.getProperty("java.version");
    public static final String VM_NAME = "VM";
    public static final SpecificationVersion VM_SPEC = Dependency.makeSpec(System.getProperty("java.vm.specification.version"));
    public static final String VM_IMPL = System.getProperty("java.vm.version");
    private final int type;
    private final int comparison;
    private final String name;
    private final String version;

    private Dependency(int n, String string, int n2, String string2) {
        this.type = n;
        this.name = string.intern();
        this.comparison = n2;
        this.version = string2 != null ? string2.intern() : null;
    }

    private static void checkCodeName(String string, boolean bl) throws IllegalArgumentException {
        int n;
        Object object;
        String string2;
        int n2 = string.indexOf(47);
        if (n2 == -1) {
            string2 = string;
        } else {
            if (!bl) {
                throw new IllegalArgumentException("No slash permitted in: " + string);
            }
            string2 = string.substring(0, n2);
            object = string.substring(n2 + 1);
            n = ((String)object).indexOf(45);
            try {
                int n3;
                if (n == -1) {
                    n3 = Integer.parseInt((String)object);
                    if (n3 < 0) {
                        throw new IllegalArgumentException("Negative release number: " + string);
                    }
                } else {
                    n3 = Integer.parseInt(((String)object).substring(0, n));
                    int n4 = Integer.parseInt(((String)object).substring(n + 1));
                    if (n3 < 0) {
                        throw new IllegalArgumentException("Negative release number: " + string);
                    }
                    if (n4 <= n3) {
                        throw new IllegalArgumentException("Release number range must be increasing: " + string);
                    }
                }
            }
            catch (NumberFormatException numberFormatException) {
                throw new IllegalArgumentException(numberFormatException.toString());
            }
        }
        object = new StringTokenizer(string2, ".", true);
        if (((StringTokenizer)object).countTokens() % 2 == 0) {
            throw new NumberFormatException("Even number of pieces: " + string2);
        }
        n = 1;
        while (((StringTokenizer)object).hasMoreTokens()) {
            if (n != 0) {
                n = 0;
                String string3 = ((StringTokenizer)object).nextToken();
                if (Utilities.isJavaIdentifier((String)string3) || "enum".equals(string3)) continue;
                throw new IllegalArgumentException("Bad package component in " + string2);
            }
            if (!".".equals(((StringTokenizer)object).nextToken())) {
                throw new NumberFormatException("Expected dot in code name: " + string2);
            }
            n = 1;
        }
    }

    public static Set create(int n, String string) throws IllegalArgumentException {
        if (string == null) {
            return Collections.EMPTY_SET;
        }
        HashSet<Object> hashSet = new HashSet<Object>(5);
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        if (!stringTokenizer.hasMoreTokens()) {
            throw new IllegalArgumentException("No deps given: \"" + string + "\"");
        }
        HashMap<DependencyKey, Object> hashMap = new HashMap<DependencyKey, Object>(10);
        while (stringTokenizer.hasMoreTokens()) {
            DependencyKey dependencyKey;
            String string2;
            int n2;
            Object object;
            String string3 = stringTokenizer.nextToken();
            StringTokenizer stringTokenizer2 = new StringTokenizer(string3, " \t\n\r");
            if (!stringTokenizer2.hasMoreTokens()) {
                throw new IllegalArgumentException("No name in dependency: " + string3);
            }
            String string4 = stringTokenizer2.nextToken();
            if (stringTokenizer2.hasMoreTokens()) {
                object = stringTokenizer2.nextToken();
                if (((String)object).equals(">")) {
                    n2 = 1;
                } else if (((String)object).equals("=")) {
                    n2 = 2;
                } else {
                    throw new IllegalArgumentException("Strange comparison string: " + (String)object);
                }
                if (!stringTokenizer2.hasMoreTokens()) {
                    throw new IllegalArgumentException("Comparison string without version: " + string3);
                }
                string2 = stringTokenizer2.nextToken();
                if (stringTokenizer2.hasMoreTokens()) {
                    throw new IllegalArgumentException("Trailing garbage in dependency: " + string3);
                }
                if (n2 == 1) {
                    try {
                        new SpecificationVersion(string2);
                    }
                    catch (NumberFormatException numberFormatException) {
                        throw new IllegalArgumentException(numberFormatException.toString());
                    }
                }
            } else {
                n2 = 3;
                string2 = null;
            }
            if (n == 1) {
                Dependency.checkCodeName(string4, true);
                if (string4.indexOf(45) != -1 && n2 == 2) {
                    throw new IllegalArgumentException("Cannot have an implementation dependency on a ranged release version: " + string3);
                }
            } else if (n == 2) {
                int n3 = string4.indexOf(91);
                if (n3 != -1) {
                    if (n3 > 0) {
                        Dependency.checkCodeName(string4.substring(0, n3), false);
                    }
                    if (string4.charAt(string4.length() - 1) != ']') {
                        throw new IllegalArgumentException("No close bracket on package dep: " + string4);
                    }
                    Dependency.checkCodeName(string4.substring(n3 + 1, string4.length() - 1), false);
                } else {
                    Dependency.checkCodeName(string4, false);
                }
                if (n3 == 0 && n2 != 3) {
                    throw new IllegalArgumentException("Cannot use a version comparison on a package dependency when only a sample class is given");
                }
                if (n3 > 0 && string4.substring(n3 + 1, string4.length() - 1).indexOf(46) != -1) {
                    throw new IllegalArgumentException("Cannot have a sample class with dots when package is specified");
                }
            } else if (n == 3) {
                if (!string4.equals(JAVA_NAME) && !string4.equals(VM_NAME)) {
                    throw new IllegalArgumentException("Java dependency must be on \"Java\" or \"VM\": " + string4);
                }
                if (n2 == 3) {
                    throw new IllegalArgumentException("Must give a comparison for a Java dep: " + string);
                }
            } else if (n == 4) {
                if (!string4.equals("IDE")) {
                    boolean bl;
                    int n4 = string4.indexOf("/");
                    if (n4 == -1) {
                        bl = false;
                    } else {
                        if (!string4.substring(0, n4).equals("IDE")) {
                            boolean bl2 = false;
                        }
                        try {
                            int n5 = Integer.parseInt(string4.substring(n4 + 1));
                            bl = n5 >= 0;
                        }
                        catch (NumberFormatException numberFormatException) {
                            bl = false;
                        }
                    }
                    if (!bl) {
                        throw new IllegalArgumentException("Invalid IDE dependency: " + string4);
                    }
                }
                if (n2 == 3) {
                    throw new IllegalArgumentException("Must give a comparison for an IDE dep: " + string);
                }
            } else if (n == 5) {
                if (n2 != 3) {
                    throw new IllegalArgumentException("Cannot give a comparison for a token requires dep: " + string);
                }
                Dependency.checkCodeName(string4, false);
            } else {
                throw new IllegalArgumentException("unknown type");
            }
            if (hashMap.containsKey(dependencyKey = new DependencyKey((Dependency)(object = new Dependency(n, string4, n2, string2))))) {
                throw new IllegalArgumentException("Dependency " + object + " duplicates the similar dependency " + hashMap.get(dependencyKey));
            }
            hashSet.add(object);
            hashMap.put(dependencyKey, object);
        }
        return hashSet;
    }

    public final int getType() {
        return this.type;
    }

    public final String getName() {
        return this.name;
    }

    public final int getComparison() {
        return this.comparison;
    }

    public final String getVersion() {
        return this.version;
    }

    public boolean equals(Object object) {
        if (object.getClass() != Dependency.class) {
            return false;
        }
        Dependency dependency = (Dependency)object;
        return this.type == dependency.type && this.comparison == dependency.comparison && this.name.equals(dependency.name) && Utilities.compareObjects((Object)this.version, (Object)dependency.version);
    }

    public int hashCode() {
        return 0xBC7E3 ^ this.type ^ this.name.hashCode();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(100);
        if (this.type == 1) {
            stringBuffer.append("module ");
        } else if (this.type == 2) {
            stringBuffer.append("package ");
        } else if (this.type == 5) {
            stringBuffer.append("token ");
        }
        stringBuffer.append(this.name);
        if (this.comparison == 2) {
            stringBuffer.append(" = ");
            stringBuffer.append(this.version);
        } else if (this.comparison == 1) {
            stringBuffer.append(" > ");
            stringBuffer.append(this.version);
        }
        return stringBuffer.toString();
    }

    private static SpecificationVersion makeSpec(String string) {
        if (string != null) {
            try {
                return new SpecificationVersion(string);
            }
            catch (NumberFormatException numberFormatException) {
                System.err.println("WARNING: invalid specification version: " + string);
                while (true) {
                    string = string.substring(0, string.length() - 1);
                    try {
                        return new SpecificationVersion(string);
                    }
                    catch (NumberFormatException numberFormatException2) {
                        if (string.length() > 0) continue;
                    }
                    break;
                }
            }
        }
        return new SpecificationVersion("0");
    }

    private static final class DependencyKey {
        private final int type;
        private final String name;

        public DependencyKey(Dependency dependency) {
            this.type = dependency.getType();
            switch (this.type) {
                case 1: 
                case 4: {
                    String string = dependency.getName();
                    int n = string.lastIndexOf(47);
                    if (n == -1) {
                        this.name = string;
                        break;
                    }
                    this.name = string.substring(0, n);
                    break;
                }
                case 2: {
                    String string = dependency.getName();
                    int n = string.indexOf(91);
                    if (n != -1) {
                        if (n == 0) {
                            this.name = string;
                            break;
                        }
                        this.name = string.substring(0, n);
                        break;
                    }
                    this.name = string;
                    break;
                }
                default: {
                    this.name = dependency.getName();
                }
            }
        }

        public int hashCode() {
            return this.name.hashCode();
        }

        public boolean equals(Object object) {
            return object instanceof DependencyKey && ((DependencyKey)object).name.equals(this.name) && ((DependencyKey)object).type == this.type;
        }

        public String toString() {
            return "DependencyKey[" + this.name + "," + this.type + "]";
        }
    }
}

