/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javahelp;

import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.AWTEventListener;
import java.awt.event.WindowEvent;
import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Stack;
import javax.help.HelpSet;
import javax.help.HelpSetException;
import javax.help.JHelp;
import javax.help.Map;
import javax.swing.BorderFactory;
import javax.swing.BoundedRangeModel;
import javax.swing.DefaultBoundedRangeModel;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressHandleFactory;
import org.netbeans.modules.javahelp.AbstractHelp;
import org.netbeans.modules.javahelp.HelpAction;
import org.netbeans.modules.javahelp.Installer;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.Task;
import org.openide.util.TaskListener;
import org.openide.util.Utilities;
import org.openide.windows.WindowManager;

public final class JavaHelp
extends AbstractHelp
implements AWTEventListener {
    private HelpSet master = null;
    private Map availableJHelps = new HashMap();
    private JFrame frameViewer = null;
    private JDialog dialogViewer = null;
    private boolean reparentToFrameLater = false;
    private Stack currentModalDialogs = new Stack();
    private boolean currentModalDialogsReady = false;
    private JHelp lastJH = null;
    private static final BoundedRangeModel mergeModel = new DefaultBoundedRangeModel(0, 0, 0, 0);
    private ProgressHandle progressHandle = null;
    private static RequestProcessor helpLoader = null;
    private static int modalExcludedSupported = -1;

    public JavaHelp() {
        Installer.err.log("JavaHelp created");
        if (!JavaHelp.isModalExcludedSupported()) {
            Toolkit.getDefaultToolkit().addAWTEventListener(this, 64L);
        }
    }

    void deactivate() {
        if (!JavaHelp.isModalExcludedSupported()) {
            Toolkit.getDefaultToolkit().removeAWTEventListener(this);
        }
    }

    private synchronized HelpSet getMaster() {
        if (this.master == null) {
            ClassLoader classLoader = JavaHelp.class.getClassLoader();
            try {
                HelpSet helpSet;
                this.master = new HelpSet(classLoader, new URL("nbresloc:/org/netbeans/modules/javahelp/resources/masterHelpSet.xml"));
                Collection collection = this.getHelpSets();
                ArrayList<HelpSet> arrayList = new ArrayList<HelpSet>(Math.min(1, collection.size()));
                Iterator iterator = collection.iterator();
                while (iterator.hasNext()) {
                    helpSet = (HelpSet)iterator.next();
                    if (!this.shouldMerge(helpSet)) continue;
                    arrayList.add(helpSet);
                }
                mergeModel.setValue(0);
                mergeModel.setMaximum(arrayList.size());
                iterator = arrayList.iterator();
                while (iterator.hasNext()) {
                    helpSet = (HelpSet)iterator.next();
                    this.master.add(helpSet);
                    mergeModel.setValue(mergeModel.getValue() + 1);
                }
            }
            catch (HelpSetException helpSetException) {
                Installer.err.notify((Throwable)helpSetException);
                this.master = new HelpSet();
            }
            catch (MalformedURLException malformedURLException) {
                malformedURLException.printStackTrace();
                throw new IllegalStateException();
            }
        }
        return this.master;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void helpSetsChanged() {
        JavaHelp javaHelp = this;
        synchronized (javaHelp) {
            this.master = null;
        }
        mergeModel.setValue(0);
        mergeModel.setMaximum(0);
        super.helpSetsChanged();
    }

    private Dialog currentModalDialog() {
        if (this.currentModalDialogs.empty()) {
            Window window = HelpAction.WindowActivatedDetector.getCurrentActivatedWindow();
            if (!this.currentModalDialogsReady && window instanceof Dialog && !(window instanceof ProgressDialog) && window != this.dialogViewer && ((Dialog)window).isModal()) {
                Installer.err.log("Early-opened modal dialog: " + window.getName() + " [" + ((Dialog)window).getTitle() + "]");
                return (Dialog)window;
            }
            return null;
        }
        return (Dialog)this.currentModalDialogs.peek();
    }

    private void ensureFrameViewer() {
        Installer.err.log("ensureFrameViewer");
        if (this.frameViewer == null) {
            Installer.err.log("\tcreating new");
            this.frameViewer = new JFrame();
            this.frameViewer.setIconImage(Utilities.loadImage((String)"org/netbeans/modules/javahelp/resources/help.gif"));
            this.frameViewer.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage((Class)JavaHelp.class, (String)"ACSD_JavaHelp_viewer"));
            if (JavaHelp.isModalExcludedSupported()) {
                JavaHelp.setModalExcluded(this.frameViewer);
                this.frameViewer.getRootPane().putClientProperty("netbeans.helpframe", Boolean.TRUE);
            }
        }
    }

    private void ensureDialogViewer() {
        Installer.err.log("ensureDialogViewer");
        Dialog dialog = this.currentModalDialog();
        if (this.dialogViewer != null && this.dialogViewer.getOwner() != dialog) {
            Installer.err.log("\tdisposing old");
            this.dialogViewer.setVisible(false);
            this.dialogViewer.dispose();
            this.dialogViewer = null;
        }
        if (this.dialogViewer == null) {
            Installer.err.log("\tcreating new");
            this.dialogViewer = new JDialog(dialog);
            this.dialogViewer.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage((Class)JavaHelp.class, (String)"ACSD_JavaHelp_viewer"));
        }
    }

    private void displayHelpInFrame(JHelp jHelp) {
        Installer.err.log("displayHelpInFrame");
        if (jHelp == null) {
            jHelp = this.lastJH;
        }
        if (jHelp == null) {
            throw new IllegalStateException();
        }
        boolean bl = this.frameViewer == null;
        this.ensureFrameViewer();
        if (this.dialogViewer != null) {
            Installer.err.log("\tdisposing old dialog");
            this.dialogViewer.setVisible(false);
            this.dialogViewer.getContentPane().removeAll();
            this.dialogViewer.dispose();
            this.dialogViewer = null;
        }
        if (this.frameViewer.getContentPane().getComponentCount() > 0 && this.frameViewer.getContentPane().getComponent(0) != jHelp) {
            Installer.err.log("\treplacing content");
            this.frameViewer.getContentPane().removeAll();
        }
        if (this.frameViewer.getContentPane().getComponentCount() == 0) {
            Installer.err.log("\tadding content");
            this.frameViewer.getContentPane().add((Component)jHelp, "Center");
            this.frameViewer.setTitle(jHelp.getModel().getHelpSet().getTitle());
            this.frameViewer.pack();
        }
        if (bl) {
            Dimension dimension = Utilities.getUsableScreenBounds().getSize();
            Dimension dimension2 = this.frameViewer.getSize();
            if (dimension2.width > dimension.width) {
                dimension2.width = dimension.width;
                this.frameViewer.setSize(dimension2);
            }
            if (dimension2.height > dimension.height) {
                dimension2.height = dimension.height;
                this.frameViewer.setSize(dimension2);
            }
            this.frameViewer.setLocation(new Point(dimension.width - this.frameViewer.getSize().width, 0));
        }
        this.frameViewer.setState(0);
        if (this.frameViewer.isVisible()) {
            this.frameViewer.repaint();
            this.frameViewer.toFront();
            Installer.err.log("\talready visible, just repainting");
        } else {
            this.frameViewer.setVisible(true);
        }
        this.lastJH = jHelp;
    }

    private void displayHelpInDialog(JHelp jHelp) {
        Installer.err.log("displayHelpInDialog");
        if (jHelp == null) {
            jHelp = this.lastJH;
        }
        if (jHelp == null) {
            throw new IllegalStateException();
        }
        this.ensureDialogViewer();
        Rectangle rectangle = null;
        if (this.frameViewer != null) {
            Installer.err.log("\thiding old frame viewer");
            if (this.frameViewer.isVisible()) {
                rectangle = this.frameViewer.getBounds();
                this.frameViewer.setVisible(false);
            }
            this.frameViewer.getContentPane().removeAll();
        }
        if (this.dialogViewer.getContentPane().getComponentCount() > 0 && this.dialogViewer.getContentPane().getComponent(0) != jHelp) {
            Installer.err.log("\tchanging content");
            this.dialogViewer.getContentPane().removeAll();
        }
        if (this.dialogViewer.getContentPane().getComponentCount() == 0) {
            Installer.err.log("\tadding content");
            this.dialogViewer.getContentPane().add((Component)jHelp, "Center");
            this.dialogViewer.setTitle(jHelp.getModel().getHelpSet().getTitle());
            this.dialogViewer.pack();
        }
        if (rectangle != null) {
            Installer.err.log("\tcopying bounds from frame viewer: " + rectangle);
            this.dialogViewer.setBounds(rectangle);
        }
        this.rearrange(this.currentModalDialog());
        if (this.dialogViewer.isVisible()) {
            Installer.err.log("\talready visible, just repainting");
            this.dialogViewer.repaint();
        } else {
            this.dialogViewer.show();
        }
        this.lastJH = jHelp;
    }

    public void showHelp(HelpCtx helpCtx, final boolean bl) {
        HelpCtx helpCtx2;
        HelpCtx helpCtx3 = helpCtx2 = helpCtx != null ? helpCtx : HelpCtx.DEFAULT_HELP;
        if (!SwingUtilities.isEventDispatchThread()) {
            Installer.err.log("showHelp later...");
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    JavaHelp.this.showHelp(helpCtx2, bl);
                }
            });
            return;
        }
        Installer.err.log("showing help: " + helpCtx2);
        final HelpSet[] helpSetArray = new HelpSet[1];
        Runnable runnable = new Runnable(){

            public void run() {
                String string = helpCtx2.getHelpID();
                if (bl || helpCtx2.equals((Object)HelpCtx.DEFAULT_HELP) || string == null) {
                    Installer.err.log("getting master...");
                    helpSetArray[0] = JavaHelp.this.getMaster();
                    Installer.err.log("getting master...done");
                }
                if (helpSetArray[0] == null || string != null && !helpSetArray[0].getCombinedMap().isValidID(string, helpSetArray[0])) {
                    Installer.err.log("finding help set for " + string + "...");
                    helpSetArray[0] = JavaHelp.this.findHelpSetForID(string);
                    Installer.err.log("finding help set for " + string + "...done");
                }
            }
        };
        if (this.master == null) {
            Installer.err.log("showing progress dialog...");
            this.progressHandle = ProgressHandleFactory.createHandle((String)"");
            this.createProgressDialog(runnable, this.currentModalDialog()).show();
            this.progressHandle.finish();
            Installer.err.log("dialog done.");
        } else {
            runnable.run();
        }
        HelpSet helpSet = helpSetArray[0];
        if (helpSet == null) {
            return;
        }
        JHelp jHelp = this.createJHelp(helpSet);
        if (jHelp == null) {
            throw new IllegalStateException();
        }
        if (JavaHelp.isModalExcludedSupported()) {
            this.displayHelpInFrame(jHelp);
        } else if (this.currentModalDialog() == null) {
            Installer.err.log("showing as non-dialog");
            this.displayHelpInFrame(jHelp);
        } else {
            Installer.err.log("showing as dialog");
            this.displayHelpInDialog(jHelp);
        }
        this.displayInJHelp(jHelp, helpCtx2.getHelpID(), helpCtx2.getHelp());
    }

    public void eventDispatched(AWTEvent aWTEvent) {
        WindowEvent windowEvent = (WindowEvent)aWTEvent;
        int n = windowEvent.getID();
        Window window = windowEvent.getWindow();
        if (n == 201 && window == this.dialogViewer) {
            Installer.err.log("7. Dialog viewer open. Viewer closed. rTFL = false.");
            this.reparentToFrameLater = false;
        }
        if (n != 202 && n != 200) {
            return;
        }
        if (window instanceof Dialog) {
            Dialog dialog = (Dialog)window;
            String string = dialog.getClass().getName();
            if (dialog.isModal() && !(dialog instanceof ProgressDialog) || dialog == this.dialogViewer) {
                if ("sun.awt.windows.WPageDialog".equals(string) || "sun.awt.windows.WPrintDialog".equals(string) || "sun.print.ServiceDialog".equals(string) || "apple.awt.CPrinterJobDialog".equals(string) || "apple.awt.CPrinterPageDialog".equals(string)) {
                    return;
                }
                if (dialog instanceof JDialog && "true".equals(((JDialog)dialog).getRootPane().getClientProperty("javahelp.ignore.modality"))) {
                    return;
                }
                if (Installer.err.isLoggable(1)) {
                    Installer.err.log("modal (or viewer) dialog event: " + windowEvent + " [" + dialog.getTitle() + "]");
                }
                if (n == 202) {
                    if (dialog != this.dialogViewer) {
                        if (dialog == this.currentModalDialog()) {
                            if (!this.currentModalDialogs.isEmpty()) {
                                this.currentModalDialogs.pop();
                                this.currentModalDialogsReady = true;
                            } else {
                                Installer.err.notify(1, (Throwable)new IllegalStateException("Please see IZ #24993"));
                            }
                            this.showDialogStack();
                            if (!(this.frameViewer != null && this.frameViewer.isVisible() && this.frameViewer.getState() != 1 || this.dialogViewer != null && this.dialogViewer.isVisible())) {
                                if (!this.reparentToFrameLater) {
                                    Installer.err.log("2. No viewer open, !rTFL. Top dialog closed. Pop it.");
                                } else if (this.currentModalDialog() == null) {
                                    Installer.err.log("3. No viewer open, rTFL. Only top dialog closed. Pop it. Create frame viewer.");
                                    if (this.frameViewer != null) {
                                        this.frameViewer.dispose();
                                        this.frameViewer = null;
                                    }
                                    this.displayHelpInFrame(null);
                                } else {
                                    Installer.err.log("4. No viewer open, rTFL. Some top dialog closed. Pop it. Create dialog viewer.");
                                    this.displayHelpInDialog(null);
                                }
                            } else if (this.dialogViewer != null && this.dialogViewer.isVisible()) {
                                Installer.err.log(16, "WARNING - dialogViewer should not still be open");
                            } else {
                                Installer.err.log(16, "WARNING - frameViewer visible when a dialog was closing");
                            }
                        } else {
                            Installer.err.log("some random modal dialog closed: " + dialog.getName() + " [" + dialog.getTitle() + "]");
                        }
                    }
                } else if (dialog != this.dialogViewer) {
                    this.currentModalDialogs.push(dialog);
                    this.showDialogStack();
                    if (!(this.frameViewer != null && this.frameViewer.isVisible() && this.frameViewer.getState() != 1 || this.dialogViewer != null && this.dialogViewer.isVisible())) {
                        Installer.err.log("1. No viewer open. Dialog opened. Push it on stack. rTFL = false.");
                        this.reparentToFrameLater = false;
                    } else if (this.frameViewer != null && this.frameViewer.isVisible()) {
                        Installer.err.log("5. Frame viewer open. Dialog opened. Push it. Close frame viewer. Create dialog viewer. rTFL = true.");
                        this.displayHelpInDialog(null);
                        this.reparentToFrameLater = true;
                    } else if (this.dialogViewer != null && this.dialogViewer.isVisible()) {
                        Installer.err.log("6. Dialog viewer open. Dialog opened. Push it. Reparent dialog viewer.");
                        this.displayHelpInDialog(null);
                    } else {
                        Installer.err.log(16, "WARNING - logic error");
                    }
                }
            }
        }
    }

    private void showDialogStack() {
        if (Installer.err.isLoggable(1)) {
            StringBuffer stringBuffer = new StringBuffer("new modal dialog stack: [");
            boolean bl = true;
            Iterator iterator = this.currentModalDialogs.iterator();
            while (iterator.hasNext()) {
                if (bl) {
                    bl = false;
                } else {
                    stringBuffer.append(", ");
                }
                stringBuffer.append(((Dialog)iterator.next()).getTitle());
            }
            stringBuffer.append("]");
            Installer.err.log(stringBuffer.toString());
        }
    }

    private void rearrange(Dialog dialog) {
        Rectangle rectangle;
        Rectangle rectangle2 = dialog.getBounds();
        if (rectangle2.intersects(rectangle = this.dialogViewer.getBounds())) {
            Installer.err.log("modal dialog and dialog viewer overlap");
            Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
            int n = dimension.width - rectangle2.width - rectangle.width;
            int n2 = dimension.height - rectangle2.height - rectangle.height;
            if (n >= n2) {
                int n3 = rectangle2.x + rectangle2.width / 2;
                int n4 = rectangle.x + rectangle.width / 2;
                if (n3 <= n4) {
                    Installer.err.log(" send help to the right");
                    if (rectangle2.x + rectangle2.width + rectangle.width <= dimension.width) {
                        Installer.err.log("there is enough place fo help");
                        rectangle.x = rectangle2.x + rectangle2.width;
                    } else {
                        Installer.err.log("there is not enough place");
                        if (rectangle2.width + rectangle.width < dimension.width) {
                            Installer.err.log("relocate both");
                            rectangle.x = dimension.width - rectangle.width;
                            rectangle2.x = rectangle.x - rectangle2.width;
                        } else {
                            Installer.err.log("relocate both and resize help");
                            rectangle2.x = 0;
                            rectangle.x = rectangle2.width;
                            rectangle.width = dimension.width - rectangle2.width;
                        }
                    }
                } else {
                    Installer.err.log("send help to the left");
                    if (rectangle2.x - rectangle.width > 0) {
                        Installer.err.log("there is enough place for help");
                        rectangle.x = rectangle2.x - rectangle.width;
                    } else {
                        Installer.err.log("there is not enough place");
                        if (rectangle2.width + rectangle.width < dimension.width) {
                            Installer.err.log("relocate both");
                            rectangle.x = 0;
                            rectangle2.x = rectangle.width;
                        } else {
                            Installer.err.log("relocate both and resize help");
                            rectangle2.x = dimension.width - rectangle2.width;
                            rectangle.x = 0;
                            rectangle.width = rectangle2.x;
                        }
                    }
                }
            } else {
                int n5 = rectangle2.y + rectangle2.height / 2;
                int n6 = rectangle.y + rectangle.height / 2;
                if (n5 <= n6) {
                    Installer.err.log(" send help to the bottom");
                    if (rectangle2.y + rectangle2.height + rectangle.height <= dimension.height) {
                        Installer.err.log("there is enough place fo help");
                        rectangle.y = rectangle2.y + rectangle2.height;
                    } else {
                        Installer.err.log("there is not enough place");
                        if (rectangle2.height + rectangle.height < dimension.height) {
                            Installer.err.log("relocate both");
                            rectangle.y = dimension.height - rectangle.height;
                            rectangle2.y = rectangle.y - rectangle2.height;
                        } else {
                            Installer.err.log("relocate both and resize help");
                            rectangle2.y = 0;
                            rectangle.y = rectangle2.height;
                            rectangle.height = dimension.height - rectangle2.height;
                        }
                    }
                } else {
                    Installer.err.log("send help to the top");
                    if (rectangle2.y - rectangle.height > 0) {
                        Installer.err.log("there is enough place for help");
                        rectangle.y = rectangle2.y - rectangle.height;
                    } else {
                        Installer.err.log("there is not enough place");
                        if (rectangle2.height + rectangle.height < dimension.height) {
                            Installer.err.log("relocate both");
                            rectangle.y = 0;
                            rectangle2.y = rectangle.height;
                        } else {
                            Installer.err.log("relocate both and resize help");
                            rectangle2.y = dimension.height - rectangle2.height;
                            rectangle.y = 0;
                            rectangle.height = rectangle2.y;
                        }
                    }
                }
            }
            dialog.setBounds(rectangle2);
            this.dialogViewer.setBounds(rectangle);
        }
    }

    private JDialog createProgressDialog(Runnable runnable, Dialog dialog) {
        return dialog == null ? new ProgressDialog(runnable, WindowManager.getDefault().getMainWindow()) : new ProgressDialog(runnable, dialog);
    }

    private static RequestProcessor getHelpLoader() {
        if (helpLoader == null) {
            helpLoader = new RequestProcessor("org.netbeans.modules.javahelp.JavaHelp");
        }
        return helpLoader;
    }

    private HelpSet findHelpSetForID(String string) {
        if (string != null) {
            Iterator iterator = this.getHelpSets().iterator();
            while (iterator.hasNext()) {
                HelpSet helpSet = (HelpSet)iterator.next();
                if (!helpSet.getCombinedMap().isValidID(string, helpSet)) continue;
                return helpSet;
            }
            JavaHelp.warnBadID(string);
        }
        return this.getMaster();
    }

    public Boolean isValidID(String string, boolean bl) {
        if (bl || this.helpSetsReady()) {
            Iterator iterator = this.getHelpSets().iterator();
            if ("org.netbeans.api.javahelp.MASTER_ID".equals(string)) {
                if (iterator.hasNext()) {
                    Installer.err.log("master id, and >=1 help set");
                    return Boolean.TRUE;
                }
                Installer.err.log("master id, and 0 help sets");
                return Boolean.FALSE;
            }
            while (iterator.hasNext()) {
                HelpSet helpSet = (HelpSet)iterator.next();
                if (!helpSet.getCombinedMap().isValidID(string, helpSet)) continue;
                Installer.err.log("found normal valid id " + string + " in " + helpSet.getTitle());
                return Boolean.TRUE;
            }
            Installer.err.log("did not find id " + string);
            return Boolean.FALSE;
        }
        Installer.err.log("not checking " + string + " specifically");
        return null;
    }

    private static void warnBadID(String string) {
        Installer.err.log(16, NbBundle.getMessage((Class)JavaHelp.class, (String)"MSG_jh_id_not_found", (Object)string));
    }

    private synchronized void displayInJHelp(JHelp jHelp, String string, URL uRL) {
        if (jHelp == null) {
            throw new NullPointerException();
        }
        if (jHelp.getModel() == null) {
            throw new IllegalArgumentException();
        }
        Installer.err.log("displayInJHelp: " + string + " " + uRL);
        try {
            if (string != null && !string.equals("org.netbeans.api.javahelp.MASTER_ID")) {
                HelpSet helpSet = jHelp.getModel().getHelpSet();
                if (helpSet.getCombinedMap().isValidID(string, helpSet)) {
                    jHelp.setCurrentID(string);
                } else {
                    JavaHelp.warnBadID(string);
                }
            } else if (uRL != null) {
                jHelp.setCurrentURL(uRL);
            }
        }
        catch (RuntimeException runtimeException) {
            Installer.err.notify((Throwable)runtimeException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private JHelp createJHelp(HelpSet helpSet) {
        JHelp jHelp;
        Object object;
        if (helpSet == null) {
            throw new NullPointerException();
        }
        Object object2 = this.availableJHelps;
        synchronized (object2) {
            object = (Reference)this.availableJHelps.get(helpSet);
            if (object != null && (jHelp = (JHelp)((Reference)object).get()) != null) {
                return jHelp;
            }
        }
        object2 = null;
        try {
            object2 = helpSet.getTitle();
            jHelp = new JHelp(helpSet);
        }
        catch (RuntimeException runtimeException) {
            if (object2 != null) {
                Installer.err.annotate((Throwable)runtimeException, 0, "While trying to display: " + (String)object2, null, null, null);
            }
            Installer.err.notify((Throwable)runtimeException);
            return new JHelp();
        }
        object = this.availableJHelps;
        synchronized (object) {
            this.availableJHelps.put(helpSet, new SoftReference<JHelp>(jHelp));
        }
        try {
            object = helpSet.getHomeID();
            if (object != null) {
                jHelp.setCurrentID((Map.ID)object);
            }
        }
        catch (Exception exception) {
            Installer.err.notify(1, (Throwable)exception);
        }
        return jHelp;
    }

    private static boolean isModalExcludedSupported() {
        if (modalExcludedSupported == -1) {
            modalExcludedSupported = 0;
            try {
                Class<?> clazz = Class.forName("sun.awt.SunToolkit");
                Method method = clazz.getMethod("isModalExcludedSupported", null);
                Boolean bl = (Boolean)method.invoke(null, null);
                modalExcludedSupported = bl != false ? 1 : 0;
                Installer.err.log("isModalExcludedSupported = " + modalExcludedSupported);
            }
            catch (ThreadDeath threadDeath) {
                throw threadDeath;
            }
            catch (Throwable throwable) {
                Installer.err.log("isModalExcludedSupported() failed  " + throwable);
            }
        }
        return modalExcludedSupported == 1;
    }

    private static void setModalExcluded(Window window) {
        if (modalExcludedSupported == 0) {
            return;
        }
        try {
            Class<?> clazz = Class.forName("sun.awt.SunToolkit");
            Method method = clazz.getMethod("setModalExcluded", Window.class);
            method.invoke(null, window);
        }
        catch (ThreadDeath threadDeath) {
            throw threadDeath;
        }
        catch (Throwable throwable) {
            Installer.err.log("setModalExcluded(Window) failed  " + throwable);
            modalExcludedSupported = 0;
        }
    }

    private final class ProgressDialog
    extends JDialog
    implements TaskListener,
    Runnable {
        private Runnable run;

        public ProgressDialog(Runnable runnable, Dialog dialog) {
            super(dialog, NbBundle.getMessage((Class)(class$org$netbeans$modules$javahelp$JavaHelp == null ? (class$org$netbeans$modules$javahelp$JavaHelp = JavaHelp.class$("org.netbeans.modules.javahelp.JavaHelp")) : class$org$netbeans$modules$javahelp$JavaHelp), (String)"TITLE_loading_help_sets"), true);
            this.init(runnable);
        }

        public ProgressDialog(Runnable runnable, Frame frame) {
            super(frame, NbBundle.getMessage((Class)(class$org$netbeans$modules$javahelp$JavaHelp == null ? (class$org$netbeans$modules$javahelp$JavaHelp = JavaHelp.class$("org.netbeans.modules.javahelp.JavaHelp")) : class$org$netbeans$modules$javahelp$JavaHelp), (String)"TITLE_loading_help_sets"), true);
            this.init(runnable);
        }

        private void init(Runnable runnable) {
            this.run = runnable;
            JComponent jComponent = ProgressHandleFactory.createProgressComponent((ProgressHandle)JavaHelp.this.progressHandle);
            jComponent.setPreferredSize(new Dimension(3 * jComponent.getPreferredSize().width, 3 * jComponent.getPreferredSize().height));
            jComponent.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
            this.getContentPane().add(jComponent);
            JavaHelp.this.progressHandle.start();
            this.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage((Class)(class$org$netbeans$modules$javahelp$JavaHelp == null ? (class$org$netbeans$modules$javahelp$JavaHelp = JavaHelp.class$("org.netbeans.modules.javahelp.JavaHelp")) : class$org$netbeans$modules$javahelp$JavaHelp), (String)"ACSD_Loading_Dialog"));
            this.pack();
            Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
            Dimension dimension2 = this.getSize();
            this.setLocation((dimension.width - dimension2.width) / 2, (dimension.height - dimension2.height) / 2);
        }

        public void show() {
            if (this.run != null) {
                Installer.err.log("posting request from progress dialog...");
                JavaHelp.getHelpLoader().post(this.run).addTaskListener((TaskListener)this);
                this.run = null;
            }
            super.show();
        }

        public void taskFinished(Task task) {
            Installer.err.log("posting request from progress dialog...request finished.");
            SwingUtilities.invokeLater(this);
        }

        public void run() {
            this.hide();
            this.dispose();
        }
    }
}

