/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javahelp;

import java.awt.Image;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ImageIcon;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.javahelp.Help;
import org.netbeans.modules.javahelp.Installer;
import org.openide.cookies.InstanceCookie;
import org.openide.loaders.XMLDataObject;
import org.openide.nodes.NodeEvent;
import org.openide.nodes.NodeListener;
import org.openide.nodes.NodeMemberEvent;
import org.openide.nodes.NodeOp;
import org.openide.nodes.NodeReorderEvent;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.WeakListeners;
import org.xml.sax.AttributeList;
import org.xml.sax.EntityResolver;
import org.xml.sax.HandlerBase;
import org.xml.sax.InputSource;
import org.xml.sax.Parser;
import org.xml.sax.SAXException;

public final class HelpCtxProcessor
implements XMLDataObject.Processor,
InstanceCookie.Of {
    private XMLDataObject xml;
    private Action p;

    private static Help findHelp() {
        return (Help)Lookup.getDefault().lookup(Help.class);
    }

    public void attachTo(XMLDataObject xMLDataObject) {
        this.xml = xMLDataObject;
        Installer.err.log("processing help context ref: " + xMLDataObject.getPrimaryFile());
    }

    public Class instanceClass() throws IOException, ClassNotFoundException {
        return ShortcutAction.class;
    }

    public String instanceName() {
        return "org.netbeans.modules.javahelp.HelpCtxProcessor$ShortcutAction";
    }

    public boolean instanceOf(Class clazz) {
        return clazz == Action.class;
    }

    public Object instanceCreate() throws IOException, ClassNotFoundException {
        if (this.p != null) {
            return this.p;
        }
        Installer.err.log("creating help context presenter from " + this.xml.getPrimaryFile());
        EntityResolver entityResolver = new EntityResolver(){

            public InputSource resolveEntity(String string, String string2) {
                return new InputSource(new ByteArrayInputStream(new byte[0]));
            }
        };
        HandlerBase handlerBase = new HandlerBase(){

            public void startElement(String string, AttributeList attributeList) throws SAXException {
                if ("helpctx".equals(string)) {
                    String string2 = attributeList.getValue("id");
                    String string3 = attributeList.getValue("showmaster");
                    if (string2 != null && !"".equals(string2)) {
                        HelpCtxProcessor.this.p = new ShortcutAction(HelpCtxProcessor.this.xml, string2, Boolean.valueOf(string3));
                    }
                }
            }
        };
        HelpCtxProcessor helpCtxProcessor = this;
        Parser parser = helpCtxProcessor.xml.createParser();
        parser.setEntityResolver(entityResolver);
        parser.setDocumentHandler(handlerBase);
        try {
            parser.parse(new InputSource(this.xml.getPrimaryFile().getInputStream()));
        }
        catch (SAXException sAXException) {
            IOException iOException = new IOException(sAXException.toString());
            Installer.err.annotate((Throwable)iOException, (Throwable)sAXException);
            throw iOException;
        }
        if (this.p == null) {
            throw new IOException("No <helpctx> element in " + this.xml.getPrimaryFile());
        }
        return this.p;
    }

    private static final class ShortcutAction
    extends AbstractAction
    implements HelpCtx.Provider,
    NodeListener,
    ChangeListener {
        private final XMLDataObject obj;
        private String helpID;
        private boolean showmaster;

        public ShortcutAction(XMLDataObject xMLDataObject, String string, boolean bl) {
            Help help;
            this.obj = xMLDataObject;
            this.helpID = string;
            this.showmaster = bl;
            this.putValue("noIconInMenu", Boolean.TRUE);
            Installer.err.log("new ShortcutAction: " + xMLDataObject + " " + string + " showmaster=" + bl);
            this.updateText();
            this.updateIcon();
            this.updateEnabled();
            if (xMLDataObject.isValid()) {
                help = xMLDataObject.getNodeDelegate();
                help.addNodeListener(NodeOp.weakNodeListener((NodeListener)this, (Object)help));
            }
            if ((help = HelpCtxProcessor.findHelp()) != null) {
                help.addChangeListener(WeakListeners.change((ChangeListener)this, (Object)help));
            }
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Help help = HelpCtxProcessor.findHelp();
            if (help != null) {
                Installer.err.log("ShortcutAction.actionPerformed: " + this.helpID + " showmaster=" + this.showmaster);
                help.showHelp(new HelpCtx(this.helpID), this.showmaster);
            } else {
                Toolkit.getDefaultToolkit().beep();
            }
        }

        public HelpCtx getHelpCtx() {
            return new HelpCtx("ide.welcome");
        }

        public void stateChanged(ChangeEvent changeEvent) {
            this.updateEnabled();
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            String string = propertyChangeEvent.getPropertyName();
            if (!this.obj.isValid()) {
                return;
            }
            if (string == null || string.equals("name") || string.equals("displayName")) {
                this.updateText();
            }
            if (string == null || string.equals("icon")) {
                this.updateIcon();
            }
        }

        private void updateText() {
            String string = this.obj.isValid() ? this.obj.getNodeDelegate().getDisplayName() : "dead";
            this.putValue("Name", string);
        }

        private void updateIcon() {
            Image image;
            if (this.obj.isValid() && (image = this.obj.getNodeDelegate().getIcon(1)) != null) {
                this.putValue("SmallIcon", new ImageIcon(image));
            }
        }

        private void updateEnabled() {
            Boolean bl;
            Help help = HelpCtxProcessor.findHelp();
            Boolean bl2 = bl = help == null ? Boolean.FALSE : help.isValidID(this.helpID, false);
            if (bl != null) {
                this.setEnabled(bl);
            }
            Installer.err.log("enabled: xml=" + this.obj.getPrimaryFile() + " id=" + this.helpID + " enabled=" + bl);
        }

        public void nodeDestroyed(NodeEvent nodeEvent) {
            this.setEnabled(false);
            this.updateText();
        }

        public void childrenAdded(NodeMemberEvent nodeMemberEvent) {
        }

        public void childrenRemoved(NodeMemberEvent nodeMemberEvent) {
        }

        public void childrenReordered(NodeReorderEvent nodeReorderEvent) {
        }
    }
}

