/*
 * Decompiled with CFR 0.152.
 */
package org.openide.explorer.view;

import java.awt.Dialog;
import java.awt.Point;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragGestureRecognizer;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DragSourceEvent;
import java.awt.dnd.DragSourceListener;
import java.awt.dnd.InvalidDnDOperationException;
import java.io.IOException;
import java.util.TooManyListenersException;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import org.openide.ErrorManager;
import org.openide.explorer.view.DragDropUtilities;
import org.openide.explorer.view.ExplorerDnDManager;
import org.openide.explorer.view.NodeRenderer;
import org.openide.nodes.Node;
import org.openide.util.Utilities;

abstract class ExplorerDragSupport
implements DragSourceListener,
DragGestureListener {
    boolean active = false;
    DragGestureRecognizer defaultGesture;
    protected JComponent comp;
    ExplorerDnDManager exDnD = ExplorerDnDManager.getDefault();

    ExplorerDragSupport() {
    }

    abstract int getAllowedDropActions();

    public void dragGestureRecognized(DragGestureEvent dragGestureEvent) {
        int n;
        Node[] nodeArray = this.obtainNodes(dragGestureEvent);
        if (nodeArray == null || nodeArray.length == 0) {
            return;
        }
        int n2 = this.getAllowedDragActions();
        for (n = 0; n < nodeArray.length; ++n) {
            if ((n2 & 2) != 0 && !nodeArray[n].canCut()) {
                n2 = 0x40000001;
            }
            if ((n2 & 1) == 0 || nodeArray[n].canCopy()) continue;
            n2 = 0;
        }
        this.exDnD = ExplorerDnDManager.getDefault();
        this.exDnD.setNodeAllowedActions(n2);
        n = dragGestureEvent.getDragAction();
        boolean bl = this.canDrag(n, n2);
        try {
            Transferable transferable;
            if ((n2 & 2) != 0) {
                transferable = DragDropUtilities.getNodeTransferable(nodeArray, 2);
                this.exDnD.setDraggedTransferable(transferable, true);
                transferable = DragDropUtilities.getNodeTransferable(nodeArray, 1);
                this.exDnD.setDraggedTransferable(transferable, false);
            } else if ((n2 & 1) != 0) {
                transferable = DragDropUtilities.getNodeTransferable(nodeArray, 1);
                this.exDnD.setDraggedTransferable(transferable, false);
            } else {
                transferable = Node.EMPTY.drag();
                this.exDnD.setDraggedTransferable(transferable, false);
            }
            this.exDnD.setDraggedNodes(nodeArray);
            Dialog dialog = (Dialog)SwingUtilities.getAncestorOfClass(Dialog.class, this.comp);
            if (dialog != null && dialog.isModal()) {
                this.exDnD.setDnDActive(false);
                return;
            }
            this.exDnD.setDnDActive(true);
            dragGestureEvent.startDrag(DragDropUtilities.chooseCursor(dragGestureEvent.getComponent(), n, bl), Utilities.loadImage((String)"org/openide/resources/cursorscopysingle.gif"), new Point(16, 16), transferable, this);
        }
        catch (InvalidDnDOperationException invalidDnDOperationException) {
            ErrorManager errorManager = ErrorManager.getDefault();
            errorManager.notify(1, (Throwable)invalidDnDOperationException);
            this.exDnD.setDnDActive(false);
        }
        catch (IOException iOException) {
            ErrorManager.getDefault().notify((Throwable)iOException);
            this.exDnD.setDnDActive(false);
        }
    }

    protected int getAllowedDragActions() {
        return 0;
    }

    private boolean canDrag(int n, int n2) {
        return (n2 & n) != 0;
    }

    public void dragEnter(DragSourceDragEvent dragSourceDragEvent) {
        this.doDragOver(dragSourceDragEvent);
    }

    public void dragOver(DragSourceDragEvent dragSourceDragEvent) {
        this.doDragOver(dragSourceDragEvent);
    }

    public void dropActionChanged(DragSourceDragEvent dragSourceDragEvent) {
    }

    public void dragExit(DragSourceEvent dragSourceEvent) {
        dragSourceEvent.getDragSourceContext().setCursor(DragDropUtilities.chooseCursor(this.comp, dragSourceEvent.getDragSourceContext().getSourceActions(), false));
    }

    private void doDragOver(DragSourceDragEvent dragSourceDragEvent) {
        dragSourceDragEvent.getDragSourceContext().setCursor(this.exDnD.getCursor());
    }

    public void dragDropEnd(DragSourceDropEvent dragSourceDropEvent) {
        this.exDnD.setDraggedTransferable(null, true);
        this.exDnD.setDraggedTransferable(null, false);
        this.exDnD.setDraggedNodes(null);
        NodeRenderer.dragExit();
        this.exDnD.setDnDActive(false);
    }

    public void activate(boolean bl) {
        if (this.active == bl) {
            return;
        }
        this.active = bl;
        DragGestureRecognizer dragGestureRecognizer = this.getDefaultGestureRecognizer();
        if (bl) {
            dragGestureRecognizer.setSourceActions(this.getAllowedDragActions());
            try {
                dragGestureRecognizer.removeDragGestureListener(this);
                dragGestureRecognizer.addDragGestureListener(this);
            }
            catch (TooManyListenersException tooManyListenersException) {
                throw new IllegalStateException("Too many listeners for drag gesture.");
            }
        } else {
            dragGestureRecognizer.removeDragGestureListener(this);
        }
    }

    DragGestureRecognizer getDefaultGestureRecognizer() {
        if (this.defaultGesture == null) {
            DragSource dragSource = DragSource.getDefaultDragSource();
            this.defaultGesture = dragSource.createDefaultDragGestureRecognizer(this.comp, this.getAllowedDragActions(), this);
        }
        return this.defaultGesture;
    }

    abstract Node[] obtainNodes(DragGestureEvent var1);
}

