/*
 * Decompiled with CFR 0.152.
 */
package org.openide.explorer.propertysheet;

import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.KeyboardFocusManager;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.FocusEvent;
import java.awt.image.BufferedImage;
import java.beans.FeatureDescriptor;
import java.beans.PropertyChangeListener;
import java.beans.PropertyEditor;
import java.beans.PropertyEditorManager;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StringWriter;
import java.lang.reflect.InvocationTargetException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.swing.Icon;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.plaf.ComboBoxUI;
import javax.swing.plaf.SplitPaneUI;
import javax.swing.plaf.basic.BasicSplitPaneDivider;
import javax.swing.plaf.basic.BasicSplitPaneUI;
import javax.swing.plaf.metal.MetalLookAndFeel;
import org.netbeans.modules.openide.explorer.PsSettings;
import org.openide.ErrorManager;
import org.openide.explorer.propertysheet.Boolean3WayEditor;
import org.openide.explorer.propertysheet.ButtonPanel;
import org.openide.explorer.propertysheet.CleanComboUI;
import org.openide.explorer.propertysheet.DefaultPropertyModel;
import org.openide.explorer.propertysheet.IconPanel;
import org.openide.explorer.propertysheet.IndexedPropertyEditor;
import org.openide.explorer.propertysheet.InplaceEditor;
import org.openide.explorer.propertysheet.NodePropertyModel;
import org.openide.explorer.propertysheet.PropertyEnv;
import org.openide.explorer.propertysheet.PropertyModel;
import org.openide.explorer.propertysheet.PropertySetModel;
import org.openide.explorer.propertysheet.ProxyNode;
import org.openide.nodes.Node;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

final class PropUtils {
    static boolean noCustomButtons;
    static boolean forceRadioButtons;
    static final boolean noCheckboxCaption;
    static final boolean hideSingleExpansion;
    static final boolean neverMargin = true;
    static final boolean psCommitOnFocusLoss;
    private static final String KEY_ALTBG = "Tree.altbackground";
    private static final String KEY_SETBG = "PropSheet.setBackground";
    private static final String KEY_SELSETBG = "PropSheet.selectedSetBackground";
    private static final String KEY_SETFG = "PropSheet.setForeground";
    private static final String KEY_SELSETFG = "PropSheet.selectedSetForeground";
    private static final String KEY_ICONMARGIN = "netbeans.ps.iconmargin";
    static final String KEY_ROWHEIGHT = "netbeans.ps.rowheight";
    private static final String PREF_KEY_SHOWDESCRIPTION = "showDescriptionArea";
    private static final String PREF_KEY_CLOSEDSETNAMES = "closedSetNames";
    private static final String PREF_KEY_SORTORDER = "sortOrder";
    static BufferedImage scratch;
    static Color disFg;
    static float fsfactor;
    static int minW;
    static int minH;
    private static Color tfFg;
    private static Color tfBg;
    static Boolean noAltBg;
    private static Icon bpIcon;
    static int marginWidth;
    private static int iconMargin;
    static Color selectedSetRendererColor;
    static Color setRendererColor;
    static Icon collapsedIcon;
    static Icon expandedIcon;
    static int spinnerHeight;
    static Color controlColor;
    static Color shadowColor;
    static Color altBg;
    private static String bptn;
    private static Comparator comp;
    private static int textMargin;
    private static Color setForegroundColor;
    private static Color selectedSetForegroundColor;
    private static Boolean useOptimizedCustomButtonPainting;
    static boolean isAqua;
    private static Graphics scratchGraphics;
    private static final String CAN_COMPARE_STRING = "Can compare only Node.Property instances.";
    private static final Comparator SORTER_TYPE;
    private static final Comparator SORTER_NAME;
    private static List missing;
    private static Set externallyEdited;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$org$openide$explorer$propertysheet$PropertySheet;
    static /* synthetic */ Class class$org$openide$explorer$propertysheet$DescriptionComponent;

    private PropUtils() {
    }

    static boolean useOptimizedCustomButtonPainting() {
        if (useOptimizedCustomButtonPainting == null) {
            useOptimizedCustomButtonPainting = "com.sun.java.swing.plaf.WindowsLookAndFeel".equals(UIManager.getLookAndFeel()) ? (PropUtils.isXPTheme() ? Boolean.TRUE : Boolean.FALSE) : ("Aqua".equals(UIManager.getLookAndFeel().getID()) ? Boolean.TRUE : Boolean.FALSE);
        }
        return useOptimizedCustomButtonPainting;
    }

    static void log(Class clazz, String string, boolean bl) {
        PropUtils.log(clazz, string);
        if (bl) {
            PropUtils.dumpStack(clazz);
        }
    }

    static void log(Class clazz, String string) {
        if (PropUtils.isLoggable(clazz)) {
            ErrorManager.getDefault().getInstance(clazz.getName()).log(string);
        }
    }

    static void log(Class clazz, FocusEvent focusEvent) {
        if (PropUtils.isLoggable(clazz)) {
            StringBuffer stringBuffer = new StringBuffer(30);
            PropUtils.focusEventToString(focusEvent, stringBuffer);
            PropUtils.log(clazz, stringBuffer.toString());
        }
    }

    static boolean isLoggable(Class clazz) {
        if (System.getProperty(clazz.getName()) == null) {
            return false;
        }
        boolean bl = ErrorManager.getDefault().getInstance(clazz.getName()).isLoggable(1);
        return bl;
    }

    static void logFocusOwner(Class clazz, String string) {
        if (PropUtils.isLoggable(clazz)) {
            StringBuffer stringBuffer = new StringBuffer(string);
            stringBuffer.append(" focus owner: ");
            Component component = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
            PropUtils.compToString(component, stringBuffer);
        }
    }

    static void focusEventToString(FocusEvent focusEvent, StringBuffer stringBuffer) {
        Component component = (Component)focusEvent.getSource();
        Component component2 = focusEvent.getOppositeComponent();
        stringBuffer.append(" focus ");
        stringBuffer.append(focusEvent.getID() == 1004 ? " gained by " : " lost by ");
        PropUtils.compToString(component, stringBuffer);
        stringBuffer.append(focusEvent.getID() == 1004 ? " from " : " to ");
        PropUtils.compToString(component2, stringBuffer);
        stringBuffer.append(" isTemporary: ");
        stringBuffer.append(focusEvent.isTemporary());
    }

    static void compToString(Component component, StringBuffer stringBuffer) {
        if (component == null) {
            stringBuffer.append(" null ");
            return;
        }
        String string = component.getName();
        Class<?> clazz = component.getClass();
        String string2 = clazz.getName();
        int n = string2.lastIndexOf(46);
        if (n != -1 && n != string2.length() - 1) {
            string2 = string2.substring(n + 1);
        }
        if (string != null) {
            stringBuffer.append("\"");
            stringBuffer.append(string);
            stringBuffer.append("\" (");
            stringBuffer.append(string2);
            stringBuffer.append(") ");
        } else {
            stringBuffer.append(' ');
            stringBuffer.append(string2);
            stringBuffer.append(' ');
        }
        if (!component.isVisible()) {
            stringBuffer.append(" [NOT VISIBLE] ");
        }
        if (!component.isDisplayable()) {
            stringBuffer.append(" [HAS NO PARENT COMPONENT] ");
        }
    }

    public static void dumpStack(Class clazz) {
        if (ErrorManager.getDefault().getInstance(clazz.getName()).isLoggable(1)) {
            StringWriter stringWriter = new StringWriter();
            new Throwable().printStackTrace(new PrintWriter(stringWriter));
            PropUtils.log(clazz, stringWriter.getBuffer().toString());
        }
    }

    static Color getButtonColor() {
        return UIManager.getColor("netbeans.ps.buttonColor");
    }

    static int getCustomButtonWidth() {
        Icon icon = PropUtils.getCustomButtonIcon();
        return icon.getIconWidth() + (isAqua ? 5 : 3);
    }

    static boolean checkEnabled(Component component, PropertyEditor propertyEditor, PropertyEnv propertyEnv) {
        if (propertyEditor instanceof NoPropertyEditorEditor) {
            return false;
        }
        if (propertyEnv != null) {
            Boolean bl = (Boolean)propertyEnv.getFeatureDescriptor().getValue("canEditAsText");
            if (!propertyEnv.isEditable() || Boolean.FALSE.equals(bl)) {
                return false;
            }
        }
        return true;
    }

    static Graphics getScratchGraphics(Component component) {
        if (scratchGraphics == null) {
            scratchGraphics = new BufferedImage(1, 1, 1).getGraphics();
        }
        return scratchGraphics;
    }

    static Color getErrorColor() {
        Color color = UIManager.getColor("nb.errorForeground");
        if (color == null) {
            color = Color.RED;
        }
        return color;
    }

    static Color getDisabledForeground() {
        if (disFg == null && (disFg = UIManager.getColor("textInactiveText")) == null) {
            disFg = Color.GRAY;
        }
        return disFg;
    }

    static float getFontSizeFactor() {
        if (fsfactor == -1.0f) {
            Font font = UIManager.getFont("controlFont");
            if (font == null) {
                JLabel jLabel = new JLabel();
                font = jLabel.getFont();
            }
            int n = 12;
            fsfactor = n / font.getSize();
        }
        return fsfactor;
    }

    static int getMinimumPropPanelWidth() {
        if (minW == -1) {
            int n = 50;
            minW = Math.round((float)n * PropUtils.getFontSizeFactor());
        }
        return minW;
    }

    static int getMinimumPropPanelHeight() {
        if (minH == -1) {
            int n = 18;
            minH = Math.round((float)n * PropUtils.getFontSizeFactor());
        }
        return minH;
    }

    static Dimension getMinimumPanelSize() {
        return new Dimension(PropUtils.getMinimumPropPanelWidth(), PropUtils.getMinimumPropPanelHeight());
    }

    static boolean updateProp(PropertyModel propertyModel, PropertyEditor propertyEditor, String string) {
        Object object = propertyEditor.getValue();
        Object object2 = PropUtils.noDlgUpdateProp(propertyModel, propertyEditor);
        if (object2 instanceof Exception) {
            if (object2 instanceof InvocationTargetException) {
                object2 = ((InvocationTargetException)object2).getTargetException();
            }
            PropUtils.processThrowable((Exception)object2, string, object);
        }
        boolean bl = object2 instanceof Boolean ? (Boolean)object2 : false;
        return bl;
    }

    static Object noDlgUpdateProp(PropertyModel propertyModel, PropertyEditor propertyEditor) {
        Object object = propertyEditor.getValue();
        Serializable serializable = Boolean.FALSE;
        try {
            try {
                Object object2 = propertyModel.getValue();
                if (object != null && !object.equals(object2) || object == null && object2 != null) {
                    propertyModel.setValue(object);
                    serializable = Boolean.TRUE;
                }
            }
            catch (ProxyNode.DifferentValuesException differentValuesException) {
                propertyModel.setValue(object);
                serializable = Boolean.TRUE;
            }
        }
        catch (Exception exception) {
            serializable = exception;
        }
        return serializable;
    }

    static Exception updatePropertyEditor(PropertyEditor propertyEditor, Object object) {
        Exception exception = null;
        try {
            if (object instanceof String) {
                propertyEditor.setAsText((String)object);
            } else {
                propertyEditor.setValue(object);
            }
        }
        catch (Exception exception2) {
            exception = exception2;
        }
        return exception;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static boolean updateProp(InplaceEditor inplaceEditor) {
        JComponent jComponent = inplaceEditor.getComponent();
        Cursor cursor = jComponent.getCursor();
        try {
            boolean bl;
            String string;
            jComponent.setCursor(Cursor.getPredefinedCursor(3));
            Object object = inplaceEditor.getValue();
            Exception exception = PropUtils.updatePropertyEditor(inplaceEditor.getPropertyEditor(), object);
            String string2 = object == null ? NbBundle.getMessage((Class)PropUtils.class, (String)"NULL") : (string = object.toString());
            if (exception != null) {
                String string3;
                PropertyModel propertyModel = inplaceEditor.getPropertyModel();
                if (propertyModel instanceof NodePropertyModel) {
                    Node.Property property = ((NodePropertyModel)propertyModel).getProperty();
                    string3 = property.getDisplayName();
                } else {
                    string3 = propertyModel instanceof DefaultPropertyModel ? ((DefaultPropertyModel)propertyModel).propertyName : NbBundle.getMessage((Class)PropUtils.class, (String)"MSG_unknown_property_name");
                }
                PropUtils.processThrowable(exception, string3, string);
            }
            boolean bl2 = bl = exception == null ? PropUtils.updateProp(inplaceEditor.getPropertyModel(), inplaceEditor.getPropertyEditor(), string) : false;
            return bl2;
        }
        finally {
            jComponent.setCursor(cursor);
        }
    }

    private static void processThrowable(Throwable throwable, String string, Object object) {
        if (throwable instanceof ThreadDeath) {
            throw (ThreadDeath)throwable;
        }
        ErrorManager errorManager = ErrorManager.getDefault();
        ErrorManager.Annotation[] annotationArray = errorManager.findAnnotations(throwable);
        if ((annotationArray == null || annotationArray.length == 0) && throwable.getLocalizedMessage() != throwable.getMessage()) {
            String string2 = MessageFormat.format(NbBundle.getMessage((Class)PropUtils.class, (String)"FMT_ErrorSettingProperty"), object, string);
            errorManager.annotate(throwable, 256, string2, throwable.getLocalizedMessage(), throwable, new Date());
        } else if (throwable instanceof NumberFormatException) {
            errorManager.annotate(throwable, 256, throwable.getMessage(), MessageFormat.format(NbBundle.getMessage((Class)PropUtils.class, (String)"FMT_BAD_NUMBER_FORMAT"), object), null, null);
        }
        errorManager.notify(throwable);
    }

    static synchronized String findLocalizedMessage(Throwable throwable, Object object, String string) {
        try {
            if (throwable == null) {
                return null;
            }
            ErrorManager errorManager = ErrorManager.getDefault();
            if (throwable.getLocalizedMessage() != throwable.getMessage()) {
                return throwable.getLocalizedMessage();
            }
            ErrorManager.Annotation[] annotationArray = errorManager.findAnnotations(throwable);
            if (throwable instanceof NumberFormatException) {
                return MessageFormat.format(NbBundle.getMessage((Class)PropUtils.class, (String)"FMT_BAD_NUMBER_FORMAT"), object);
            }
            if (annotationArray != null) {
                for (int i = 0; i < annotationArray.length; ++i) {
                    if (annotationArray[i].getLocalizedMessage() == null || annotationArray[i].getSeverity() != 256) continue;
                    return annotationArray[i].getLocalizedMessage();
                }
            }
            ErrorManager.getDefault().annotate(throwable, 16, null, null, null, null);
            return MessageFormat.format(NbBundle.getMessage((Class)PropUtils.class, (String)"FMT_CannotUpdateProperty"), object, string);
        }
        catch (Exception exception) {
            ErrorManager.getDefault().notify((Throwable)exception);
            return null;
        }
    }

    static Comparator getComparator(int n) {
        switch (n) {
            case 0: {
                return null;
            }
            case 1: {
                return SORTER_NAME;
            }
            case 2: {
                return SORTER_TYPE;
            }
        }
        throw new IllegalArgumentException("Unknown sorting mode: " + Integer.toString(n));
    }

    public static ComboBoxUI createComboUI(JComboBox jComboBox, boolean bl) {
        return new CleanComboUI(bl);
    }

    private static List getMissing() {
        if (missing == null) {
            missing = new ArrayList();
        }
        return missing;
    }

    static PropertyEditor getPropertyEditor(Class clazz) {
        PropertyEditor propertyEditor = PropertyEditorManager.findEditor(clazz);
        if (propertyEditor == null) {
            propertyEditor = new NoPropertyEditorEditor();
        }
        return propertyEditor;
    }

    static PropertyEditor getPropertyEditor(Node.Property property) {
        return PropUtils.getPropertyEditor(property, true);
    }

    static PropertyEditor getPropertyEditor(Node.Property property, boolean bl) {
        PropertyEditor propertyEditor;
        block15: {
            propertyEditor = property.getPropertyEditor();
            if (property instanceof Node.IndexedProperty && propertyEditor == null) {
                propertyEditor = new IndexedPropertyEditor();
                property.setValue("changeImmediate", (Object)Boolean.FALSE);
            }
            if (propertyEditor == null) {
                propertyEditor = PropUtils.getPropertyEditor(property.getValueType());
            }
            if (propertyEditor == null) {
                String string;
                List list = PropUtils.getMissing();
                if (!list.contains(string = property.getValueType().getName())) {
                    ErrorManager.getDefault().log(1, "No property editor registered for type " + string);
                    list.add(string);
                }
                propertyEditor = new NoPropertyEditorEditor();
            } else if (property.canRead()) {
                try {
                    try {
                        try {
                            if ((property.getValueType() == Boolean.class || property.getValueType() == Boolean.TYPE) && property.getValue() == null) {
                                propertyEditor = new Boolean3WayEditor();
                            }
                            if (bl) {
                                PropUtils.updateEdFromProp(property, propertyEditor, property.getDisplayName());
                            }
                        }
                        catch (ProxyNode.DifferentValuesException differentValuesException) {
                            if (property.getValueType() == Boolean.class || property.getValueType() == Boolean.TYPE) {
                                propertyEditor = new Boolean3WayEditor();
                                break block15;
                            }
                            propertyEditor = new DifferentValuesEditor(propertyEditor);
                        }
                    }
                    catch (IllegalAccessException illegalAccessException) {
                        IllegalStateException illegalStateException = new IllegalStateException("Error getting property value");
                        ErrorManager.getDefault().annotate((Throwable)illegalStateException, (Throwable)illegalAccessException);
                        throw illegalStateException;
                    }
                }
                catch (InvocationTargetException invocationTargetException) {
                    IllegalStateException illegalStateException = new IllegalStateException("Error getting property value");
                    ErrorManager.getDefault().annotate((Throwable)illegalStateException, (Throwable)invocationTargetException);
                    throw illegalStateException;
                }
            }
        }
        return propertyEditor;
    }

    private static void updateEdFromProp(Node.Property property, PropertyEditor propertyEditor, String string) throws ProxyNode.DifferentValuesException, IllegalAccessException, InvocationTargetException {
        Object object = property.getValue();
        if (object instanceof String && ((String)object).length() > 2048) {
            propertyEditor.setValue(object);
            return;
        }
        Object object2 = propertyEditor.getValue();
        if (object == null && object2 == null) {
            return;
        }
        if (object != null && !object.equals(object2) || object == null && object2 != null) {
            if (object2 instanceof Object[] && object instanceof Object[] && Arrays.equals((Object[])object2, (Object[])object)) {
                return;
            }
            propertyEditor.setValue(object);
        }
    }

    static Color getControlColor() {
        if (controlColor == null) {
            PropUtils.deriveColorsAndMargin();
        }
        return controlColor;
    }

    static Color getShadowColor() {
        if (shadowColor == null) {
            PropUtils.deriveColorsAndMargin();
        }
        return shadowColor;
    }

    static Color getAltBg() {
        if (altBg == null) {
            PropUtils.deriveColorsAndMargin();
        }
        return altBg;
    }

    static boolean noAltBg() {
        if (noAltBg == null) {
            noAltBg = UIManager.getColor(KEY_ALTBG) == null ? Boolean.TRUE : Boolean.FALSE;
        }
        return noAltBg;
    }

    static Color getTextFieldBackground() {
        if (tfBg == null) {
            tfBg = UIManager.getColor("TextField.background");
            if (tfBg == null) {
                tfBg = UIManager.getColor("text");
            }
            if (tfBg == null) {
                tfBg = Color.WHITE;
            }
        }
        return tfBg;
    }

    static Color getTextFieldForeground() {
        if (tfFg == null) {
            tfFg = UIManager.getColor("TextField.foreground");
            if (tfFg == null) {
                tfFg = UIManager.getColor("textText");
            }
            if (tfFg == null) {
                tfFg = Color.BLACK;
            }
        }
        return tfFg;
    }

    private static void deriveColorsAndMargin() {
        Serializable serializable;
        int n;
        int n2;
        int n3;
        controlColor = UIManager.getColor("control");
        if (controlColor == null) {
            controlColor = Color.LIGHT_GRAY;
        }
        boolean bl = "com.sun.java.swing.plaf.windows.WindowsLookAndFeel".equals(UIManager.getLookAndFeel().getClass().getName());
        boolean bl2 = "Aqua".equals(UIManager.getLookAndFeel().getID());
        setRendererColor = UIManager.getColor(KEY_SETBG);
        selectedSetRendererColor = UIManager.getColor(KEY_SELSETBG);
        if (setRendererColor == null) {
            if (bl2) {
                setRendererColor = new Color(225, 235, 240);
            } else if (setRendererColor == null) {
                n3 = PropUtils.adjustColorComponent(controlColor.getRed(), -25, -25);
                n2 = PropUtils.adjustColorComponent(controlColor.getGreen(), -25, -25);
                n = PropUtils.adjustColorComponent(controlColor.getBlue(), -25, -25);
                setRendererColor = new Color(n3, n2, n);
            }
        }
        if (bl2) {
            selectedSetRendererColor = UIManager.getColor("Table.selectionBackground");
        }
        if (selectedSetRendererColor == null) {
            Serializable serializable2 = serializable = bl ? UIManager.getColor("Table.selectionBackground") : UIManager.getColor("activeCaptionBorder");
            if (serializable == null) {
                serializable = Color.BLUE;
            }
            n3 = PropUtils.adjustColorComponent(((Color)serializable).getRed(), -25, -25);
            n2 = PropUtils.adjustColorComponent(((Color)serializable).getGreen(), -25, -25);
            n = PropUtils.adjustColorComponent(((Color)serializable).getBlue(), -25, -25);
            selectedSetRendererColor = new Color(n3, n2, n);
        }
        if ((shadowColor = UIManager.getColor("controlShadow")) == null) {
            shadowColor = Color.GRAY;
        }
        if ((setForegroundColor = UIManager.getColor(KEY_SETFG)) == null && (setForegroundColor = UIManager.getColor("Table.foreground")) == null && (setForegroundColor = UIManager.getColor("textText")) == null) {
            setForegroundColor = Color.BLACK;
        }
        if ((selectedSetForegroundColor = UIManager.getColor(KEY_SELSETFG)) == null && (selectedSetForegroundColor = UIManager.getColor("Table.selectionForeground")) == null) {
            selectedSetForegroundColor = Color.WHITE;
        }
        if ((altBg = UIManager.getColor(KEY_ALTBG)) == null) {
            altBg = UIManager.getColor("Tree.background");
            if (altBg == null) {
                altBg = Color.WHITE;
            }
            noAltBg = Boolean.TRUE;
        } else {
            noAltBg = Boolean.FALSE;
        }
        collapsedIcon = UIManager.getIcon("Tree.collapsedIcon");
        if (collapsedIcon == null) {
            collapsedIcon = new Icon(){

                public int getIconHeight() {
                    return 7;
                }

                public int getIconWidth() {
                    return 7;
                }

                public void paintIcon(Component component, Graphics graphics, int n, int n2) {
                }
            };
        }
        if ((expandedIcon = UIManager.getIcon("Tree.expandedIcon")) == null) {
            expandedIcon = collapsedIcon;
        }
        if (expandedIcon != null && expandedIcon.getIconHeight() <= 0 || expandedIcon.getIconHeight() <= 0) {
            expandedIcon = new WrapperSizeIcon(expandedIcon);
        }
        if (collapsedIcon != null && collapsedIcon.getIconHeight() <= 0 || collapsedIcon.getIconHeight() <= 0) {
            collapsedIcon = new WrapperSizeIcon(collapsedIcon);
        }
        marginWidth = collapsedIcon != null ? Math.max(14, collapsedIcon.getIconWidth() - 2) : 13;
        serializable = (Integer)UIManager.get(KEY_ICONMARGIN);
        iconMargin = serializable != null ? (Integer)serializable : ("com.sun.java.swing.plaf.windows.WindowsLookAndFeel".equals(UIManager.getLookAndFeel().getClass().getName()) ? 4 : 0);
        serializable = (Integer)UIManager.get(KEY_ROWHEIGHT);
        spinnerHeight = serializable != null ? ((Integer)serializable).intValue() : expandedIcon.getIconHeight();
    }

    static Icon getExpandedIcon() {
        if (expandedIcon == null) {
            PropUtils.deriveColorsAndMargin();
        }
        return expandedIcon;
    }

    static Icon getCollapsedIcon() {
        if (collapsedIcon == null) {
            PropUtils.deriveColorsAndMargin();
        }
        return collapsedIcon;
    }

    static Color getSetRendererColor() {
        if (setRendererColor == null) {
            PropUtils.deriveColorsAndMargin();
        }
        return setRendererColor;
    }

    static Color getSelectedSetRendererColor() {
        if (selectedSetRendererColor == null) {
            PropUtils.deriveColorsAndMargin();
        }
        return selectedSetRendererColor;
    }

    static Color getSetForegroundColor() {
        if (setForegroundColor == null) {
            PropUtils.deriveColorsAndMargin();
        }
        return setForegroundColor;
    }

    static Color getSelectedSetForegroundColor() {
        if (selectedSetForegroundColor == null) {
            PropUtils.deriveColorsAndMargin();
        }
        return selectedSetForegroundColor;
    }

    static int getMarginWidth() {
        if (marginWidth == -1) {
            PropUtils.deriveColorsAndMargin();
        }
        return marginWidth;
    }

    static int getSpinnerHeight() {
        if (spinnerHeight == -1) {
            PropUtils.deriveColorsAndMargin();
        }
        return spinnerHeight;
    }

    static int getIconMargin() {
        if (iconMargin == -1) {
            PropUtils.deriveColorsAndMargin();
        }
        return iconMargin;
    }

    static Icon getCustomButtonIcon() {
        if (bpIcon == null) {
            bpIcon = new BpIcon();
        }
        return bpIcon;
    }

    private static int adjustColorComponent(int n, int n2, int n3) {
        n = n > 128 ? (n -= n2) : (n += n3);
        if (n < 0) {
            n = 0;
        }
        if (n > 255) {
            n = 255;
        }
        return n;
    }

    static String basicPropsTabName() {
        if (bptn == null) {
            bptn = NbBundle.getMessage((Class)PropUtils.class, (String)"LBL_BasicTab");
        }
        return bptn;
    }

    static Comparator getTabListComparator() {
        if (comp == null) {
            comp = new TabListComparator();
        }
        return comp;
    }

    static SplitPaneUI createSplitPaneUI() {
        return new CleanSplitPaneUI();
    }

    static boolean shouldShowDescription() {
        return PsSettings.getDefault().getBoolean(PREF_KEY_SHOWDESCRIPTION, true);
    }

    static void saveShowDescription(boolean bl) {
        PsSettings.getDefault().putBoolean(PREF_KEY_SHOWDESCRIPTION, bl);
    }

    static String[] getSavedClosedSetNames() {
        String string = PsSettings.getDefault().get(PREF_KEY_CLOSEDSETNAMES, null);
        if (string != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
            String[] stringArray = new String[stringTokenizer.countTokens()];
            int n = 0;
            while (stringTokenizer.hasMoreElements()) {
                stringArray[n] = stringTokenizer.nextToken();
                ++n;
            }
            return stringArray;
        }
        return new String[0];
    }

    static void putSavedClosedSetNames(Set set) {
        if (set.size() > 0) {
            StringBuffer stringBuffer = new StringBuffer(set.size() * 20);
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                stringBuffer.append(iterator.next());
                if (!iterator.hasNext()) continue;
                stringBuffer.append(',');
            }
            PsSettings.getDefault().put(PREF_KEY_CLOSEDSETNAMES, stringBuffer.toString());
        } else {
            PsSettings.getDefault().put(PREF_KEY_CLOSEDSETNAMES, "");
        }
    }

    static void putSortOrder(int n) {
        PsSettings.getDefault().putInt(PREF_KEY_SORTORDER, n);
    }

    static int getSavedSortOrder() {
        return PsSettings.getDefault().getInt(PREF_KEY_SORTORDER, 0);
    }

    static int getTextMargin() {
        if ("apple.laf.AquaLookAndFeel".equals(UIManager.getLookAndFeel().getClass().getName())) {
            return 0;
        }
        if (textMargin == -1) {
            Object object = UIManager.get("netbeans.ps.textMargin");
            textMargin = object instanceof Integer ? (Integer)object : 2;
        }
        return textMargin;
    }

    static String createHtmlTooltip(String string, String string2) {
        boolean bl = false;
        if (string2.matches("\\<(html|HTML)\\>.*\\<\\/(html|HTML)\\>")) {
            string2 = string2.replaceAll("\\<\\/{0,1}(html|HTML)\\>", "");
            bl = true;
        }
        String string3 = null;
        if (string2.indexOf(" ") != -1) {
            string3 = " ";
        } else if (string2.indexOf(",") != -1) {
            string3 = ",";
        } else if (string2.indexOf(";") != -1) {
            string3 = ";";
        } else if (string2.indexOf("/") != -1) {
            string3 = "/";
        } else if (string2.indexOf("\\") != -1) {
            string3 = "\\";
        } else {
            return string2;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string2, string3, true);
        StringBuffer stringBuffer = new StringBuffer(string2.length() + 20);
        stringBuffer.append("<html>");
        stringBuffer.append("<b><u>");
        stringBuffer.append(string);
        stringBuffer.append("</u></b><br>");
        int n = 0;
        int n2 = 0;
        while (stringTokenizer.hasMoreTokens()) {
            String string4 = stringTokenizer.nextToken();
            if (!bl) {
                string4 = Utilities.replaceString((String)string4, (String)"&", (String)"&amp;");
                string4 = Utilities.replaceString((String)string4, (String)"<", (String)"&lt;");
                string4 = Utilities.replaceString((String)string4, (String)">", (String)"&gt;");
            }
            n += string4.length();
            stringBuffer.append(string4);
            if (stringTokenizer.hasMoreTokens()) {
                ++n;
            }
            if (n <= 80) continue;
            stringBuffer.append("<br>");
            n = 0;
            if (++n2 <= 10) continue;
            stringBuffer.append(NbBundle.getMessage((Class)PropUtils.class, (String)"MSG_ELLIPSIS"));
            return stringBuffer.toString();
        }
        stringBuffer.append("</html>");
        return stringBuffer.toString();
    }

    static InplaceEditor findInnermostInplaceEditor(InplaceEditor inplaceEditor) {
        while (inplaceEditor instanceof IconPanel || inplaceEditor instanceof ButtonPanel) {
            if (inplaceEditor instanceof IconPanel) {
                inplaceEditor = ((IconPanel)inplaceEditor).getInplaceEditor();
                continue;
            }
            inplaceEditor = ((ButtonPanel)inplaceEditor).getInplaceEditor();
        }
        return inplaceEditor;
    }

    static boolean shouldDrawMargin(PropertySetModel propertySetModel) {
        return false;
    }

    private static final Color getIconForeground() {
        return UIManager.getColor("PropSheet.customButtonForeground");
    }

    public static boolean isXPTheme() {
        Boolean bl = (Boolean)Toolkit.getDefaultToolkit().getDesktopProperty("win.xpstyle.themeActive");
        return bl == null ? false : bl;
    }

    static final boolean shallBeRDVEnabled(FeatureDescriptor featureDescriptor) {
        if (featureDescriptor != null && featureDescriptor instanceof Node.Property) {
            return PropUtils.shallBeRDVEnabled((Node.Property)featureDescriptor);
        }
        return false;
    }

    static final boolean shallBeRDVEnabled(Node.Property property) {
        if (property == null || !property.supportsDefaultValue()) {
            return false;
        }
        try {
            if (property.getClass().getMethod("isDefaultValue", null).getDeclaringClass() == Node.Property.class) {
                return true;
            }
            return !property.isDefaultValue();
        }
        catch (NoSuchMethodException noSuchMethodException) {
            if (!$assertionsDisabled) {
                throw new AssertionError((Object)("No isDefaultValue in " + property.getClass() + ": " + noSuchMethodException));
            }
            return true;
        }
    }

    static void addExternallyEdited(Node.Property property) {
        externallyEdited.add(property);
    }

    static void removeExternallyEdited(Node.Property property) {
        externallyEdited.remove(property);
    }

    static boolean isExternallyEdited(Node.Property property) {
        return externallyEdited.contains(property);
    }

    static {
        $assertionsDisabled = !PropUtils.class.desiredAssertionStatus();
        noCustomButtons = Boolean.getBoolean("netbeans.ps.noCustomButtons");
        forceRadioButtons = Boolean.getBoolean("netbeans.ps.forceRadioButtons");
        noCheckboxCaption = !Boolean.getBoolean("netbeans.ps.checkboxCaption");
        hideSingleExpansion = Boolean.getBoolean("netbeans.ps.hideSingleExpansion");
        psCommitOnFocusLoss = !Boolean.getBoolean("netbeans.ps.NoCommitOnFocusLoss");
        scratch = null;
        disFg = null;
        fsfactor = -1.0f;
        minW = -1;
        minH = -1;
        tfFg = null;
        tfBg = null;
        noAltBg = null;
        bpIcon = null;
        marginWidth = -1;
        iconMargin = -1;
        selectedSetRendererColor = null;
        setRendererColor = null;
        collapsedIcon = null;
        expandedIcon = null;
        spinnerHeight = -1;
        controlColor = null;
        shadowColor = null;
        altBg = null;
        bptn = null;
        comp = null;
        textMargin = -1;
        setForegroundColor = null;
        selectedSetForegroundColor = null;
        useOptimizedCustomButtonPainting = null;
        isAqua = "Aqua".equals(UIManager.getLookAndFeel().getID());
        scratchGraphics = null;
        SORTER_TYPE = new Comparator(){

            public int compare(Object object, Object object2) {
                Class clazz;
                String string;
                if (!(object instanceof Node.Property)) {
                    throw new IllegalArgumentException(PropUtils.CAN_COMPARE_STRING);
                }
                if (!(object2 instanceof Node.Property)) {
                    throw new IllegalArgumentException(PropUtils.CAN_COMPARE_STRING);
                }
                Class clazz2 = ((Node.Property)object).getValueType();
                String string2 = clazz2 != null ? clazz2.getName() : "";
                int n = string2.compareToIgnoreCase(string = (clazz = ((Node.Property)object2).getValueType()) != null ? clazz.getName() : "");
                if (n != 0) {
                    return n;
                }
                string2 = ((Node.Property)object).getDisplayName();
                string = ((Node.Property)object2).getDisplayName();
                return string2.compareToIgnoreCase(string);
            }

            public String toString() {
                return "Type comparator";
            }
        };
        SORTER_NAME = new Comparator(){

            public int compare(Object object, Object object2) {
                if (!(object instanceof Node.Property)) {
                    throw new IllegalArgumentException(PropUtils.CAN_COMPARE_STRING);
                }
                if (!(object2 instanceof Node.Property)) {
                    throw new IllegalArgumentException(PropUtils.CAN_COMPARE_STRING);
                }
                String string = ((Node.Property)object).getDisplayName();
                String string2 = ((Node.Property)object2).getDisplayName();
                return String.CASE_INSENSITIVE_ORDER.compare(string, string2);
            }

            public String toString() {
                return "Name comparator";
            }
        };
        missing = null;
        externallyEdited = new HashSet(3);
    }

    static class BpIcon
    implements Icon {
        boolean larger;

        public BpIcon() {
            Font font = UIManager.getFont("Table.font");
            this.larger = font != null ? font.getSize() > 13 : false;
        }

        public int getIconHeight() {
            return 12;
        }

        public int getIconWidth() {
            return this.larger ? 16 : 12;
        }

        public void paintIcon(Component component, Graphics graphics, int n, int n2) {
            int n3 = component.getWidth();
            int n4 = component.getHeight();
            int n5 = n4 - 5;
            int n6 = n3 / 2;
            int n7 = n6 - 4;
            int n8 = n6 + 4;
            graphics.setColor(PropUtils.getIconForeground() == null ? component.getForeground() : PropUtils.getIconForeground());
            this.drawDot(graphics, n7 + 1, n5, this.larger);
            this.drawDot(graphics, n6, n5, this.larger);
            this.drawDot(graphics, n8 - 1, n5, this.larger);
        }

        private void drawDot(Graphics graphics, int n, int n2, boolean bl) {
            if (!bl) {
                graphics.drawLine(n, n2, n, n2);
            } else {
                graphics.drawLine(n - 1, n2, n + 1, n2);
                graphics.drawLine(n, n2 - 1, n, n2 + 1);
            }
        }
    }

    private static class CleanSplitPaneDivider
    extends BasicSplitPaneDivider
    implements Accessible {
        private AccessibleContext accessibleContext;

        public CleanSplitPaneDivider(BasicSplitPaneUI basicSplitPaneUI) {
            super(basicSplitPaneUI);
        }

        public AccessibleContext getAccessibleContext() {
            if (null == this.accessibleContext) {
                this.accessibleContext = new Component.AccessibleAWTComponent(){

                    public AccessibleRole getAccessibleRole() {
                        return AccessibleRole.SPLIT_PANE;
                    }
                };
                this.accessibleContext.setAccessibleName(NbBundle.getMessage((Class)(class$org$openide$explorer$propertysheet$DescriptionComponent == null ? (class$org$openide$explorer$propertysheet$DescriptionComponent = PropUtils.class$("org.openide.explorer.propertysheet.DescriptionComponent")) : class$org$openide$explorer$propertysheet$DescriptionComponent), (String)"ACS_Splitter"));
                this.accessibleContext.setAccessibleDescription(NbBundle.getMessage((Class)(class$org$openide$explorer$propertysheet$DescriptionComponent == null ? (class$org$openide$explorer$propertysheet$DescriptionComponent = PropUtils.class$("org.openide.explorer.propertysheet.DescriptionComponent")) : class$org$openide$explorer$propertysheet$DescriptionComponent), (String)"ACSD_Splitter"));
            }
            return this.accessibleContext;
        }
    }

    private static class CleanSplitPaneUI
    extends BasicSplitPaneUI {
        private CleanSplitPaneUI() {
        }

        protected void installDefaults() {
            super.installDefaults();
            this.divider.setBorder(new SplitBorder());
        }

        public BasicSplitPaneDivider createDefaultDivider() {
            return new CleanSplitPaneDivider(this);
        }
    }

    static final class DifferentValuesEditor
    implements PropertyEditor {
        private PropertyEditor ed;
        private boolean notSet = true;

        public DifferentValuesEditor(PropertyEditor propertyEditor) {
            this.ed = propertyEditor;
        }

        public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
            this.ed.addPropertyChangeListener(propertyChangeListener);
        }

        public String getAsText() {
            String string = this.notSet ? NbBundle.getMessage((Class)(class$org$openide$explorer$propertysheet$PropUtils == null ? (class$org$openide$explorer$propertysheet$PropUtils = PropUtils.class$("org.openide.explorer.propertysheet.PropUtils")) : class$org$openide$explorer$propertysheet$PropUtils), (String)"CTL_Different_Values") : this.ed.getAsText();
            return string;
        }

        public Component getCustomEditor() {
            return this.ed.getCustomEditor();
        }

        public String getJavaInitializationString() {
            return this.ed.getJavaInitializationString();
        }

        public String[] getTags() {
            return this.ed.getTags();
        }

        public Object getValue() {
            Object object = this.notSet ? null : this.ed.getValue();
            return object;
        }

        public boolean isPaintable() {
            return this.notSet ? false : this.ed.isPaintable();
        }

        public void paintValue(Graphics graphics, Rectangle rectangle) {
            if (this.isPaintable()) {
                this.ed.paintValue(graphics, rectangle);
            }
        }

        public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
            this.ed.removePropertyChangeListener(propertyChangeListener);
        }

        public void setAsText(String string) throws IllegalArgumentException {
            this.ed.setAsText(string);
            this.notSet = false;
        }

        public void setValue(Object object) {
            this.ed.setValue(object);
            this.notSet = false;
        }

        public boolean supportsCustomEditor() {
            return this.ed.supportsCustomEditor();
        }
    }

    static final class NoPropertyEditorEditor
    implements PropertyEditor {
        NoPropertyEditorEditor() {
        }

        public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        }

        public String getAsText() {
            return NbBundle.getMessage((Class)(class$org$openide$explorer$propertysheet$PropertySheet == null ? (class$org$openide$explorer$propertysheet$PropertySheet = PropUtils.class$("org.openide.explorer.propertysheet.PropertySheet")) : class$org$openide$explorer$propertysheet$PropertySheet), (String)"CTL_NoPropertyEditor");
        }

        public Component getCustomEditor() {
            return null;
        }

        public String getJavaInitializationString() {
            return "";
        }

        public String[] getTags() {
            return null;
        }

        public Object getValue() {
            return this.getAsText();
        }

        public boolean isPaintable() {
            return false;
        }

        public void paintValue(Graphics graphics, Rectangle rectangle) {
        }

        public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        }

        public void setAsText(String string) throws IllegalArgumentException {
        }

        public void setValue(Object object) {
        }

        public boolean supportsCustomEditor() {
            return false;
        }
    }

    private static class SplitBorder
    implements Border {
        private SplitBorder() {
        }

        public Insets getBorderInsets(Component component) {
            if (UIManager.getLookAndFeel() instanceof MetalLookAndFeel) {
                return new Insets(2, 0, 1, 0);
            }
            return new Insets(1, 0, 1, 0);
        }

        public boolean isBorderOpaque() {
            return true;
        }

        public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
            if (UIManager.getLookAndFeel() instanceof MetalLookAndFeel) {
                graphics.setColor(UIManager.getColor("controlShadow"));
                graphics.drawLine(n, n2, n + n3, n2);
                graphics.setColor(UIManager.getColor("controlHighlight"));
                graphics.drawLine(n, n2 + 1, n + n3, n2 + 1);
                graphics.drawLine(n, n2 + n4 - 1, n + n3, n2 + n4 - 1);
                graphics.setColor(UIManager.getColor("controlShadow"));
                graphics.drawLine(n, n2 + n4 - 2, n + n3, n2 + n4 - 2);
            } else {
                graphics.setColor(UIManager.getColor("controlHighlight"));
                graphics.drawLine(n, n2, n + n3, n2);
                graphics.setColor(UIManager.getColor("controlShadow"));
                graphics.drawLine(n, n2 + n4 - 1, n + n3, n2 + n4 - 1);
            }
        }
    }

    private static class TabListComparator
    implements Comparator {
        private TabListComparator() {
        }

        public int compare(Object object, Object object2) {
            String string = (String)object;
            String string2 = (String)object2;
            if (string == string2) {
                return 0;
            }
            String string3 = PropUtils.basicPropsTabName();
            if (string3.equals(string)) {
                return -1;
            }
            if (string3.equals(string2)) {
                return 1;
            }
            return string.compareTo(string2);
        }
    }

    private static final class WrapperSizeIcon
    implements Icon {
        private Icon wrapped;

        public WrapperSizeIcon(Icon icon) {
            this.wrapped = icon;
        }

        public int getIconWidth() {
            int n = this.wrapped.getIconWidth();
            if (n <= 0) {
                n = 11;
            }
            return n;
        }

        public int getIconHeight() {
            int n = this.wrapped.getIconHeight();
            if (n <= 0) {
                n = 11;
            }
            return n;
        }

        public void paintIcon(Component component, Graphics graphics, int n, int n2) {
            this.wrapped.paintIcon(component, graphics, n, n2);
        }
    }
}

