/*
 * Decompiled with CFR 0.152.
 */
package org.openide.explorer.propertysheet;

import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyEditor;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.lang.ref.WeakReference;
import java.lang.reflect.InvocationTargetException;
import java.text.MessageFormat;
import javax.swing.JComponent;
import javax.swing.JScrollBar;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.EventListenerList;
import org.openide.ErrorManager;
import org.openide.explorer.propertysheet.EditorPropertyDisplayer;
import org.openide.explorer.propertysheet.ExPropertyEditor;
import org.openide.explorer.propertysheet.ModelProperty;
import org.openide.explorer.propertysheet.NodePropertyModel;
import org.openide.explorer.propertysheet.PropUtils;
import org.openide.explorer.propertysheet.PropertyDialogManager;
import org.openide.explorer.propertysheet.PropertyDisplayer_Editable;
import org.openide.explorer.propertysheet.PropertyEnv;
import org.openide.explorer.propertysheet.PropertyModel;
import org.openide.explorer.propertysheet.ProxyNode;
import org.openide.explorer.propertysheet.editors.EnhancedCustomPropertyEditor;
import org.openide.nodes.Node;
import org.openide.util.NbBundle;
import org.openide.util.WeakListeners;

final class CustomEditorDisplayer
implements PropertyDisplayer_Editable {
    private int updatePolicy = 0;
    private Node.Property prop;
    private PropertyEnv env = null;
    private PropertyEditor editor = null;
    private Component customEditor = null;
    boolean ignoreChanges = false;
    private PropertyChangeListener editorListener = null;
    private EnvListener envListener = null;
    private PropertyModel model = null;
    private Object originalValue = null;
    private EventListenerList listenerList = null;
    private boolean ignoreChanges2 = false;
    private PropertyChangeListener remoteEnvListener = null;
    private VetoableChangeListener remotevEnvListener = null;

    public CustomEditorDisplayer(Node.Property property) {
        this.prop = property;
    }

    public CustomEditorDisplayer(Node.Property property, PropertyModel propertyModel) {
        this(property);
        this.model = propertyModel;
    }

    public void setUpdatePolicy(int n) {
        this.updatePolicy = n;
        if (this.env != null) {
            this.env.setChangeImmediate(n != 2);
        }
    }

    private Component getCustomEditor() {
        if (this.customEditor == null) {
            this.customEditor = this.getPropertyEditor().getCustomEditor();
        }
        return this.customEditor;
    }

    PropertyEditor getPropertyEditor() {
        if (this.editor == null) {
            this.setPropertyEditor(PropUtils.getPropertyEditor(this.getProperty()));
        }
        return this.editor;
    }

    public synchronized void dispose() {
        PropertyEditor propertyEditor = this.editor;
        Node.Property property = this.prop;
        PropertyEnv propertyEnv = this.env;
        Component component = this.customEditor;
        PropertyModel propertyModel = this.model;
        PropertyChangeListener propertyChangeListener = this.remoteEnvListener;
        VetoableChangeListener vetoableChangeListener = this.remotevEnvListener;
        this.setPropertyEnv(null);
        this.setPropertyEditor(null);
        this.remotevEnvListener = null;
        this.remoteEnvListener = null;
        this.customEditor = null;
        this.editor = null;
        this.prop = null;
        this.model = null;
        if (this.getUpdatePolicy() != 2) {
            new Spud(property, propertyEditor, propertyModel, propertyEnv, component, propertyChangeListener, vetoableChangeListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setPropertyEditor(PropertyEditor propertyEditor) {
        block8: {
            if (this.editor != null) {
                this.detachFromPropertyEditor(this.editor);
                this.ignoreChanges = true;
            }
            this.editor = propertyEditor;
            try {
                if (propertyEditor == null) break block8;
                if (!propertyEditor.supportsCustomEditor()) {
                    throw new IllegalArgumentException("Property editor " + propertyEditor + " for property " + this.getProperty() + " does not support a custom editor.");
                }
                try {
                    this.originalValue = propertyEditor.getValue();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                PropertyEnv propertyEnv = new PropertyEnv();
                propertyEnv.setFeatureDescriptor(EditorPropertyDisplayer.findFeatureDescriptor(this));
                this.setPropertyEnv(propertyEnv);
                if (propertyEditor instanceof ExPropertyEditor) {
                    ((ExPropertyEditor)propertyEditor).attachEnv(propertyEnv);
                }
                this.attachToPropertyEditor(propertyEditor);
            }
            finally {
                this.ignoreChanges = false;
            }
        }
    }

    private void setPropertyEnv(PropertyEnv propertyEnv) {
        if (this.env != null) {
            this.detachFromEnv(this.env);
        }
        this.env = propertyEnv;
        if (propertyEnv != null) {
            propertyEnv.setChangeImmediate(this.getUpdatePolicy() != 2);
            this.attachToEnv(propertyEnv);
        }
    }

    private void attachToEnv(PropertyEnv propertyEnv) {
        propertyEnv.addPropertyChangeListener(this.getEnvListener());
        propertyEnv.addVetoableChangeListener(this.getEnvListener());
        propertyEnv.setBeans(EditorPropertyDisplayer.findBeans(this));
    }

    private void detachFromEnv(PropertyEnv propertyEnv) {
        propertyEnv.removePropertyChangeListener(this.getEnvListener());
        propertyEnv.removeVetoableChangeListener(this.getEnvListener());
    }

    private void attachToPropertyEditor(PropertyEditor propertyEditor) {
        propertyEditor.addPropertyChangeListener(this.getEditorListener());
    }

    private void detachFromPropertyEditor(PropertyEditor propertyEditor) {
        propertyEditor.removePropertyChangeListener(this.getEditorListener());
    }

    private PropertyChangeListener getEditorListener() {
        if (this.editorListener == null) {
            this.editorListener = new EditorListener();
        }
        return this.editorListener;
    }

    private EnvListener getEnvListener() {
        if (this.envListener == null) {
            this.envListener = new EnvListener();
        }
        return this.envListener;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean commit() throws IllegalArgumentException {
        try {
            Object object;
            this.ignoreChanges = true;
            PropertyEditor propertyEditor = this.getPropertyEditor();
            Object object2 = this.getEnteredValue();
            try {
                if (object2 != null && object2.equals(this.getProperty().getValue())) {
                    boolean bl = false;
                    return bl;
                }
            }
            catch (Exception exception) {
                ErrorManager.getDefault().notify(1, (Throwable)exception);
                try {
                    if (this.getProperty().canRead()) {
                        propertyEditor.setValue(this.model.getValue());
                    }
                }
                catch (ProxyNode.DifferentValuesException differentValuesException) {
                }
                catch (Exception exception2) {
                    PropertyDialogManager.notify(exception2);
                }
                boolean bl = false;
                return bl;
            }
            PropertyEnv propertyEnv = this.getPropertyEnv();
            Exception exception = PropUtils.updatePropertyEditor(propertyEditor, object2);
            if (exception == null && propertyEnv != null && PropertyEnv.STATE_NEEDS_VALIDATION.equals(propertyEnv.getState())) {
                object = propertyEnv.silentlySetState(PropertyEnv.STATE_VALID, object2);
                System.err.println("  result of silent set state: " + (String)object);
                if (object != null && !PropertyEnv.STATE_VALID.equals(propertyEnv.getState())) {
                    IllegalArgumentException illegalArgumentException = new IllegalArgumentException("Error setting value");
                    ErrorManager.getDefault().annotate((Throwable)illegalArgumentException, 256, null, (String)object, null, null);
                    if (!PropertyEnv.STATE_INVALID.equals(propertyEnv.getState())) {
                        propertyEnv.silentlySetState(PropertyEnv.STATE_INVALID, null);
                    }
                    throw illegalArgumentException;
                }
            }
            object = Boolean.FALSE;
            if (exception == null) {
                object = PropUtils.noDlgUpdateProp(this.getModel(), propertyEditor);
                this.originalValue = propertyEditor.getValue();
                if (object instanceof Exception && !(object instanceof ProxyNode.DifferentValuesException)) {
                    exception = (Exception)object;
                }
                if (object instanceof InvocationTargetException || object instanceof IllegalAccessException) {
                    PropertyDialogManager.notify((Exception)object);
                }
            }
            if (exception != null) {
                if (exception instanceof IllegalArgumentException) {
                    throw (IllegalArgumentException)exception;
                }
                PropertyDialogManager.notify(exception);
                IllegalArgumentException illegalArgumentException = new IllegalArgumentException("Error setting value");
                ErrorManager.getDefault().annotate((Throwable)illegalArgumentException, 256, null, PropUtils.findLocalizedMessage(exception, object2, this.getProperty().getDisplayName()), (Throwable)exception, null);
                throw illegalArgumentException;
            }
            boolean bl = Boolean.TRUE.equals(object);
            if (bl) {
                this.fireActionPerformed();
            }
            boolean bl2 = bl;
            return bl2;
        }
        finally {
            this.ignoreChanges = false;
        }
    }

    PropertyModel getModel() {
        if (this.model == null) {
            return new NodePropertyModel(this.getProperty(), null);
        }
        return this.model;
    }

    void setModel(PropertyModel propertyModel) {
        this.model = propertyModel;
    }

    public PropertyEnv getPropertyEnv() {
        return this.env;
    }

    public Component getComponent() {
        return this.getCustomEditor();
    }

    public Object getEnteredValue() {
        PropertyEditor propertyEditor = this.getPropertyEditor();
        Object object = propertyEditor instanceof EnhancedCustomPropertyEditor ? ((EnhancedCustomPropertyEditor)((Object)propertyEditor)).getPropertyValue() : propertyEditor.getValue();
        return object;
    }

    public Node.Property getProperty() {
        return this.prop;
    }

    public int getUpdatePolicy() {
        return this.updatePolicy;
    }

    public String isModifiedValueLegal() {
        boolean bl = true;
        String string = null;
        PropertyEditor propertyEditor = this.getPropertyEditor();
        if (this.env != null) {
            bl = this.env.getState() != PropertyEnv.STATE_INVALID;
            System.err.println(" Attempting to validate env");
            if (bl) {
                if (PropertyEnv.STATE_NEEDS_VALIDATION.equals(this.env.getState())) {
                    string = this.env.silentlySetState(PropertyEnv.STATE_VALID, this.getEnteredValue());
                    bl = string == null;
                }
            }
        } else if (propertyEditor instanceof EnhancedCustomPropertyEditor) {
            Object object = ((EnhancedCustomPropertyEditor)((Object)propertyEditor)).getPropertyValue();
            try {
                propertyEditor.setValue(object);
            }
            catch (IllegalStateException illegalStateException) {
                bl = false;
                string = PropUtils.findLocalizedMessage(illegalStateException, object, this.getProperty().getDisplayName());
            }
        }
        if (!bl && string == null) {
            string = MessageFormat.format(NbBundle.getMessage((Class)CustomEditorDisplayer.class, (String)"FMT_CannotUpdateProperty"), propertyEditor.getValue(), this.getProperty().getDisplayName());
        }
        return string;
    }

    public boolean isValueModified() {
        boolean bl;
        PropertyEditor propertyEditor = this.getPropertyEditor();
        boolean bl2 = bl = propertyEditor.getValue() != this.originalValue;
        if (!bl && propertyEditor instanceof EnhancedCustomPropertyEditor) {
            Object object = ((EnhancedCustomPropertyEditor)((Object)propertyEditor)).getPropertyValue();
            bl = object != null ? object.equals(this.originalValue) : this.originalValue == null;
        }
        return bl;
    }

    public void refresh() {
    }

    public void reset() {
        try {
            this.originalValue = this.getProperty().getValue();
            this.getPropertyEditor().setValue(this.originalValue);
        }
        catch (Exception exception) {
            ErrorManager.getDefault().notify(16, (Throwable)exception);
        }
    }

    public void setEnabled(boolean bl) {
        Container container = (Container)this.getComponent();
        if (container instanceof Container) {
            this.setEnabled(container, bl);
        }
        container.setEnabled(bl);
    }

    public void setEnabled(Container container, boolean bl) {
        Component[] componentArray = container.getComponents();
        for (int i = 0; i < componentArray.length; ++i) {
            Boolean bl2;
            if (!(componentArray[i] instanceof JScrollBar)) {
                componentArray[i].setEnabled(false);
            } else {
                ((JScrollBar)componentArray[i]).setFocusable(bl);
            }
            if (!(componentArray[i] instanceof Container)) continue;
            boolean bl3 = false;
            if (componentArray[i] instanceof JComponent && (bl2 = (Boolean)((JComponent)componentArray[i]).getClientProperty("dontEnableMe")) != null) {
                bl3 = bl2;
            }
            if (bl3) continue;
            this.setEnabled((Container)componentArray[i], bl);
        }
        container.setEnabled(bl);
    }

    public void setEnteredValue(Object object) {
        PropUtils.updatePropertyEditor(this.getPropertyEditor(), object);
    }

    public void setActionCommand(String string) {
    }

    public String getActionCommand() {
        return null;
    }

    public synchronized void addActionListener(ActionListener actionListener) {
        if (this.listenerList == null) {
            this.listenerList = new EventListenerList();
        }
        this.listenerList.add(ActionListener.class, actionListener);
    }

    public synchronized void removeActionListener(ActionListener actionListener) {
        this.listenerList.remove(ActionListener.class, actionListener);
    }

    private void fireActionPerformed() {
        ActionEvent actionEvent = new ActionEvent(this, 1001, "userChangedValue");
        if (this.listenerList == null) {
            return;
        }
        Object[] objectArray = this.listenerList.getListenerList();
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != (class$java$awt$event$ActionListener == null ? CustomEditorDisplayer.class$("java.awt.event.ActionListener") : class$java$awt$event$ActionListener)) continue;
            ((ActionListener)objectArray[i + 1]).actionPerformed(actionEvent);
        }
    }

    public synchronized void addChangeListener(ChangeListener changeListener) {
        if (this.listenerList == null) {
            this.listenerList = new EventListenerList();
        }
        this.listenerList.add(ChangeListener.class, changeListener);
    }

    public synchronized void removeChangeListener(ChangeListener changeListener) {
        this.listenerList.remove(ChangeListener.class, changeListener);
    }

    private void fireStateChanged() {
        ChangeEvent changeEvent = new ChangeEvent(this);
        if (this.listenerList == null) {
            return;
        }
        Object[] objectArray = this.listenerList.getListenerList();
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != (class$javax$swing$event$ChangeListener == null ? CustomEditorDisplayer.class$("javax.swing.event.ChangeListener") : class$javax$swing$event$ChangeListener)) continue;
            ((ChangeListener)objectArray[i + 1]).stateChanged(changeEvent);
        }
    }

    void setRemoteEnvListener(PropertyChangeListener propertyChangeListener) {
        this.remoteEnvListener = propertyChangeListener;
    }

    void setRemoteEnvVetoListener(VetoableChangeListener vetoableChangeListener) {
        this.remotevEnvListener = vetoableChangeListener;
    }

    private class EditorListener
    implements PropertyChangeListener {
        private EditorListener() {
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if (CustomEditorDisplayer.this.ignoreChanges) {
                return;
            }
            if ("propertyValueValid".equals(propertyChangeEvent.getPropertyName())) {
                return;
            }
            if (CustomEditorDisplayer.this.ignoreChanges2) {
                return;
            }
            CustomEditorDisplayer.this.ignoreChanges2 = true;
            if (CustomEditorDisplayer.this.getUpdatePolicy() != 2) {
                CustomEditorDisplayer.this.commit();
            }
            CustomEditorDisplayer.this.fireStateChanged();
            CustomEditorDisplayer.this.ignoreChanges2 = false;
        }
    }

    private class EnvListener
    implements PropertyChangeListener,
    VetoableChangeListener {
        private EnvListener() {
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            CustomEditorDisplayer.this.fireStateChanged();
            if (CustomEditorDisplayer.this.remoteEnvListener != null) {
                CustomEditorDisplayer.this.remoteEnvListener.propertyChange(propertyChangeEvent);
            }
        }

        public void vetoableChange(PropertyChangeEvent propertyChangeEvent) throws PropertyVetoException {
            if (CustomEditorDisplayer.this.remotevEnvListener != null) {
                CustomEditorDisplayer.this.remotevEnvListener.vetoableChange(propertyChangeEvent);
            }
        }
    }

    private static final class Spud
    implements PropertyChangeListener,
    VetoableChangeListener {
        WeakReference envListener = null;
        WeakReference venvListener = null;
        WeakReference editor = null;
        WeakReference property = null;
        WeakReference env = null;
        WeakReference customEditor = null;
        WeakReference model = null;
        private boolean inGetModel = false;
        private boolean inGetProperty = false;
        private boolean ignoreChanges = false;

        public Spud(Node.Property property, PropertyEditor propertyEditor, PropertyModel propertyModel, PropertyEnv propertyEnv, Component component, PropertyChangeListener propertyChangeListener, VetoableChangeListener vetoableChangeListener) {
            if (property != null) {
                this.property = new WeakReference<WeakReference>(this.property);
            }
            if (propertyEditor != null) {
                this.editor = new WeakReference<PropertyEditor>(propertyEditor);
            }
            if (propertyEnv != null) {
                this.env = new WeakReference<PropertyEnv>(propertyEnv);
                propertyEnv.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this, (Object)propertyEnv));
                propertyEnv.addVetoableChangeListener(WeakListeners.vetoableChange((VetoableChangeListener)this, (Object)propertyEnv));
            }
            if (component != null) {
                this.customEditor = new WeakReference<Component>(component);
            }
            if (propertyChangeListener != null) {
                this.envListener = new WeakReference<PropertyChangeListener>(propertyChangeListener);
            }
            if (vetoableChangeListener != null) {
                this.venvListener = new WeakReference<VetoableChangeListener>(vetoableChangeListener);
            }
            if (propertyModel != null) {
                this.model = new WeakReference<PropertyModel>(propertyModel);
                propertyModel.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this, (Object)propertyEditor));
            }
            if (propertyEditor != null) {
                propertyEditor.addPropertyChangeListener(this);
            }
        }

        private PropertyEnv getEnv() {
            PropertyEnv propertyEnv = null;
            if (this.env != null) {
                propertyEnv = (PropertyEnv)this.env.get();
            }
            return propertyEnv;
        }

        private Component getCustomEditor() {
            Component component = null;
            if (this.customEditor != null) {
                component = (Component)this.customEditor.get();
            }
            return component;
        }

        private VetoableChangeListener getVetoListener() {
            VetoableChangeListener vetoableChangeListener = null;
            if (this.venvListener != null) {
                vetoableChangeListener = (VetoableChangeListener)this.venvListener.get();
            }
            return vetoableChangeListener;
        }

        private PropertyChangeListener getPropListener() {
            PropertyChangeListener propertyChangeListener = null;
            if (this.venvListener != null) {
                propertyChangeListener = (PropertyChangeListener)this.venvListener.get();
            }
            return propertyChangeListener;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Node.Property getProperty() {
            Node.Property property = null;
            this.inGetProperty = true;
            try {
                if (this.property != null) {
                    property = (Node.Property)this.property.get();
                }
                if (property == null && !this.inGetModel) {
                    PropertyModel propertyModel = this.getModel();
                }
            }
            finally {
                this.inGetProperty = false;
            }
            return property;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private synchronized PropertyModel getModel() {
            this.inGetModel = true;
            PropertyModel propertyModel = null;
            try {
                Node.Property property;
                if (this.model != null) {
                    propertyModel = (PropertyModel)this.model.get();
                }
                if (propertyModel == null && !this.inGetProperty && (property = this.getProperty()) != null) {
                    NodePropertyModel nodePropertyModel = new NodePropertyModel(property, null);
                    return nodePropertyModel;
                }
            }
            finally {
                this.inGetModel = false;
            }
            return propertyModel;
        }

        private PropertyEditor getPropertyEditor() {
            Object object;
            PropertyEditor propertyEditor = null;
            if (this.editor != null) {
                propertyEditor = (PropertyEditor)this.editor.get();
            }
            if (propertyEditor == null && (object = this.getProperty()) != null) {
                propertyEditor = object.getPropertyEditor();
                this.editor = new WeakReference<PropertyEditor>(propertyEditor);
            }
            if (propertyEditor == null && (object = this.getModel()) != null) {
                Node.Property property = ModelProperty.toProperty((PropertyModel)object);
                propertyEditor = property.getPropertyEditor();
                this.editor = new WeakReference<PropertyEditor>(propertyEditor);
            }
            return propertyEditor;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if (this.ignoreChanges) {
                return;
            }
            if ("propertyValueValid".equals(propertyChangeEvent.getPropertyName())) {
                return;
            }
            this.ignoreChanges = true;
            try {
                PropertyChangeListener propertyChangeListener;
                if (propertyChangeEvent.getSource() instanceof PropertyEnv && (propertyChangeListener = this.getPropListener()) != null) {
                    propertyChangeListener.propertyChange(propertyChangeEvent);
                }
                if (propertyChangeEvent.getSource() instanceof PropertyModel) {
                    // empty if block
                }
                if (propertyChangeEvent.getSource() instanceof PropertyEditor) {
                    this.handleChangeFromEditor((PropertyEditor)propertyChangeEvent.getSource());
                }
            }
            finally {
                this.ignoreChanges = false;
            }
        }

        private void handleChangeFromEditor(PropertyEditor propertyEditor) {
            this.commit(propertyEditor);
        }

        public void vetoableChange(PropertyChangeEvent propertyChangeEvent) throws PropertyVetoException {
            VetoableChangeListener vetoableChangeListener = this.getVetoListener();
            if (vetoableChangeListener != null) {
                vetoableChangeListener.vetoableChange(propertyChangeEvent);
            }
        }

        public Object getEnteredValue(PropertyEditor propertyEditor) {
            Object object = null;
            Component component = this.getCustomEditor();
            if (propertyEditor instanceof EnhancedCustomPropertyEditor) {
                object = ((EnhancedCustomPropertyEditor)((Object)propertyEditor)).getPropertyValue();
            } else if (this.customEditor instanceof EnhancedCustomPropertyEditor) {
                object = ((EnhancedCustomPropertyEditor)((Object)component)).getPropertyValue();
            }
            if (object == null) {
                object = propertyEditor.getValue();
            }
            return object;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean commit(PropertyEditor propertyEditor) {
            try {
                Object object;
                Object object2;
                PropertyModel propertyModel = this.getModel();
                Node.Property property = this.getProperty();
                Object object3 = this.getEnteredValue(propertyEditor);
                if (propertyModel != null) {
                    object2 = propertyModel.getValue();
                } else if (property != null) {
                    object2 = property.getValue();
                } else {
                    if (propertyEditor != null) {
                        propertyEditor.removePropertyChangeListener(this);
                    }
                    boolean bl = false;
                    return bl;
                }
                PropertyEnv propertyEnv = this.getEnv();
                try {
                    if (object3 != null && object3.equals(object2)) {
                        boolean bl = false;
                        return bl;
                    }
                }
                catch (Exception exception) {
                    ErrorManager.getDefault().notify(1, (Throwable)exception);
                    try {
                        if (property.canRead()) {
                            propertyEditor.setValue(propertyModel.getValue());
                        }
                    }
                    catch (ProxyNode.DifferentValuesException differentValuesException) {
                    }
                    catch (Exception exception2) {
                        PropertyDialogManager.notify(exception2);
                    }
                    boolean bl = false;
                    return bl;
                }
                Exception exception = PropUtils.updatePropertyEditor(propertyEditor, object3);
                if (exception == null && propertyEnv != null && PropertyEnv.STATE_NEEDS_VALIDATION.equals(propertyEnv.getState())) {
                    object = propertyEnv.silentlySetState(PropertyEnv.STATE_VALID, object3);
                    if (object != null && !PropertyEnv.STATE_VALID.equals(propertyEnv.getState())) {
                        IllegalArgumentException illegalArgumentException = new IllegalArgumentException("Error setting value");
                        ErrorManager.getDefault().annotate((Throwable)illegalArgumentException, 256, null, (String)object, null, null);
                        if (!PropertyEnv.STATE_INVALID.equals(propertyEnv.getState())) {
                            propertyEnv.silentlySetState(PropertyEnv.STATE_INVALID, null);
                        }
                        throw illegalArgumentException;
                    }
                }
                object = Boolean.FALSE;
                if (exception == null) {
                    object = PropUtils.noDlgUpdateProp(propertyModel, propertyEditor);
                    if (object instanceof Exception && !(object instanceof ProxyNode.DifferentValuesException)) {
                        exception = (Exception)object;
                    }
                    if (object instanceof InvocationTargetException || object instanceof IllegalAccessException) {
                        PropertyDialogManager.notify((Exception)object);
                    }
                }
                if (exception != null) {
                    if (exception instanceof IllegalArgumentException) {
                        throw (IllegalArgumentException)exception;
                    }
                    PropertyDialogManager.notify(exception);
                    IllegalArgumentException illegalArgumentException = new IllegalArgumentException("Error setting value");
                    ErrorManager.getDefault().annotate((Throwable)illegalArgumentException, 256, null, PropUtils.findLocalizedMessage(exception, object3, this.getProperty().getDisplayName()), (Throwable)exception, null);
                    throw illegalArgumentException;
                }
                boolean bl = Boolean.TRUE.equals(object);
                if (bl && propertyEnv != null) {
                    propertyEnv.setState(PropertyEnv.STATE_VALID);
                }
                boolean bl2 = bl;
                return bl2;
            }
            catch (Exception exception) {
                ErrorManager.getDefault().notify((Throwable)exception);
            }
            finally {
                this.ignoreChanges = false;
            }
            return false;
        }
    }
}

