/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.startup;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.net.URL;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import javax.accessibility.Accessible;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.KeyStroke;
import javax.swing.SwingConstants;
import javax.swing.SwingUtilities;
import org.openide.ErrorManager;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

public final class Splash
implements SwingConstants {
    static Reference splashRef;
    static Reference aboutRef;

    public static void showSplashDialog(Frame frame, JComponent jComponent, JComponent jComponent2) {
        Splash.createSplashDialog(frame, jComponent, jComponent2).setVisible(true);
    }

    static JDialog createSplashDialog(Frame frame, JComponent jComponent, JComponent jComponent2) {
        SplashDialog splashDialog = new SplashDialog(frame, jComponent, jComponent2);
        return splashDialog;
    }

    public static SplashOutput showSplash() {
        SplashWindow splashWindow = new SplashWindow();
        SwingUtilities.invokeLater(new SplashRunner(splashWindow, true));
        return splashWindow;
    }

    public static void hideSplash(SplashOutput splashOutput) {
        Window window = (Window)((Object)splashOutput);
        ((SplashOutputInternal)((Object)splashOutput)).hideRequested();
        SwingUtilities.invokeLater(new SplashRunner(window, false));
    }

    public static boolean isVisible(SplashOutput splashOutput) {
        return !((SplashOutputInternal)((Object)splashOutput)).isHideRequested();
    }

    public static final void center(Window window) {
        window.pack();
        window.setBounds(Utilities.findCenterBounds((Dimension)window.getSize()));
    }

    static Image getSplash() {
        Image image;
        if (splashRef == null || (image = (Image)splashRef.get()) == null) {
            image = Splash.loadSplash();
            splashRef = new WeakReference<Image>(image);
        }
        return image;
    }

    static Image getAbout() {
        Image image;
        if (aboutRef == null || (image = (Image)aboutRef.get()) == null) {
            image = Splash.loadAbout();
            aboutRef = new WeakReference<Image>(image);
        }
        return image;
    }

    private static Image loadSplash() {
        URL uRL = NbBundle.getLocalizedFile((String)"org.netbeans.core.startup.splash", (String)"gif", (Locale)Locale.getDefault(), (ClassLoader)Splash.class.getClassLoader());
        return Toolkit.getDefaultToolkit().getImage(uRL);
    }

    private static Image loadAbout() {
        try {
            URL uRL = NbBundle.getLocalizedFile((String)"org.netbeans.core.startup.about", (String)"gif", (Locale)Locale.getDefault(), (ClassLoader)Splash.class.getClassLoader());
            return Toolkit.getDefaultToolkit().getImage(uRL);
        }
        catch (MissingResourceException missingResourceException) {
            return Splash.loadSplash();
        }
    }

    private static class AboutComponent
    extends SplashComponent {
        public AboutComponent() {
            ResourceBundle resourceBundle = NbBundle.getBundle((Class)(class$org$netbeans$core$startup$Splash == null ? (class$org$netbeans$core$startup$Splash = Splash.class$("org.netbeans.core.startup.Splash")) : class$org$netbeans$core$startup$Splash));
            this.image = new ImageIcon(Splash.getAbout()).getImage();
            StringTokenizer stringTokenizer = new StringTokenizer(resourceBundle.getString("AboutTextBounds"), " ,");
            view = new Rectangle(Integer.parseInt(stringTokenizer.nextToken()), Integer.parseInt(stringTokenizer.nextToken()), Integer.parseInt(stringTokenizer.nextToken()), Integer.parseInt(stringTokenizer.nextToken()));
            Integer n = Integer.decode(resourceBundle.getString("AboutTextColor"));
            color_text = new Color(n);
        }
    }

    private static class SplashComponent
    extends JComponent
    implements Accessible {
        private static final long serialVersionUID = -1162806313274828742L;
        private FontMetrics fm;
        static Rectangle view;
        static Color color_text;
        static Color color_bar;
        static Color color_edge;
        static Color color_corner;
        static boolean draw_bar;
        protected Image image;
        private Rectangle dirty = new Rectangle();
        private String text;
        private Rectangle rect = new Rectangle();
        private Rectangle bar = new Rectangle();
        private Rectangle bar_inc = new Rectangle();
        private int progress = 0;
        private int maxSteps = 0;
        private int tmpSteps = 0;
        private int barStart = 0;
        private int barLength = 0;

        public SplashComponent() {
            Object object;
            this.image = new ImageIcon(Splash.getSplash()).getImage();
            ResourceBundle resourceBundle = NbBundle.getBundle((Class)(class$org$netbeans$core$startup$Splash == null ? (class$org$netbeans$core$startup$Splash = Splash.class$("org.netbeans.core.startup.Splash")) : class$org$netbeans$core$startup$Splash));
            StringTokenizer stringTokenizer = new StringTokenizer(resourceBundle.getString("SplashRunningTextBounds"), " ,");
            view = new Rectangle(Integer.parseInt(stringTokenizer.nextToken()), Integer.parseInt(stringTokenizer.nextToken()), Integer.parseInt(stringTokenizer.nextToken()), Integer.parseInt(stringTokenizer.nextToken()));
            draw_bar = true;
            try {
                draw_bar = resourceBundle.getString("SplashShowProgressBar").equals("true");
                stringTokenizer = new StringTokenizer(resourceBundle.getString("SplashProgressBarBounds"), " ,");
                try {
                    this.bar = new Rectangle(Integer.parseInt(stringTokenizer.nextToken()), Integer.parseInt(stringTokenizer.nextToken()), Integer.parseInt(stringTokenizer.nextToken()), Integer.parseInt(stringTokenizer.nextToken()));
                    this.maxSteps = 350;
                    Integer n = Integer.decode(resourceBundle.getString("SplashRunningTextColor"));
                    color_text = new Color(n);
                    n = Integer.decode(resourceBundle.getString("SplashProgressBarColor"));
                    color_bar = new Color(n);
                    n = Integer.decode(resourceBundle.getString("SplashProgressBarEdgeColor"));
                    color_edge = new Color(n);
                    n = Integer.decode(resourceBundle.getString("SplashProgressBarCornerColor"));
                    color_corner = new Color(n);
                }
                catch (NumberFormatException numberFormatException) {
                    ErrorManager.getDefault().log(16, "Number format exception loading splash screen parameters.");
                    ErrorManager.getDefault().notify(16, (Throwable)numberFormatException);
                    color_text = Color.BLACK;
                    color_bar = Color.ORANGE;
                    color_edge = Color.BLUE;
                    color_corner = Color.GREEN;
                    this.bar = new Rectangle(0, 0, 80, 10);
                    draw_bar = false;
                }
            }
            catch (MissingResourceException missingResourceException) {
                draw_bar = false;
            }
            int n = 12;
            try {
                object = resourceBundle.getString("SplashRunningTextFontSize");
                n = Integer.parseInt((String)object);
            }
            catch (MissingResourceException missingResourceException) {
            }
            catch (NumberFormatException numberFormatException) {
                n = 11;
            }
            object = new Font("Dialog", 0, n);
            this.setFont((Font)object);
            this.fm = this.getFontMetrics((Font)object);
        }

        public void setText(final String string) {
            if (string != null && string.equals(this.text)) {
                return;
            }
            EventQueue.invokeLater(new Runnable(){

                public void run() {
                    if (string == null) {
                        SplashComponent.this.repaint(SplashComponent.this.dirty);
                        return;
                    }
                    if (SplashComponent.this.fm == null) {
                        return;
                    }
                    SplashComponent.this.adjustText(string);
                    SwingUtilities.layoutCompoundLabel(SplashComponent.this.fm, string, null, 3, 2, 3, 2, view, new Rectangle(), SplashComponent.this.rect, 0);
                    SplashComponent.this.dirty = SplashComponent.this.dirty.union(SplashComponent.this.rect);
                    SplashComponent.this.repaint(SplashComponent.this.dirty);
                    SplashComponent.this.dirty = new Rectangle(SplashComponent.this.rect);
                }
            });
        }

        public void setMaxSteps(int n) {
            this.maxSteps = n;
        }

        public void addToMaxSteps(int n) {
            this.tmpSteps += n;
        }

        public void addAndSetMaxSteps(int n) {
            this.tmpSteps += n;
            this.maxSteps = this.tmpSteps;
        }

        public void increment(int n) {
            if (draw_bar) {
                int n2;
                this.progress += n;
                if (this.progress > this.maxSteps) {
                    this.progress = this.maxSteps;
                } else if (this.maxSteps > 0 && ((n2 = this.bar.width * this.progress / this.maxSteps - this.barStart) > 1 || this.barStart % 2 == 0)) {
                    this.barLength = n2;
                    this.bar_inc = new Rectangle(this.bar.x + this.barStart, this.bar.y, this.barLength + 1, this.bar.height);
                    this.repaint(this.bar_inc);
                }
            }
        }

        private void adjustText(String string) {
            String string2 = null;
            if (string == null) {
                return;
            }
            if (this.fm == null) {
                return;
            }
            int n = this.fm.stringWidth(string);
            if (n > SplashComponent.view.width) {
                String string3;
                StringTokenizer stringTokenizer = new StringTokenizer(string);
                while (stringTokenizer.hasMoreTokens()) {
                    String string4 = stringTokenizer.nextToken();
                    string3 = string2 == null ? string4 : string2 + " " + string4;
                    if (this.fm.stringWidth(string3 + "...") > SplashComponent.view.width) {
                        this.text = string2 + "...";
                        break;
                    }
                    string2 = string3;
                }
                if (string2 == null) {
                    this.text = "";
                    string3 = "";
                    string2 = "";
                    for (int i = 0; i < string.length(); ++i) {
                        if (this.fm.stringWidth((string3 = string3 + string.charAt(i)) + "...") > SplashComponent.view.width) {
                            this.text = string2 + "...";
                            break;
                        }
                        string2 = string3;
                    }
                }
            } else {
                this.text = string;
            }
        }

        public void update(Graphics graphics) {
            this.paint(graphics);
        }

        public void paint(Graphics graphics) {
            graphics.setColor(color_text);
            graphics.drawImage(this.image, 0, 0, null);
            if (this.text == null) {
                return;
            }
            if (this.fm == null) {
                return;
            }
            SwingUtilities.layoutCompoundLabel(this.fm, this.text, null, 3, 2, 3, 2, view, new Rectangle(), this.rect, 0);
            Graphics2D graphics2D = (Graphics2D)graphics;
            graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
            graphics.drawString(this.text, this.rect.x, this.rect.y + this.fm.getAscent());
            if (draw_bar && !Boolean.getBoolean("netbeans.splash.nobar") && this.maxSteps > 0) {
                graphics.setColor(color_bar);
                graphics.fillRect(this.bar.x, this.bar.y, this.barStart + this.barLength, this.bar.height);
                graphics.setColor(color_corner);
                graphics.drawLine(this.bar.x, this.bar.y, this.bar.x, this.bar.y + this.bar.height);
                graphics.drawLine(this.bar.x + this.barStart + this.barLength, this.bar.y, this.bar.x + this.barStart + this.barLength, this.bar.y + this.bar.height);
                graphics.setColor(color_edge);
                graphics.drawLine(this.bar.x, this.bar.y + this.bar.height / 2, this.bar.x, this.bar.y + this.bar.height / 2);
                graphics.drawLine(this.bar.x + this.barStart + this.barLength, this.bar.y + this.bar.height / 2, this.bar.x + this.barStart + this.barLength, this.bar.y + this.bar.height / 2);
                this.barStart += this.barLength;
                this.barLength = 0;
            }
        }

        public Dimension getPreferredSize() {
            return new Dimension(this.image.getWidth(null), this.image.getHeight(null));
        }

        public Dimension getMinimumSize() {
            return this.getPreferredSize();
        }

        public boolean isOpaque() {
            return true;
        }
    }

    private static class SplashDialog
    extends JDialog
    implements SplashOutput,
    SplashOutputInternal,
    ActionListener {
        static final long serialVersionUID = 5185644855500178404L;
        private final SplashComponent splashComponent = new AboutComponent();
        private boolean hideRequested = false;

        public SplashDialog(Frame frame, JComponent jComponent, JComponent jComponent2) {
            super(frame, true);
            JTabbedPane jTabbedPane = new JTabbedPane();
            this.setTitle(NbBundle.getMessage((Class)(class$org$netbeans$core$startup$Splash == null ? (class$org$netbeans$core$startup$Splash = Splash.class$("org.netbeans.core.startup.Splash")) : class$org$netbeans$core$startup$Splash), (String)"CTL_About_Title"));
            jTabbedPane.addTab(NbBundle.getMessage((Class)(class$org$netbeans$core$startup$Splash == null ? (class$org$netbeans$core$startup$Splash = Splash.class$("org.netbeans.core.startup.Splash")) : class$org$netbeans$core$startup$Splash), (String)"CTL_About_Title"), this.getSplashPanel(jComponent2));
            jTabbedPane.addTab(NbBundle.getMessage((Class)(class$org$netbeans$core$startup$Splash == null ? (class$org$netbeans$core$startup$Splash = Splash.class$("org.netbeans.core.startup.Splash")) : class$org$netbeans$core$startup$Splash), (String)"CTL_About_Detail"), jComponent);
            this.getContentPane().add((Component)jTabbedPane, "Center");
            this.getRootPane().registerKeyboardAction(this, KeyStroke.getKeyStroke(27, 0), 1);
            jTabbedPane.getAccessibleContext().setAccessibleName(NbBundle.getMessage((Class)(class$org$netbeans$core$startup$Splash == null ? (class$org$netbeans$core$startup$Splash = Splash.class$("org.netbeans.core.startup.Splash")) : class$org$netbeans$core$startup$Splash), (String)"ACSN_AboutTabs"));
            jTabbedPane.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage((Class)(class$org$netbeans$core$startup$Splash == null ? (class$org$netbeans$core$startup$Splash = Splash.class$("org.netbeans.core.startup.Splash")) : class$org$netbeans$core$startup$Splash), (String)"ACSD_AboutTabs"));
            this.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage((Class)(class$org$netbeans$core$startup$Splash == null ? (class$org$netbeans$core$startup$Splash = Splash.class$("org.netbeans.core.startup.Splash")) : class$org$netbeans$core$startup$Splash), (String)"ACSD_AboutDialog"));
            Splash.center(this);
            this.setDefaultCloseOperation(2);
        }

        private JComponent getSplashPanel(JComponent jComponent) {
            JPanel jPanel = new JPanel(new GridBagLayout());
            jPanel.add((Component)this.splashComponent, new GridBagConstraints());
            if (jComponent != null) {
                GridBagConstraints gridBagConstraints = new GridBagConstraints();
                gridBagConstraints.gridx = 0;
                gridBagConstraints.gridy = 1;
                gridBagConstraints.fill = 3;
                gridBagConstraints.weightx = 1.0;
                gridBagConstraints.weighty = 1.0;
                JPanel jPanel2 = new JPanel(){

                    public Dimension getPreferredSize() {
                        return new Dimension(SplashDialog.this.splashComponent.getWidth(), super.getPreferredSize().height);
                    }

                    public Dimension getMinimumSize() {
                        return this.getPreferredSize();
                    }
                };
                jPanel2.setLayout(new BorderLayout());
                jPanel2.add((Component)jComponent, "Center");
                jPanel.add((Component)jPanel2, gridBagConstraints);
            }
            return jPanel;
        }

        public void print(String string) {
            this.splashComponent.setText(string);
        }

        public boolean isHideRequested() {
            return this.hideRequested;
        }

        public void hideRequested() {
            this.hideRequested = true;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            this.setVisible(false);
            this.dispose();
        }

        public void increment(int n) {
        }

        public void setMaxSteps(int n) {
        }

        public void addToMaxSteps(int n) {
        }

        public void addAndSetMaxSteps(int n) {
        }

        public Component getComponent() {
            return this;
        }
    }

    public static interface SplashOutput {
        public void print(String var1);

        public void setMaxSteps(int var1);

        public void addToMaxSteps(int var1);

        public void addAndSetMaxSteps(int var1);

        public void increment(int var1);

        public Component getComponent();
    }

    private static interface SplashOutputInternal {
        public void hideRequested();

        public boolean isHideRequested();
    }

    private static class SplashRunner
    implements Runnable {
        private Window splashWindow;
        private boolean visible;

        public SplashRunner(Window window, boolean bl) {
            this.splashWindow = window;
            this.visible = bl;
        }

        public void run() {
            if (this.visible) {
                Splash.center(this.splashWindow);
                this.splashWindow.setVisible(true);
                this.splashWindow.toFront();
            } else {
                this.splashWindow.setVisible(false);
                this.splashWindow.dispose();
            }
        }
    }

    private static class SplashWindow
    extends Frame
    implements SplashOutput,
    SplashOutputInternal {
        static final long serialVersionUID = 4838519880359397841L;
        private final SplashComponent splashComponent = new SplashComponent();
        private static final String ICON_SMALL = "org/netbeans/core/startup/frame.gif";
        private static final String ICON_BIG = "org/netbeans/core/startup/frame32.gif";
        private boolean hideRequested = false;

        public SplashWindow() {
            super(NbBundle.getMessage((Class)(class$org$netbeans$core$startup$Splash == null ? (class$org$netbeans$core$startup$Splash = Splash.class$("org.netbeans.core.startup.Splash")) : class$org$netbeans$core$startup$Splash), (String)"LBL_splash_window_title"));
            this.setIconImage(SplashWindow.createIDEImage());
            this.setUndecorated(true);
            this.setLayout(new BorderLayout());
            this.add((Component)this.splashComponent, "Center");
        }

        private static Image createIDEImage() {
            return Utilities.loadImage((String)(Utilities.isLargeFrameIcons() ? ICON_BIG : ICON_SMALL), (boolean)true);
        }

        public Dimension getPreferredSize() {
            int n = Integer.parseInt(NbBundle.getMessage((Class)(class$org$netbeans$core$startup$Splash == null ? (class$org$netbeans$core$startup$Splash = Splash.class$("org.netbeans.core.startup.Splash")) : class$org$netbeans$core$startup$Splash), (String)"SPLASH_WIDTH"));
            int n2 = Integer.parseInt(NbBundle.getMessage((Class)(class$org$netbeans$core$startup$Splash == null ? (class$org$netbeans$core$startup$Splash = Splash.class$("org.netbeans.core.startup.Splash")) : class$org$netbeans$core$startup$Splash), (String)"SPLASH_HEIGHT"));
            return new Dimension(n, n2);
        }

        public void print(String string) {
            this.splashComponent.setText(string);
        }

        public boolean isHideRequested() {
            return this.hideRequested;
        }

        public void hideRequested() {
            this.hideRequested = true;
        }

        public void increment(int n) {
            this.splashComponent.increment(n);
        }

        public void setMaxSteps(int n) {
            this.splashComponent.setMaxSteps(n);
        }

        public void addToMaxSteps(int n) {
            this.splashComponent.addToMaxSteps(n);
        }

        public void addAndSetMaxSteps(int n) {
            this.splashComponent.addAndSetMaxSteps(n);
        }

        public Component getComponent() {
            return this;
        }
    }
}

