/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.startup;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import org.netbeans.Events;
import org.netbeans.InvalidException;
import org.netbeans.Module;
import org.netbeans.ModuleInstaller;
import org.netbeans.ModuleManager;
import org.netbeans.Util;
import org.netbeans.core.startup.AutomaticDependencies;
import org.netbeans.core.startup.CoreBridge;
import org.netbeans.core.startup.Main;
import org.netbeans.core.startup.MainLookup;
import org.netbeans.core.startup.ManifestSection;
import org.netbeans.core.startup.ModuleHistory;
import org.netbeans.core.startup.ModuleList;
import org.netbeans.core.startup.layers.ModuleLayeredFileSystem;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.Repository;
import org.openide.modules.Dependency;
import org.openide.modules.ModuleInstall;
import org.openide.modules.SpecificationVersion;
import org.openide.util.NbBundle;
import org.openide.util.SharedClassObject;
import org.openide.util.Utilities;
import org.openide.util.lookup.InstanceContent;
import org.xml.sax.SAXException;

final class NbInstaller
extends ModuleInstaller {
    private final Map sections = new HashMap(100);
    private final Map installs = new HashMap(100);
    private final Map layers = new HashMap(100);
    private boolean initializedFolderLookup = false;
    private final Events ev;
    private ModuleList moduleList;
    private ModuleManager mgr;
    private final Map kosherPackages = new HashMap(100);
    private static String[] specialResourcePrefixes;
    private final InstanceContent.Convertor convertor = new Convertor();
    private AutomaticDependencies autoDepsHandler = null;
    private static final String[] CLASSPATH_PACKAGES;
    private static boolean withoutOptimizations;
    private static final String[][] CLASSPATH_JARS;
    private File manifestCacheFile;
    private boolean usingManifestCache = Boolean.valueOf(System.getProperty("netbeans.cache.manifests", "true"));
    private Map manifestCache;
    private boolean manifestCacheDirty;
    static /* synthetic */ Class class$org$openide$modules$ModuleInstall;
    static final /* synthetic */ boolean $assertionsDisabled;

    public NbInstaller(Events events) {
        if (this.usingManifestCache) {
            String string = System.getProperty("netbeans.user");
            if (string != null) {
                this.manifestCacheFile = new File(new File(new File(new File(string), "var"), "cache"), "all-manifests.dat");
                Util.err.log("Using manifest cache in " + this.manifestCacheFile);
            } else {
                this.usingManifestCache = false;
                Util.err.log("Not using any manifest cache; no user directory");
            }
        } else {
            Util.err.log("Manifest cache disabled");
        }
        this.manifestCache = null;
        this.manifestCacheDirty = false;
        this.ev = events;
    }

    void registerList(ModuleList moduleList) {
        if (this.moduleList != null) {
            throw new IllegalStateException();
        }
        this.moduleList = moduleList;
    }

    void registerManager(ModuleManager moduleManager) {
        if (this.mgr != null) {
            throw new IllegalStateException();
        }
        this.mgr = moduleManager;
    }

    public void prepare(Module module) throws InvalidException {
        Object object;
        Map.Entry<String, Attributes> entry;
        this.ev.log("prepare", (Object)module);
        HashSet<ManifestSection> hashSet = null;
        Class<?> clazz = null;
        Object object2 = module.getManifest().getEntries().entrySet().iterator();
        while (object2.hasNext()) {
            entry = object2.next();
            object = ManifestSection.create(entry.getKey(), entry.getValue(), module);
            if (object == null) continue;
            if (hashSet == null) {
                hashSet = new HashSet<ManifestSection>(25);
            }
            hashSet.add((ManifestSection)object);
        }
        object2 = module.getManifest().getMainAttributes().getValue("OpenIDE-Module-Install");
        if (object2 != null) {
            try {
                entry = Util.createPackageName((String)object2);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                InvalidException invalidException = new InvalidException(module, illegalArgumentException.toString());
                Util.err.annotate((Throwable)invalidException, (Throwable)illegalArgumentException);
                throw invalidException;
            }
            if (((String)object2).endsWith(".ser")) {
                throw new InvalidException(module, "Serialized module installs not supported: " + (String)object2);
            }
            try {
                clazz = Class.forName((String)((Object)entry), false, module.getClassLoader());
                if (clazz.getClassLoader() != module.getClassLoader()) {
                    this.ev.log("wrongClassLoader", (Object)module, clazz, (Object)module.getClassLoader());
                }
                for (object = clazz; object != (class$org$openide$modules$ModuleInstall == null ? NbInstaller.class$("org.openide.modules.ModuleInstall") : class$org$openide$modules$ModuleInstall) && object != (class$java$lang$Object == null ? NbInstaller.class$("java.lang.Object") : class$java$lang$Object); object = ((Class)object).getSuperclass()) {
                    try {
                        ((Class)object).getDeclaredMethod("validate", new Class[0]);
                        ModuleInstall moduleInstall = (ModuleInstall)SharedClassObject.findObject(clazz, (boolean)true);
                        moduleInstall.validate();
                        continue;
                    }
                    catch (NoSuchMethodException noSuchMethodException) {
                        // empty catch block
                    }
                }
                if (object == Object.class) {
                    throw new ClassCastException("Should extend ModuleInstall: " + clazz.getName());
                }
            }
            catch (Exception exception) {
                InvalidException invalidException = new InvalidException(module, exception.toString());
                Util.err.annotate((Throwable)invalidException, (Throwable)exception);
                throw invalidException;
            }
            catch (LinkageError linkageError) {
                InvalidException invalidException = new InvalidException(module, linkageError.toString());
                Util.err.annotate((Throwable)invalidException, (Throwable)linkageError);
                throw invalidException;
            }
        }
        if ((entry = module.getManifest().getMainAttributes().getValue("OpenIDE-Module-Layer")) != null && (object = module.getClassLoader().getResource((String)((Object)entry))) == null) {
            throw new InvalidException(module, "Layer not found: " + (String)((Object)entry));
        }
        object = module.getManifest().getMainAttributes().getValue("OpenIDE-Module-Description");
        if (object != null) {
            Util.err.log(16, "Use of OpenIDE-Module-Description in " + module.getCodeNameBase() + " is deprecated.");
            Util.err.log(16, "(Please install help using an XML layer instead.)");
        }
        if (hashSet != null) {
            this.sections.put(module, hashSet);
        }
        if (clazz != null) {
            this.installs.put(module, clazz);
        }
        if (entry != null) {
            this.layers.put(module, entry);
        }
    }

    public void dispose(Module module) {
        Util.err.log("dispose: " + module);
        Set set = (Set)this.sections.remove(module);
        if (set != null) {
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                ManifestSection manifestSection = (ManifestSection)iterator.next();
                manifestSection.dispose();
            }
        }
        this.installs.remove(module);
        this.layers.remove(module);
        this.kosherPackages.remove(module);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void load(List list) {
        Module module;
        this.ev.log("startLoad", (Object)list);
        if (this.mgr != null) {
            MainLookup.systemClassLoaderChanged(this.mgr.getClassLoader());
        }
        this.ev.log("perfTick", (Object)"META-INF/services/ additions registered");
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            module = (Module)iterator.next();
            this.checkForDeprecations(module);
            NbInstaller.openideModuleEnabled(module);
        }
        this.loadLayers(list, true);
        this.ev.log("perfTick", (Object)"layers loaded");
        iterator = list.iterator();
        this.ev.log("perfStart", (Object)"NbInstaller.load - sections");
        this.ev.log("loadSection");
        CoreBridge.conditionallyLoaderPoolTransaction(true);
        try {
            while (iterator.hasNext()) {
                module = (Module)iterator.next();
                try {
                    this.loadSections(module, true);
                }
                catch (Exception exception) {
                    Util.err.notify((Throwable)exception);
                }
                catch (LinkageError linkageError) {
                    Util.err.notify((Throwable)linkageError);
                }
                this.ev.log("perfTick", (Object)("sections for " + module.getCodeName() + " loaded"));
            }
        }
        finally {
            CoreBridge.conditionallyLoaderPoolTransaction(false);
        }
        this.ev.log("perfEnd", (Object)"NbInstaller.load - sections");
        if (!this.initializedFolderLookup) {
            Util.err.log("modulesClassPathInitialized");
            MainLookup.modulesClassPathInitialized();
            this.initializedFolderLookup = true;
        }
        Main.initUICustomizations();
        iterator = list.iterator();
        this.ev.log("perfStart", (Object)"NbInstaller.load - ModuleInstalls");
        while (iterator.hasNext()) {
            module = (Module)iterator.next();
            try {
                this.loadCode(module, true);
            }
            catch (Exception exception) {
                Util.err.notify((Throwable)exception);
            }
            catch (LinkageError linkageError) {
                Util.err.notify((Throwable)linkageError);
            }
            catch (AssertionError assertionError) {
                Util.err.notify((Throwable)((Object)assertionError));
            }
            this.ev.log("perfTick", (Object)("ModuleInstall for " + module.getCodeName() + " called"));
        }
        this.ev.log("perfEnd", (Object)"NbInstaller.load - ModuleInstalls");
        this.ev.log("finishLoad", (Object)list);
        this.maybeSaveManifestCache();
        if (Boolean.getBoolean("netbeans.preresolve.classes")) {
            this.preresolveClasses(list);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unload(List list) {
        block16: {
            Module module;
            this.ev.log("startUnload", (Object)list);
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                module = (Module)iterator.next();
                try {
                    this.loadCode(module, false);
                }
                catch (Exception exception) {
                    Util.err.notify((Throwable)exception);
                }
                catch (LinkageError linkageError) {
                    Util.err.notify((Throwable)linkageError);
                }
            }
            iterator = list.iterator();
            CoreBridge.conditionallyLoaderPoolTransaction(true);
            block14: while (true) {
                while (iterator.hasNext()) {
                    module = (Module)iterator.next();
                    try {
                        this.loadSections(module, false);
                        continue block14;
                    }
                    catch (Exception exception) {
                        Util.err.notify((Throwable)exception);
                    }
                    catch (LinkageError linkageError) {
                        Util.err.notify((Throwable)linkageError);
                    }
                }
                break block16;
                {
                    continue block14;
                    break;
                }
                break;
            }
            finally {
                try {
                    CoreBridge.conditionallyLoaderPoolTransaction(false);
                }
                catch (RuntimeException runtimeException) {
                    Util.err.notify((Throwable)runtimeException);
                }
            }
        }
        this.loadLayers(list, false);
        this.ev.log("finishUnload", (Object)list);
    }

    private void loadCode(Module module, boolean bl) throws Exception {
        Class clazz = (Class)this.installs.get(module);
        if (clazz != null) {
            ModuleInstall moduleInstall = (ModuleInstall)SharedClassObject.findObject((Class)clazz, (boolean)true);
            if (bl) {
                Object object;
                if (this.moduleList != null) {
                    this.moduleList.installPrepare(module, moduleInstall);
                }
                if ((object = module.getHistory()) instanceof ModuleHistory) {
                    ModuleHistory moduleHistory = (ModuleHistory)object;
                    if (moduleHistory.isPreviouslyInstalled()) {
                        SpecificationVersion specificationVersion = moduleHistory.getOldSpecificationVersion();
                        SpecificationVersion specificationVersion2 = module.getSpecificationVersion();
                        if (module.getCodeNameRelease() != moduleHistory.getOldMajorVersion() || specificationVersion == null ^ specificationVersion2 == null || specificationVersion != null && specificationVersion2 != null && specificationVersion.compareTo((Object)specificationVersion2) != 0) {
                            this.ev.log("update", (Object)module);
                            moduleInstall.updated(moduleHistory.getOldMajorVersion(), specificationVersion == null ? null : specificationVersion.toString());
                        } else {
                            this.ev.log("restore", (Object)module);
                            moduleInstall.restored();
                        }
                    } else {
                        this.ev.log("install", (Object)module);
                        moduleInstall.installed();
                    }
                } else {
                    this.ev.log("restore", (Object)module);
                    moduleInstall.restored();
                }
                if (this.moduleList != null) {
                    this.moduleList.installPostpare(module, moduleInstall);
                }
            } else {
                this.ev.log("uninstall", (Object)module);
                moduleInstall.uninstalled();
                if (module.getHistory() instanceof ModuleHistory) {
                    ((ModuleHistory)module.getHistory()).resetHistory();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadSections(Module module, boolean bl) throws Exception {
        Set set = (Set)this.sections.get(module);
        if (set == null) {
            return;
        }
        boolean bl2 = false;
        try {
            Main.incrementSplashProgressBar();
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                ManifestSection manifestSection = (ManifestSection)iterator.next();
                if (manifestSection instanceof ManifestSection.ActionSection) {
                    if (!bl2) {
                        Object object = module.getLocalizedAttribute("OpenIDE-Module-Display-Category");
                        if (object == null) {
                            object = module.getCodeNameBase();
                        }
                        CoreBridge.getDefault().attachToCategory(object);
                        bl2 = true;
                    }
                    CoreBridge.getDefault().loadActionSection((ManifestSection.ActionSection)manifestSection, bl);
                    continue;
                }
                if (manifestSection instanceof ManifestSection.ClipboardConvertorSection) {
                    this.loadGenericSection(manifestSection, bl);
                    continue;
                }
                if (manifestSection instanceof ManifestSection.DebuggerSection) {
                    this.loadGenericSection(manifestSection, bl);
                    continue;
                }
                if (manifestSection instanceof ManifestSection.LoaderSection) {
                    CoreBridge.getDefault().loadLoaderSection((ManifestSection.LoaderSection)manifestSection, bl);
                    continue;
                }
                if (!$assertionsDisabled) {
                    throw new AssertionError(manifestSection);
                }
            }
        }
        finally {
            if (bl2) {
                CoreBridge.getDefault().attachToCategory(null);
            }
        }
    }

    private void loadGenericSection(ManifestSection manifestSection, boolean bl) {
        CoreBridge.getDefault().loadDefaultSection(manifestSection, this.convertor, bl);
    }

    private void loadLayers(List arrayList, boolean bl) {
        Object object;
        Object object2;
        Object object3;
        this.ev.log(bl ? "loadLayers" : "unloadLayers", (Object)arrayList);
        arrayList = new ArrayList(arrayList);
        Collections.reverse(arrayList);
        HashMap hashMap = new HashMap(5);
        Iterator<Object> iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            String string;
            object3 = (Module)iterator.next();
            object2 = (String)this.layers.get(object3);
            if (object2 == null) continue;
            Util.err.log("loadLayer: " + (String)object2 + " load=" + bl);
            int n = ((String)object2).lastIndexOf(46);
            if (n == -1) {
                object = object2;
                string = "";
            } else {
                object = ((String)object2).substring(0, n);
                string = ((String)object2).substring(n);
            }
            ClassLoader classLoader = object3.getClassLoader();
            Iterator iterator2 = NbBundle.getLocalizingSuffixes();
            ModuleLayeredFileSystem moduleLayeredFileSystem = object3.isReloadable() ? ModuleLayeredFileSystem.getUserModuleLayer() : ModuleLayeredFileSystem.getInstallationModuleLayer();
            ArrayList<URL> arrayList2 = (ArrayList<URL>)hashMap.get((Object)moduleLayeredFileSystem);
            if (arrayList2 == null) {
                arrayList2 = new ArrayList<URL>(100);
                hashMap.put(moduleLayeredFileSystem, arrayList2);
            }
            boolean bl2 = false;
            while (iterator2.hasNext()) {
                String string2 = (String)iterator2.next();
                String string3 = (String)object + string2 + string;
                URL uRL = classLoader.getResource(string3);
                if (uRL == null) continue;
                arrayList2.add(uRL);
                bl2 = true;
            }
            if (bl2) continue;
            Util.err.log("Module layer not found: " + (String)object2);
        }
        iterator = hashMap.entrySet().iterator();
        while (iterator.hasNext()) {
            object3 = (Map.Entry)iterator.next();
            object2 = (ModuleLayeredFileSystem)((Object)object3.getKey());
            object = (List)object3.getValue();
            Util.err.log("Adding/removing layer URLs: host=" + object2 + " urls=" + object);
            try {
                if (bl) {
                    ((ModuleLayeredFileSystem)((Object)object2)).addURLs((Collection)object);
                    continue;
                }
                ((ModuleLayeredFileSystem)((Object)object2)).removeURLs((Collection)object);
            }
            catch (Exception exception) {
                Util.err.notify((Throwable)exception);
            }
        }
    }

    private void checkForDeprecations(Module module) {
        if (!Boolean.valueOf((String)module.getAttribute("OpenIDE-Module-Deprecated")).booleanValue()) {
            Dependency[] dependencyArray = module.getDependenciesArray();
            for (int i = 0; i < dependencyArray.length; ++i) {
                if (dependencyArray[i].getType() != 1) continue;
                String string = (String)Util.parseCodeName((String)dependencyArray[i].getName())[0];
                Module module2 = this.mgr.get(string);
                if (module2 == null) {
                    throw new IllegalStateException("No such module: " + string);
                }
                if (!Boolean.valueOf((String)module2.getAttribute("OpenIDE-Module-Deprecated")).booleanValue()) continue;
                String string2 = (String)module2.getLocalizedAttribute("OpenIDE-Module-Deprecation-Message");
                if (string2 != null) {
                    Util.err.log(16, "Warning: the module " + module.getCodeNameBase() + " uses " + string + " which is deprecated: " + string2);
                    continue;
                }
                Util.err.log(16, "Warning: the module " + module.getCodeNameBase() + " uses " + string + " which is deprecated.");
            }
        }
    }

    public boolean closing(List list) {
        Util.err.log("closing: " + list);
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            Module module = (Module)iterator.next();
            Class clazz = (Class)this.installs.get(module);
            if (clazz == null) continue;
            try {
                ModuleInstall moduleInstall = (ModuleInstall)SharedClassObject.findObject((Class)clazz, (boolean)true);
                if (moduleInstall.closing()) continue;
                Util.err.log("Module " + module + " refused to close");
                return false;
            }
            catch (RuntimeException runtimeException) {
                Util.err.notify((Throwable)runtimeException);
            }
            catch (LinkageError linkageError) {
                Util.err.notify((Throwable)linkageError);
            }
        }
        return true;
    }

    public void close(List list) {
        Util.err.log("close: " + list);
        this.ev.log("close");
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            Module module = (Module)iterator.next();
            Class clazz = (Class)this.installs.get(module);
            if (clazz == null) continue;
            try {
                ModuleInstall moduleInstall = (ModuleInstall)SharedClassObject.findObject((Class)clazz, (boolean)true);
                if (moduleInstall == null) {
                    throw new IllegalStateException("Inconsistent state: " + clazz);
                }
                moduleInstall.close();
            }
            catch (ThreadDeath threadDeath) {
                throw threadDeath;
            }
            catch (Throwable throwable) {
                Util.err.notify(throwable);
            }
        }
    }

    public void refineDependencies(Module module, Set set) {
        Object object;
        if (Boolean.getBoolean("org.netbeans.core.modules.NbInstaller.noAutoDeps")) {
            return;
        }
        if (this.autoDepsHandler == null) {
            object = Repository.getDefault().getDefaultFileSystem().findResource("ModuleAutoDeps");
            if (object != null) {
                FileObject[] fileObjectArray = object.getChildren();
                ArrayList<URL> arrayList = new ArrayList<URL>(Math.max(fileObjectArray.length, 1));
                for (int i = 0; i < fileObjectArray.length; ++i) {
                    if (!fileObjectArray[i].hasExt("xml")) continue;
                    try {
                        arrayList.add(fileObjectArray[i].getURL());
                        continue;
                    }
                    catch (FileStateInvalidException fileStateInvalidException) {
                        Util.err.notify((Throwable)fileStateInvalidException);
                    }
                }
                try {
                    this.autoDepsHandler = AutomaticDependencies.parse(arrayList.toArray(new URL[arrayList.size()]));
                }
                catch (IOException iOException) {
                    Util.err.notify((Throwable)iOException);
                }
                catch (SAXException sAXException) {
                    Util.err.notify((Throwable)sAXException);
                }
            }
            if (this.autoDepsHandler == null) {
                this.autoDepsHandler = AutomaticDependencies.empty();
            }
            if (Util.err.isLoggable(1)) {
                Util.err.log(1, "Auto deps: " + this.autoDepsHandler);
            }
        }
        if (((AutomaticDependencies.Report)(object = this.autoDepsHandler.refineDependenciesAndReport(module.getCodeNameBase(), set))).isModified()) {
            Util.err.log(16, "Warning - had to upgrade dependencies for module " + module.getCodeNameBase() + ": added = " + ((AutomaticDependencies.Report)object).getAdded() + " removed = " + ((AutomaticDependencies.Report)object).getRemoved() + "; details: " + ((AutomaticDependencies.Report)object).getMessages());
        }
    }

    public String[] refineProvides(Module module) {
        if (module.getCodeNameBase().equals("org.openide.modules")) {
            boolean bl;
            ArrayList<String> arrayList = new ArrayList<String>(4);
            boolean bl2 = (Utilities.getOperatingSystem() & 0x1000) != 0;
            boolean bl3 = bl = (Utilities.getOperatingSystem() & 0x800) != 0;
            if (Utilities.isUnix()) {
                arrayList.add("org.openide.modules.os.Unix");
                if (!bl2) {
                    arrayList.add("org.openide.modules.os.PlainUnix");
                }
            }
            if (Utilities.isWindows()) {
                arrayList.add("org.openide.modules.os.Windows");
            }
            if (bl2) {
                arrayList.add("org.openide.modules.os.MacOSX");
            }
            if (bl) {
                arrayList.add("org.openide.modules.os.OS2");
            }
            arrayList.add("org.openide.modules.ModuleFormat1");
            return arrayList.toArray(new String[0]);
        }
        return null;
    }

    private void addLoadersRecursively(List list, Dependency[] dependencyArray, Set set, Module module, Set set2) {
        for (int i = 0; i < dependencyArray.length; ++i) {
            if (dependencyArray[i].getType() != 1) continue;
            String string = (String)Util.parseCodeName((String)dependencyArray[i].getName())[0];
            Module module2 = this.mgr.get(string);
            if (module2 == null) {
                throw new IllegalStateException("No such parent module of " + module + ": " + string);
            }
            if (!set.add(module2)) continue;
            if (!list.contains(module2.getClassLoader())) {
                if (Util.err.isLoggable(1)) {
                    Util.err.log("#27853: adding virtual dependency from " + module + ": " + module2);
                }
                list.add(module2.getClassLoader());
                set2.add(string);
            }
            this.addLoadersRecursively(list, module2.getDependenciesArray(), set, module, set2);
        }
    }

    public boolean shouldDelegateResource(Module module, Module module2, String string) {
        if (module2 == null) {
            for (int i = 0; i < CLASSPATH_PACKAGES.length; ++i) {
                if (!string.startsWith(CLASSPATH_PACKAGES[i]) || this.findKosher(module).contains(CLASSPATH_PACKAGES[i])) continue;
                if (Util.err.isLoggable(1)) {
                    Util.err.log("Refusing to load classpath package " + string + " for " + module.getCodeNameBase() + " without a proper dependency");
                }
                return false;
            }
        }
        return true;
    }

    private Set findKosher(Module module) {
        Set<String> set = (HashSet)this.kosherPackages.get(module);
        if (set == null) {
            set = new HashSet();
            Dependency[] dependencyArray = module.getDependenciesArray();
            SpecificationVersion specificationVersion = Util.getModuleDep((Set)module.getDependencies(), (String)"org.openide");
            boolean bl = specificationVersion == null || specificationVersion.compareTo((Object)new SpecificationVersion("1.3.12")) < 0;
            for (int i = 0; i < dependencyArray.length; ++i) {
                int n;
                String string;
                String string2;
                if (dependencyArray[i].getType() == 1 && dependencyArray[i].getName().equals("org.netbeans.core.startup/1")) {
                    set.add("org/netbeans/core/startup/");
                    continue;
                }
                if (bl && dependencyArray[i].getType() == 1) {
                    Module module2;
                    string2 = dependencyArray[i].getName();
                    int n2 = string2.indexOf(47);
                    if (n2 != -1) {
                        string2 = string2.substring(0, n2);
                    }
                    if ((module2 = this.mgr.get(string2)) == null) {
                        throw new IllegalStateException("Should have found dep " + dependencyArray[i] + " from " + module);
                    }
                    set.addAll(this.findKosher(module2));
                    continue;
                }
                if (dependencyArray[i].getType() != 2) continue;
                string2 = dependencyArray[i].getName();
                int n3 = string2.indexOf(91);
                if (n3 == -1) {
                    string = string2.replace('.', '/').concat("/");
                } else if (n3 == 0) {
                    n = string2.lastIndexOf(46);
                    string = string2.substring(1, n).replace('.', '/').concat("/");
                } else {
                    string = string2.substring(0, n3).replace('.', '/').concat("/");
                }
                for (n = 0; n < CLASSPATH_PACKAGES.length; ++n) {
                    if (!string.startsWith(CLASSPATH_PACKAGES[n])) continue;
                    set.add(CLASSPATH_PACKAGES[n]);
                }
            }
            if (set.isEmpty()) {
                set = Collections.EMPTY_SET;
            }
            this.kosherPackages.put(module, set);
        }
        return set;
    }

    static void openideModuleEnabled(Module module) {
        String string = module.getCodeNameBase();
        if (!string.startsWith("org.openide.")) {
            return;
        }
        if ("org.openide.util".equals(string)) {
            return;
        }
        if ("org.openide.actions".equals(string)) {
            return;
        }
        if ("org.openide.awt".equals(string)) {
            return;
        }
        if ("org.openide.modules".equals(string)) {
            return;
        }
        if ("org.openide.nodes".equals(string)) {
            return;
        }
        if ("org.openide.windows".equals(string)) {
            return;
        }
        if ("org.openide.explorer".equals(string)) {
            return;
        }
        if ("org.openide.util.enumerations".equals(string)) {
            return;
        }
        if ("org.openide.execution".equals(string)) {
            return;
        }
        if ("org.openide.options".equals(string)) {
            return;
        }
        if ("org.openide.execution".equals(string)) {
            return;
        }
        if ("org.openide.loaders".equals(string)) {
            return;
        }
        if ("org.openide.dialogs".equals(string)) {
            return;
        }
        if ("org.openide.filesystems".equals(string)) {
            return;
        }
        if ("org.openide.io".equals(string)) {
            return;
        }
        if ("org.openide.text".equals(string)) {
            return;
        }
        if ("org.openide.src".equals(string)) {
            return;
        }
        Util.err.log(16, "Disabling openide load optimizations due to use of " + string);
        withoutOptimizations = true;
    }

    public boolean isSpecialResource(String string) {
        if (string.startsWith("org/openide/")) {
            if ("org/openide/".equals(string)) {
                return true;
            }
            if ("org/openide/actions/".equals(string)) {
                return true;
            }
            if ("org/openide/awt/".equals(string)) {
                return true;
            }
            if ("org/openide/cookies/".equals(string)) {
                return true;
            }
            if ("org/openide/resources/".equals(string)) {
                return true;
            }
            if ("org/openide/explorer/propertysheet/editors/".equals(string)) {
                return true;
            }
            if ("org/openide/windows/".equals(string)) {
                return true;
            }
            if ("org/openide/text/".equals(string)) {
                return true;
            }
            if ("org/openide/util/actions/".equals(string)) {
                return true;
            }
            if (withoutOptimizations) {
                if ("org/openide/explorer/".equals(string)) {
                    return true;
                }
                if ("org/openide/util/".equals(string)) {
                    return true;
                }
            }
        }
        if (this.isSpecialResourceFromSystemProperty(string)) {
            return true;
        }
        if (string.equals("org/w3c/dom/")) {
            return true;
        }
        if (string.equals("org/w3c/dom/ls/")) {
            return true;
        }
        return super.isSpecialResource(string);
    }

    private boolean isSpecialResourceFromSystemProperty(String string) {
        String[] stringArray = NbInstaller.getSpecialResourcePrefixes();
        for (int i = 0; i < stringArray.length; ++i) {
            if (!string.startsWith(stringArray[i])) continue;
            return true;
        }
        return false;
    }

    private static String[] getSpecialResourcePrefixes() {
        if (specialResourcePrefixes == null) {
            String string = System.getProperty("org.netbeans.core.startup.specialResource");
            specialResourcePrefixes = string != null ? string.split(",") : new String[0];
        }
        return specialResourcePrefixes;
    }

    String getEffectiveClasspath(Module module) {
        if (!module.isEnabled()) {
            return "";
        }
        ArrayList arrayList = new ArrayList(100);
        NbInstaller.createBootClassPath(arrayList);
        Set set = module.isFixed() ? null : this.findKosher(module);
        StringTokenizer stringTokenizer = new StringTokenizer(System.getProperty("java.class.path", ""), File.pathSeparator);
        while (stringTokenizer.hasMoreTokens()) {
            NbInstaller.addStartupClasspathEntry(new File(stringTokenizer.nextToken()), arrayList, set);
        }
        stringTokenizer = new StringTokenizer(System.getProperty("netbeans.dynamic.classpath", ""), File.pathSeparator);
        while (stringTokenizer.hasMoreTokens()) {
            NbInstaller.addStartupClasspathEntry(new File(stringTokenizer.nextToken()), arrayList, set);
        }
        HashSet hashSet = new HashSet(50);
        HashSet<String> hashSet2 = new HashSet<String>(10);
        Dependency[] dependencyArray = module.getDependenciesArray();
        for (int i = 0; i < dependencyArray.length; ++i) {
            if (dependencyArray[i].getType() != 1 || dependencyArray[i].getComparison() != 2) continue;
            hashSet2.add(dependencyArray[i].getName());
        }
        SpecificationVersion specificationVersion = Util.getModuleDep((Set)module.getDependencies(), (String)"org.openide");
        boolean bl = specificationVersion == null || specificationVersion.compareTo((Object)new SpecificationVersion("1.3.12")) < 0;
        this.addModuleClasspathEntries(module, module, hashSet, hashSet2, arrayList, bl ? Integer.MAX_VALUE : 1);
        StringBuffer stringBuffer = new StringBuffer(arrayList.size() * 100 + 1);
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            if (stringBuffer.length() > 0) {
                stringBuffer.append(File.pathSeparatorChar);
            }
            stringBuffer.append((String)iterator.next());
        }
        return stringBuffer.toString();
    }

    private static void createBootClassPath(List list) {
        Object object;
        String string = System.getProperty("sun.boot.class.path");
        if (string != null) {
            object = new StringTokenizer(string, File.pathSeparator);
            while (((StringTokenizer)object).hasMoreTokens()) {
                list.add(((StringTokenizer)object).nextToken());
            }
        }
        if ((object = System.getProperty("java.ext.dirs")) != null) {
            StringTokenizer stringTokenizer = new StringTokenizer((String)object, File.pathSeparator);
            while (stringTokenizer.hasMoreTokens()) {
                File file = new File(stringTokenizer.nextToken());
                File[] fileArray = file.listFiles();
                if (fileArray == null) continue;
                for (int i = 0; i < fileArray.length; ++i) {
                    String string2 = fileArray[i].getName().toLowerCase(Locale.US);
                    if (!string2.endsWith(".zip") && !string2.endsWith(".jar")) continue;
                    list.add(fileArray[i].getAbsolutePath());
                }
            }
        }
    }

    private static void addStartupClasspathEntry(File file, List list, Set set) {
        if (file.isDirectory()) {
            list.add(file.getAbsolutePath());
            return;
        }
        String string = file.getName();
        for (int i = 0; i < CLASSPATH_JARS.length; ++i) {
            if (set == null || !string.startsWith(CLASSPATH_JARS[i][0])) continue;
            StringBuffer stringBuffer = null;
            for (int j = 1; j < CLASSPATH_JARS[i].length; ++j) {
                String string2 = CLASSPATH_JARS[i][j];
                if (!set.contains(string2)) continue;
                if (stringBuffer == null) {
                    stringBuffer = new StringBuffer(100);
                    stringBuffer.append(file.getAbsolutePath());
                    stringBuffer.append('[');
                } else {
                    stringBuffer.append(',');
                }
                stringBuffer.append(string2.replace('/', '.'));
                stringBuffer.append("**");
            }
            if (stringBuffer != null) {
                stringBuffer.append(']');
                list.add(stringBuffer.toString());
            }
            return;
        }
        list.add(file.getAbsolutePath());
    }

    private void addModuleClasspathEntries(Module module, Module module2, Set set, Set set2, List list, int n) {
        Object object;
        String string;
        Object object2;
        int n2;
        if (!set.add(module)) {
            return;
        }
        Dependency[] dependencyArray = module.getDependenciesArray();
        for (n2 = 0; n2 < dependencyArray.length; ++n2) {
            if (dependencyArray[n2].getType() != 1) continue;
            object2 = (String)Util.parseCodeName((String)dependencyArray[n2].getName())[0];
            string = this.mgr.get((String)object2);
            if (string == null) {
                throw new IllegalStateException("No such module: " + (String)object2);
            }
            if (n <= 0) continue;
            this.addModuleClasspathEntries((Module)string, module2, set, set2, list, n - 1);
        }
        n2 = module == module2 || set2.contains(module.getCodeName()) ? 1 : 0;
        object2 = n2 != 0 ? null : module.getPublicPackages();
        string = "";
        if (object2 != null) {
            if (((Module.PackageExport[])object2).length == 0) {
                return;
            }
            object = new StringBuffer(100);
            ((StringBuffer)object).append('[');
            for (int i = 0; i < ((Module.PackageExport[])object2).length; ++i) {
                if (i > 0) {
                    ((StringBuffer)object).append(',');
                }
                ((StringBuffer)object).append(object2[i].pkg.replace('/', '.'));
                ((StringBuffer)object).append(object2[i].recursive ? "**" : "*");
            }
            ((StringBuffer)object).append(']');
            string = ((StringBuffer)object).toString();
        }
        object = module.getAllJars();
        Iterator iterator = object.iterator();
        while (iterator.hasNext()) {
            list.add(((File)iterator.next()).getAbsolutePath() + string);
        }
    }

    public Manifest loadManifest(File file) throws IOException {
        Object[] objectArray;
        if (!this.usingManifestCache) {
            return super.loadManifest(file);
        }
        if (this.manifestCache == null) {
            this.manifestCache = this.loadManifestCache(this.manifestCacheFile);
        }
        if ((objectArray = (Object[])this.manifestCache.get(file)) != null) {
            if (((Date)objectArray[0]).getTime() == file.lastModified()) {
                Util.err.log("Found manifest for " + file + " in cache");
                return (Manifest)objectArray[1];
            }
            Util.err.log("Wrong timestamp for " + file + " in manifest cache");
        } else {
            Util.err.log("No entry for " + file + " in manifest cache");
        }
        Manifest manifest = super.loadManifest(file);
        this.manifestCache.put(file, new Object[]{new Date(file.lastModified()), manifest});
        this.manifestCacheDirty = true;
        return manifest;
    }

    private void maybeSaveManifestCache() {
        if (this.usingManifestCache && this.manifestCacheDirty) {
            try {
                this.saveManifestCache(this.manifestCache, this.manifestCacheFile);
            }
            catch (IOException iOException) {
                Util.err.notify(16, (Throwable)iOException);
            }
            this.usingManifestCache = false;
            this.manifestCacheDirty = false;
            this.manifestCache = null;
            this.manifestCacheFile = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveManifestCache(Map map, File file) throws IOException {
        Util.err.log("Saving manifest cache");
        file.getParentFile().mkdirs();
        OutputStream outputStream = new FileOutputStream(file);
        try {
            try {
                outputStream = new BufferedOutputStream(outputStream);
                Iterator iterator = map.entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry entry = iterator.next();
                    File file2 = (File)entry.getKey();
                    Object[] objectArray = (Object[])entry.getValue();
                    long l = ((Date)objectArray[0]).getTime();
                    Manifest manifest = (Manifest)objectArray[1];
                    outputStream.write(file2.getAbsolutePath().getBytes("UTF-8"));
                    outputStream.write(0);
                    for (int i = 7; i >= 0; --i) {
                        outputStream.write((int)(l >> i * 8 & 0xFFL));
                    }
                    manifest.write(outputStream);
                    outputStream.write(0);
                }
            }
            finally {
                outputStream.close();
            }
        }
        catch (IOException iOException) {
            file.delete();
            throw iOException;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map loadManifestCache(File file) {
        HashMap hashMap;
        if (!file.canRead()) {
            Util.err.log("No manifest cache found at " + file);
            return new HashMap(200);
        }
        this.ev.log("perfStart", (Object)"NbInstaller - loadManifestCache");
        FileInputStream fileInputStream = new FileInputStream(file);
        try {
            BufferedInputStream bufferedInputStream = new BufferedInputStream(fileInputStream);
            HashMap hashMap2 = new HashMap(200);
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream((int)file.length());
            FileUtil.copy((InputStream)bufferedInputStream, (OutputStream)byteArrayOutputStream);
            byte[] byArray = byteArrayOutputStream.toByteArray();
            NbInstaller.readManifestCacheEntries(byArray, hashMap2);
            hashMap = hashMap2;
        }
        catch (Throwable throwable) {
            try {
                ((InputStream)fileInputStream).close();
                this.ev.log("perfEnd", (Object)"NbInstaller - loadManifestCache");
                throw throwable;
            }
            catch (IOException iOException) {
                Util.err.annotate((Throwable)iOException, 0, "While reading: " + file, null, null, null);
                Util.err.notify(16, (Throwable)iOException);
                return new HashMap(200);
            }
        }
        ((InputStream)fileInputStream).close();
        this.ev.log("perfEnd", (Object)"NbInstaller - loadManifestCache");
        return hashMap;
    }

    private static int findNullByte(byte[] byArray, int n) {
        int n2 = byArray.length;
        for (int i = n; i < n2; ++i) {
            if (byArray[i] != 0) continue;
            return i;
        }
        return -1;
    }

    private static void readManifestCacheEntries(byte[] byArray, Map map) throws IOException {
        int n = 0;
        while (n != byArray.length) {
            Manifest manifest;
            int n2 = NbInstaller.findNullByte(byArray, n);
            if (n2 == -1) {
                throw new IOException("Could not find next manifest JAR name from " + n);
            }
            File file = new File(new String(byArray, n, n2 - n, "UTF-8"));
            long l = 0L;
            if (n2 + 8 >= byArray.length) {
                throw new IOException("Ran out of space for timestamp for " + file);
            }
            for (int i = 0; i < 8; ++i) {
                long l2 = byArray[n2 + i + 1];
                if (l2 < 0L) {
                    l2 += 256L;
                }
                int n3 = 7 - i;
                long l3 = l2 << n3 * 8;
                l |= l3;
            }
            n = n2 + 9;
            if ((n2 = NbInstaller.findNullByte(byArray, n)) == -1) {
                throw new IOException("Could not find manifest body for " + file);
            }
            try {
                manifest = new Manifest(new ByteArrayInputStream(byArray, n, n2 - n));
            }
            catch (IOException iOException) {
                Util.err.annotate((Throwable)iOException, 0, "While in entry for " + file, null, null, null);
                throw iOException;
            }
            map.put(file, new Object[]{new Date(l), manifest});
            if (Util.err.isLoggable(1)) {
                Util.err.log("Manifest cache entry: jar=" + file + " date=" + new Date(l) + " codename=" + manifest.getMainAttributes().getValue("OpenIDE-Module"));
            }
            n = n2 + 1;
        }
        return;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void preresolveClasses(List list) {
        Util.err.log(256, "Pre-resolving classes for all loaded modules...be sure you have not specified -J-Xverify:none in ide.cfg");
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            Module module = (Module)iterator.next();
            if (module.isFixed() || module.getJarFile() == null) continue;
            File file = module.getJarFile();
            try {
                JarFile jarFile = new JarFile(file, true);
                try {
                    Enumeration<JarEntry> enumeration = jarFile.entries();
                    while (enumeration.hasMoreElements()) {
                        JarEntry jarEntry = enumeration.nextElement();
                        String string = jarEntry.getName();
                        if (!string.endsWith(".class")) continue;
                        String string2 = string.substring(0, string.length() - 6).replace('/', '.');
                        try {
                            Class.forName(string2, false, module.getClassLoader());
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            Util.err.annotate((Throwable)classNotFoundException, 0, "From " + string2 + " in " + module.getCodeNameBase() + " with effective classpath " + this.getEffectiveClasspath(module), null, null, null);
                            Util.err.notify(1, (Throwable)classNotFoundException);
                        }
                        catch (LinkageError linkageError) {
                            Util.err.annotate((Throwable)linkageError, 0, "From " + string2 + " in " + module.getCodeNameBase() + " with effective classpath " + this.getEffectiveClasspath(module), null, null, null);
                            Util.err.notify(1, (Throwable)linkageError);
                        }
                        catch (RuntimeException runtimeException) {
                            Util.err.annotate((Throwable)runtimeException, 0, "From " + string2 + " in " + module.getCodeNameBase() + " with effective classpath " + this.getEffectiveClasspath(module), null, null, null);
                            Util.err.notify(1, (Throwable)runtimeException);
                        }
                    }
                }
                finally {
                    jarFile.close();
                }
            }
            catch (IOException iOException) {
                Util.err.notify(1, (Throwable)iOException);
            }
        }
    }

    static {
        $assertionsDisabled = !NbInstaller.class.desiredAssertionStatus();
        specialResourcePrefixes = null;
        CLASSPATH_PACKAGES = new String[]{"org/netbeans/core/startup/", "org/apache/crimson/", "org/apache/xalan/", "org/apache/xpath/", "org/apache/xml/dtm/", "org/apache/xml/utils/", "javax/xml/bind/", "javax/xml/ws/", "javax/xml/stream/", "javax/jws/", "javax/xml/soap/"};
        CLASSPATH_JARS = new String[][]{{"core", "org/netbeans/core/", "org/netbeans/beaninfo/"}, {"boot"}};
    }

    private final class Convertor
    implements InstanceContent.Convertor {
        Convertor() {
        }

        public Object convert(Object object) {
            ManifestSection manifestSection = (ManifestSection)object;
            try {
                return manifestSection.getInstance();
            }
            catch (Exception exception) {
                Util.err.notify((Throwable)exception);
                NbInstaller.this.loadGenericSection(manifestSection, false);
                return null;
            }
        }

        public Class type(Object object) {
            ManifestSection manifestSection = (ManifestSection)object;
            return manifestSection.getSuperclass();
        }

        public String id(Object object) {
            return object.toString();
        }

        public String displayName(Object object) {
            return object.toString();
        }
    }
}

