/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.startup;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import org.netbeans.DuplicateException;
import org.netbeans.Events;
import org.netbeans.Module;
import org.netbeans.ModuleInstaller;
import org.netbeans.ModuleManager;
import org.netbeans.Util;
import org.netbeans.core.startup.MainLookup;
import org.netbeans.core.startup.ModuleHistory;
import org.netbeans.core.startup.ModuleList;
import org.netbeans.core.startup.NbEvents;
import org.netbeans.core.startup.NbInstaller;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;

public final class ModuleSystem {
    private final ModuleManager mgr;
    private final NbInstaller installer;
    private final ModuleList list;
    private final Events ev;
    private Set bootModules = null;

    public ModuleSystem(FileSystem fileSystem) throws IOException {
        if (Boolean.getBoolean("org.netbeans.core.startup.ModuleSystem.CULPRIT")) {
            Thread.dumpStack();
        }
        this.ev = Boolean.getBoolean("netbeans.modules.quiet") ? new QuietEvents() : new NbEvents();
        this.installer = new NbInstaller(this.ev);
        this.mgr = new ModuleManager((ModuleInstaller)this.installer, this.ev);
        PropertyChangeListener propertyChangeListener = new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if ("classLoader".equals(propertyChangeEvent.getPropertyName())) {
                    MainLookup.systemClassLoaderChanged(ModuleSystem.this.mgr.getClassLoader());
                }
            }
        };
        this.mgr.addPropertyChangeListener(propertyChangeListener);
        MainLookup.systemClassLoaderChanged(((Object)((Object)this.installer)).getClass().getClassLoader());
        MainLookup.moduleLookupReady(this.mgr.getModuleLookup());
        if (fileSystem.isReadOnly()) {
            this.list = null;
        } else {
            FileObject fileObject = fileSystem.getRoot();
            FileObject fileObject2 = fileObject.getFileObject("Modules");
            if (fileObject2 == null) {
                fileObject2 = fileObject.createFolder("Modules");
            }
            this.list = new ModuleList(this.mgr, fileObject2, this.ev);
            this.installer.registerList(this.list);
            this.installer.registerManager(this.mgr);
        }
        this.ev.log("createdModuleSystem");
    }

    public ModuleManager getManager() {
        return this.mgr;
    }

    public Events getEvents() {
        return this.ev;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getModuleJars() {
        this.mgr.mutexPrivileged().enterReadAccess();
        try {
            Iterator iterator = this.mgr.getEnabledModules().iterator();
            ArrayList arrayList = new ArrayList();
            while (iterator.hasNext()) {
                arrayList.addAll(((Module)iterator.next()).getAllJars());
            }
            ArrayList arrayList2 = arrayList;
            return arrayList2;
        }
        finally {
            this.mgr.mutexPrivileged().exitReadAccess();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadBootModules() {
        Serializable serializable;
        Object object;
        Object object2;
        Object object3;
        ArrayList<String> arrayList = new ArrayList<String>(3);
        try {
            object3 = System.getProperty("java.home");
            if (((String)object3).endsWith(File.separator + "jre")) {
                object3 = ((String)object3).substring(0, ((String)object3).length() - 4);
            }
            object2 = new File((String)object3);
            arrayList.add("jar:" + ((File)object2).toURI().toURL());
            object = System.getProperty("netbeans.home");
            if (object != null) {
                serializable = new File((String)object);
                object2 = new File(new File((File)serializable, "lib"), "ext");
                arrayList.add("jar:" + ((File)object2).toURI().toURL());
            }
        }
        catch (MalformedURLException malformedURLException) {
            Util.err.notify(1, (Throwable)malformedURLException);
        }
        if (Util.err.isLoggable(1)) {
            Util.err.log("ignoredPrefixes=" + arrayList);
        }
        this.mgr.mutexPrivileged().enterWriteAccess();
        this.ev.log("startLoadBootModules");
        try {
            this.bootModules = new HashSet(10);
            object3 = ModuleSystem.class.getClassLoader();
            object2 = ((ClassLoader)object3).getResources("META-INF/MANIFEST.MF");
            this.ev.log("perfTick", (Object)"got all manifests");
            object = new HashSet();
            block15: while (object2.hasMoreElements()) {
                InputStream inputStream;
                serializable = (URL)object2.nextElement();
                if (!object.add(serializable)) continue;
                String string = ((URL)serializable).toExternalForm();
                Iterator iterator = arrayList.iterator();
                while (iterator.hasNext()) {
                    if (!string.startsWith((String)iterator.next())) continue;
                    continue block15;
                }
                if (Util.err.isLoggable(1)) {
                    Util.err.log("Checking boot manifest: " + string);
                }
                try {
                    inputStream = ((URL)serializable).openStream();
                }
                catch (IOException iOException) {
                    Util.err.annotate((Throwable)iOException, 0, "URL: " + serializable, null, null, null);
                    throw iOException;
                }
                try {
                    Manifest manifest = new Manifest(inputStream);
                    Attributes attributes = manifest.getMainAttributes();
                    if (attributes.getValue("OpenIDE-Module") == null) continue;
                    this.bootModules.add(this.mgr.createFixed(manifest, (Object)serializable, (ClassLoader)object3));
                }
                finally {
                    inputStream.close();
                }
            }
            if (this.list == null) {
                this.mgr.enable(this.bootModules);
            }
            this.ev.log("perfTick", (Object)"added all classpath modules");
        }
        catch (IOException iOException) {
            Util.err.notify((Throwable)iOException);
        }
        catch (DuplicateException duplicateException) {
            Util.err.notify((Throwable)duplicateException);
        }
        finally {
            this.ev.log("finishLoadBootModules");
            this.mgr.mutexPrivileged().exitWriteAccess();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void readList() {
        this.ev.log("perfStart", (Object)"ModuleSystem.readList");
        this.mgr.mutexPrivileged().enterWriteAccess();
        try {
            this.list.readInitial();
        }
        finally {
            this.mgr.mutexPrivileged().exitWriteAccess();
        }
        this.ev.log("perfEnd", (Object)"ModuleSystem.readList");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void restore() {
        this.ev.log("perfStart", (Object)"ModuleSystem.restore");
        this.mgr.mutexPrivileged().enterWriteAccess();
        try {
            HashSet hashSet = new HashSet(this.bootModules);
            this.list.trigger(hashSet);
        }
        finally {
            this.mgr.mutexPrivileged().exitWriteAccess();
        }
        this.ev.log("perfEnd", (Object)"ModuleSystem.restore");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean shutDown(Runnable runnable) {
        this.mgr.mutexPrivileged().enterWriteAccess();
        try {
            boolean bl = this.mgr.shutDown(runnable);
            return bl;
        }
        finally {
            this.mgr.mutexPrivileged().exitWriteAccess();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void deployTestModule(File file) throws IOException {
        if (!file.isAbsolute()) {
            throw new IOException("Absolute paths only please");
        }
        this.mgr.mutexPrivileged().enterWriteAccess();
        this.ev.log("startDeployTestModule", (Object)file);
        System.err.println("Deploying test module " + file + "...");
        try {
            Module module;
            Module module2 = null;
            HashSet hashSet = new HashSet();
            Iterator iterator = this.mgr.getModules().iterator();
            while (iterator.hasNext()) {
                module = (Module)iterator.next();
                if (module.getJarFile() == null || !file.equals(module.getJarFile())) continue;
                if (!module.isReloadable()) {
                    module.setReloadable(true);
                }
                this.turnOffModule(module, hashSet);
                this.mgr.reload(module);
                module2 = module;
                break;
            }
            if (module2 == null) {
                try {
                    module2 = this.mgr.create(file, (Object)new ModuleHistory(file.getAbsolutePath()), true, false, false);
                }
                catch (DuplicateException duplicateException) {
                    Module module3 = duplicateException.getOldModule();
                    System.err.println("Replacing old module in " + module3);
                    this.turnOffModule(module3, hashSet);
                    this.mgr.delete(module3);
                    try {
                        module2 = this.mgr.create(file, (Object)new ModuleHistory(file.getAbsolutePath()), true, false, false);
                    }
                    catch (DuplicateException duplicateException2) {
                        IOException iOException = new IOException(duplicateException2.toString());
                        Util.err.annotate((Throwable)iOException, (Throwable)duplicateException2);
                        throw iOException;
                    }
                }
            }
            System.err.println("Enabling " + module2 + "...");
            if (!this.mgr.simulateEnable(Collections.singleton(module2)).contains(module2)) {
                throw new IOException("Cannot enable " + module2 + "; problems: " + module2.getProblems());
            }
            this.mgr.enable(module2);
            if (!hashSet.isEmpty()) {
                System.err.println("Also re-enabling:");
                iterator = hashSet.iterator();
                while (iterator.hasNext()) {
                    module = (Module)iterator.next();
                    System.err.println("\t" + module.getDisplayName());
                    if (!module.isReloadable()) continue;
                    module.reload();
                }
                try {
                    this.mgr.enable(hashSet);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw new IOException(illegalArgumentException.toString());
                }
            }
            System.err.println("Done.");
        }
        finally {
            this.ev.log("finishDeployTestModule", (Object)file);
            this.mgr.mutexPrivileged().exitWriteAccess();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void turnOffModule(Module module, Set set) {
        if (!module.isEnabled()) {
            return;
        }
        Iterator iterator = this.mgr.simulateDisable(Collections.singleton(module)).iterator();
        while (iterator.hasNext()) {
            Module module2 = (Module)iterator.next();
            if (module2.isAutoload() || module2.isEager()) continue;
            set.add(module2);
        }
        try {
            System.err.println("Disabling " + module + "...");
            this.mgr.disable(set);
        }
        finally {
            set.remove(module);
        }
    }

    public String getEffectiveClasspath(Module module) {
        return this.installer.getEffectiveClasspath(module);
    }

    private static final class QuietEvents
    extends Events {
        QuietEvents() {
        }

        protected void logged(String string, Object[] objectArray) {
        }
    }
}

