/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.startup;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.CharArrayWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectOutput;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.netbeans.DuplicateException;
import org.netbeans.Events;
import org.netbeans.InvalidException;
import org.netbeans.Module;
import org.netbeans.ModuleManager;
import org.netbeans.Util;
import org.netbeans.core.startup.ModuleHistory;
import org.openide.filesystems.FileAttributeEvent;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileRenameEvent;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.modules.Dependency;
import org.openide.modules.InstalledFileLocator;
import org.openide.modules.ModuleInstall;
import org.openide.modules.SpecificationVersion;
import org.openide.util.RequestProcessor;
import org.openide.util.Utilities;
import org.openide.util.WeakSet;
import org.openide.util.io.NbObjectInputStream;
import org.openide.util.io.NbObjectOutputStream;
import org.openide.xml.EntityCatalog;
import org.openide.xml.XMLUtil;
import org.xml.sax.Attributes;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

final class ModuleList {
    public static final String PUBLIC_ID = "-//NetBeans//DTD Module Status 1.0//EN";
    public static final String SYSTEM_ID = "http://www.netbeans.org/dtds/module-status-1_0.dtd";
    private static final boolean VALIDATE_XML = true;
    private final ModuleManager mgr;
    private final FileObject folder;
    private final Events ev;
    private final Map statuses = new HashMap(100);
    private boolean triggered = false;
    private final Listener listener = new Listener();
    private final Map compatibilitySers = new HashMap(100);
    private final Set myAtomicActions = Collections.synchronizedSet(new WeakSet(100));
    private static final byte[] MODULE_XML_INTRO = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<!DOCTYPE module PUBLIC \"-//NetBeans//DTD Module Status 1.0//EN\"\n                        \"http://www.netbeans.org/dtds/module-status-1_0.dtd\">\n<module name=\"".getBytes();
    private static final byte[] MODULE_XML_INTRO_END = ">\n".getBytes();
    private static final byte[] MODULE_XML_DIV2 = "   <param name=\"".getBytes();
    private static final byte[] MODULE_XML_DIV3 = "/param>\n".getBytes();
    private static final byte[] MODULE_XML_END = "/module>\n".getBytes();
    private static RequestProcessor rpListener = null;
    static /* synthetic */ Class class$org$openide$modules$ModuleInstall;
    static /* synthetic */ Class class$org$netbeans$core$startup$ModuleList;

    public ModuleList(ModuleManager moduleManager, FileObject fileObject, Events events) {
        this.mgr = moduleManager;
        this.folder = fileObject;
        this.ev = events;
        Util.err.log("ModuleList created, storage in " + fileObject);
    }

    public Set readInitial() {
        this.ev.log("startRead");
        final HashSet hashSet = new HashSet();
        try {
            this.folder.getFileSystem().runAtomicAction(new FileSystem.AtomicAction(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() throws IOException {
                    FileObject[] fileObjectArray = ModuleList.this.folder.getChildren();
                    ModuleList.this.ev.log("perfTick", (Object)"list of files found");
                    XMLReader xMLReader = null;
                    for (int i = 0; i < fileObjectArray.length; ++i) {
                        if (!fileObjectArray[i].hasExt("ser")) {
                            if (fileObjectArray[i].hasExt("xml")) {
                                try {
                                    Object object;
                                    Module module;
                                    File file;
                                    Object object2;
                                    Object object3;
                                    Map map;
                                    String string;
                                    String string2;
                                    block25: {
                                        string2 = fileObjectArray[i].getName();
                                        char[] cArray = new char[]{'.', '/', '>', '='};
                                        for (int j = 0; j < 4; ++j) {
                                            if (string2.indexOf(cArray[j]) == -1) continue;
                                            throw new IllegalArgumentException("Bad name: " + string2);
                                        }
                                        string = string2.replace('-', '.').intern();
                                        Dependency.create((int)1, (String)string);
                                        InputStream inputStream = fileObjectArray[i].getInputStream();
                                        try {
                                            map = ModuleList.this.readStatus(new BufferedInputStream(inputStream));
                                            if (map != null) break block25;
                                            Util.err.log(16, "Note - failed to parse " + fileObjectArray[i] + " the quick way, falling back on XMLReader");
                                            inputStream.close();
                                            inputStream = fileObjectArray[i].getInputStream();
                                            object3 = new InputSource(inputStream);
                                            ((InputSource)object3).setSystemId(fileObjectArray[i].getURL().toExternalForm());
                                            if (xMLReader == null) {
                                                try {
                                                    xMLReader = XMLUtil.createXMLReader();
                                                }
                                                catch (SAXException sAXException) {
                                                    object2 = new IllegalStateException(sAXException.toString());
                                                    Util.err.annotate((Throwable)object2, (Throwable)sAXException);
                                                    throw object2;
                                                }
                                                xMLReader.setEntityResolver(ModuleList.this.listener);
                                                xMLReader.setErrorHandler(ModuleList.this.listener);
                                            }
                                            map = ModuleList.this.readStatus((InputSource)object3, xMLReader);
                                        }
                                        finally {
                                            inputStream.close();
                                        }
                                    }
                                    if (!string.equals(map.get("name"))) {
                                        throw new IOException("Code name mismatch: " + string + " vs. " + map.get("name"));
                                    }
                                    object3 = (String)map.get("jar");
                                    try {
                                        file = ModuleList.this.findJarByName((String)object3, string);
                                    }
                                    catch (FileNotFoundException fileNotFoundException) {
                                        ModuleList.this.ev.log("missingJarFile", (Object)new File(fileNotFoundException.getMessage()));
                                        try {
                                            fileObjectArray[i].delete();
                                        }
                                        catch (IOException iOException) {
                                            Util.err.notify((Throwable)iOException);
                                        }
                                        continue;
                                    }
                                    object2 = new ModuleHistory((String)object3);
                                    Integer n = (Integer)map.get("release");
                                    int n2 = n == null ? -1 : n;
                                    SpecificationVersion specificationVersion = (SpecificationVersion)map.get("specversion");
                                    ((ModuleHistory)object2).upgrade(n2, specificationVersion);
                                    Boolean bl = (Boolean)map.get("reloadable");
                                    boolean bl2 = bl != null ? bl : false;
                                    Boolean bl3 = (Boolean)map.get("enabled");
                                    boolean bl4 = bl3 != null ? bl3 : false;
                                    Boolean bl5 = (Boolean)map.get("autoload");
                                    boolean bl6 = bl5 != null ? bl5 : false;
                                    Boolean bl7 = (Boolean)map.get("eager");
                                    boolean bl8 = bl7 != null ? bl7 : false;
                                    String string3 = (String)map.get("installer");
                                    if (string3 != null) {
                                        if (!string3.equals(string2 + ".ser")) {
                                            throw new IOException("Incorrect installer ser name: " + string3);
                                        }
                                        module = ModuleList.this.folder.getFileObject(string2, "ser");
                                        if (module == null) {
                                            throw new IOException("No such install ser: " + string3 + "; I see only: " + Arrays.asList(fileObjectArray));
                                        }
                                        object = new byte[(int)module.getSize()];
                                        InputStream inputStream = module.getInputStream();
                                        try {
                                            inputStream.read((byte[])object);
                                        }
                                        finally {
                                            inputStream.close();
                                        }
                                        ((ModuleHistory)object2).setInstallerState((byte[])object);
                                        map.put("installerState", object);
                                    }
                                    module = ModuleList.this.mgr.create(file, object2, bl2, bl6, bl8);
                                    hashSet.add(module);
                                    object = new DiskStatus();
                                    ((DiskStatus)object).module = module;
                                    ((DiskStatus)object).file = fileObjectArray[i];
                                    ((DiskStatus)object).pendingInstall = bl4;
                                    ((DiskStatus)object).diskProps = map;
                                    ModuleList.this.statuses.put(string, object);
                                }
                                catch (Exception exception) {
                                    Util.err.annotate((Throwable)exception, 4096, "Error encountered while reading " + fileObjectArray[i], null, null, null);
                                    Util.err.notify((Throwable)exception);
                                }
                            } else {
                                Util.err.log("Strange file encountered in modules folder: " + fileObjectArray[i]);
                            }
                        }
                        ModuleList.this.ev.log("modulesFileProcessed", (Object)fileObjectArray[i]);
                    }
                    if (Util.err.isLoggable(1)) {
                        Util.err.log("read initial XML files: statuses=" + ModuleList.this.statuses);
                    }
                    ModuleList.this.ev.log("finishRead", (Object)hashSet);
                    ModuleList.this.folder.addFileChangeListener(FileUtil.weakFileChangeListener((FileChangeListener)ModuleList.this.listener, (Object)ModuleList.this.folder));
                }
            });
        }
        catch (IOException iOException) {
            Util.err.notify((Throwable)iOException);
        }
        return hashSet;
    }

    private File findJarByName(String string, String string2) throws IOException {
        File file = new File(string);
        if (file.isAbsolute()) {
            if (!file.isFile()) {
                throw new FileNotFoundException(file.getAbsolutePath());
            }
            return file;
        }
        file = InstalledFileLocator.getDefault().locate(string, string2, false);
        if (file != null) {
            return file;
        }
        throw new FileNotFoundException(string);
    }

    public void trigger(Set set) {
        this.ev.log("perfStart", (Object)"ModuleList.trigger");
        if (this.triggered) {
            throw new IllegalStateException("Duplicate call to trigger()");
        }
        HashSet<Module> hashSet = new HashSet<Module>(set);
        Iterator iterator = this.statuses.values().iterator();
        while (iterator.hasNext()) {
            DiskStatus diskStatus = (DiskStatus)iterator.next();
            if (!diskStatus.pendingInstall) continue;
            diskStatus.pendingInstall = false;
            Module module = diskStatus.module;
            if (module.isEnabled() || module.isAutoload() || module.isEager()) {
                throw new IllegalStateException();
            }
            hashSet.add(module);
        }
        this.ev.log("perfTick", (Object)"modules to enable prepared");
        if (!hashSet.isEmpty()) {
            this.ev.log("startAutoRestore", hashSet);
            this.installNew(hashSet);
            this.ev.log("finishAutoRestore", hashSet);
        }
        Util.err.log("ModuleList.trigger: enabled new modules, flushing changes...");
        this.triggered = true;
        this.flushInitial();
        this.ev.log("perfEnd", (Object)"ModuleList.trigger");
    }

    private void installNew(Set set) {
        Object object;
        Object object2;
        if (set.isEmpty()) {
            return;
        }
        this.ev.log("perfStart", (Object)"ModuleList.installNew");
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            object2 = (Module)iterator.next();
            if (object2.isAutoload() || object2.isEager()) {
                iterator.remove();
                continue;
            }
            if (object2.isEnabled()) {
                Util.err.log("#17295 fix active for " + object2.getCodeNameBase());
                iterator.remove();
                continue;
            }
            if (object2.isValid()) continue;
            Util.err.log("#17471 fix active for " + object2.getCodeNameBase());
            iterator.remove();
        }
        object2 = this.mgr.simulateEnable(set);
        iterator = object2.iterator();
        while (iterator.hasNext()) {
            object = (Module)iterator.next();
            if (object.isAutoload() || object.isEager() || set.contains(object)) continue;
            set.add(object);
        }
        object = new HashSet(set);
        object.removeAll((Collection<?>)object2);
        if (!object.isEmpty()) {
            Util.transitiveClosureModuleDependencies((ModuleManager)this.mgr, (Set)object);
            iterator = object.iterator();
            while (iterator.hasNext()) {
                Module module = (Module)iterator.next();
                if (!module.getProblems().isEmpty()) continue;
                iterator.remove();
            }
            this.ev.log("failedInstallNew", object);
            set.removeAll((Collection<?>)object);
        }
        try {
            this.mgr.enable(set);
        }
        catch (InvalidException invalidException) {
            Util.err.notify(1, (Throwable)invalidException);
            Module module = invalidException.getModule();
            if (module == null) {
                throw new IllegalStateException();
            }
            this.ev.log("failedInstallNewUnexpected", (Object)module, (Object)invalidException);
            set.remove(module);
            this.installNew(set);
        }
        this.ev.log("perfEnd", (Object)"ModuleList.installNew");
    }

    void installPrepare(Module module, ModuleInstall moduleInstall) {
        if (!(module.getHistory() instanceof ModuleHistory)) {
            Util.err.log(module + " had strange history " + module.getHistory() + ", ignoring...");
            return;
        }
        ModuleHistory moduleHistory = (ModuleHistory)module.getHistory();
        byte[] byArray = (byte[])this.compatibilitySers.get(moduleInstall.getClass().getName());
        if (byArray != null) {
            Util.err.log("Had some old-style state for " + module);
            if (ModuleList.isReallyExternalizable(moduleInstall.getClass())) {
                try {
                    ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(1000);
                    new NbObjectOutputStream((OutputStream)byteArrayOutputStream).writeObject((Object)moduleInstall);
                    byteArrayOutputStream.close();
                    if (Utilities.compareObjects((Object)byArray, (Object)byteArrayOutputStream.toByteArray())) {
                        Util.err.log("Old-style state for " + module + " was gratuitous");
                    } else {
                        Util.err.log("Old-style state for " + module + " was useful, loading it...");
                        moduleHistory.setInstallerState(new byte[0]);
                        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
                        Object object = new NbObjectInputStream((InputStream)byteArrayInputStream).readObject();
                        if (object != moduleInstall) {
                            throw new ClassCastException("Stored " + object + " but expecting " + moduleInstall);
                        }
                    }
                }
                catch (Exception exception) {
                    Util.err.notify((Throwable)exception);
                    moduleHistory.setInstallerState(new byte[0]);
                }
                catch (LinkageError linkageError) {
                    Util.err.notify((Throwable)linkageError);
                    moduleHistory.setInstallerState(new byte[0]);
                }
            } else {
                Util.err.log(module + " did not want to store install state");
            }
        } else if (moduleHistory.getInstallerState() != null) {
            Util.err.log("Loading install state for " + module);
            try {
                ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(moduleHistory.getInstallerState());
                Object object = new NbObjectInputStream((InputStream)byteArrayInputStream).readObject();
                if (object != moduleInstall) {
                    throw new ClassCastException("Stored " + object + " but expecting " + moduleInstall);
                }
            }
            catch (Exception exception) {
                Util.err.notify((Throwable)exception);
            }
            catch (LinkageError linkageError) {
                Util.err.notify((Throwable)linkageError);
            }
        } else if (ModuleList.isReallyExternalizable(moduleInstall.getClass())) {
            Util.err.log("Checking pre-install state of " + module);
            Util.err.log(16, "Warning: use of writeExternal (or writeReplace) in " + moduleInstall.getClass().getName() + " is deprecated; use normal settings instead");
            try {
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(1000);
                new NbObjectOutputStream((OutputStream)byteArrayOutputStream).writeObject((Object)moduleInstall);
                byteArrayOutputStream.close();
                moduleHistory.setInstallerState(byteArrayOutputStream.toByteArray());
            }
            catch (Exception exception) {
                Util.err.notify((Throwable)exception);
                moduleHistory.setInstallerState(new byte[0]);
            }
            catch (LinkageError linkageError) {
                Util.err.notify((Throwable)linkageError);
                moduleHistory.setInstallerState(new byte[0]);
            }
        } else {
            Util.err.log(module + " did not want to store install state");
        }
    }

    private static boolean isReallyExternalizable(Class clazz) {
        Class clazz2;
        for (clazz2 = clazz; clazz2 != (class$org$openide$modules$ModuleInstall == null ? ModuleList.class$("org.openide.modules.ModuleInstall") : class$org$openide$modules$ModuleInstall) && clazz2 != (class$java$lang$Object == null ? ModuleList.class$("java.lang.Object") : class$java$lang$Object); clazz2 = clazz2.getSuperclass()) {
            try {
                Method method = clazz2.getDeclaredMethod("writeExternal", ObjectOutput.class);
                return true;
            }
            catch (NoSuchMethodException noSuchMethodException) {
                try {
                    Method method = clazz2.getDeclaredMethod("writeReplace", new Class[0]);
                    return true;
                }
                catch (NoSuchMethodException noSuchMethodException2) {
                    continue;
                }
            }
        }
        if (clazz2 == Object.class) {
            throw new IllegalArgumentException("Class " + clazz + " was not a ModuleInstall");
        }
        return false;
    }

    void installPostpare(Module module, ModuleInstall moduleInstall) {
        block7: {
            if (!(module.getHistory() instanceof ModuleHistory)) {
                Util.err.log(module + " had strange history " + module.getHistory() + ", ignoring...");
                return;
            }
            ModuleHistory moduleHistory = (ModuleHistory)module.getHistory();
            if (moduleHistory.getInstallerState() != null) {
                try {
                    ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(1000);
                    new NbObjectOutputStream((OutputStream)byteArrayOutputStream).writeObject((Object)moduleInstall);
                    byteArrayOutputStream.close();
                    byte[] byArray = moduleHistory.getInstallerState();
                    byte[] byArray2 = byteArrayOutputStream.toByteArray();
                    if (Utilities.compareObjects((Object)byArray, (Object)byArray2)) {
                        Util.err.log(module + " did not change installer state (" + byArray.length + " bytes), not writing anything");
                        break block7;
                    }
                    Util.err.log(module + " changed installer state after loading");
                    moduleHistory.setInstallerState(byArray2);
                }
                catch (Exception exception) {
                    Util.err.notify((Throwable)exception);
                }
                catch (LinkageError linkageError) {
                    Util.err.notify((Throwable)linkageError);
                }
            } else {
                Util.err.log(module + " has no saved state");
            }
        }
    }

    private Map readStatus(InputSource inputSource, XMLReader xMLReader) throws IOException, SAXException {
        if (xMLReader == null) {
            xMLReader = XMLUtil.createXMLReader((boolean)true);
            xMLReader.setEntityResolver(this.listener);
            xMLReader.setErrorHandler(this.listener);
        }
        final HashMap hashMap = new HashMap();
        DefaultHandler defaultHandler = new DefaultHandler(){
            private String modName;
            private String paramName;
            private StringBuffer data = new StringBuffer();

            public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
                if ("module".equals(string3)) {
                    this.modName = attributes.getValue("name");
                    if (this.modName == null) {
                        throw new SAXException("No module name");
                    }
                    hashMap.put("name", this.modName.intern());
                } else if (this.modName != null && "param".equals(string3)) {
                    this.paramName = attributes.getValue("name");
                    if (this.paramName == null) {
                        throw new SAXException("No param name");
                    }
                    this.paramName = this.paramName.intern();
                    this.data.setLength(0);
                }
            }

            public void characters(char[] cArray, int n, int n2) {
                if (this.modName != null && this.paramName != null) {
                    this.data.append(cArray, n, n2);
                }
            }

            public void endElement(String string, String string2, String string3) throws SAXException {
                if ("param".equals(string3)) {
                    if (this.modName != null && this.paramName != null) {
                        if (this.data.length() == 0) {
                            throw new SAXException("No text contents in " + this.paramName + " of " + this.modName);
                        }
                        try {
                            hashMap.put(this.paramName, ModuleList.this.processStatusParam(this.paramName, this.data.toString()));
                        }
                        catch (NumberFormatException numberFormatException) {
                            SAXException sAXException = new SAXException(numberFormatException.toString());
                            Util.err.annotate((Throwable)sAXException, (Throwable)numberFormatException);
                            throw sAXException;
                        }
                        this.data.setLength(0);
                        this.paramName = null;
                    }
                } else if ("module".equals(string3)) {
                    this.modName = null;
                }
            }
        };
        xMLReader.setContentHandler(defaultHandler);
        xMLReader.parse(inputSource);
        this.sanityCheckStatus(hashMap);
        return hashMap;
    }

    private Object processStatusParam(String string, String string2) throws NumberFormatException {
        if (string == "release") {
            return new Integer(string2);
        }
        if (string == "enabled" || string == "autoload" || string == "eager" || string == "reloadable") {
            return Boolean.valueOf(string2);
        }
        if (string == "specversion") {
            return new SpecificationVersion(string2);
        }
        if (string2.length() < 100) {
            string2 = string2.intern();
        }
        return string2;
    }

    private void sanityCheckStatus(Map map) throws IOException {
        if (map.get("jar") == null) {
            throw new IOException("Must define jar param");
        }
        if (map.get("autoload") != null && ((Boolean)map.get("autoload")).booleanValue() && map.get("enabled") != null) {
            throw new IOException("Autoloads cannot specify enablement");
        }
        if (map.get("eager") != null && ((Boolean)map.get("eager")).booleanValue() && map.get("enabled") != null) {
            throw new IOException("Eager modules cannot specify enablement");
        }
        String string = (String)map.remove("origin");
        if (string != null) {
            String string2;
            String string3 = (String)map.get("jar");
            if (string.equals("user") || string.equals("installation")) {
                string2 = "modules/" + string3;
            } else if (string.equals("user/autoload") || string.equals("installation/autoload")) {
                string2 = "modules/autoload/" + string3;
            } else if (string.equals("user/eager") || string.equals("installation/eager")) {
                string2 = "modules/eager/" + string3;
            } else if (string.equals("adhoc")) {
                string2 = string3;
            } else {
                throw new IOException("Unrecognized origin " + string + " for " + string3);
            }
            Util.err.log(16, "Upgrading 'jar' param from " + string3 + " to " + string2 + " and removing 'origin' " + string);
            map.put("jar", string2);
        }
    }

    private Map readStatus(InputStream inputStream) throws IOException {
        HashMap<String, Object> hashMap = new HashMap<String, Object>(15);
        if (!this.expect(inputStream, MODULE_XML_INTRO)) {
            Util.err.log("Could not read intro");
            return null;
        }
        String string = this.readTo(inputStream, '\"');
        if (string == null) {
            Util.err.log("Could not read code name base");
            return null;
        }
        hashMap.put("name", string.intern());
        if (!this.expect(inputStream, MODULE_XML_INTRO_END)) {
            Util.err.log("Could not read stuff after cnb");
            return null;
        }
        block6: while (true) {
            int n = inputStream.read();
            switch (n) {
                case 32: {
                    if (!this.expect(inputStream, MODULE_XML_DIV2)) {
                        Util.err.log("Could not read up to param");
                        return null;
                    }
                    String string2 = this.readTo(inputStream, '\"');
                    if (string2 == null) {
                        Util.err.log("Could not read param");
                        return null;
                    }
                    string2 = string2.intern();
                    if (inputStream.read() != 62) {
                        Util.err.log("No > at end of <param> " + string2);
                        return null;
                    }
                    String string3 = this.readTo(inputStream, '<');
                    if (string3 == null) {
                        Util.err.log("Could not read value of " + string2);
                        return null;
                    }
                    if (!this.expect(inputStream, MODULE_XML_DIV3)) {
                        Util.err.log("Could not read end of param " + string2);
                        return null;
                    }
                    try {
                        hashMap.put(string2, this.processStatusParam(string2, string3));
                        break;
                    }
                    catch (NumberFormatException numberFormatException) {
                        Util.err.log("Number misparse: " + numberFormatException);
                        return null;
                    }
                }
                case 60: {
                    if (!this.expect(inputStream, MODULE_XML_END)) {
                        Util.err.log("Strange ending");
                        return null;
                    }
                    if (inputStream.read() == -1) break block6;
                    Util.err.log("Trailing garbage");
                    return null;
                }
                default: {
                    Util.err.log("Strange stuff after <param>s: " + n);
                    return null;
                }
            }
        }
        this.sanityCheckStatus(hashMap);
        return hashMap;
    }

    private boolean expect(InputStream inputStream, byte[] byArray) throws IOException {
        int n = byArray.length;
        boolean bl = false;
        int n2 = 0;
        while (n2 < n) {
            int n3 = inputStream.read();
            if (n3 == 10 || n3 == 13) {
                if (bl) continue;
                bl = true;
                n3 = 10;
            } else {
                bl = false;
            }
            if (n3 == byArray[n2++]) continue;
            return false;
        }
        if (byArray[n - 1] == 10) {
            if (!inputStream.markSupported()) {
                throw new IOException("Mark not supported");
            }
            inputStream.mark(1);
            n2 = inputStream.read();
            if (n2 != -1 && n2 != 10 && n2 != 13) {
                inputStream.reset();
            }
        }
        return true;
    }

    private String readTo(InputStream inputStream, char c) throws IOException {
        if (c == '\n') {
            throw new IOException("Not implemented");
        }
        CharArrayWriter charArrayWriter = new CharArrayWriter(100);
        boolean bl = false;
        int n;
        while ((n = inputStream.read()) != -1) {
            if (n > 126) {
                return null;
            }
            if (n == 10 || n == 13) {
                if (bl) continue;
                bl = true;
                n = 10;
            } else {
                if (n < 32 && n != 9) {
                    return null;
                }
                bl = false;
            }
            if (n == c) {
                return charArrayWriter.toString();
            }
            charArrayWriter.write(n);
        }
        return null;
    }

    private void writeStatus(Map map, OutputStream outputStream) throws IOException {
        String string = (String)map.get("name");
        if (string == null) {
            throw new IllegalArgumentException("no code name present");
        }
        OutputStreamWriter outputStreamWriter = new OutputStreamWriter(outputStream, "UTF-8");
        outputStreamWriter.write("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
        outputStreamWriter.write("<!DOCTYPE module PUBLIC \"");
        outputStreamWriter.write(PUBLIC_ID);
        outputStreamWriter.write("\"\n                        \"");
        outputStreamWriter.write(SYSTEM_ID);
        outputStreamWriter.write("\">\n");
        outputStreamWriter.write("<module name=\"");
        outputStreamWriter.write(XMLUtil.toAttributeValue((String)string));
        outputStreamWriter.write("\">\n");
        Iterator iterator = new TreeMap(map).entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            String string2 = (String)entry.getKey();
            if (string2.equals("installerState") || string2.equals("name")) continue;
            Object v = entry.getValue();
            outputStreamWriter.write("    <param name=\"");
            outputStreamWriter.write(XMLUtil.toAttributeValue((String)string2));
            outputStreamWriter.write("\">");
            outputStreamWriter.write(XMLUtil.toElementContent((String)v.toString()));
            outputStreamWriter.write("</param>\n");
        }
        outputStreamWriter.write("</module>\n");
        ((Writer)outputStreamWriter).flush();
    }

    private DiskStatus writeOut(Module module, DiskStatus diskStatus) throws IOException {
        DiskStatus diskStatus2;
        if (diskStatus == null) {
            diskStatus2 = new DiskStatus();
            diskStatus2.module = module;
            diskStatus2.diskProps = this.computeProperties(module);
        } else {
            diskStatus2 = diskStatus;
        }
        FileSystem.AtomicAction atomicAction = new FileSystem.AtomicAction(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() throws IOException {
                Object object;
                if (diskStatus2.file == null) {
                    boolean bl = true;
                    diskStatus2.file = ModuleList.this.folder.createData(((String)diskStatus2.diskProps.get("name")).replace('.', '-'), "xml");
                } else {
                    boolean bl = false;
                    if (diskStatus2.dirty) {
                        throw new IOException("Will not clobber external changes in " + diskStatus2.file);
                    }
                }
                Util.err.log("ModuleList: (re)writing " + diskStatus2.file);
                FileLock fileLock = diskStatus2.file.lock();
                try {
                    object = diskStatus2.file.getOutputStream(fileLock);
                    try {
                        ModuleList.this.writeStatus(diskStatus2.diskProps, (OutputStream)object);
                    }
                    finally {
                        ((OutputStream)object).close();
                    }
                }
                finally {
                    fileLock.releaseLock();
                }
                object = (byte[])diskStatus2.diskProps.get("installerState");
                if (object != null) {
                    String string = (String)diskStatus2.diskProps.get("installer");
                    FileObject fileObject = ModuleList.this.folder.getFileObject(string);
                    if (fileObject == null) {
                        int n = string.lastIndexOf(46);
                        fileObject = ModuleList.this.folder.createData(string.substring(0, n), string.substring(n + 1));
                    }
                    fileLock = fileObject.lock();
                    try {
                        OutputStream outputStream = fileObject.getOutputStream(fileLock);
                        try {
                            outputStream.write((byte[])object);
                        }
                        finally {
                            outputStream.close();
                        }
                    }
                    finally {
                        fileLock.releaseLock();
                    }
                }
            }
        };
        this.myAtomicActions.add(atomicAction);
        this.folder.getFileSystem().runAtomicAction(atomicAction);
        return diskStatus2;
    }

    private void deleteFromDisk(final Module module, final DiskStatus diskStatus) throws IOException {
        final String string = module.getCodeNameBase().replace('.', '-');
        FileSystem.AtomicAction atomicAction = new FileSystem.AtomicAction(){

            public void run() throws IOException {
                FileObject fileObject = ModuleList.this.folder.getFileObject(string, "xml");
                if (fileObject == null) {
                    Util.err.log("ModuleList: " + module + "'s XML already gone from disk");
                    return;
                }
                if (diskStatus.dirty) {
                    throw new IOException("Unapproved external change to " + fileObject);
                }
                Util.err.log("ModuleList: deleting " + fileObject);
                fileObject.delete();
                FileObject fileObject2 = ModuleList.this.folder.getFileObject(string, "ser");
                if (fileObject2 != null) {
                    Util.err.log("(and also " + fileObject2 + ")");
                    fileObject2.delete();
                }
            }
        };
        this.myAtomicActions.add(atomicAction);
        this.folder.getFileSystem().runAtomicAction(atomicAction);
    }

    private void flushInitial() {
        Util.err.log("Flushing initial module list...");
        Iterator iterator = this.mgr.getModules().iterator();
        while (iterator.hasNext()) {
            Module module = (Module)iterator.next();
            DiskStatus diskStatus = (DiskStatus)this.statuses.get(module.getCodeNameBase());
            if (diskStatus == null) continue;
            this.moduleChanged(module, diskStatus);
            module.addPropertyChangeListener((PropertyChangeListener)this.listener);
        }
        this.moduleListChanged();
        this.mgr.addPropertyChangeListener((PropertyChangeListener)this.listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void moduleListChanged() {
        Map map = this.statuses;
        synchronized (map) {
            String string;
            Object object;
            if (Util.err.isLoggable(1)) {
                Util.err.log("ModuleList: moduleListChanged; statuses=" + this.statuses);
            }
            Iterator<Object> iterator = this.mgr.getModules().iterator();
            while (iterator.hasNext()) {
                object = (Module)iterator.next();
                if (object.isFixed() || object.getAllJars().isEmpty() || this.statuses.get(string = object.getCodeNameBase()) != null) continue;
                Util.err.log("moduleListChanged: added: " + object);
                try {
                    this.statuses.put(string, this.writeOut((Module)object, null));
                    object.addPropertyChangeListener((PropertyChangeListener)this.listener);
                }
                catch (IOException iOException) {
                    Util.err.notify((Throwable)iOException);
                }
            }
            iterator = this.statuses.values().iterator();
            while (iterator.hasNext()) {
                object = (DiskStatus)iterator.next();
                if (object.module.isValid()) continue;
                object.module.removePropertyChangeListener((PropertyChangeListener)this.listener);
                string = this.mgr.get(object.module.getCodeNameBase());
                if (string != null) {
                    Util.err.log("moduleListChanged: recreated: " + string);
                    string.addPropertyChangeListener((PropertyChangeListener)this.listener);
                    object.module = string;
                    this.moduleChanged((Module)string, (DiskStatus)object);
                    continue;
                }
                Util.err.log("moduleListChanged: deleted: " + object.module);
                iterator.remove();
                try {
                    this.deleteFromDisk(object.module, (DiskStatus)object);
                }
                catch (IOException iOException) {
                    Util.err.notify((Throwable)iOException);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void moduleChanged(Module module, DiskStatus diskStatus) {
        DiskStatus diskStatus2 = diskStatus;
        synchronized (diskStatus2) {
            Map map;
            if (Util.err.isLoggable(1)) {
                Util.err.log("ModuleList: moduleChanged: " + module);
            }
            if (!Utilities.compareObjects((Object)diskStatus.diskProps, (Object)(map = this.computeProperties(module)))) {
                if (Util.err.isLoggable(1)) {
                    HashSet hashSet = new HashSet(map.entrySet());
                    hashSet.removeAll(diskStatus.diskProps.entrySet());
                    Util.err.log("ModuleList: changes are " + hashSet);
                }
                diskStatus.diskProps = map;
                try {
                    this.writeOut(module, diskStatus);
                }
                catch (IOException iOException) {
                    Util.err.notify((Throwable)iOException);
                }
            }
        }
    }

    private Map computeProperties(Module module) {
        SpecificationVersion specificationVersion;
        if (module.isFixed() || !module.isValid()) {
            throw new IllegalArgumentException("fixed or invalid: " + module);
        }
        if (!(module.getHistory() instanceof ModuleHistory)) {
            throw new IllegalArgumentException("weird history: " + module);
        }
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("name", module.getCodeNameBase());
        int n = module.getCodeNameRelease();
        if (n >= 0) {
            hashMap.put("release", new Integer(n));
        }
        if ((specificationVersion = module.getSpecificationVersion()) != null) {
            hashMap.put("specversion", specificationVersion);
        }
        if (!module.isAutoload() && !module.isEager()) {
            hashMap.put("enabled", module.isEnabled() ? Boolean.TRUE : Boolean.FALSE);
        }
        hashMap.put("autoload", module.isAutoload() ? Boolean.TRUE : Boolean.FALSE);
        hashMap.put("eager", module.isEager() ? Boolean.TRUE : Boolean.FALSE);
        hashMap.put("reloadable", module.isReloadable() ? Boolean.TRUE : Boolean.FALSE);
        ModuleHistory moduleHistory = (ModuleHistory)module.getHistory();
        hashMap.put("jar", moduleHistory.getJar());
        if (moduleHistory.getInstallerStateChanged()) {
            hashMap.put("installer", module.getCodeNameBase().replace('.', '-') + ".ser");
            hashMap.put("installerState", moduleHistory.getInstallerState());
        }
        return hashMap;
    }

    private static final class DiskStatus {
        public Module module;
        public FileObject file;
        public boolean pendingInstall = false;
        public Map diskProps;
        public boolean dirty = false;

        public String toString() {
            return "DiskStatus[module=" + this.module + ",valid=" + this.module.isValid() + ",file=" + this.file + ",dirty=" + this.dirty + ",pendingInstall=" + this.pendingInstall + ",diskProps=" + this.diskProps + "]";
        }
    }

    private final class Listener
    implements PropertyChangeListener,
    ErrorHandler,
    EntityResolver,
    FileChangeListener,
    Runnable {
        private boolean listening = true;
        private boolean pendingRun = false;

        Listener() {
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if (!ModuleList.this.triggered) {
                throw new IllegalStateException("Property change before trigger()");
            }
            String string = propertyChangeEvent.getPropertyName();
            Object object = propertyChangeEvent.getSource();
            if (!this.listening) {
                if (Util.err.isLoggable(1)) {
                    Util.err.log("ModuleList: ignoring own change " + string + " from " + object);
                }
                return;
            }
            if ("classLoader".equals(string) || "enabledModules".equals(string) || "classLoader".equals(string) || "problems".equals(string) || "valid".equals(string)) {
                return;
            }
            if ("modules".equals(string)) {
                ModuleList.this.moduleListChanged();
            } else if (object instanceof Module) {
                Module module = (Module)object;
                if (!module.isValid()) {
                    return;
                }
                DiskStatus diskStatus = (DiskStatus)ModuleList.this.statuses.get(module.getCodeNameBase());
                if (diskStatus == null) {
                    throw new IllegalStateException("Unknown module " + module + "; statuses=" + ModuleList.this.statuses);
                }
                if (diskStatus.pendingInstall && "enabled".equals(string)) {
                    throw new IllegalStateException("Got PROP_ENABLED on " + module + " before trigger()");
                }
                ModuleList.this.moduleChanged(module, diskStatus);
            } else {
                Util.err.log("Unexpected property change: " + propertyChangeEvent + " prop=" + string + " src=" + object);
            }
        }

        public void warning(SAXParseException sAXParseException) throws SAXException {
            Util.err.notify(16, (Throwable)sAXParseException);
        }

        public void error(SAXParseException sAXParseException) throws SAXException {
            throw sAXParseException;
        }

        public void fatalError(SAXParseException sAXParseException) throws SAXException {
            throw sAXParseException;
        }

        public InputSource resolveEntity(String string, String string2) throws SAXException, IOException {
            if (string.equals(ModuleList.PUBLIC_ID)) {
                return new InputSource((class$org$netbeans$core$startup$ModuleList == null ? (class$org$netbeans$core$startup$ModuleList = ModuleList.class$("org.netbeans.core.startup.ModuleList")) : class$org$netbeans$core$startup$ModuleList).getResource("module-status-1_0.dtd").toExternalForm());
            }
            return EntityCatalog.getDefault().resolveEntity(string, string2);
        }

        public void fileDeleted(FileEvent fileEvent) {
            if (this.isOurs(fileEvent)) {
                if (Util.err.isLoggable(1)) {
                    Util.err.log("ModuleList: got expected deletion " + fileEvent);
                }
                return;
            }
            FileObject fileObject = fileEvent.getFile();
            this.fileDeleted0(fileObject.getName(), fileObject.getExt());
        }

        public void fileDataCreated(FileEvent fileEvent) {
            if (this.isOurs(fileEvent)) {
                if (Util.err.isLoggable(1)) {
                    Util.err.log("ModuleList: got expected creation " + fileEvent);
                }
                return;
            }
            FileObject fileObject = fileEvent.getFile();
            this.fileCreated0(fileObject, fileObject.getName(), fileObject.getExt());
        }

        public void fileRenamed(FileRenameEvent fileRenameEvent) {
            if (this.isOurs((FileEvent)fileRenameEvent)) {
                throw new IllegalStateException("I don't rename anything! " + fileRenameEvent);
            }
            FileObject fileObject = fileRenameEvent.getFile();
            this.fileDeleted0(fileRenameEvent.getName(), fileRenameEvent.getExt());
            this.fileCreated0(fileObject, fileObject.getName(), fileObject.getExt());
        }

        private void fileCreated0(FileObject fileObject, String string, String string2) {
            if ("xml".equals(string2)) {
                String string3 = string.replace('-', '.');
                DiskStatus diskStatus = (DiskStatus)ModuleList.this.statuses.get(string3);
                Util.err.log("ModuleList: outside file creation event for " + string3);
                if (diskStatus != null) {
                    diskStatus.dirty = true;
                }
                this.runme();
            } else if ("ser".equals(string2)) {
                // empty if block
            }
        }

        private void fileDeleted0(String string, String string2) {
            if ("xml".equals(string2)) {
                String string3 = string.replace('-', '.');
                DiskStatus diskStatus = (DiskStatus)ModuleList.this.statuses.get(string3);
                Util.err.log("ModuleList: outside file deletion event for " + string3);
                if (diskStatus != null) {
                    diskStatus.dirty = true;
                }
                this.runme();
            } else if ("ser".equals(string2)) {
                // empty if block
            }
        }

        public void fileChanged(FileEvent fileEvent) {
            if (this.isOurs(fileEvent)) {
                if (Util.err.isLoggable(1)) {
                    Util.err.log("ModuleList: got expected modification " + fileEvent);
                }
                return;
            }
            FileObject fileObject = fileEvent.getFile();
            String string = fileObject.getName();
            String string2 = fileObject.getExt();
            if ("xml".equals(string2)) {
                String string3 = string.replace('-', '.');
                DiskStatus diskStatus = (DiskStatus)ModuleList.this.statuses.get(string3);
                Util.err.log("ModuleList: outside file modification event for " + string3 + ": " + fileEvent);
                if (diskStatus != null) {
                    diskStatus.dirty = true;
                }
                this.runme();
            } else if ("ser".equals(string2)) {
                // empty if block
            }
        }

        public void fileFolderCreated(FileEvent fileEvent) {
        }

        public void fileAttributeChanged(FileAttributeEvent fileAttributeEvent) {
        }

        private boolean isOurs(FileEvent fileEvent) {
            Iterator iterator = ModuleList.this.myAtomicActions.iterator();
            while (iterator.hasNext()) {
                if (!fileEvent.firedFrom((FileSystem.AtomicAction)iterator.next())) continue;
                return true;
            }
            return false;
        }

        private synchronized void runme() {
            if (!this.pendingRun) {
                this.pendingRun = true;
                if (rpListener == null) {
                    rpListener = new RequestProcessor("org.netbeans.core.modules.ModuleList.Listener");
                }
                rpListener.post((Runnable)this);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            Listener listener = this;
            synchronized (listener) {
                this.pendingRun = false;
            }
            Util.err.log("ModuleList: will process outstanding external XML changes");
            ModuleList.this.mgr.mutexPrivileged().enterWriteAccess();
            try {
                ModuleList.this.folder.getFileSystem().runAtomicAction(new FileSystem.AtomicAction(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void run() throws IOException {
                        Map map = Listener.this.prepareXMLFiles();
                        Map map2 = Listener.this.prepareDirtyProps(map);
                        Listener.this.listening = false;
                        try {
                            Listener.this.stepCheckReloadable(map, map2);
                            Listener.this.stepCreate(map, map2);
                            Listener.this.stepEnable(map, map2);
                            Listener.this.stepDisable(map, map2);
                            Listener.this.stepDelete(map, map2);
                            Listener.this.stepCheckMisc(map, map2);
                            Listener.this.stepCheckSer(map, map2);
                        }
                        finally {
                            Listener.this.listening = true;
                            Listener.this.stepUpdateProps(map, map2);
                            Listener.this.stepMarkClean(map, map2);
                        }
                    }
                });
                Util.err.log("ModuleList: finished processing outstanding external XML changes");
            }
            catch (IOException iOException) {
                Util.err.notify((Throwable)iOException);
            }
            finally {
                ModuleList.this.mgr.mutexPrivileged().exitWriteAccess();
            }
        }

        private Map prepareXMLFiles() {
            Util.err.log("ModuleList: prepareXMLFiles");
            HashMap<String, FileObject> hashMap = new HashMap<String, FileObject>(100);
            FileObject[] fileObjectArray = ModuleList.this.folder.getChildren();
            for (int i = 0; i < fileObjectArray.length; ++i) {
                if (!fileObjectArray[i].hasExt("xml")) continue;
                hashMap.put(fileObjectArray[i].getName().replace('-', '.'), fileObjectArray[i]);
            }
            return hashMap;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Map prepareDirtyProps(Map map) throws IOException {
            Util.err.log("ModuleList: prepareDirtyProps");
            HashMap<String, Map> hashMap = new HashMap<String, Map>(100);
            Iterator iterator = map.entrySet().iterator();
            while (iterator.hasNext()) {
                FileObject fileObject;
                Map.Entry entry = iterator.next();
                String string = (String)entry.getKey();
                DiskStatus diskStatus = (DiskStatus)ModuleList.this.statuses.get(string);
                if (diskStatus != null && !diskStatus.dirty || (fileObject = (FileObject)entry.getValue()) == null || !fileObject.canRead()) continue;
                InputStream inputStream = fileObject.getInputStream();
                try {
                    InputSource inputSource = new InputSource(inputStream);
                    inputSource.setSystemId(fileObject.getURL().toString());
                    try {
                        hashMap.put(string, ModuleList.this.readStatus(inputSource, null));
                    }
                    catch (SAXException sAXException) {
                        IOException iOException = new IOException(sAXException.toString());
                        Util.err.annotate((Throwable)iOException, (Throwable)sAXException);
                        throw iOException;
                    }
                }
                finally {
                    inputStream.close();
                }
            }
            return hashMap;
        }

        private void stepCheckReloadable(Map map, Map map2) {
            Util.err.log("ModuleList: stepCheckReloadable");
            Iterator iterator = map2.entrySet().iterator();
            while (iterator.hasNext()) {
                boolean bl;
                Map.Entry entry = iterator.next();
                String string = (String)entry.getKey();
                DiskStatus diskStatus = (DiskStatus)ModuleList.this.statuses.get(string);
                if (diskStatus == null) continue;
                Map map3 = (Map)entry.getValue();
                Boolean bl2 = (Boolean)map3.get("reloadable");
                boolean bl3 = bl = bl2 != null ? bl2 : false;
                boolean bl4 = diskStatus.module.isReloadable();
                if (bl4 == bl) continue;
                Util.err.log("Disk change in reloadable for " + string + " from " + bl4 + " to " + bl);
                diskStatus.module.setReloadable(bl);
            }
        }

        private void stepCreate(Map map, Map map2) throws IOException {
            Util.err.log("ModuleList: stepCreate");
            Iterator iterator = map.entrySet().iterator();
            while (iterator.hasNext()) {
                HashMap<String, Boolean> hashMap;
                Object object;
                Module module;
                Map.Entry entry = iterator.next();
                String string = (String)entry.getKey();
                if (ModuleList.this.statuses.containsKey(string)) continue;
                FileObject fileObject = (FileObject)entry.getValue();
                HashMap<String, Boolean> hashMap2 = (HashMap<String, Boolean>)map2.get(string);
                if (!string.equals(hashMap2.get("name"))) {
                    throw new IOException("Code name mismatch");
                }
                String string2 = (String)hashMap2.get("jar");
                File file = ModuleList.this.findJarByName(string2, string);
                Boolean bl = (Boolean)hashMap2.get("reloadable");
                boolean bl2 = bl != null ? bl : false;
                Boolean bl3 = (Boolean)hashMap2.get("autoload");
                boolean bl4 = bl3 != null ? bl3 : false;
                Boolean bl5 = (Boolean)hashMap2.get("eager");
                boolean bl6 = bl5 != null ? bl5 : false;
                try {
                    module = ModuleList.this.mgr.create(file, (Object)new ModuleHistory(string2), bl2, bl4, bl6);
                }
                catch (DuplicateException duplicateException) {
                    object = new IOException(duplicateException.toString());
                    Util.err.annotate((Throwable)object, (Throwable)duplicateException);
                    throw object;
                }
                module.addPropertyChangeListener((PropertyChangeListener)this);
                if (hashMap2.get("enabled") != null && ((Boolean)hashMap2.get("enabled")).booleanValue()) {
                    hashMap = new HashMap<String, Boolean>(hashMap2);
                    hashMap.put("enabled", Boolean.FALSE);
                } else {
                    hashMap = hashMap2;
                }
                object = new DiskStatus();
                ((DiskStatus)object).module = module;
                ((DiskStatus)object).file = fileObject;
                ((DiskStatus)object).diskProps = hashMap;
                ModuleList.this.statuses.put(string, object);
            }
        }

        private void stepEnable(Map map, Map map2) throws IOException {
            Util.err.log("ModuleList: stepEnable");
            HashSet<Module> hashSet = new HashSet<Module>();
            Iterator iterator = map2.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                String string = (String)entry.getKey();
                Map map3 = (Map)entry.getValue();
                if (map3.get("enabled") == null || !((Boolean)map3.get("enabled")).booleanValue()) continue;
                DiskStatus diskStatus = (DiskStatus)ModuleList.this.statuses.get(string);
                if (diskStatus.diskProps.get("enabled") != null && ((Boolean)diskStatus.diskProps.get("enabled")).booleanValue()) continue;
                if (diskStatus.module.isEnabled()) {
                    throw new IllegalStateException("Already enabled: " + diskStatus.module);
                }
                hashSet.add(diskStatus.module);
            }
            ModuleList.this.installNew(hashSet);
        }

        private void stepDisable(Map map, Map map2) throws IOException {
            String string;
            Object object;
            Util.err.log("ModuleList: stepDisable");
            HashSet<Object> hashSet = new HashSet<Object>();
            Iterator iterator = map2.entrySet().iterator();
            while (iterator.hasNext()) {
                object = iterator.next();
                string = (String)object.getKey();
                Map map3 = (Map)object.getValue();
                if (map3.get("enabled") != null && ((Boolean)map3.get("enabled")).booleanValue()) continue;
                DiskStatus diskStatus = (DiskStatus)ModuleList.this.statuses.get(string);
                if (diskStatus.diskProps.get("enabled") == null || !((Boolean)diskStatus.diskProps.get("enabled")).booleanValue()) continue;
                if (!diskStatus.module.isEnabled()) {
                    throw new IllegalStateException("Already disabled: " + diskStatus.module);
                }
                hashSet.add(diskStatus.module);
            }
            if (hashSet.isEmpty()) {
                return;
            }
            object = ModuleList.this.mgr.simulateDisable(hashSet);
            iterator = object.iterator();
            while (iterator.hasNext()) {
                string = (Module)iterator.next();
                if (string.isAutoload() || string.isEager() || hashSet.contains(string)) continue;
                hashSet.add(string);
            }
            ModuleList.this.mgr.disable(hashSet);
        }

        private void stepDelete(Map map, Map map2) throws IOException {
            DiskStatus diskStatus;
            Object object;
            Object object2;
            Util.err.log("ModuleList: stepDelete");
            HashSet<Module> hashSet = new HashSet<Module>();
            Iterator iterator = ModuleList.this.statuses.entrySet().iterator();
            while (iterator.hasNext()) {
                object2 = iterator.next();
                object = (String)object2.getKey();
                diskStatus = (DiskStatus)object2.getValue();
                if (map.containsKey(object)) continue;
                Module module = diskStatus.module;
                hashSet.add(module);
                iterator.remove();
            }
            if (hashSet.isEmpty()) {
                return;
            }
            object2 = new HashSet();
            iterator = hashSet.iterator();
            while (iterator.hasNext()) {
                object = (Module)iterator.next();
                if (!object.isEnabled() || object.isAutoload() || object.isEager()) continue;
                object2.add(object);
            }
            object = ModuleList.this.mgr.simulateDisable((Set)object2);
            iterator = object.iterator();
            while (iterator.hasNext()) {
                diskStatus = (Module)iterator.next();
                if (diskStatus.isAutoload() || diskStatus.isEager() || object2.contains(diskStatus)) continue;
                object2.add(diskStatus);
            }
            ModuleList.this.mgr.disable((Set)object2);
            iterator = hashSet.iterator();
            while (iterator.hasNext()) {
                diskStatus = (Module)iterator.next();
                if (diskStatus.isEnabled()) {
                    if (!diskStatus.isAutoload() && !diskStatus.isEager()) {
                        throw new IllegalStateException("Module " + diskStatus + " scheduled for deletion could not be disabled yet was not an autoload nor eager");
                    }
                    ModuleList.this.ev.log("cantDeleteEnabledAutoload", (Object)diskStatus);
                    iterator.remove();
                    continue;
                }
                ModuleList.this.mgr.delete((Module)diskStatus);
            }
        }

        private void stepCheckMisc(Map map, Map map2) {
            Util.err.log("ModuleList: stepCheckMisc");
            String[] stringArray = new String[]{"jar", "autoload", "eager", "release", "specversion"};
            Iterator iterator = map2.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                String string = (String)entry.getKey();
                Map map3 = (Map)entry.getValue();
                DiskStatus diskStatus = (DiskStatus)ModuleList.this.statuses.get(string);
                Map map4 = diskStatus.diskProps;
                for (int i = 0; i < stringArray.length; ++i) {
                    Object v;
                    String string2 = stringArray[i];
                    Object v2 = map3.get(string2);
                    if (Utilities.compareObjects(v2, v = map4.get(string2))) continue;
                    ModuleList.this.ev.log("miscPropMismatch", (Object)diskStatus.module, (Object)string2, v2, v);
                }
            }
        }

        private void stepCheckSer(Map map, Map map2) {
        }

        private void stepUpdateProps(Map map, Map map2) {
            Util.err.log("ModuleList: stepUpdateProps");
            Iterator iterator = map2.entrySet().iterator();
            while (iterator.hasNext()) {
                Map map3;
                Map.Entry entry = iterator.next();
                String string = (String)entry.getKey();
                DiskStatus diskStatus = (DiskStatus)ModuleList.this.statuses.get(string);
                if (diskStatus == null) continue;
                diskStatus.diskProps = map3 = (Map)entry.getValue();
            }
        }

        private void stepMarkClean(Map map, Map map2) {
            Util.err.log("ModuleList: stepMarkClean");
            Iterator iterator = ModuleList.this.statuses.values().iterator();
            while (iterator.hasNext()) {
                DiskStatus diskStatus = (DiskStatus)iterator.next();
                diskStatus.dirty = false;
            }
        }
    }
}

