/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.startup;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Locale;
import org.netbeans.CLIHandler;
import org.netbeans.TopSecurityManager;
import org.netbeans.core.startup.StartLog;
import org.netbeans.core.startup.TopLogging;
import org.openide.util.NbBundle;

public class CLIOptions
extends CLIHandler {
    static final String DIR_MODULES = "modules";
    protected static boolean noLogging = false;
    protected static boolean noSplash = false;
    protected static TopLogging logger;
    protected static Class uiClass;
    protected static int uiFontSize;
    private static String homeDir;
    private static String userDir;
    private static String systemDir;
    private static boolean specifiedBranding;

    public CLIOptions() {
        super(1);
    }

    protected int cli(CLIHandler.Args args) {
        return this.cli(args.getArguments());
    }

    public static boolean isGui() {
        return "true".equals(System.getProperty("org.openide.TopManager.GUI"));
    }

    private static boolean isOption(String string, String string2) {
        if (string == null) {
            return false;
        }
        if (string.startsWith("--")) {
            return string.substring(2).equals(string2);
        }
        if (string.startsWith("-")) {
            return string.substring(1).equals(string2);
        }
        return false;
    }

    public final int cli(String[] stringArray) {
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i] == null) continue;
            boolean bl = true;
            if (CLIOptions.isOption(stringArray[i], "nogui")) {
                System.getProperties().put("org.openide.TopManager", "org.netbeans.core.NonGui");
                System.setProperty("org.openide.TopManager.GUI", "false");
            } else if (CLIOptions.isOption(stringArray[i], "nosplash")) {
                noSplash = true;
            } else if (!CLIOptions.isOption(stringArray[i], "noinfo")) {
                if (CLIOptions.isOption(stringArray[i], "nologging")) {
                    noLogging = true;
                } else {
                    String string;
                    if (CLIOptions.isOption(stringArray[i], "userdir")) {
                        stringArray[i] = null;
                        try {
                            System.setProperty("netbeans.user", stringArray[++i]);
                        }
                        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                            System.err.println(CLIOptions.getString("ERR_UserDirExpected"));
                            return 2;
                        }
                    }
                    if (CLIOptions.isOption(stringArray[i], "ui") || CLIOptions.isOption(stringArray[i], "laf")) {
                        stringArray[i] = null;
                        try {
                            string = stringArray[++i];
                            if ("com.sun.java.swing.plaf.gtk.GTKLookAndFeel".equals(string) && System.getProperty("java.version").indexOf("1.4.2") != -1) {
                                System.err.println(CLIOptions.getString("MSG_GTKNotSupported"));
                            }
                            uiClass = Class.forName(string);
                        }
                        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                            System.err.println(CLIOptions.getString("ERR_UIExpected"));
                            return 2;
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            System.err.println(CLIOptions.getString("ERR_UINotFound"));
                        }
                    } else {
                        if (CLIOptions.isOption(stringArray[i], "fontsize")) {
                            stringArray[i] = null;
                            try {
                                uiFontSize = Integer.parseInt(stringArray[++i]);
                            }
                            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                                System.err.println(CLIOptions.getString("ERR_FontSizeExpected"));
                                return 2;
                            }
                            catch (NumberFormatException numberFormatException) {
                                System.err.println(CLIOptions.getString("ERR_BadFontSize"));
                                return 1;
                            }
                        }
                        if (CLIOptions.isOption(stringArray[i], "locale")) {
                            String string2;
                            stringArray[i] = null;
                            string = stringArray[++i];
                            String string3 = "";
                            String string4 = "";
                            int n = string.indexOf(":");
                            if (n == -1) {
                                string2 = string;
                            } else {
                                string2 = string.substring(0, n);
                                int n2 = string.indexOf(":", n + 1);
                                if (n2 != -1) {
                                    string3 = string.substring(n + 1, n2);
                                    string4 = string.substring(n2 + 1);
                                } else {
                                    string3 = string.substring(n + 1);
                                }
                            }
                            Locale.setDefault(new Locale(string2, string3, string4));
                        } else if (CLIOptions.isOption(stringArray[i], "branding")) {
                            stringArray[i] = null;
                            if (++i == stringArray.length) {
                                System.err.println(CLIOptions.getString("ERR_BrandingNeedsArgument"));
                                return 2;
                            }
                            string = stringArray[i];
                            if (string.equals("-")) {
                                string = null;
                            }
                            try {
                                NbBundle.setBranding((String)string);
                            }
                            catch (IllegalArgumentException illegalArgumentException) {
                                illegalArgumentException.printStackTrace();
                                return 1;
                            }
                            specifiedBranding = true;
                        } else {
                            bl = false;
                        }
                    }
                }
            }
            if (!bl) continue;
            stringArray[i] = null;
        }
        return 0;
    }

    public static void initialize() {
        if (!noLogging) {
            try {
                logger = "memory".equals(CLIOptions.getUserDir()) ? new TopLogging(null) : new TopLogging(CLIOptions.getLogDir());
            }
            catch (IOException iOException) {
                System.err.println("Cannot create log file. Logging disabled.");
                iOException.printStackTrace();
            }
        }
        StartLog.logProgress("TopLogging initialized");
    }

    protected void usage(PrintWriter printWriter) {
        printWriter.println("Core options:");
        printWriter.println("  --laf <LaF classname> use given LookAndFeel class instead of the default");
        printWriter.println("  --fontsize <size>     set the base font size of the user interface, in points");
        printWriter.println("  --locale <language[:country[:variant]]> use specified locale");
        printWriter.println("  --userdir <path>      use specified directory to store user settings");
        printWriter.println("");
    }

    private static String getString(String string) {
        return NbBundle.getMessage((Class)CLIOptions.class, (String)string);
    }

    public static String getLogDir() {
        return new File(new File(CLIOptions.getUserDir(), "var"), "log").toString();
    }

    static final void clearForTests() {
        homeDir = null;
        userDir = null;
    }

    public static String getHomeDir() {
        if (homeDir == null) {
            homeDir = System.getProperty("netbeans.home");
        }
        return homeDir;
    }

    public static String getUserDir() {
        if (userDir == null) {
            userDir = System.getProperty("netbeans.user");
            if ("memory".equals(userDir)) {
                return "memory";
            }
            if (userDir == null) {
                System.err.println(NbBundle.getMessage((Class)CLIOptions.class, (String)"ERR_no_user_directory"));
                Thread.dumpStack();
                TopSecurityManager.exit((int)1);
            }
            if (userDir.equals(CLIOptions.getHomeDir())) {
                System.err.println(NbBundle.getMessage((Class)CLIOptions.class, (String)"ERR_user_directory_is_home"));
                TopSecurityManager.exit((int)1);
            }
            File file = new File(userDir);
            try {
                file = file.getCanonicalFile();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            userDir = file.getPath();
            System.setProperty("netbeans.user", userDir);
            File file2 = new File(userDir, "config");
            CLIOptions.makedir(file2);
            systemDir = file2.getAbsolutePath();
            CLIOptions.makedir(new File(userDir, DIR_MODULES));
        }
        return userDir;
    }

    private static void makedir(File file) {
        Object[] objectArray;
        if (file.isFile()) {
            objectArray = new Object[]{file};
            System.err.println(NbBundle.getMessage((Class)CLIOptions.class, (String)"CTL_CannotCreate_text", (Object[])objectArray));
            TopSecurityManager.exit((int)6);
        }
        if (!file.exists() && !file.mkdirs()) {
            objectArray = new Object[]{file};
            System.err.println(NbBundle.getMessage((Class)CLIOptions.class, (String)"CTL_CannotCreateSysDir_text", (Object[])objectArray));
            TopSecurityManager.exit((int)7);
        }
    }

    protected static String getSystemDir() {
        CLIOptions.getUserDir();
        return systemDir;
    }

    public static int getFontSize() {
        return uiFontSize;
    }

    static {
        uiFontSize = 0;
        specifiedBranding = false;
    }
}

