/*
 * Decompiled with CFR 0.152.
 */
package tr.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.channels.FileChannel;

public final class Utils {
    public static final boolean equal(Object o1, Object o2) {
        if (o1 == null && o2 == null) {
            return true;
        }
        if (o1 == null || o2 == null) {
            return false;
        }
        return o1.equals(o2);
    }

    public static void copy(File in, File out) throws FileNotFoundException, IOException {
        FileChannel srcChannel = new FileInputStream(in).getChannel();
        FileChannel dstChannel = new FileOutputStream(out).getChannel();
        srcChannel.transferTo(0L, srcChannel.size(), dstChannel);
        srcChannel.close();
        dstChannel.close();
    }

    public static final String getExtension(String name) {
        int index;
        if (name != null && (index = name.lastIndexOf(46)) > 0 && index < name.length() - 1) {
            return name.substring(index + 1).toLowerCase();
        }
        return null;
    }

    public static final String setExtension(String path, String extn) {
        if (path == null || extn == null) {
            return null;
        }
        return path + "." + extn;
    }

    public static final String removeExtension(String path) {
        if (path == null) {
            return null;
        }
        int index = path.lastIndexOf(".");
        if (index < 0) {
            return path;
        }
        return path.substring(0, index);
    }

    public static final boolean in(String str, String[] arr) {
        if (str != null && arr != null) {
            for (int i = 0; i < arr.length; ++i) {
                if (!str.equals(arr[i])) continue;
                return true;
            }
        }
        return false;
    }

    public static final File getTempDir() throws IOException {
        String tmpdir = System.getProperty("java.io.tmpdir");
        File dir = new File(tmpdir);
        if (dir.isDirectory() && dir.canWrite()) {
            return dir;
        }
        tmpdir = System.getProperty("user.home");
        dir = new File(tmpdir);
        if (dir.isDirectory() && dir.canWrite()) {
            return dir;
        }
        throw new IOException("A writeable temporary directory could not be found.");
    }
}

