/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.masterfs.filebasedfs.fileobjects;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.channels.FileChannel;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.netbeans.modules.masterfs.filebasedfs.fileobjects.WriteLockFactory;
import org.netbeans.modules.masterfs.filebasedfs.fileobjects.WriteLockUtils;
import org.netbeans.modules.masterfs.filebasedfs.utils.FSException;
import org.openide.ErrorManager;
import org.openide.filesystems.FileAlreadyLockedException;
import org.openide.filesystems.FileLock;
import org.openide.util.NbBundle;

public class WriteLock
extends FileLock {
    static final Set allLocks;
    private File lockFile;
    static final /* synthetic */ boolean $assertionsDisabled;

    static WriteLock tryLock(File file) throws IOException {
        return WriteLock.getInstance(file, false);
    }

    static WriteLock tryNioLock(File file) throws IOException {
        return WriteLock.getInstance(file, true);
    }

    static WriteLock tryLightWeightLock(File file) throws IOException {
        return WriteLock.getLightWeightInstance(file);
    }

    private static WriteLock getLightWeightInstance(File file) throws IOException {
        File file2 = WriteLockUtils.getAssociatedLockFile(file);
        boolean bl = allLocks.contains(file2.getAbsolutePath());
        if (bl) {
            throw new FileAlreadyLockedException(NbBundle.getMessage((Class)WriteLock.class, (String)"EXC_FileAlreadyLocked", (Object)file.getAbsolutePath()));
        }
        return new WriteLock(file2);
    }

    private static WriteLock getInstance(File file, boolean bl) throws IOException {
        boolean bl2 = false;
        IOException iOException = null;
        File file2 = WriteLockUtils.getAssociatedLockFile(file);
        if (!file2.exists()) {
            bl2 = true;
        }
        RandomAccessFile randomAccessFile = WriteLock.getAccessToFile(file2);
        if (!$assertionsDisabled && !file2.exists()) {
            throw new AssertionError();
        }
        FileChannel fileChannel = randomAccessFile.getChannel();
        if (fileChannel != null && fileChannel.isOpen()) {
            try {
                String string = WriteLockUtils.getContentOfLckFile(file2, fileChannel);
                if (string == null && (bl2 || file2.length() == 0L)) {
                    if (!$assertionsDisabled && file2.length() != 0L) {
                        throw new AssertionError();
                    }
                    string = WriteLockUtils.writeContentOfLckFile(file2, fileChannel);
                }
                if (string != null && !allLocks.contains(string)) {
                    if (fileChannel != null && fileChannel.isOpen() && !bl) {
                        fileChannel.close();
                    }
                    return bl ? new NioLock(file2, fileChannel, fileChannel.tryLock()) : new WriteLock(file2);
                }
            }
            catch (IOException iOException2) {
                iOException = iOException2;
            }
        }
        if (fileChannel != null && fileChannel.isOpen()) {
            fileChannel.close();
        }
        if (bl2 && file2.exists()) {
            file2.delete();
        }
        if (iOException == null) {
            iOException = file2.exists() ? new FileAlreadyLockedException(NbBundle.getMessage((Class)WriteLock.class, (String)"EXC_FileLockAlreadyExists", (Object)file.getAbsolutePath(), (Object)file2.getAbsolutePath())) : new FileAlreadyLockedException(NbBundle.getMessage((Class)WriteLock.class, (String)"EXC_FileAlreadyLocked", (Object)file.getAbsolutePath()));
        }
        FSException.annotateException(iOException);
        throw iOException;
    }

    private static RandomAccessFile getAccessToFile(File file) throws FileNotFoundException {
        RandomAccessFile randomAccessFile = null;
        try {
            randomAccessFile = new RandomAccessFile(file, "rwd");
        }
        catch (FileNotFoundException fileNotFoundException) {
            FileNotFoundException fileNotFoundException2 = fileNotFoundException;
            if (!file.exists()) {
                fileNotFoundException2 = (FileNotFoundException)new FileNotFoundException(fileNotFoundException.getLocalizedMessage()).initCause(fileNotFoundException);
            } else if (!file.canRead()) {
                fileNotFoundException2 = (FileNotFoundException)new FileNotFoundException(fileNotFoundException.getLocalizedMessage()).initCause(fileNotFoundException);
            } else if (!file.canWrite()) {
                fileNotFoundException2 = (FileNotFoundException)new FileNotFoundException(fileNotFoundException.getLocalizedMessage()).initCause(fileNotFoundException);
            } else if (file.getParentFile() == null) {
                fileNotFoundException2 = (FileNotFoundException)new FileNotFoundException(fileNotFoundException.getLocalizedMessage()).initCause(fileNotFoundException);
            } else if (!file.getParentFile().exists()) {
                fileNotFoundException2 = (FileNotFoundException)new FileNotFoundException(fileNotFoundException.getLocalizedMessage()).initCause(fileNotFoundException);
            }
            throw fileNotFoundException2;
        }
        return randomAccessFile;
    }

    private WriteLock(File file) {
        this.lockFile = file;
        this.register();
    }

    public boolean isValid(File file) {
        boolean bl = this.isValid();
        if (bl) {
            File file2 = WriteLockUtils.getAssociatedLockFile(file);
            bl = this.lockFile.equals(file2);
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseLock() {
        Class clazz = WriteLockFactory.class;
        synchronized (clazz) {
            if (this.isValid()) {
                this.deregister();
                super.releaseLock();
                if (this.getLockFile().exists()) {
                    boolean bl = this.getLockFile().delete();
                }
            }
        }
    }

    private final boolean deregister() {
        return allLocks.remove(this.getLockFile().getAbsolutePath());
    }

    private final boolean register() {
        return allLocks.add(this.getLockFile().getAbsolutePath());
    }

    final File getLockFile() {
        return this.lockFile;
    }

    public final String toString() {
        String string = this.getLockFile().getName();
        String string2 = string.substring(".LCK".length(), string.length() - "~".length());
        return new File(this.getLockFile().getParentFile(), string2).getAbsolutePath();
    }

    static {
        $assertionsDisabled = !WriteLock.class.desiredAssertionStatus();
        allLocks = new HashSet();
        Runtime.getRuntime().addShutdownHook(new Thread(){

            public void run() {
                Iterator iterator = allLocks.iterator();
                while (iterator.hasNext()) {
                    String string = (String)iterator.next();
                    File file = new File(string);
                    if (!file.exists() || !WriteLockUtils.hasActiveLockFileSigns(string)) continue;
                    file.delete();
                }
            }
        });
    }

    private static class NioLock
    extends WriteLock {
        private FileChannel channel;
        private java.nio.channels.FileLock nioLock;
        static final /* synthetic */ boolean $assertionsDisabled;

        NioLock(File file, FileChannel fileChannel, java.nio.channels.FileLock fileLock) {
            super(file);
            if (!$assertionsDisabled && fileLock == null) {
                throw new AssertionError();
            }
            if (!$assertionsDisabled && !fileLock.isValid()) {
                throw new AssertionError();
            }
            if (!$assertionsDisabled && fileChannel == null) {
                throw new AssertionError();
            }
            this.channel = fileChannel;
            this.nioLock = fileLock;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void releaseLock() {
            Class clazz = class$org$netbeans$modules$masterfs$filebasedfs$fileobjects$WriteLockFactory == null ? (class$org$netbeans$modules$masterfs$filebasedfs$fileobjects$WriteLockFactory = WriteLock.class$("org.netbeans.modules.masterfs.filebasedfs.fileobjects.WriteLockFactory")) : class$org$netbeans$modules$masterfs$filebasedfs$fileobjects$WriteLockFactory;
            synchronized (clazz) {
                try {
                    if (this.nioLock.isValid()) {
                        this.nioLock.release();
                    }
                    if (this.channel.isOpen()) {
                        this.channel.close();
                    }
                }
                catch (IOException iOException) {
                    ErrorManager.getDefault().notify((Throwable)iOException);
                }
                super.releaseLock();
            }
        }

        static {
            $assertionsDisabled = !(class$org$netbeans$modules$masterfs$filebasedfs$fileobjects$WriteLock == null ? (class$org$netbeans$modules$masterfs$filebasedfs$fileobjects$WriteLock = WriteLock.class$("org.netbeans.modules.masterfs.filebasedfs.fileobjects.WriteLock")) : class$org$netbeans$modules$masterfs$filebasedfs$fileobjects$WriteLock).desiredAssertionStatus();
        }
    }
}

