/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.masterfs.filebasedfs.fileobjects;

import java.io.File;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import org.netbeans.modules.masterfs.filebasedfs.fileobjects.BaseFileObj;
import org.netbeans.modules.masterfs.filebasedfs.fileobjects.FileObj;
import org.netbeans.modules.masterfs.filebasedfs.fileobjects.FolderObj;
import org.netbeans.modules.masterfs.filebasedfs.fileobjects.RootObj;
import org.netbeans.modules.masterfs.filebasedfs.naming.FileNaming;
import org.netbeans.modules.masterfs.filebasedfs.naming.NamingFactory;
import org.netbeans.modules.masterfs.filebasedfs.utils.FileInfo;
import org.openide.filesystems.FileObject;

public final class FileObjectFactory {
    private final Map allInstances = Collections.synchronizedMap(new WeakHashMap());
    private RootObj root;
    static final /* synthetic */ boolean $assertionsDisabled;

    public static FileObjectFactory getInstance(FileInfo fileInfo) {
        return new FileObjectFactory(fileInfo);
    }

    public final RootObj getRoot() {
        return this.root;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getSize() {
        Map map = this.allInstances;
        synchronized (map) {
            return this.allInstances.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final FileObject findFileObject(FileInfo fileInfo) {
        FileObject fileObject = null;
        File file = fileInfo.getFile();
        Map map = this.allInstances;
        synchronized (map) {
            fileObject = this.get(file);
            if (fileObject == null || !fileObject.isValid()) {
                File file2 = file.getParentFile();
                fileObject = file2 != null ? this.create(fileInfo) : this.getRoot();
            }
            if (!$assertionsDisabled && fileObject != null && !fileObject.isValid()) {
                throw new AssertionError((Object)fileObject.toString());
            }
            return fileObject;
        }
    }

    private BaseFileObj create(FileInfo fileInfo) {
        if (fileInfo.isWindowsFloppy()) {
            return null;
        }
        if (!fileInfo.isConvertibleToFileObject()) {
            return null;
        }
        File file = fileInfo.getFile();
        FileNaming fileNaming = fileInfo.getFileNaming();
        FileNaming fileNaming2 = fileNaming = fileNaming == null ? NamingFactory.fromFile(file) : fileNaming;
        if (fileNaming == null) {
            return null;
        }
        if (fileNaming.isFile()) {
            if (!$assertionsDisabled && (fileNaming.getFile() == null || !fileNaming.getFile().isFile() && fileNaming.getFile().isDirectory())) {
                throw new AssertionError(fileNaming);
            }
            FileObj fileObj = new FileObj(file, fileNaming);
            return this.putInCache(fileObj, fileObj.getFileName().getId());
        }
        if (!fileNaming.isFile() || fileInfo.isUNCFolder()) {
            if (!$assertionsDisabled && (fileNaming.getFile() == null || fileNaming.getFile().isFile() && !fileNaming.getFile().isDirectory())) {
                throw new AssertionError(fileNaming);
            }
            FolderObj folderObj = new FolderObj(file, fileNaming);
            return this.putInCache(folderObj, folderObj.getFileName().getId());
        }
        if (fileInfo.isUnixSpecialFile()) {
            if (!($assertionsDisabled || fileNaming.getFile() != null && fileNaming.getFile().isFile() == fileNaming.getFile().isDirectory())) {
                throw new AssertionError(fileNaming);
            }
            FileObj fileObj = new FileObj(file, fileNaming);
            return this.putInCache(fileObj, fileObj.getFileName().getId());
        }
        if (!$assertionsDisabled) {
            throw new AssertionError();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void refreshAll(boolean bl) {
        Object object;
        HashSet<Object> hashSet = new HashSet<Object>();
        Object object2 = this.allInstances;
        synchronized (object2) {
            object = this.allInstances.values().iterator();
            while (object.hasNext()) {
                Object object3;
                Object object4;
                Object v = object.next();
                if (v instanceof List) {
                    object4 = ((List)v).iterator();
                    while (object4.hasNext()) {
                        object3 = (WeakReference)object4.next();
                        BaseFileObj baseFileObj = object3 != null ? ((Reference)object3).get() : null;
                        if (baseFileObj == null) continue;
                        hashSet.add((Object)baseFileObj);
                    }
                    continue;
                }
                object4 = (WeakReference)v;
                object3 = object4 != null ? ((Reference)object4).get() : null;
                if (object3 == null) continue;
                hashSet.add(object3);
            }
        }
        object2 = hashSet.iterator();
        while (object2.hasNext()) {
            object = (BaseFileObj)((Object)object2.next());
            object.refresh(bl);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void rename() {
        HashMap<Integer, Object> hashMap = new HashMap<Integer, Object>();
        Map map = this.allInstances;
        synchronized (map) {
            Object object;
            Object object2;
            Integer n;
            Object object3;
            Object object4;
            Iterator iterator = this.allInstances.entrySet().iterator();
            while (iterator.hasNext()) {
                Object object5;
                object4 = iterator.next();
                object3 = object4.getValue();
                n = (Integer)object4.getKey();
                if (!(object3 instanceof List)) {
                    object2 = (WeakReference)object3;
                    object = object2 != null ? ((Reference)object2).get() : null;
                    if (object == null || n.equals(object5 = object.getFileName().getId())) continue;
                    hashMap.put(n, object);
                    continue;
                }
                object2 = ((List)object3).iterator();
                while (object2.hasNext()) {
                    Integer n2;
                    object = (WeakReference)object2.next();
                    object5 = object != null ? ((Reference)object).get() : null;
                    if (object5 == null || n.equals(n2 = ((BaseFileObj)((Object)object5)).getFileName().getId())) continue;
                    hashMap.put(n, object);
                }
            }
            object4 = hashMap.entrySet().iterator();
            while (object4.hasNext()) {
                object3 = (Map.Entry)object4.next();
                n = object3.getKey();
                object2 = this.allInstances.remove(n);
                if (object2 instanceof List) {
                    object = (List)object2;
                    object.remove(object3.getValue());
                    this.allInstances.put(n, object2);
                    continue;
                }
                object = (BaseFileObj)((Object)object3.getValue());
                this.putInCache((BaseFileObj)((Object)object), object.getFileName().getId());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final BaseFileObj get(File file) {
        Object var2_5;
        Map map = this.allInstances;
        synchronized (map) {
            Object v = this.allInstances.get(NamingFactory.createID(file));
            Reference reference = null;
            reference = (Reference)(v instanceof Reference ? v : null);
            reference = reference == null && v instanceof List ? FileObjectFactory.getReference((List)v, file) : reference;
            Object v0 = var2_5 = reference != null ? reference.get() : null;
            if (!$assertionsDisabled && var2_5 != null && !(var2_5 instanceof BaseFileObj)) {
                throw new AssertionError();
            }
        }
        return var2_5;
    }

    private static Reference getReference(List list, File file) {
        Reference reference = null;
        for (int i = 0; reference == null && i < list.size(); ++i) {
            BaseFileObj baseFileObj;
            Reference reference2 = (Reference)list.get(i);
            BaseFileObj baseFileObj2 = baseFileObj = reference2 != null ? (BaseFileObj)((Object)reference2.get()) : null;
            if (baseFileObj == null || baseFileObj.getFileName().getFile().compareTo(file) != 0) continue;
            reference = reference2;
        }
        return reference;
    }

    private FileObjectFactory(FileInfo fileInfo) {
        File file = fileInfo.getFile();
        if (!$assertionsDisabled && file.getParentFile() != null) {
            throw new AssertionError();
        }
        BaseFileObj baseFileObj = this.create(fileInfo);
        this.root = new RootObj(baseFileObj);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BaseFileObj putInCache(BaseFileObj baseFileObj, Integer n) {
        Map map = this.allInstances;
        synchronized (map) {
            WeakReference<BaseFileObj> weakReference = new WeakReference<BaseFileObj>(baseFileObj);
            WeakReference<BaseFileObj> weakReference2 = this.allInstances.put(n, weakReference);
            if (weakReference2 != null) {
                if (weakReference2 instanceof List) {
                    ((List)((Object)weakReference2)).add(weakReference);
                    this.allInstances.put(n, weakReference2);
                } else {
                    BaseFileObj baseFileObj2;
                    if (!$assertionsDisabled && !(weakReference2 instanceof WeakReference)) {
                        throw new AssertionError();
                    }
                    Reference reference = weakReference2;
                    BaseFileObj baseFileObj3 = baseFileObj2 = reference != null ? (BaseFileObj)((Object)reference.get()) : null;
                    if (baseFileObj2 != null && !baseFileObj.getFileName().equals(baseFileObj2.getFileName())) {
                        ArrayList<Reference> arrayList = new ArrayList<Reference>();
                        arrayList.add(reference);
                        arrayList.add(weakReference);
                        this.allInstances.put(n, arrayList);
                    }
                }
            }
        }
        return baseFileObj;
    }

    static {
        $assertionsDisabled = !FileObjectFactory.class.desiredAssertionStatus();
    }
}

