/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.masterfs;

import java.awt.Image;
import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.Set;
import org.netbeans.modules.masterfs.MasterFileObject;
import org.netbeans.modules.masterfs.MasterFileSystem;
import org.netbeans.modules.masterfs.ResourcePath;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

public class Utils {
    static String getString(String string) {
        try {
            return NbBundle.getBundle((String)"org.netbeans.modules.masterfs.resources.Bundle", (Locale)Locale.getDefault(), (ClassLoader)MasterFileSystem.class.getClassLoader()).getString(string);
        }
        catch (MissingResourceException missingResourceException) {
            return "";
        }
    }

    static String formatString(String string, Object[] objectArray) {
        String string2 = Utils.getString(string);
        if (objectArray == null) {
            return string2;
        }
        return MessageFormat.format(string2, objectArray);
    }

    static void throwIOException(String string, Object[] objectArray) throws IOException {
        Utils.throwIOException(new IOException(Utils.formatString(string, objectArray)));
    }

    static void throwIOException(IOException iOException) throws IOException {
        ErrorManager.getDefault().annotate((Throwable)iOException, 16, null, iOException.getLocalizedMessage(), null, null);
        throw iOException;
    }

    static Image getRootIcon(int n, Object object) {
        try {
            BeanInfo beanInfo = Utilities.getBeanInfo(object.getClass());
            Image image = beanInfo.getIcon(n);
            return image;
        }
        catch (IntrospectionException introspectionException) {
            return null;
        }
    }

    static Set transformSet(Set set) {
        HashSet<FileObject> hashSet = new HashSet<FileObject>();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            MasterFileObject masterFileObject = (MasterFileObject)((Object)iterator.next());
            FileObject fileObject = masterFileObject.getDelegate().get(true);
            if (fileObject == null) continue;
            hashSet.add(fileObject);
        }
        return hashSet;
    }

    static ResourcePath getResource(File file) {
        String string;
        try {
            string = file.getCanonicalPath();
        }
        catch (IOException iOException) {
            string = file.getAbsolutePath();
        }
        return new ResourcePath(string);
    }

    static Set transformToDelegates(Set set, boolean bl) {
        HashSet<FileObject> hashSet = new HashSet<FileObject>();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            FileObject fileObject;
            MasterFileObject masterFileObject;
            Object e = iterator.next();
            if (!(e instanceof MasterFileObject)) continue;
            if (bl) {
                masterFileObject = (MasterFileObject)((Object)e);
                fileObject = masterFileObject.getDelegate().getPrefered();
            } else {
                masterFileObject = (MasterFileObject)((Object)e);
                fileObject = masterFileObject.getDelegate().get();
            }
            if (fileObject == null) continue;
            hashSet.add(fileObject);
        }
        return hashSet;
    }
}

