/*
 * Decompiled with CFR 0.152.
 */
package tr.view.criteria;

import java.awt.BorderLayout;
import java.io.Serializable;
import java.util.logging.Logger;
import org.openide.ErrorManager;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.NbBundle;
import org.openide.util.lookup.Lookups;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;
import tr.model.Data;
import tr.model.DataLookup;
import tr.view.Window;
import tr.view.criteria.CriteriaPanel;
import tr.view.criteria.Resources;

public final class CriteriaTopComponent
extends Window {
    public static final String PREFERRED_ID = "CriteriaTopComponent";
    private static final Logger LOG = Logger.getLogger("tr.view.criteria");
    private static CriteriaTopComponent instance;
    private transient Lookup lookup;
    private transient Lookup.Result result;
    private transient CriteriaPanel panel;

    private CriteriaTopComponent() {
        this.setName(NbBundle.getMessage(CriteriaTopComponent.class, (String)"CTL_CriteriaTopComponent"));
        this.setToolTipText(NbBundle.getMessage(CriteriaTopComponent.class, (String)"HINT_CriteriaTopComponent"));
        this.setIcon(Resources.ICON_CRITERIA.getImage());
        this.initComponents();
    }

    private void initComponents() {
        this.setLayout(new BorderLayout());
    }

    public static synchronized CriteriaTopComponent getDefault() {
        if (instance == null) {
            instance = new CriteriaTopComponent();
        }
        return instance;
    }

    public static synchronized CriteriaTopComponent findInstance() {
        TopComponent win = WindowManager.getDefault().findTopComponent(PREFERRED_ID);
        if (win == null) {
            ErrorManager.getDefault().log(16, "Cannot find Criteria component. It will not be located properly in the window system.");
            return CriteriaTopComponent.getDefault();
        }
        if (win instanceof CriteriaTopComponent) {
            return (CriteriaTopComponent)win;
        }
        ErrorManager.getDefault().log(16, "There seem to be multiple components with the 'CriteriaTopComponent' ID. That is a potential source of errors and unexpected behavior.");
        return CriteriaTopComponent.getDefault();
    }

    public int getPersistenceType() {
        return 0;
    }

    public void componentOpened() {
        LOG.fine("Opened");
        if (this.panel == null) {
            this.removeAll();
            this.panel = new CriteriaPanel();
            this.add(this.panel, "Center");
            super.revalidate();
            super.repaint();
        }
        if (this.result == null) {
            this.result = DataLookup.instance().lookup(new Lookup.Template(Data.class));
            this.result.addLookupListener(new LookupListener(){

                public void resultChanged(LookupEvent lookupEvent) {
                    LOG.fine("LookupListener for DataLookup - data has changed.");
                    CriteriaTopComponent.this.removeAll();
                    CriteriaTopComponent.this.panel = null;
                }
            });
        }
    }

    public void componentClosed() {
        LOG.fine("Closed");
    }

    public Object writeReplace() {
        return new ResolvableHelper();
    }

    public String preferredID() {
        return PREFERRED_ID;
    }

    public void refresh() {
    }

    public Lookup getLookup() {
        if (this.panel == null) {
            return super.getLookup();
        }
        if (this.lookup == null) {
            this.lookup = Lookups.singleton((Object)this.panel);
        }
        return this.lookup;
    }

    public void deactivate() {
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx("tr.view.criteria");
    }

    static final class ResolvableHelper
    implements Serializable {
        private static final long serialVersionUID = 1L;

        ResolvableHelper() {
        }

        public Object readResolve() {
            return CriteriaTopComponent.getDefault();
        }
    }
}

