/*
 * Decompiled with CFR 0.152.
 */
package tr.view.criteria;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import javax.swing.table.DefaultTableModel;
import org.jdesktop.layout.GroupLayout;
import org.jdesktop.swingx.JXTable;
import org.openide.awt.Mnemonics;
import tr.model.Data;
import tr.model.DataLookup;
import tr.model.IDGenerator;
import tr.model.criteria.Criterion;
import tr.view.criteria.CriterionTableModel;
import tr.view.criteria.Resources;

final class CriteriaPanel
extends JPanel {
    private final Data data = (Data)DataLookup.instance().lookup(Data.class);
    private final Map<String, CriterionTableModel> map = new HashMap<String, CriterionTableModel>();
    private JButton addButton;
    private JComboBox criteriaCombo;
    private JLabel criteriaLabel;
    private JButton delButton;
    private JButton downButton;
    private JPanel mainPanel;
    private JTable table;
    private JScrollPane tableScrollPane;
    private JToolBar toolbar;
    private JButton upButton;
    private JCheckBox useCheckBox;

    public CriteriaPanel() {
        this.initComponents();
        this.criteriaComboActionPerformed(null);
    }

    private void initComponents() {
        this.criteriaCombo = new JComboBox();
        this.criteriaLabel = new JLabel();
        this.mainPanel = new JPanel();
        this.useCheckBox = new JCheckBox();
        this.tableScrollPane = new JScrollPane();
        this.table = this.getTable();
        this.toolbar = new JToolBar();
        this.addButton = new JButton();
        this.delButton = new JButton();
        this.downButton = new JButton();
        this.upButton = new JButton();
        this.criteriaCombo.setModel(this.getCriteraComboBoxModel());
        this.criteriaCombo.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                CriteriaPanel.this.criteriaComboActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((JLabel)this.criteriaLabel, (String)"Criterion");
        this.mainPanel.setBorder(BorderFactory.createEtchedBorder());
        Mnemonics.setLocalizedText((AbstractButton)this.useCheckBox, (String)"Use this criterion");
        this.useCheckBox.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.useCheckBox.setMargin(new Insets(0, 0, 0, 0));
        this.useCheckBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                CriteriaPanel.this.useActionPerformed(evt);
            }
        });
        this.table.setModel(new DefaultTableModel(new Object[0][], new String[]{"Values"}){
            Class[] types;
            {
                this.types = new Class[]{String.class};
            }

            public Class getColumnClass(int columnIndex) {
                return this.types[columnIndex];
            }
        });
        this.tableScrollPane.setViewportView(this.table);
        this.toolbar.setFloatable(false);
        this.toolbar.setOrientation(1);
        this.toolbar.setMargin(new Insets(2, 2, 2, 2));
        this.addButton.setIcon(Resources.ICON_PLUS);
        this.addButton.setHorizontalTextPosition(0);
        this.addButton.setMaximumSize(new Dimension(24, 24));
        this.addButton.setMinimumSize(new Dimension(24, 24));
        this.addButton.setPreferredSize(new Dimension(24, 24));
        this.addButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                CriteriaPanel.this.addActionPerformed(evt);
            }
        });
        this.toolbar.add(this.addButton);
        this.delButton.setIcon(Resources.ICON_MINUS);
        this.delButton.setHorizontalTextPosition(0);
        this.delButton.setMaximumSize(new Dimension(24, 24));
        this.delButton.setMinimumSize(new Dimension(24, 24));
        this.delButton.setPreferredSize(new Dimension(24, 24));
        this.delButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                CriteriaPanel.this.removeActionPerformed(evt);
            }
        });
        this.toolbar.add(this.delButton);
        this.downButton.setIcon(Resources.ICON_DOWN);
        this.downButton.setHorizontalTextPosition(0);
        this.downButton.setMaximumSize(new Dimension(24, 24));
        this.downButton.setMinimumSize(new Dimension(24, 24));
        this.downButton.setPreferredSize(new Dimension(24, 24));
        this.downButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                CriteriaPanel.this.downActionPerformed(evt);
            }
        });
        this.toolbar.add(this.downButton);
        this.upButton.setIcon(Resources.ICON_UP);
        this.upButton.setHorizontalTextPosition(0);
        this.upButton.setMaximumSize(new Dimension(24, 24));
        this.upButton.setMinimumSize(new Dimension(24, 24));
        this.upButton.setPreferredSize(new Dimension(24, 24));
        this.upButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                CriteriaPanel.this.upActionPerformed(evt);
            }
        });
        this.toolbar.add(this.upButton);
        GroupLayout mainPanelLayout = new GroupLayout((Container)this.mainPanel);
        this.mainPanel.setLayout((LayoutManager)mainPanelLayout);
        mainPanelLayout.setHorizontalGroup((GroupLayout.Group)mainPanelLayout.createParallelGroup(1).add((GroupLayout.Group)mainPanelLayout.createSequentialGroup().add((GroupLayout.Group)mainPanelLayout.createParallelGroup(1).add((GroupLayout.Group)mainPanelLayout.createSequentialGroup().add(9, 9, 9).add((Component)this.toolbar, -2, -1, -2).add(1, 1, 1).add((Component)this.tableScrollPane, -1, 216, Short.MAX_VALUE)).add((GroupLayout.Group)mainPanelLayout.createSequentialGroup().addContainerGap().add((Component)this.useCheckBox))).addContainerGap()));
        mainPanelLayout.setVerticalGroup((GroupLayout.Group)mainPanelLayout.createParallelGroup(1).add((GroupLayout.Group)mainPanelLayout.createSequentialGroup().addContainerGap().add((Component)this.useCheckBox).add((GroupLayout.Group)mainPanelLayout.createParallelGroup(1).add((GroupLayout.Group)mainPanelLayout.createSequentialGroup().add(12, 12, 12).add((Component)this.tableScrollPane, -1, 130, Short.MAX_VALUE)).add((GroupLayout.Group)mainPanelLayout.createSequentialGroup().add(30, 30, 30).add((Component)this.toolbar, -2, 112, -2))).addContainerGap()));
        GroupLayout layout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(2).add(1, (Component)this.mainPanel, -1, -1, Short.MAX_VALUE).add(1, (GroupLayout.Group)layout.createSequentialGroup().add((Component)this.criteriaLabel, -2, 67, -2).addPreferredGap(0).add((Component)this.criteriaCombo, -2, 210, -2))).addContainerGap()));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.criteriaLabel).add((Component)this.criteriaCombo, -2, -1, -2)).addPreferredGap(0).add((Component)this.mainPanel, -1, -1, Short.MAX_VALUE).addContainerGap()));
    }

    private JTable getTable() {
        JXTable jxtable = new JXTable();
        jxtable.setColumnControlVisible(false);
        jxtable.setSortable(false);
        jxtable.setShowGrid(false);
        jxtable.setColumnSelectionAllowed(false);
        jxtable.setCellSelectionEnabled(false);
        jxtable.setRowSelectionAllowed(true);
        jxtable.setSelectionMode(0);
        return jxtable;
    }

    private void useActionPerformed(ActionEvent evt) {
        Criterion criterion = (Criterion)this.criteriaCombo.getSelectedItem();
        if (criterion == null) {
            return;
        }
        criterion.setUse(this.useCheckBox.isSelected());
    }

    private void downActionPerformed(ActionEvent evt) {
        int row = this.table.getSelectedRow();
        if (row == -1) {
            return;
        }
        CriterionTableModel tm = (CriterionTableModel)this.table.getModel();
        if (tm == null) {
            return;
        }
        this.table.requestFocusInWindow();
        if (tm.moveDown(row)) {
            this.selectTableRow(row + 1);
        }
    }

    private void upActionPerformed(ActionEvent evt) {
        int row = this.table.getSelectedRow();
        if (row == -1) {
            return;
        }
        CriterionTableModel tm = (CriterionTableModel)this.table.getModel();
        if (tm == null) {
            return;
        }
        this.table.requestFocusInWindow();
        if (tm.moveUp(row)) {
            this.selectTableRow(row - 1);
        }
    }

    private void removeActionPerformed(ActionEvent evt) {
        int row = this.table.getSelectedRow();
        if (row == -1) {
            return;
        }
        CriterionTableModel tm = (CriterionTableModel)this.table.getModel();
        if (tm == null) {
            return;
        }
        if (tm.removeRow(row)) {
            if (row < this.table.getRowCount()) {
                this.selectTableRow(row);
            } else if (row > 0) {
                this.selectTableRow(row - 1);
            }
        }
    }

    private void addActionPerformed(ActionEvent evt) {
        CriterionTableModel tm = (CriterionTableModel)this.table.getModel();
        if (tm == null) {
            return;
        }
        if (tm.addRow()) {
            int row = this.table.getRowCount() - 1;
            this.table.changeSelection(row, 0, false, false);
            this.table.requestFocus();
            this.table.editCellAt(row, 0);
        }
    }

    private void selectTableRow(final int row) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                CriteriaPanel.this.table.requestFocusInWindow();
                CriteriaPanel.this.table.changeSelection(row, 0, false, false);
            }
        });
    }

    private void criteriaComboActionPerformed(ActionEvent evt) {
        Criterion criterion = (Criterion)this.criteriaCombo.getSelectedItem();
        if (criterion == null) {
            this.table.setModel(null);
            return;
        }
        CriterionTableModel ctm = this.map.get(criterion.name);
        if (ctm == null) {
            ctm = new CriterionTableModel(criterion, (IDGenerator)this.data);
            this.map.put(criterion.name, ctm);
        }
        this.table.setModel(ctm);
        this.useCheckBox.setSelected(criterion.use);
    }

    private ComboBoxModel getCriteraComboBoxModel() {
        Data data = (Data)DataLookup.instance().lookup(Data.class);
        if (data == null) {
            return new DefaultComboBoxModel();
        }
        Vector<Criterion> criteria = new Vector<Criterion>();
        criteria.add(data.getTimeCriterion());
        criteria.add(data.getEnergyCriterion());
        criteria.add(data.getPriorityCriterion());
        return new DefaultComboBoxModel(criteria);
    }
}

