/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.windows.view.ui.toolbars;

import java.awt.Dimension;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Iterator;
import java.util.Vector;
import org.netbeans.core.windows.view.ui.toolbars.ToolbarConfiguration;
import org.netbeans.core.windows.view.ui.toolbars.ToolbarConstraints;
import org.openide.awt.Toolbar;
import org.openide.awt.ToolbarPool;

public class ToolbarRow {
    ToolbarConfiguration toolbarConfig;
    ToolbarRow prevRow;
    ToolbarRow nextRow;
    private Vector toolbars;
    private PropertyChangeListener constraintsL;
    private int prefHeight;

    ToolbarRow(ToolbarConfiguration toolbarConfiguration) {
        this.toolbarConfig = toolbarConfiguration;
        this.toolbars = new Vector();
        this.nextRow = null;
        this.prevRow = null;
        this.constraintsL = new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if ("preferredSize".equals(propertyChangeEvent.getPropertyName())) {
                    Dimension dimension = (Dimension)propertyChangeEvent.getOldValue();
                    Dimension dimension2 = (Dimension)propertyChangeEvent.getNewValue();
                    if (dimension.height != dimension2.height) {
                        ToolbarRow.this.updateRowsBelow();
                    }
                }
            }
        };
    }

    void addToolbar(ToolbarConstraints toolbarConstraints) {
        this.addToolbar2(toolbarConstraints, this.toolbars.size());
    }

    void addToolbar(ToolbarConstraints toolbarConstraints, int n) {
        int n2 = toolbarConstraints.checkInitialIndexInRow();
        if (n2 >= 0) {
            n2 = Math.min(n2, this.toolbars.size());
        } else {
            ToolbarConstraints toolbarConstraints2;
            n2 = 0;
            Iterator iterator = this.toolbars.iterator();
            while (iterator.hasNext() && n > (toolbarConstraints2 = (ToolbarConstraints)iterator.next()).getPosition()) {
                ++n2;
            }
        }
        this.addToolbar2(toolbarConstraints, n2);
    }

    private void addToolbar2(ToolbarConstraints toolbarConstraints, int n) {
        if (this.toolbars.contains(toolbarConstraints)) {
            return;
        }
        ToolbarConstraints toolbarConstraints2 = null;
        ToolbarConstraints toolbarConstraints3 = null;
        if (n != 0) {
            toolbarConstraints2 = (ToolbarConstraints)this.toolbars.elementAt(n - 1);
            toolbarConstraints2.addNextBar(toolbarConstraints);
            toolbarConstraints.addPrevBar(toolbarConstraints2);
        }
        if (n < this.toolbars.size()) {
            toolbarConstraints3 = (ToolbarConstraints)this.toolbars.elementAt(n);
            toolbarConstraints.addNextBar(toolbarConstraints3);
            toolbarConstraints3.addPrevBar(toolbarConstraints);
        }
        if (toolbarConstraints2 != null && toolbarConstraints3 != null) {
            toolbarConstraints2.removeNextBar(toolbarConstraints3);
            toolbarConstraints3.removePrevBar(toolbarConstraints2);
        }
        int n2 = this.getPreferredHeight();
        toolbarConstraints.addOwnRow(this);
        this.toolbars.insertElementAt(toolbarConstraints, n);
        toolbarConstraints.updatePosition();
        toolbarConstraints.addPropertyChangeListener(this.constraintsL);
    }

    void removeToolbar(ToolbarConstraints toolbarConstraints) {
        int n = this.toolbars.indexOf(toolbarConstraints);
        ToolbarConstraints toolbarConstraints2 = null;
        ToolbarConstraints toolbarConstraints3 = null;
        try {
            toolbarConstraints2 = (ToolbarConstraints)this.toolbars.elementAt(n - 1);
            toolbarConstraints2.removeNextBar(toolbarConstraints);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            // empty catch block
        }
        try {
            toolbarConstraints3 = (ToolbarConstraints)this.toolbars.elementAt(n + 1);
            toolbarConstraints3.removePrevBar(toolbarConstraints);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            // empty catch block
        }
        if (toolbarConstraints2 != null && toolbarConstraints3 != null) {
            toolbarConstraints2.addNextBar(toolbarConstraints3);
            toolbarConstraints3.addPrevBar(toolbarConstraints2);
        }
        this.toolbars.removeElement(toolbarConstraints);
        if (toolbarConstraints2 != null) {
            toolbarConstraints2.updatePosition();
        } else if (toolbarConstraints3 != null) {
            toolbarConstraints3.updatePosition();
        }
        toolbarConstraints.removePropertyChangeListener(this.constraintsL);
    }

    Iterator iterator() {
        return this.toolbars.iterator();
    }

    void setPrevRow(ToolbarRow toolbarRow) {
        this.prevRow = toolbarRow;
    }

    ToolbarRow getPrevRow() {
        return this.prevRow;
    }

    void setNextRow(ToolbarRow toolbarRow) {
        this.nextRow = toolbarRow;
    }

    ToolbarRow getNextRow() {
        return this.nextRow;
    }

    int getPrefWidth() {
        if (this.toolbars.isEmpty()) {
            return -1;
        }
        return ((ToolbarConstraints)this.toolbars.lastElement()).getPrefWidth();
    }

    boolean isEmpty() {
        return this.toolbars.isEmpty();
    }

    int toolbarCount() {
        return this.toolbars.size();
    }

    void updateBounds() {
        Iterator iterator = this.toolbars.iterator();
        while (iterator.hasNext()) {
            ToolbarConstraints toolbarConstraints = (ToolbarConstraints)iterator.next();
            toolbarConstraints.updateBounds();
        }
    }

    private void updateRowsBelow() {
        for (int i = this.toolbarConfig.rowIndex(this) + 1; i < this.toolbarConfig.getRowCount(); ++i) {
            this.toolbarConfig.getRow(i).updateBounds();
        }
    }

    void switchBars(ToolbarConstraints toolbarConstraints, ToolbarConstraints toolbarConstraints2) {
        int n = this.toolbars.indexOf(toolbarConstraints);
        int n2 = this.toolbars.indexOf(toolbarConstraints2);
        ToolbarConstraints toolbarConstraints3 = null;
        ToolbarConstraints toolbarConstraints4 = null;
        try {
            toolbarConstraints3 = (ToolbarConstraints)this.toolbars.elementAt(n - 1);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            // empty catch block
        }
        try {
            toolbarConstraints4 = (ToolbarConstraints)this.toolbars.elementAt(n2 + 1);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            // empty catch block
        }
        if (toolbarConstraints3 != null) {
            toolbarConstraints3.removeNextBar(toolbarConstraints);
        }
        toolbarConstraints.removePrevBar(toolbarConstraints3);
        toolbarConstraints.removeNextBar(toolbarConstraints2);
        toolbarConstraints2.removePrevBar(toolbarConstraints);
        toolbarConstraints2.removeNextBar(toolbarConstraints4);
        if (toolbarConstraints4 != null) {
            toolbarConstraints4.removePrevBar(toolbarConstraints2);
        }
        if (toolbarConstraints3 != null) {
            toolbarConstraints3.addNextBar(toolbarConstraints2);
        }
        toolbarConstraints.addPrevBar(toolbarConstraints2);
        toolbarConstraints.addNextBar(toolbarConstraints4);
        toolbarConstraints2.addPrevBar(toolbarConstraints3);
        toolbarConstraints2.addNextBar(toolbarConstraints);
        if (toolbarConstraints4 != null) {
            toolbarConstraints4.addPrevBar(toolbarConstraints);
        }
        this.toolbars.setElementAt(toolbarConstraints, n2);
        this.toolbars.setElementAt(toolbarConstraints2, n);
    }

    void trySwitchLeft(ToolbarConstraints toolbarConstraints) {
        int n = this.toolbars.indexOf(toolbarConstraints);
        if (n == 0) {
            return;
        }
        try {
            ToolbarConstraints toolbarConstraints2 = (ToolbarConstraints)this.toolbars.elementAt(n - 1);
            if (ToolbarConstraints.canSwitchLeft(toolbarConstraints.getPosition(), toolbarConstraints.getWidth(), toolbarConstraints2.getPosition(), toolbarConstraints2.getWidth())) {
                this.switchBars(toolbarConstraints2, toolbarConstraints);
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            // empty catch block
        }
    }

    void trySwitchRight(ToolbarConstraints toolbarConstraints) {
        int n = this.toolbars.indexOf(toolbarConstraints);
        try {
            ToolbarConstraints toolbarConstraints2 = (ToolbarConstraints)this.toolbars.elementAt(n + 1);
            if (ToolbarConstraints.canSwitchRight(toolbarConstraints.getPosition(), toolbarConstraints.getWidth(), toolbarConstraints2.getPosition(), toolbarConstraints2.getWidth())) {
                this.switchBars(toolbarConstraints, toolbarConstraints2);
                toolbarConstraints2.setPosition(toolbarConstraints.getPosition() - toolbarConstraints2.getWidth() - 1);
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            // empty catch block
        }
    }

    int getPreferredHeight() {
        ToolbarConstraints toolbarConstraints = null;
        ToolbarPool toolbarPool = ToolbarPool.getDefault();
        this.prefHeight = 0;
        int n = 0;
        Iterator iterator = this.toolbars.iterator();
        while (iterator.hasNext()) {
            Toolbar toolbar;
            toolbarConstraints = (ToolbarConstraints)iterator.next();
            if (toolbarConstraints.getRowCount() != 1 || (toolbar = toolbarPool.findToolbar(toolbarConstraints.getName())) == null || this.prefHeight >= (n = toolbar.getPreferredSize().height)) continue;
            this.prefHeight = n;
        }
        this.prefHeight = this.prefHeight <= 0 ? Toolbar.getBasicHeight() : Math.min(Toolbar.getBasicHeight(), this.prefHeight);
        return this.prefHeight;
    }

    static class WritableToolbarRow {
        Vector toolbars = new Vector();

        public WritableToolbarRow() {
        }

        public WritableToolbarRow(ToolbarRow toolbarRow) {
            this();
            this.initToolbars(toolbarRow);
        }

        void initToolbars(ToolbarRow toolbarRow) {
            Iterator iterator = toolbarRow.toolbars.iterator();
            while (iterator.hasNext()) {
                this.toolbars.addElement(new ToolbarConstraints.WritableToolbar((ToolbarConstraints)iterator.next()));
            }
        }

        void addToolbar(ToolbarConstraints toolbarConstraints) {
            int n = 0;
            Iterator iterator = this.toolbars.iterator();
            while (iterator.hasNext()) {
                ToolbarConstraints.WritableToolbar writableToolbar = (ToolbarConstraints.WritableToolbar)iterator.next();
                if (toolbarConstraints.getPosition() < writableToolbar.position) break;
                ++n;
            }
            this.toolbars.insertElementAt(new ToolbarConstraints.WritableToolbar(toolbarConstraints), n);
        }

        boolean isEmpty() {
            return this.toolbars.isEmpty();
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("  <").append("Row").append(">\n");
            Iterator iterator = this.toolbars.iterator();
            while (iterator.hasNext()) {
                stringBuffer.append(iterator.next().toString());
            }
            stringBuffer.append("  </").append("Row").append(">\n");
            return stringBuffer.toString();
        }
    }
}

