/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.windows.view.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.io.IOException;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import org.netbeans.core.windows.ModeImpl;
import org.netbeans.core.windows.WindowManagerImpl;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.cookies.SaveCookie;
import org.openide.explorer.ExplorerManager;
import org.openide.explorer.view.ListView;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;
import org.openide.util.WeakListeners;
import org.openide.windows.TopComponent;

public class DocumentsDlg
extends JPanel
implements PropertyChangeListener,
ExplorerManager.Provider {
    private static DocumentsDlg defaultInstance;
    private final ExplorerManager explorer = new ExplorerManager();
    private JButton closeButton;
    private JTextArea descriptionArea;
    private JLabel descriptionLabel;
    private JLabel explorerLabel;
    private JPanel explorerPanel;
    private JButton jButtonActivate;
    private JButton jButtonClose;
    private JButton jButtonSave;
    private JScrollPane jScrollPane1;
    private ListView listView;
    private static final Collator COLLATOR;
    static /* synthetic */ Class class$org$openide$cookies$SaveCookie;

    private DocumentsDlg() {
        this.initComponents();
        this.jButtonActivate.setText(NbBundle.getMessage((Class)DocumentsDlg.class, (String)"LBL_Activate"));
        this.jButtonClose.setText(NbBundle.getMessage((Class)DocumentsDlg.class, (String)"LBL_CloseDocuments"));
        this.jButtonSave.setText(NbBundle.getMessage((Class)DocumentsDlg.class, (String)"LBL_SaveDocuments"));
        this.explorerLabel.setText(NbBundle.getMessage((Class)DocumentsDlg.class, (String)"LBL_Documents"));
        this.descriptionLabel.setText(NbBundle.getMessage((Class)DocumentsDlg.class, (String)"LBL_Description"));
        this.closeButton.setText(NbBundle.getMessage((Class)DocumentsDlg.class, (String)"LBL_Close"));
        this.jButtonActivate.setMnemonic(NbBundle.getMessage((Class)DocumentsDlg.class, (String)"LBL_Activate_Mnemonic").charAt(0));
        this.jButtonClose.setMnemonic(NbBundle.getMessage((Class)DocumentsDlg.class, (String)"LBL_CloseDocuments_Mnemonic").charAt(0));
        this.jButtonSave.setMnemonic(NbBundle.getMessage((Class)DocumentsDlg.class, (String)"LBL_SaveDocuments_Mnemonic").charAt(0));
        this.explorerLabel.setDisplayedMnemonic(NbBundle.getMessage((Class)DocumentsDlg.class, (String)"LBL_Documents_Mnemonic").charAt(0));
        this.descriptionLabel.setDisplayedMnemonic(NbBundle.getMessage((Class)DocumentsDlg.class, (String)"LBL_Description_Mnemonic").charAt(0));
        this.closeButton.setMnemonic(NbBundle.getMessage((Class)DocumentsDlg.class, (String)"LBL_Close_Mnemonic").charAt(0));
        this.explorerLabel.setLabelFor((Component)this.listView);
        this.descriptionLabel.setLabelFor(this.descriptionArea);
        this.jButtonActivate.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage((Class)DocumentsDlg.class, (String)"ACSD_Activate"));
        this.jButtonClose.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage((Class)DocumentsDlg.class, (String)"ACSD_CloseDocuments"));
        this.jButtonSave.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage((Class)DocumentsDlg.class, (String)"ACSD_SaveDocuments"));
        this.closeButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage((Class)DocumentsDlg.class, (String)"ACSD_Close"));
        this.descriptionArea.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage((Class)DocumentsDlg.class, (String)"ACSD_DescriptionArea"));
    }

    private static DocumentsDlg getDefault() {
        if (defaultInstance == null) {
            defaultInstance = new DocumentsDlg();
        }
        return defaultInstance;
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(DocumentsDlg.class);
    }

    private void initComponents() {
        this.explorerLabel = new JLabel();
        this.descriptionLabel = new JLabel();
        this.explorerPanel = this.createListView();
        this.jScrollPane1 = new JScrollPane();
        this.descriptionArea = new JTextArea();
        this.jButtonActivate = new JButton();
        this.jButtonClose = new JButton();
        this.jButtonSave = new JButton();
        this.closeButton = new JButton();
        this.setLayout(new GridBagLayout());
        this.setBorder(BorderFactory.createEmptyBorder(12, 12, 0, 11));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 16;
        gridBagConstraints.insets = new Insets(0, 0, 2, 0);
        this.add((Component)this.explorerLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.anchor = 16;
        gridBagConstraints.insets = new Insets(0, 0, 2, 0);
        this.add((Component)this.descriptionLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridheight = 4;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 11, 11);
        this.add((Component)this.explorerPanel, gridBagConstraints);
        this.jScrollPane1.setPreferredSize(new Dimension(3, 60));
        this.descriptionArea.setEditable(false);
        this.jScrollPane1.setViewportView(this.descriptionArea);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.gridheight = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 15;
        gridBagConstraints.insets = new Insets(0, 0, 11, 11);
        this.add((Component)this.jScrollPane1, gridBagConstraints);
        this.jButtonActivate.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                DocumentsDlg.this.activate(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.insets = new Insets(0, 0, 5, 0);
        this.add((Component)this.jButtonActivate, gridBagConstraints);
        this.jButtonClose.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                DocumentsDlg.this.closeDocuments(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.insets = new Insets(0, 0, 5, 0);
        this.add((Component)this.jButtonClose, gridBagConstraints);
        this.jButtonSave.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                DocumentsDlg.this.saveDocuments(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 11, 0);
        this.add((Component)this.jButtonSave, gridBagConstraints);
        this.closeButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                DocumentsDlg.this.closeButtonActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 15;
        gridBagConstraints.weighty = 0.1;
        gridBagConstraints.insets = new Insets(0, 0, 11, 0);
        this.add((Component)this.closeButton, gridBagConstraints);
    }

    private void closeButtonActionPerformed(ActionEvent actionEvent) {
        this.closeDialog();
    }

    private void saveDocuments(ActionEvent actionEvent) {
        Node[] nodeArray = this.explorer.getSelectedNodes();
        if (nodeArray.length == 0) {
            return;
        }
        for (int i = 0; i < nodeArray.length; ++i) {
            TopComponent topComponent = ((TopComponentNode)nodeArray[i]).getTopComponent();
            Lookup lookup = topComponent.getLookup();
            SaveCookie saveCookie = (SaveCookie)lookup.lookup(class$org$openide$cookies$SaveCookie == null ? DocumentsDlg.class$("org.openide.cookies.SaveCookie") : class$org$openide$cookies$SaveCookie);
            if (saveCookie == null) continue;
            try {
                saveCookie.save();
            }
            catch (IOException iOException) {
                ErrorManager errorManager = ErrorManager.getDefault();
                errorManager.log(16, "[WinSys.DocumentsDlg.saveDocuments] Warning: Cannot save content of TopComponent: [" + WindowManagerImpl.getInstance().getTopComponentDisplayName(topComponent) + "]" + " [" + topComponent.getClass().getName() + "]");
                errorManager.notify(1, (Throwable)iOException);
            }
            ((TopComponentNode)nodeArray[i]).refresh();
        }
        this.jButtonSave.setEnabled(false);
    }

    private void closeDocuments(ActionEvent actionEvent) {
        TopComponent topComponent;
        Object object;
        Node[] nodeArray = this.explorer.getSelectedNodes();
        if (nodeArray.length == 0) {
            return;
        }
        for (int i = 0; i < nodeArray.length; ++i) {
            object = ((TopComponentNode)nodeArray[i]).getTopComponent();
            object.close();
        }
        List list = DocumentsDlg.getOpenedDocuments();
        object = new ArrayList(list.size());
        for (int i = 0; i < list.size(); ++i) {
            topComponent = (TopComponent)list.get(i);
            object.add(new TopComponentNode(topComponent));
        }
        if (list.isEmpty()) {
            this.closeDialog();
        } else {
            Collections.sort(object);
            Children.Array array = new Children.Array();
            array.add((Node[])object.toArray(new TopComponentNode[0]));
            topComponent = new AbstractNode((Children)array);
            this.explorer.setRootContext((Node)topComponent);
            try {
                this.explorer.setSelectedNodes(new Node[]{topComponent.getChildren().getNodes()[0]});
            }
            catch (PropertyVetoException propertyVetoException) {
                // empty catch block
            }
            this.listView.requestFocusInWindow();
        }
    }

    private void activate(ActionEvent actionEvent) {
        Node[] nodeArray = this.explorer.getSelectedNodes();
        if (nodeArray.length == 0) {
            return;
        }
        this.closeDialog();
        final TopComponent topComponent = ((TopComponentNode)nodeArray[0]).getTopComponent();
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                WindowManagerImpl windowManagerImpl = WindowManagerImpl.getInstance();
                ModeImpl modeImpl = (ModeImpl)windowManagerImpl.findMode(topComponent);
                if (modeImpl != null && modeImpl != windowManagerImpl.getMaximizedMode()) {
                    windowManagerImpl.setMaximizedMode(null);
                }
                topComponent.requestActive();
            }
        });
    }

    private void closeDialog() {
        Window window = SwingUtilities.getWindowAncestor(this);
        window.hide();
        window.dispose();
    }

    public void addNotify() {
        this.explorer.addPropertyChangeListener((PropertyChangeListener)this);
        this.jButtonActivate.setEnabled(false);
        this.jButtonClose.setEnabled(false);
        this.jButtonSave.setEnabled(false);
        super.addNotify();
    }

    public void removeNotify() {
        super.removeNotify();
        this.explorer.removePropertyChangeListener((PropertyChangeListener)this);
    }

    public static void showDocumentsDialog() {
        DocumentsDlg documentsDlg = DocumentsDlg.getDefault();
        DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)documentsDlg, NbBundle.getMessage((Class)DocumentsDlg.class, (String)"CTL_DocumentsTitle"), true, new Object[0], (Object)DocumentsDlg.getDefault().jButtonActivate, 0, null, null);
        Dialog dialog = DialogDisplayer.getDefault().createDialog(dialogDescriptor);
        dialog.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage((Class)DocumentsDlg.class, (String)"ACSD_DocumentsDialog"));
        DocumentsDlg.getDefault().updateNodes();
        dialog.setVisible(true);
        DocumentsDlg.getDefault().clearNodes();
    }

    private JPanel createListView() {
        JPanel jPanel = new JPanel();
        jPanel.setPreferredSize(new Dimension(375, 232));
        jPanel.setLayout(new BorderLayout());
        this.listView = new ListView();
        this.listView.setBorder((Border)UIManager.get("Nb.ScrollPane.border"));
        this.listView.setPopupAllowed(false);
        this.listView.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage((Class)DocumentsDlg.class, (String)"ACSD_ListView"));
        jPanel.add((Component)this.listView, "Center");
        return jPanel;
    }

    private void updateNodes() {
        TopComponent topComponent;
        List list = DocumentsDlg.getOpenedDocuments();
        TopComponent topComponent2 = TopComponent.getRegistry().getActivated();
        Object[] objectArray = new TopComponentNode[list.size()];
        Object object = null;
        for (int i = 0; i < objectArray.length; ++i) {
            topComponent = (TopComponent)list.get(i);
            objectArray[i] = new TopComponentNode(topComponent);
            if (topComponent != topComponent2) continue;
            object = objectArray[i];
        }
        Arrays.sort(objectArray);
        Children.Array array = new Children.Array();
        array.add((Node[])objectArray);
        topComponent = new AbstractNode((Children)array);
        this.explorer.setRootContext((Node)topComponent);
        this.listView.requestFocus();
        if (objectArray.length > 0) {
            try {
                if (null == object) {
                    object = objectArray[0];
                }
                this.explorer.setSelectedNodes(new Node[]{object});
            }
            catch (PropertyVetoException propertyVetoException) {
                // empty catch block
            }
        }
    }

    private void clearNodes() {
        this.explorer.setRootContext(Node.EMPTY);
    }

    private static List getOpenedDocuments() {
        ArrayList arrayList = new ArrayList();
        Iterator iterator = WindowManagerImpl.getInstance().getModes().iterator();
        while (iterator.hasNext()) {
            ModeImpl modeImpl = (ModeImpl)iterator.next();
            if (modeImpl.getKind() != 1) continue;
            arrayList.addAll(modeImpl.getOpenedTopComponents());
        }
        return arrayList;
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if ("selectedNodes".equals(propertyChangeEvent.getPropertyName())) {
            Node[] nodeArray = (Node[])propertyChangeEvent.getNewValue();
            if (nodeArray.length == 1) {
                this.jButtonActivate.setEnabled(true);
            } else {
                this.jButtonActivate.setEnabled(false);
            }
            if (nodeArray.length > 0) {
                this.jButtonClose.setEnabled(true);
            } else {
                this.jButtonClose.setEnabled(false);
            }
            boolean bl = false;
            for (int i = 0; i < nodeArray.length; ++i) {
                TopComponent topComponent = ((TopComponentNode)nodeArray[i]).getTopComponent();
                Lookup lookup = topComponent.getLookup();
                SaveCookie saveCookie = (SaveCookie)lookup.lookup(class$org$openide$cookies$SaveCookie == null ? DocumentsDlg.class$("org.openide.cookies.SaveCookie") : class$org$openide$cookies$SaveCookie);
                if (saveCookie == null) continue;
                bl = true;
                break;
            }
            this.jButtonSave.setEnabled(bl);
            if (nodeArray != null && nodeArray.length == 1) {
                this.descriptionArea.setText(((TopComponentNode)nodeArray[0]).getDescription());
            } else {
                this.descriptionArea.setText(null);
            }
        }
    }

    public ExplorerManager getExplorerManager() {
        return this.explorer;
    }

    static {
        COLLATOR = Collator.getInstance();
    }

    private class TopComponentNode
    extends AbstractNode
    implements Comparable,
    Action,
    PropertyChangeListener {
        private TopComponent tc;

        public TopComponentNode(TopComponent topComponent) {
            super(Children.LEAF);
            this.tc = topComponent;
            topComponent.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this, (Object)topComponent));
        }

        public String getName() {
            return this.tc.getName();
        }

        public String getDisplayName() {
            String string = this.tc.getDisplayName();
            return string != null ? string : this.tc.getName();
        }

        public String getHtmlDisplayName() {
            return this.tc.getHtmlDisplayName();
        }

        public Image getIcon(int n) {
            Image image = this.tc.getIcon();
            return image == null ? Utilities.loadImage((String)"org/openide/resources/actions/empty.gif") : image;
        }

        public String getDescription() {
            return this.tc.getToolTipText();
        }

        public TopComponent getTopComponent() {
            return this.tc;
        }

        void refresh() {
            this.fireNameChange(null, null);
        }

        public int compareTo(Object object) {
            if (!(object instanceof TopComponentNode)) {
                return -1;
            }
            TopComponentNode topComponentNode = (TopComponentNode)object;
            String string = this.getDisplayName();
            String string2 = topComponentNode.getDisplayName();
            if (string == null) {
                return string2 == null ? 0 : -1;
            }
            return string2 == null ? 1 : COLLATOR.compare(string, string2);
        }

        public Action getPreferredAction() {
            return this;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            DocumentsDlg.this.activate(actionEvent);
        }

        public boolean isEnabled() {
            return true;
        }

        public void putValue(String string, Object object) {
        }

        public void setEnabled(boolean bl) {
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            this.fireDisplayNameChange(null, null);
        }
    }
}

