/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.windows.view.ui;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.swing.JLayeredPane;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.netbeans.core.windows.view.SlidingView;
import org.netbeans.core.windows.view.ViewElement;
import org.netbeans.core.windows.view.ui.slides.SlideOperation;
import org.openide.windows.TopComponent;

public final class DesktopImpl {
    private JLayeredPane layeredPane = new JLayeredPane();
    private JPanel desktop;
    private ViewElement splitRoot;
    private ViewElement maximizedMode;
    private Component splitRootComponent;
    private Component viewComponent;
    private Set slidingViews;
    private SlideOperation curSlideIn;
    private static final int MIN_EDITOR_ALIGN_THICK = 200;

    public DesktopImpl() {
        this.layeredPane.setLayout(new LayeredLayout());
        this.desktop = new JPanel();
        this.desktop.setLayout(new GridBagLayout());
        this.layeredPane.add(this.desktop);
    }

    public Component getDesktopComponent() {
        return this.layeredPane;
    }

    public Dimension getInnerPaneDimension() {
        int n = this.desktop.getSize().width;
        int n2 = this.desktop.getSize().height;
        SlidingView slidingView = this.findView("left");
        n = slidingView != null ? n - slidingView.getComponent().getSize().width : n;
        slidingView = this.findView("right");
        n = slidingView != null ? n - slidingView.getComponent().getSize().width : n;
        slidingView = this.findView("bottom");
        n2 = slidingView != null ? n2 - slidingView.getComponent().getSize().height : n2;
        return new Dimension(n, n2);
    }

    public void setSplitRoot(ViewElement viewElement) {
        this.splitRoot = viewElement;
        if (viewElement != null) {
            this.setViewComponent(viewElement.getComponent());
        } else {
            this.setViewComponent(null);
        }
    }

    public void setMaximizedView(ViewElement viewElement) {
        this.maximizedMode = viewElement;
        if (viewElement.getComponent() != this.viewComponent) {
            this.setViewComponent(viewElement.getComponent());
        }
    }

    private void setViewComponent(Component component) {
        if (this.viewComponent == component) {
            return;
        }
        if (this.viewComponent != null) {
            this.desktop.remove(this.viewComponent);
        }
        this.viewComponent = component;
        if (this.viewComponent != null) {
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.fill = 1;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.weighty = 1.0;
            this.desktop.add(component, gridBagConstraints);
        }
        this.layeredPane.revalidate();
        this.layeredPane.repaint();
    }

    public ViewElement getSplitRoot() {
        return this.splitRoot;
    }

    public void addSlidingView(SlidingView slidingView) {
        Set set = this.getSlidingViews();
        if (set.contains(slidingView)) {
            return;
        }
        set.add(slidingView);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        if ("bottom".equals(slidingView.getSide())) {
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridy = 1;
            gridBagConstraints.anchor = 16;
        } else if ("left".equals(slidingView.getSide())) {
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.gridheight = 2;
            gridBagConstraints.anchor = 18;
        } else if ("right".equals(slidingView.getSide())) {
            gridBagConstraints.gridx = 2;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.gridheight = 2;
            gridBagConstraints.anchor = 12;
        }
        this.desktop.add(slidingView.getComponent(), gridBagConstraints);
        this.layeredPane.revalidate();
    }

    public void removeSlidingView(SlidingView slidingView) {
        Set set = this.getSlidingViews();
        if (!set.contains(slidingView)) {
            return;
        }
        set.remove(slidingView);
        this.desktop.remove(slidingView.getComponent());
        this.checkCurSlide();
        this.layeredPane.revalidate();
    }

    private void checkCurSlide() {
        if (this.curSlideIn != null) {
            SlidingView slidingView = null;
            Component component = this.curSlideIn.getComponent();
            Iterator iterator = this.slidingViews.iterator();
            while (iterator.hasNext()) {
                slidingView = (SlidingView)iterator.next();
                if (!slidingView.getTopComponents().contains(component)) continue;
                return;
            }
            this.layeredPane.remove(component);
        }
    }

    public void performSlideIn(SlideOperation slideOperation, Rectangle rectangle) {
        Rectangle rectangle2 = this.computeSlideInBounds(slideOperation, rectangle);
        slideOperation.setFinishBounds(rectangle2);
        slideOperation.setStartBounds(this.computeThinBounds(slideOperation, rectangle2));
        this.performSlide(slideOperation);
        this.curSlideIn = slideOperation;
    }

    public void performSlideOut(SlideOperation slideOperation, Rectangle rectangle) {
        Rectangle rectangle2 = slideOperation.getComponent().getBounds();
        slideOperation.setStartBounds(rectangle2);
        slideOperation.setFinishBounds(this.computeThinBounds(slideOperation, rectangle2));
        this.curSlideIn = null;
        this.performSlide(slideOperation);
        this.desktop.revalidate();
        this.desktop.repaint();
    }

    public void performSlideIntoEdge(SlideOperation slideOperation, Rectangle rectangle) {
        slideOperation.setFinishBounds(this.computeLastButtonBounds(slideOperation));
        Rectangle rectangle2 = slideOperation.getStartBounds();
        slideOperation.setStartBounds(this.convertRectFromScreen(this.layeredPane, rectangle2));
        this.performSlide(slideOperation);
    }

    public void performSlideIntoDesktop(SlideOperation slideOperation, Rectangle rectangle) {
        Rectangle rectangle2 = slideOperation.getStartBounds();
        slideOperation.setStartBounds(this.convertRectFromScreen(this.layeredPane, rectangle2));
        Rectangle rectangle3 = slideOperation.getStartBounds();
        slideOperation.setStartBounds(this.convertRectFromScreen(this.layeredPane, rectangle3));
        this.performSlide(slideOperation);
    }

    public void performSlideResize(SlideOperation slideOperation) {
        this.performSlide(slideOperation);
    }

    private void performSlide(SlideOperation slideOperation) {
        slideOperation.run(this.layeredPane, new Integer(102));
    }

    private Rectangle convertRectFromScreen(Component component, Rectangle rectangle) {
        if (rectangle == null) {
            rectangle = new Rectangle(0, 0, 0, 0);
        }
        Point point = rectangle.getLocation();
        SwingUtilities.convertPointFromScreen(point, component);
        return new Rectangle(point, rectangle.getSize());
    }

    private Rectangle computeSlideInBounds(SlideOperation slideOperation, Rectangle rectangle) {
        Point point = rectangle.getLocation();
        SwingUtilities.convertPointFromScreen(point, this.layeredPane);
        rectangle = new Rectangle(point, rectangle.getSize());
        String string = slideOperation.getSide();
        SlidingView slidingView = this.findView(string);
        Rectangle rectangle2 = this.viewComponent.getBounds();
        Rectangle rectangle3 = new Rectangle();
        Rectangle rectangle4 = slidingView.getComponent().getBounds();
        Dimension dimension = slidingView.getComponent().getPreferredSize();
        int n = 200;
        TopComponent topComponent = slidingView.getSelectedTopComponent();
        if (null != topComponent && Boolean.TRUE.equals(topComponent.getClientProperty((Object)"keepPreferredSizeWhenSlideIn"))) {
            n = 20;
        }
        if ("left".equals(string)) {
            rectangle3.x = rectangle4.x + Math.max(rectangle4.width, dimension.width);
            rectangle3.y = 0;
            rectangle3.height = rectangle2.height;
            rectangle3.width = slidingView.getSlideBounds().width;
            if (rectangle3.width < n) {
                rectangle3.width = rectangle2.width / 3;
            }
            if (rectangle3.width > rectangle2.width) {
                rectangle3.width = rectangle2.width - rectangle2.width / 10;
            }
        } else if ("right".equals(string)) {
            int n2 = this.layeredPane.getBounds().width - Math.max(rectangle4.width, dimension.width);
            int n3 = rectangle3.x = slidingView.getSlideBounds().width < n ? n2 - rectangle2.width / 3 : n2 - slidingView.getSlideBounds().width;
            if (rectangle3.x < 0) {
                rectangle3.x = rectangle2.width / 10;
            }
            rectangle3.y = 0;
            rectangle3.height = rectangle2.height;
            rectangle3.width = n2 - rectangle3.x;
        } else if ("bottom".equals(string)) {
            int n4 = rectangle4.y + rectangle4.height - Math.max(rectangle4.height, dimension.height);
            rectangle3.x = rectangle2.x;
            int n5 = rectangle3.y = slidingView.getSlideBounds().height < n ? n4 - rectangle2.height / 3 : n4 - slidingView.getSlideBounds().height;
            if (rectangle3.y < 0) {
                rectangle3.y = rectangle2.width / 10;
            }
            rectangle3.height = n4 - rectangle3.y;
            rectangle3.width = rectangle2.width;
        }
        return rectangle3;
    }

    private Rectangle computeThinBounds(SlideOperation slideOperation, Rectangle rectangle) {
        String string = slideOperation.getSide();
        Rectangle rectangle2 = new Rectangle();
        if ("left".equals(string)) {
            rectangle2.x = rectangle.x;
            rectangle2.y = rectangle.y;
            rectangle2.height = rectangle.height;
            rectangle2.width = 0;
        } else if ("right".equals(string)) {
            rectangle2.x = rectangle.x + rectangle.width;
            rectangle2.y = rectangle.y;
            rectangle2.height = rectangle.height;
            rectangle2.width = 0;
        } else if ("bottom".equals(string)) {
            rectangle2.x = rectangle.x;
            rectangle2.y = rectangle.y + rectangle.height;
            rectangle2.height = 0;
            rectangle2.width = rectangle.width;
        }
        return rectangle2;
    }

    private Rectangle computeLastButtonBounds(SlideOperation slideOperation) {
        String string = slideOperation.getSide();
        SlidingView slidingView = this.findView(string);
        Rectangle rectangle = slidingView.getTabBounds(slidingView.getTopComponents().size() - 1);
        Point point = rectangle.getLocation();
        if ("bottom".equals(string)) {
            point.y += this.desktop.getHeight() - slidingView.getComponent().getPreferredSize().height;
        } else if ("right".equals(string)) {
            point.x += this.desktop.getWidth() - slidingView.getComponent().getPreferredSize().width;
        }
        return new Rectangle(point, rectangle.getSize());
    }

    private SlidingView findView(String string) {
        Iterator iterator = this.getSlidingViews().iterator();
        while (iterator.hasNext()) {
            SlidingView slidingView = (SlidingView)iterator.next();
            if (!string.equals(slidingView.getSide())) continue;
            return slidingView;
        }
        return null;
    }

    private Set getSlidingViews() {
        if (this.slidingViews == null) {
            this.slidingViews = new HashSet(5);
        }
        return this.slidingViews;
    }

    private final class LayeredLayout
    implements LayoutManager {
        private Dimension lastSize;

        private LayeredLayout() {
        }

        public void layoutContainer(Container container) {
            String string;
            SlidingView slidingView;
            Dimension dimension = container.getSize();
            DesktopImpl.this.desktop.setBounds(0, 0, dimension.width, dimension.height);
            if (DesktopImpl.this.curSlideIn != null && DesktopImpl.this.curSlideIn.getComponent().isVisible() && (slidingView = DesktopImpl.this.findView(string = DesktopImpl.this.curSlideIn.getSide())) != null && DesktopImpl.this.viewComponent != null) {
                Component component = DesktopImpl.this.curSlideIn.getComponent();
                Rectangle rectangle = component.getBounds();
                Rectangle rectangle2 = slidingView.getComponent().getBounds();
                Dimension dimension2 = slidingView.getComponent().getPreferredSize();
                Rectangle rectangle3 = DesktopImpl.this.viewComponent.getBounds();
                if ("left".equals(string)) {
                    rectangle.height = rectangle3.height;
                    if (this.lastSize != null && !this.lastSize.equals(dimension)) {
                        int n = slidingView.getSlideBounds().width;
                        rectangle.width = n > dimension.width - rectangle2.width ? dimension.width - dimension.width / 10 : n;
                    }
                } else if ("right".equals(string)) {
                    rectangle.height = rectangle3.height;
                    if (this.lastSize != null && !this.lastSize.equals(dimension)) {
                        int n;
                        int n2 = dimension.width - Math.max(rectangle2.width, dimension2.width);
                        if (n2 - (n = slidingView.getSlideBounds().width) < n / 10) {
                            rectangle.x = 0 + n / 10;
                            rectangle.width = n2 - n / 10;
                        } else {
                            rectangle.x = n2 - rectangle.width;
                            rectangle.width = n;
                        }
                    }
                } else if ("bottom".equals(string)) {
                    rectangle.width = rectangle3.width;
                    if (this.lastSize != null && !this.lastSize.equals(dimension)) {
                        int n = dimension.height - Math.max(rectangle2.height, dimension2.height);
                        int n3 = rectangle2.height;
                        if (n3 < slidingView.getSlideBounds().height) {
                            n3 = slidingView.getSlideBounds().height;
                        }
                        if (n - n3 < n3 / 10) {
                            rectangle.y = 0 + n3 / 10;
                            rectangle.height = n - n3 / 10;
                        } else {
                            rectangle.y = n - n3;
                            rectangle.height = n3;
                        }
                    }
                }
                component.setBounds(rectangle);
            }
            this.lastSize = dimension;
        }

        public Dimension minimumLayoutSize(Container container) {
            return DesktopImpl.this.desktop.getMinimumSize();
        }

        public Dimension preferredLayoutSize(Container container) {
            return DesktopImpl.this.desktop.getPreferredSize();
        }

        public void addLayoutComponent(String string, Component component) {
        }

        public void removeLayoutComponent(Component component) {
        }
    }
}

