/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.windows.view.ui;

import java.awt.Component;
import java.awt.Frame;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowStateListener;
import javax.swing.JFrame;
import javax.swing.plaf.basic.BasicHTML;
import org.netbeans.core.windows.Constants;
import org.netbeans.core.windows.WindowManagerImpl;
import org.netbeans.core.windows.view.ModeView;
import org.netbeans.core.windows.view.ViewElement;
import org.netbeans.core.windows.view.dnd.TopComponentDroppable;
import org.netbeans.core.windows.view.dnd.WindowDnDManager;
import org.netbeans.core.windows.view.ui.AbstractModeContainer;
import org.netbeans.core.windows.view.ui.MainWindow;
import org.netbeans.core.windows.view.ui.ModeComponent;
import org.netbeans.core.windows.view.ui.Tabbed;
import org.netbeans.core.windows.view.ui.tabcontrol.TabbedAdapter;
import org.openide.util.Utilities;
import org.openide.windows.TopComponent;

public final class DefaultSeparateContainer
extends AbstractModeContainer {
    private final JFrame frame;

    public DefaultSeparateContainer(final ModeView modeView, WindowDnDManager windowDnDManager, Rectangle rectangle) {
        super(modeView, windowDnDManager);
        this.frame = new ModeFrame(this, modeView);
        this.frame.getContentPane().add(this.tabbedHandler.getComponent());
        this.frame.setBounds(rectangle);
        this.frame.addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent componentEvent) {
                if (DefaultSeparateContainer.this.frame.getExtendedState() == 6) {
                    return;
                }
                modeView.getController().userResizedModeBounds(modeView, DefaultSeparateContainer.this.frame.getBounds());
            }

            public void componentMoved(ComponentEvent componentEvent) {
                if (DefaultSeparateContainer.this.frame.getExtendedState() == 6) {
                    return;
                }
                modeView.getController().userResizedModeBounds(modeView, DefaultSeparateContainer.this.frame.getBounds());
            }
        });
        this.frame.addWindowStateListener(new WindowStateListener(){

            public void windowStateChanged(WindowEvent windowEvent) {
                Component component = modeView.getComponent();
                if (component instanceof Frame) {
                    long l = System.currentTimeMillis();
                    if (l > modeView.getUserStamp() + 500L && l > modeView.getMainWindowStamp() + 1000L) {
                        modeView.getController().userChangedFrameStateMode(modeView, windowEvent.getNewState());
                    } else {
                        modeView.setUserStamp(0L);
                        modeView.setMainWindowStamp(0L);
                        modeView.updateFrameState();
                    }
                    long l2 = System.currentTimeMillis();
                    modeView.setUserStamp(l2);
                }
            }
        });
    }

    public void requestAttention(TopComponent topComponent) {
    }

    public void cancelRequestAttention(TopComponent topComponent) {
    }

    protected Component getModeComponent() {
        return this.frame;
    }

    protected Tabbed createTabbed() {
        TabbedAdapter tabbedAdapter = this.getKind() == 1 ? new TabbedAdapter(1) : new TabbedAdapter(0);
        return tabbedAdapter;
    }

    protected void updateTitle(String string) {
        if (BasicHTML.isHTMLString(string)) {
            char[] cArray = string.toCharArray();
            StringBuffer stringBuffer = new StringBuffer(string.length());
            boolean bl = false;
            boolean bl2 = false;
            for (int i = 0; i < cArray.length; ++i) {
                if (bl && cArray[i] == '>') {
                    bl = false;
                    continue;
                }
                if (!bl && cArray[i] == '<') {
                    bl = true;
                    continue;
                }
                if (bl) continue;
                stringBuffer.append(cArray[i]);
            }
            string = Utilities.replaceString((String)stringBuffer.toString(), (String)"&nbsp;", (String)" ");
        }
        this.frame.setTitle(string);
    }

    protected void updateActive(boolean bl) {
        if (bl && this.frame.isVisible() && !this.frame.isActive()) {
            this.frame.toFront();
        }
    }

    public boolean isActive() {
        return this.frame.isActive();
    }

    protected boolean isAttachingPossible() {
        return false;
    }

    protected TopComponentDroppable getModeDroppable() {
        return (ModeFrame)this.frame;
    }

    private static class ModeFrame
    extends JFrame
    implements ModeComponent,
    TopComponentDroppable {
        private final AbstractModeContainer abstractModeContainer;
        private final ModeView modeView;
        private long frametimestamp = 0L;

        public ModeFrame(AbstractModeContainer abstractModeContainer, ModeView modeView) {
            super("");
            this.abstractModeContainer = abstractModeContainer;
            this.modeView = modeView;
            this.enableEvents(16L);
            this.setIconImage(MainWindow.createIDEImage());
            this.addWindowListener(new WindowAdapter(){

                public void windowClosing(WindowEvent windowEvent) {
                    ModeFrame.this.modeView.getController().userClosingMode(ModeFrame.this.modeView);
                }

                public void windowActivated(WindowEvent windowEvent) {
                    if (ModeFrame.this.frametimestamp != 0L && System.currentTimeMillis() > ModeFrame.this.frametimestamp + 500L) {
                        ModeFrame.this.modeView.getController().userActivatedModeWindow(ModeFrame.this.modeView);
                    }
                    ModeFrame.this.frametimestamp = System.currentTimeMillis();
                }

                public void windowOpened(WindowEvent windowEvent) {
                    ModeFrame.this.frametimestamp = System.currentTimeMillis();
                }
            });
        }

        public void setVisible(boolean bl) {
            this.frametimestamp = System.currentTimeMillis();
            super.setVisible(bl);
        }

        public void toFront() {
            this.frametimestamp = System.currentTimeMillis();
            super.toFront();
        }

        public ModeView getModeView() {
            return this.abstractModeContainer.getModeView();
        }

        public int getKind() {
            return this.abstractModeContainer.getKind();
        }

        public Shape getIndicationForLocation(Point point) {
            return this.abstractModeContainer.getIndicationForLocation(point);
        }

        public Object getConstraintForLocation(Point point) {
            return this.abstractModeContainer.getConstraintForLocation(point);
        }

        public Component getDropComponent() {
            return this.abstractModeContainer.getDropComponent();
        }

        public ViewElement getDropViewElement() {
            return this.abstractModeContainer.getDropModeView();
        }

        public boolean canDrop(TopComponent topComponent, Point point) {
            return this.abstractModeContainer.canDrop(topComponent);
        }

        public boolean supportsKind(int n, TopComponent topComponent) {
            if (Constants.SWITCH_MODE_ADD_NO_RESTRICT || WindowManagerImpl.getInstance().isTopComponentAllowedToMoveAnywhere(topComponent)) {
                return true;
            }
            return n == 0 || n == 2;
        }
    }
}

