/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.windows.view.dnd;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Toolkit;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.dnd.DragSourceMotionListener;
import java.awt.dnd.DropTarget;
import java.io.IOException;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JInternalFrame;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.RootPaneContainer;
import javax.swing.SwingUtilities;
import org.netbeans.core.windows.Constants;
import org.netbeans.core.windows.Debug;
import org.netbeans.core.windows.ModeImpl;
import org.netbeans.core.windows.WindowManagerImpl;
import org.netbeans.core.windows.view.Controller;
import org.netbeans.core.windows.view.EditorView;
import org.netbeans.core.windows.view.ModeView;
import org.netbeans.core.windows.view.ViewElement;
import org.netbeans.core.windows.view.dnd.DropTargetGlassPane;
import org.netbeans.core.windows.view.dnd.EnhancedDragPainter;
import org.netbeans.core.windows.view.dnd.TopComponentDragSupport;
import org.netbeans.core.windows.view.dnd.TopComponentDroppable;
import org.netbeans.core.windows.view.ui.MainWindow;
import org.netbeans.core.windows.view.ui.ModeComponent;
import org.openide.ErrorManager;
import org.openide.util.WeakSet;
import org.openide.windows.TopComponent;

public final class WindowDnDManager
implements DropTargetGlassPane.Observer,
DropTargetGlassPane.Informer {
    private final TopComponentDragSupport topComponentDragSupport = new TopComponentDragSupport(this);
    private DragSource windowDragSource;
    private boolean dragging;
    private boolean dropSuccess;
    private final Map root2glass = new HashMap();
    private final Set floatingFrames = new WeakSet(4);
    private Reference lastTargetWRef = new WeakReference<Object>(null);
    private final ViewAccessor viewAccessor;
    private TopComponentDroppable startingDroppable;
    private Point startingPoint;
    private TopComponent startingTransfer;
    private static WeakReference centerDropWRef = new WeakReference<Object>(null);
    private static final boolean DEBUG = Debug.isLoggable(WindowDnDManager.class);
    private CenterSlidingDroppable lastSlideDroppable;
    static /* synthetic */ Class class$javax$swing$RootPaneContainer;

    public WindowDnDManager(ViewAccessor viewAccessor) {
        this.viewAccessor = viewAccessor;
        Toolkit.getDefaultToolkit().addAWTEventListener(this.topComponentDragSupport, 48L);
    }

    public static boolean isDnDEnabled() {
        return !Constants.SWITCH_DND_DISABLE;
    }

    public synchronized DragSource getWindowDragSource() {
        if (this.windowDragSource == null) {
            this.windowDragSource = new DragSource();
            this.windowDragSource.addDragSourceMotionListener(new MotionListener(this, this.topComponentDragSupport));
        }
        return this.windowDragSource;
    }

    public boolean isDragging() {
        return this.dragging;
    }

    public void setDropSuccess(boolean bl) {
        this.dropSuccess = bl;
    }

    public boolean isDropSuccess() {
        return this.dropSuccess;
    }

    public void setLastDropTarget(DropTargetGlassPane dropTargetGlassPane) {
        if (dropTargetGlassPane != this.lastTargetWRef.get()) {
            this.lastTargetWRef = new WeakReference<DropTargetGlassPane>(dropTargetGlassPane);
        }
    }

    public void resetDragSource() {
        this.dragFinished();
    }

    public TopComponentDroppable getStartingDroppable() {
        return this.startingDroppable;
    }

    public Point getStartingPoint() {
        return this.startingPoint;
    }

    public TopComponent getStartingTransfer() {
        return this.startingTransfer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dragStarting(TopComponentDroppable topComponentDroppable, Point point, TopComponent topComponent) {
        Component component;
        if (DEBUG) {
            WindowDnDManager.debugLog("");
            WindowDnDManager.debugLog("dragStarting");
        }
        this.startingDroppable = topComponentDroppable;
        this.startingPoint = point;
        this.startingTransfer = topComponent;
        HashMap<JRootPane, Object> hashMap = new HashMap<JRootPane, Object>();
        HashSet<Component> hashSet = new HashSet<Component>();
        Object object = this.viewAccessor.getModeComponents().iterator();
        while (object.hasNext()) {
            Object object2;
            component = (Component)object.next();
            if (!(component instanceof TopComponentDroppable)) continue;
            JRootPane jRootPane = null;
            if (component instanceof RootPaneContainer) {
                jRootPane = ((RootPaneContainer)((Object)component)).getRootPane();
            } else {
                object2 = (RootPaneContainer)((Object)SwingUtilities.getAncestorOfClass(class$javax$swing$RootPaneContainer == null ? WindowDnDManager.class$("javax.swing.RootPaneContainer") : class$javax$swing$RootPaneContainer, component));
                if (object2 != null) {
                    jRootPane = object2.getRootPane();
                }
            }
            if (jRootPane == null || (object2 = WindowDnDManager.setDropTargetGlassPane(jRootPane, this)) == null) continue;
            hashMap.put(jRootPane, object2);
        }
        object = this.viewAccessor.getSeparateModeFrames().iterator();
        while (object.hasNext()) {
            component = (Frame)object.next();
            if (component == null) continue;
            hashSet.add(component);
        }
        if (!hashMap.isEmpty()) {
            object = this.root2glass;
            synchronized (object) {
                this.root2glass.putAll(hashMap);
            }
        }
        if (!hashSet.isEmpty()) {
            object = this.floatingFrames;
            synchronized (object) {
                this.floatingFrames.addAll(hashSet);
            }
        }
        this.dragging = true;
        this.dropSuccess = false;
    }

    private static Component setDropTargetGlassPane(JRootPane jRootPane, WindowDnDManager windowDnDManager) {
        Component component = jRootPane.getGlassPane();
        if (component instanceof DropTargetGlassPane) {
            return null;
        }
        DropTargetGlassPane dropTargetGlassPane = new DropTargetGlassPane(windowDnDManager);
        new DropTarget(dropTargetGlassPane, 3, dropTargetGlassPane);
        jRootPane.setGlassPane(dropTargetGlassPane);
        dropTargetGlassPane.initialize();
        return component;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dragFinished() {
        HashMap hashMap;
        if (DEBUG) {
            WindowDnDManager.debugLog("");
            WindowDnDManager.debugLog("dragFinished");
        }
        this.startingDroppable = null;
        this.startingPoint = null;
        this.startingTransfer = null;
        this.topComponentDragSupport.dragFinished();
        this.dragging = false;
        Object object = this.root2glass;
        synchronized (object) {
            hashMap = new HashMap(this.root2glass);
            this.root2glass.clear();
        }
        object = hashMap.keySet().iterator();
        while (object.hasNext()) {
            JRootPane jRootPane = (JRootPane)object.next();
            WindowDnDManager.setOriginalGlassPane(jRootPane, (Component)hashMap.get(jRootPane));
        }
    }

    private static void setOriginalGlassPane(JRootPane jRootPane, Component component) {
        JComponent jComponent;
        Component component2 = jRootPane.getGlassPane();
        if (component2 instanceof DropTargetGlassPane) {
            jComponent = (DropTargetGlassPane)component2;
            jComponent.setDropTarget(null);
            ((DropTargetGlassPane)jComponent).uninitialize();
        }
        if (component != null) {
            jRootPane.setGlassPane(component);
        }
        if ((jComponent = (JInternalFrame)SwingUtilities.getAncestorOfClass(JInternalFrame.class, component)) != null && !((JInternalFrame)jComponent).isSelected() && !component.isVisible()) {
            component.setVisible(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dragFinishedEx() {
        Set set = this.floatingFrames;
        synchronized (set) {
            this.floatingFrames.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set getFloatingFrames() {
        Set set = this.floatingFrames;
        synchronized (set) {
            return new HashSet(this.floatingFrames);
        }
    }

    public boolean isInFloatingFrame(Point point) {
        Iterator iterator = this.getFloatingFrames().iterator();
        while (iterator.hasNext()) {
            Frame frame = (Frame)iterator.next();
            if (!frame.getBounds().contains(point)) continue;
            return true;
        }
        return false;
    }

    public boolean isCopyOperationPossible() {
        return this.topComponentDragSupport.isCopyOperationPossible();
    }

    public Controller getController() {
        return this.viewAccessor.getController();
    }

    private static void debugLog(String string) {
        Debug.log(WindowDnDManager.class, string);
    }

    static boolean isInMainWindow(Point point) {
        return WindowManagerImpl.getInstance().getMainWindow().getBounds().contains(point);
    }

    private boolean isInMainWindowDroppable(Point point, int n, TopComponent topComponent) {
        return this.findMainWindowDroppable(point, n, topComponent) != null;
    }

    private static boolean isInFloatingFrameDroppable(Set set, Point point, int n, TopComponent topComponent) {
        return WindowDnDManager.findFloatingFrameDroppable(set, point, n, topComponent) != null;
    }

    private static boolean isInFreeArea(Point point) {
        Frame[] frameArray = Frame.getFrames();
        for (int i = 0; i < frameArray.length; ++i) {
            if (!frameArray[i].isVisible() || !frameArray[i].getBounds().contains(point.x, point.y)) continue;
            return false;
        }
        return true;
    }

    private TopComponentDroppable findDroppableFromScreen(Set set, Point point, int n, TopComponent topComponent) {
        TopComponentDroppable topComponentDroppable = this.findMainWindowDroppable(point, n, topComponent);
        if (topComponentDroppable != null) {
            return topComponentDroppable;
        }
        topComponentDroppable = WindowDnDManager.findFloatingFrameDroppable(set, point, n, topComponent);
        if (topComponentDroppable != null) {
            return topComponentDroppable;
        }
        if (WindowDnDManager.isInFreeArea(point)) {
            return WindowDnDManager.getFreeAreaDroppable(point);
        }
        return null;
    }

    private TopComponentDroppable findMainWindowDroppable(Point point, int n, TopComponent topComponent) {
        Object object;
        MainWindow mainWindow = (MainWindow)WindowManagerImpl.getInstance().getMainWindow();
        Point point2 = new Point(point);
        SwingUtilities.convertPointFromScreen(point2, mainWindow.getContentPane());
        if (this.lastSlideDroppable != null && this.lastSlideDroppable.isWithinSlide(point2)) {
            return this.lastSlideDroppable;
        }
        TopComponentDroppable topComponentDroppable = WindowDnDManager.findSlideDroppable(this.viewAccessor.getSlidingModeComponent("left"));
        if (topComponentDroppable != null && ((CenterSlidingDroppable)(object = new CenterSlidingDroppable(this.viewAccessor, topComponentDroppable, "left"))).isWithinSlide(point2)) {
            this.lastSlideDroppable = object;
            return object;
        }
        topComponentDroppable = WindowDnDManager.findSlideDroppable(this.viewAccessor.getSlidingModeComponent("right"));
        if (topComponentDroppable != null && ((CenterSlidingDroppable)(object = new CenterSlidingDroppable(this.viewAccessor, topComponentDroppable, "right"))).isWithinSlide(point2)) {
            this.lastSlideDroppable = object;
            return object;
        }
        topComponentDroppable = WindowDnDManager.findSlideDroppable(this.viewAccessor.getSlidingModeComponent("bottom"));
        if (topComponentDroppable != null && ((CenterSlidingDroppable)(object = new CenterSlidingDroppable(this.viewAccessor, topComponentDroppable, "bottom"))).isWithinSlide(point2)) {
            this.lastSlideDroppable = object;
            return object;
        }
        this.lastSlideDroppable = null;
        if (WindowDnDManager.isNearEdge(point, this.viewAccessor)) {
            return this.getCenterPanelDroppable();
        }
        object = new Point(point);
        SwingUtilities.convertPointFromScreen((Point)object, mainWindow);
        return WindowDnDManager.findDroppable(mainWindow, (Point)object, n, topComponent);
    }

    private static TopComponentDroppable findSlideDroppable(Component component) {
        TopComponentDroppable topComponentDroppable = null;
        topComponentDroppable = component instanceof TopComponentDroppable ? (TopComponentDroppable)((Object)component) : (TopComponentDroppable)((Object)SwingUtilities.getAncestorOfClass(TopComponentDroppable.class, component));
        return topComponentDroppable;
    }

    private static TopComponentDroppable findFloatingFrameDroppable(Set set, Point point, int n, TopComponent topComponent) {
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            TopComponentDroppable topComponentDroppable;
            Component component = (Component)iterator.next();
            Rectangle rectangle = component.getBounds();
            if (!rectangle.contains(point) || (topComponentDroppable = WindowDnDManager.findDroppable(component, new Point(point.x - rectangle.x, point.y - rectangle.y), n, topComponent)) == null) continue;
            return topComponentDroppable;
        }
        return null;
    }

    private static TopComponentDroppable findDroppable(Component component, Point point, int n, TopComponent topComponent) {
        TopComponentDroppable topComponentDroppable;
        Container container;
        JFrame jFrame;
        if (component instanceof JFrame) {
            jFrame = (JFrame)component;
        } else {
            container = SwingUtilities.getWindowAncestor(component);
            if (container instanceof JFrame) {
                jFrame = (JFrame)container;
            } else {
                return null;
            }
        }
        container = jFrame.getContentPane();
        point = SwingUtilities.convertPoint(component, point, container);
        Component component2 = SwingUtilities.getDeepestComponentAt(container, point.x, point.y);
        if (component2 instanceof TopComponentDroppable && (topComponentDroppable = (TopComponentDroppable)((Object)component2)).supportsKind(n, topComponent)) {
            return topComponentDroppable;
        }
        while (component2 != null) {
            topComponentDroppable = (TopComponentDroppable)((Object)SwingUtilities.getAncestorOfClass(class$org$netbeans$core$windows$view$dnd$TopComponentDroppable == null ? WindowDnDManager.class$("org.netbeans.core.windows.view.dnd.TopComponentDroppable") : class$org$netbeans$core$windows$view$dnd$TopComponentDroppable, component2));
            if (topComponentDroppable != null && topComponentDroppable.supportsKind(n, topComponent)) {
                return topComponentDroppable;
            }
            component2 = (Component)((Object)topComponentDroppable);
        }
        return null;
    }

    static boolean isAroundCenterPanel(Point point) {
        Component component = ((MainWindow)WindowManagerImpl.getInstance().getMainWindow()).getDesktop();
        if (component == null) {
            return false;
        }
        Point point2 = new Point(point);
        SwingUtilities.convertPointFromScreen(point2, component.getParent());
        Rectangle rectangle = component.getBounds();
        if (!rectangle.contains(point2)) {
            rectangle.grow(20, 20);
            if (rectangle.contains(point2)) {
                return true;
            }
        }
        return false;
    }

    static boolean isNearEdge(Point point, ViewAccessor viewAccessor) {
        Component component = ((MainWindow)WindowManagerImpl.getInstance().getMainWindow()).getDesktop();
        if (component == null) {
            return false;
        }
        Point point2 = new Point(point);
        SwingUtilities.convertPointFromScreen(point2, component);
        Rectangle rectangle = component.getBounds();
        rectangle.y -= 20;
        rectangle.height += 20;
        Rectangle rectangle2 = component.getBounds();
        rectangle2.grow(-10, 0);
        rectangle2.height -= 10;
        Component component2 = viewAccessor.getSlidingModeComponent("left");
        if (component2 != null) {
            rectangle2.x += component2.getBounds().width;
            rectangle2.width -= component2.getBounds().width;
        }
        if ((component2 = viewAccessor.getSlidingModeComponent("right")) != null) {
            rectangle2.width -= component2.getBounds().width;
        }
        if ((component2 = viewAccessor.getSlidingModeComponent("bottom")) != null) {
            rectangle2.height -= component2.getBounds().height;
        }
        boolean bl = rectangle.contains(point2) && !rectangle2.contains(point2);
        return bl;
    }

    private TopComponentDroppable getCenterPanelDroppable() {
        CenterPanelDroppable centerPanelDroppable = (CenterPanelDroppable)centerDropWRef.get();
        if (centerPanelDroppable == null) {
            centerPanelDroppable = new CenterPanelDroppable();
            centerDropWRef = new WeakReference<CenterPanelDroppable>(centerPanelDroppable);
        }
        return centerPanelDroppable;
    }

    private static TopComponentDroppable getFreeAreaDroppable(Point point) {
        return new FreeAreaDroppable(point);
    }

    boolean tryPerformDrop(Controller controller, Set set, Point point, int n, Transferable transferable) {
        TopComponent[] topComponentArray = WindowDnDManager.extractTopComponent(n == 1, transferable);
        if (topComponentArray == null || topComponentArray.length == 0) {
            return false;
        }
        ModeImpl modeImpl = (ModeImpl)WindowManagerImpl.getInstance().findMode(topComponentArray[0]);
        int n2 = modeImpl != null ? modeImpl.getKind() : 1;
        TopComponentDroppable topComponentDroppable = this.findDroppableFromScreen(set, point, n2, topComponentArray[0]);
        if (topComponentDroppable == null) {
            return false;
        }
        Component component = topComponentDroppable.getDropComponent();
        if (component != null) {
            SwingUtilities.convertPointFromScreen(point, component);
        }
        return WindowDnDManager.performDrop(controller, topComponentDroppable, n, topComponentArray, point);
    }

    static TopComponent[] extractTopComponent(boolean bl, Transferable transferable) {
        DataFlavor dataFlavor = WindowDnDManager.getDataFlavorForDropAction(bl);
        if (dataFlavor == null) {
            return null;
        }
        if (transferable.isDataFlavorSupported(dataFlavor)) {
            try {
                TopComponent topComponent;
                if (bl) {
                    TopComponent.Cloneable cloneable = (TopComponent.Cloneable)transferable.getTransferData(dataFlavor);
                    topComponent = cloneable.cloneComponent();
                } else {
                    topComponent = (TopComponent)transferable.getTransferData(dataFlavor);
                }
                return new TopComponent[]{topComponent};
            }
            catch (UnsupportedFlavorException unsupportedFlavorException) {
                ErrorManager.getDefault().notify(1, (Throwable)unsupportedFlavorException);
            }
            catch (IOException iOException) {
                ErrorManager.getDefault().notify(1, (Throwable)iOException);
            }
        }
        if (transferable.isDataFlavorSupported(dataFlavor = new DataFlavor("application/x-java-jvm-local-objectref; class=org.netbeans.core.windows.view.dnd.TopComponentDragSupport$TopComponentArray", null))) {
            try {
                return (TopComponent[])transferable.getTransferData(dataFlavor);
            }
            catch (UnsupportedFlavorException unsupportedFlavorException) {
                ErrorManager.getDefault().notify(1, (Throwable)unsupportedFlavorException);
            }
            catch (IOException iOException) {
                ErrorManager.getDefault().notify(1, (Throwable)iOException);
            }
        }
        return null;
    }

    private static DataFlavor getDataFlavorForDropAction(boolean bl) {
        DataFlavor dataFlavor = bl ? new DataFlavor("application/x-java-jvm-local-objectref; class=org.openide.windows.TopComponent$Cloneable", null) : new DataFlavor("application/x-java-jvm-local-objectref; class=org.openide.windows.TopComponent", null);
        return dataFlavor;
    }

    private static boolean performDrop(Controller controller, TopComponentDroppable topComponentDroppable, int n, TopComponent[] topComponentArray, Point point) {
        if (DEBUG) {
            WindowDnDManager.debugLog("");
            WindowDnDManager.debugLog("performDrop");
            WindowDnDManager.debugLog("droppable=" + topComponentDroppable);
        }
        if (topComponentArray == null || topComponentArray.length == 0) {
            return true;
        }
        if (!topComponentDroppable.canDrop(topComponentArray[0], point)) {
            return true;
        }
        ViewElement viewElement = topComponentDroppable.getDropViewElement();
        Object object = topComponentDroppable.getConstraintForLocation(point);
        if (viewElement instanceof EditorView) {
            int n2;
            ModeImpl modeImpl = (ModeImpl)WindowManagerImpl.getInstance().findMode(topComponentArray[0]);
            int n3 = n2 = modeImpl != null ? modeImpl.getKind() : 1;
            if (n2 == 1) {
                controller.userDroppedTopComponentsIntoEmptyEditor(topComponentArray);
            } else if (object == "top" || object == "left" || object == "right" || object == "bottom") {
                controller.userDroppedTopComponentsAroundEditor(topComponentArray, (String)object);
            } else if (Constants.SWITCH_MODE_ADD_NO_RESTRICT || WindowManagerImpl.getInstance().isTopComponentAllowedToMoveAnywhere(topComponentArray[0])) {
                controller.userDroppedTopComponentsIntoEmptyEditor(topComponentArray);
            }
        } else if (viewElement instanceof ModeView) {
            ModeView modeView = (ModeView)viewElement;
            if (object == "top" || object == "left" || object == "right" || object == "bottom") {
                controller.userDroppedTopComponents(modeView, topComponentArray, (String)object);
            } else if (object instanceof Integer) {
                controller.userDroppedTopComponents(modeView, topComponentArray, (Integer)object);
            } else {
                controller.userDroppedTopComponents(modeView, topComponentArray);
            }
        } else if (viewElement == null) {
            if (object == "top" || object == "left" || object == "right" || object == "bottom") {
                controller.userDroppedTopComponentsAround(topComponentArray, (String)object);
            } else if (object instanceof Rectangle) {
                Rectangle rectangle = (Rectangle)object;
                Container container = SwingUtilities.getAncestorOfClass(ModeComponent.class, (Component)topComponentArray[0]);
                if (container != null) {
                    rectangle.setSize(container.getWidth(), container.getHeight());
                }
                controller.userDroppedTopComponentsIntoFreeArea(topComponentArray, rectangle);
            }
        }
        return true;
    }

    private class CenterPanelDroppable
    implements TopComponentDroppable {
        private CenterPanelDroppable() {
        }

        public Shape getIndicationForLocation(Point point) {
            Rectangle rectangle = this.getDropComponent().getBounds();
            Rectangle rectangle2 = null;
            double d = 0.25;
            Object object = this.getConstraintForLocation(point);
            if (object == "left") {
                rectangle2 = new Rectangle(0, 0, (int)((double)rectangle.width * d) - 1, rectangle.height - 1);
            } else if (object == "top") {
                rectangle2 = new Rectangle(0, 0, rectangle.width - 1, (int)((double)rectangle.height * d) - 1);
            } else if (object == "right") {
                rectangle2 = new Rectangle(rectangle.width - (int)((double)rectangle.width * d), 0, (int)((double)rectangle.width * d) - 1, rectangle.height - 1);
            } else if (object == "bottom") {
                rectangle2 = new Rectangle(0, rectangle.height - (int)((double)rectangle.height * d), rectangle.width - 1, (int)((double)rectangle.height * d) - 1);
            }
            return rectangle2;
        }

        public Object getConstraintForLocation(Point point) {
            Rectangle rectangle = this.getDropComponent().getBounds();
            Component component = WindowDnDManager.this.viewAccessor.getSlidingModeComponent("left");
            Component component2 = WindowDnDManager.this.viewAccessor.getSlidingModeComponent("right");
            Component component3 = WindowDnDManager.this.viewAccessor.getSlidingModeComponent("bottom");
            if (null != component && point.x < component.getBounds().width + 10) {
                return "left";
            }
            if (point.y < rectangle.y) {
                return "top";
            }
            if (null != component2 && null != component && point.x > rectangle.width - 10 - component2.getBounds().width - component.getBounds().width) {
                return "right";
            }
            if (null != component3 && point.y > rectangle.height - 10 - component3.getBounds().height) {
                return "bottom";
            }
            return null;
        }

        public Component getDropComponent() {
            return ((MainWindow)WindowManagerImpl.getInstance().getMainWindow()).getDesktop();
        }

        public ViewElement getDropViewElement() {
            return null;
        }

        public boolean canDrop(TopComponent topComponent, Point point) {
            if (Constants.SWITCH_MODE_ADD_NO_RESTRICT || WindowManagerImpl.getInstance().isTopComponentAllowedToMoveAnywhere(topComponent)) {
                return true;
            }
            ModeImpl modeImpl = (ModeImpl)WindowManagerImpl.getInstance().findMode(topComponent);
            return modeImpl != null && (modeImpl.getKind() == 0 || modeImpl.getKind() == 2);
        }

        public boolean supportsKind(int n, TopComponent topComponent) {
            if (Constants.SWITCH_MODE_ADD_NO_RESTRICT || WindowManagerImpl.getInstance().isTopComponentAllowedToMoveAnywhere(topComponent)) {
                return true;
            }
            return n == 0 || n == 2;
        }
    }

    private static class CenterSlidingDroppable
    implements TopComponentDroppable,
    EnhancedDragPainter {
        private ViewAccessor accesor;
        private TopComponentDroppable original;
        private String side;
        JPanel pan;
        private boolean isShowing;

        public CenterSlidingDroppable(ViewAccessor viewAccessor, TopComponentDroppable topComponentDroppable, String string) {
            this.original = topComponentDroppable;
            this.accesor = viewAccessor;
            this.side = string;
            this.pan = new JPanel();
            this.isShowing = false;
        }

        public boolean canDrop(TopComponent topComponent, Point point) {
            return this.original.canDrop(topComponent, point);
        }

        public Object getConstraintForLocation(Point point) {
            return this.original.getConstraintForLocation(point);
        }

        public Component getDropComponent() {
            return this.original.getDropComponent();
        }

        public ViewElement getDropViewElement() {
            return this.original.getDropViewElement();
        }

        public Shape getIndicationForLocation(Point point) {
            Shape shape = this.original.getIndicationForLocation(point);
            Rectangle rectangle = this.original.getDropComponent().getBounds();
            if (rectangle.width < 10 || rectangle.height < 10) {
                Rectangle rectangle2 = shape.getBounds();
                if ("left".equals(this.side)) {
                    shape = new Rectangle(0, 0, Math.max(rectangle2.width, 20), Math.max(rectangle2.height, 20));
                } else if ("right".equals(this.side)) {
                    shape = new Rectangle(-20, 0, Math.max(rectangle2.width, 20), Math.max(rectangle2.height, 20));
                } else if ("bottom".equals(this.side)) {
                    shape = new Rectangle(0, -20, Math.max(rectangle2.width, 20), Math.max(rectangle2.height, 20));
                }
            }
            return shape;
        }

        public boolean isWithinSlide(Point point) {
            JRootPane jRootPane = SwingUtilities.getRootPane(this.original.getDropComponent());
            Point point2 = SwingUtilities.convertPoint(jRootPane, point, this.original.getDropComponent());
            if (this.original.getDropComponent().contains(point2)) {
                return true;
            }
            if ("left".equals(this.side)) {
                Dimension dimension = this.original.getDropComponent().getSize();
                int n = Math.abs(point2.x);
                if (this.isShowing && n < 20) {
                    return true;
                }
                if (!this.isShowing && point2.x <= 0 && point2.x > -20) {
                    return true;
                }
            } else if ("right".equals(this.side)) {
                Dimension dimension = this.original.getDropComponent().getSize();
                if (this.isShowing && (point2.x < 0 && point2.x > -20 || point2.x > 0 && point2.x - dimension.width < 20)) {
                    return true;
                }
                if (!this.isShowing && point2.x >= 0 && point2.x < 20 + dimension.width) {
                    return true;
                }
            } else if ("bottom".equals(this.side)) {
                Dimension dimension = this.original.getDropComponent().getSize();
                if (this.isShowing && (point2.y < 0 && point2.y > -20 || point2.y > 0 && point2.y - dimension.height < 20)) {
                    return true;
                }
                if (!this.isShowing && point2.y >= 0 && point2.y < 20 + dimension.height) {
                    return true;
                }
            }
            return false;
        }

        public boolean supportsKind(int n, TopComponent topComponent) {
            return this.original.supportsKind(n, topComponent);
        }

        public void additionalDragPaint(Graphics2D graphics2D) {
            Point point;
            Point point2;
            Rectangle rectangle = this.original.getDropComponent().getBounds();
            if (rectangle.width > 10 && rectangle.height > 10) {
                return;
            }
            this.isShowing = true;
            Component component = ((JComponent)this.original.getDropComponent()).getRootPane().getGlassPane();
            Point point3 = SwingUtilities.convertPoint(this.original.getDropComponent(), 0, 0, component);
            if ("right".equals(this.side)) {
                point3 = new Point(point3.x - 24, point3.y);
                point2 = new Point(point3);
                point = new Point(point3.x, point3.y + rectangle.height);
            } else if ("bottom".equals(this.side)) {
                point3 = new Point(0, point3.y - 24);
                point2 = new Point(point3);
                point = new Point(point3.x + component.getBounds().width, point3.y);
            } else {
                point2 = new Point(point3.x + 25, point3.y);
                point = new Point(point3.x + 25, point3.y + rectangle.height);
            }
            Rectangle rectangle2 = new Rectangle(point3.x, point3.y, Math.max(25, rectangle.width), Math.max(25, rectangle.height));
            if ("bottom".equals(this.side)) {
                rectangle2.width = component.getBounds().width;
            }
            Color color = graphics2D.getColor();
            graphics2D.setColor(this.pan.getBackground());
            graphics2D.fill(rectangle2);
            graphics2D.setColor(this.pan.getBackground().darker());
            graphics2D.drawLine(point2.x, point2.y, point.x, point.y);
            graphics2D.setColor(color);
        }
    }

    private static class FreeAreaDroppable
    implements TopComponentDroppable {
        private Point location;

        public FreeAreaDroppable(Point point) {
            this.location = point;
        }

        public Shape getIndicationForLocation(Point point) {
            return null;
        }

        public Object getConstraintForLocation(Point point) {
            return new Rectangle(this.location.x, this.location.y, Constants.DROP_NEW_MODE_SIZE.width, Constants.DROP_NEW_MODE_SIZE.height);
        }

        public Component getDropComponent() {
            return null;
        }

        public ViewElement getDropViewElement() {
            return null;
        }

        public boolean canDrop(TopComponent topComponent, Point point) {
            ModeImpl modeImpl = (ModeImpl)WindowManagerImpl.getInstance().findMode(topComponent);
            return modeImpl != null && (modeImpl.getKind() == 0 || modeImpl.getKind() == 2);
        }

        public boolean supportsKind(int n, TopComponent topComponent) {
            if (Constants.SWITCH_MODE_ADD_NO_RESTRICT || WindowManagerImpl.getInstance().isTopComponentAllowedToMoveAnywhere(topComponent)) {
                return true;
            }
            return n == 0 || n == 2;
        }
    }

    private static class MotionListener
    implements DragSourceMotionListener {
        private final WindowDnDManager windowDnDManager;
        private final TopComponentDragSupport topComponentDragSupport;

        private MotionListener(WindowDnDManager windowDnDManager, TopComponentDragSupport topComponentDragSupport) {
            this.windowDnDManager = windowDnDManager;
            this.topComponentDragSupport = topComponentDragSupport;
        }

        public void dragMouseMoved(DragSourceDragEvent dragSourceDragEvent) {
            Point point;
            if (DEBUG) {
                WindowDnDManager.debugLog("dragMouseMoved evt=" + dragSourceDragEvent);
            }
            if ((point = dragSourceDragEvent.getLocation()) == null) {
                return;
            }
            ModeImpl modeImpl = (ModeImpl)WindowManagerImpl.getInstance().findMode(this.windowDnDManager.startingTransfer);
            int n = modeImpl != null ? modeImpl.getKind() : 1;
            boolean bl = this.windowDnDManager.isInMainWindowDroppable(point, n, this.windowDnDManager.startingTransfer);
            boolean bl2 = WindowDnDManager.isInFloatingFrameDroppable(this.windowDnDManager.getFloatingFrames(), point, n, this.windowDnDManager.startingTransfer);
            boolean bl3 = WindowDnDManager.isAroundCenterPanel(point);
            if (bl || bl2 || bl3) {
                TopComponentDroppable topComponentDroppable = this.windowDnDManager.findDroppableFromScreen(this.windowDnDManager.getFloatingFrames(), point, n, this.windowDnDManager.startingTransfer);
                if (topComponentDroppable instanceof FreeAreaDroppable) {
                    if (WindowManagerImpl.getInstance().getEditorAreaState() == 1 && topComponentDroppable.canDrop(this.windowDnDManager.startingTransfer, point)) {
                        this.topComponentDragSupport.setSuccessCursor();
                    } else {
                        this.topComponentDragSupport.setUnsuccessCursor();
                    }
                } else if (topComponentDroppable != null) {
                    JComponent jComponent = (JComponent)topComponentDroppable.getDropComponent();
                    Component component = jComponent.getRootPane().getGlassPane();
                    if (component instanceof DropTargetGlassPane) {
                        this.windowDnDManager.setLastDropTarget((DropTargetGlassPane)component);
                    }
                    Point point2 = new Point(point);
                    SwingUtilities.convertPointFromScreen(point2, topComponentDroppable.getDropComponent());
                    if (topComponentDroppable.canDrop(this.windowDnDManager.startingTransfer, point2)) {
                        this.topComponentDragSupport.setSuccessCursor();
                    } else {
                        this.topComponentDragSupport.setUnsuccessCursor();
                    }
                    this.dragOverDropTarget(point, topComponentDroppable);
                }
            } else if (!WindowDnDManager.isInMainWindow(point) && this.windowDnDManager.isInFloatingFrame(point)) {
                this.topComponentDragSupport.setSuccessCursor();
            } else if (WindowDnDManager.isInFreeArea(point) && WindowManagerImpl.getInstance().getEditorAreaState() == 1 && WindowDnDManager.getFreeAreaDroppable(point).canDrop(this.windowDnDManager.startingTransfer, point)) {
                this.topComponentDragSupport.setSuccessCursor();
            } else {
                this.topComponentDragSupport.setUnsuccessCursor();
            }
            if (!(bl || bl2 || bl3)) {
                this.clearExitedDropTarget();
            }
        }

        private void dragOverDropTarget(Point point, TopComponentDroppable topComponentDroppable) {
            DropTargetGlassPane dropTargetGlassPane = (DropTargetGlassPane)this.windowDnDManager.lastTargetWRef.get();
            if (dropTargetGlassPane != null) {
                Point point2 = new Point(point);
                SwingUtilities.convertPointFromScreen(point2, dropTargetGlassPane);
                dropTargetGlassPane.dragOver(point2, topComponentDroppable);
            }
        }

        private void clearExitedDropTarget() {
            DropTargetGlassPane dropTargetGlassPane = (DropTargetGlassPane)this.windowDnDManager.lastTargetWRef.get();
            if (dropTargetGlassPane != null) {
                dropTargetGlassPane.clearIndications();
                this.windowDnDManager.lastTargetWRef = new WeakReference<Object>(null);
            }
        }

        private static DropTargetGlassPane getMainDropTargetGlassPane() {
            Component component = ((JFrame)WindowManagerImpl.getInstance().getMainWindow()).getGlassPane();
            if (component instanceof DropTargetGlassPane) {
                return (DropTargetGlassPane)component;
            }
            return null;
        }
    }

    public static interface ViewAccessor {
        public Set getModeComponents();

        public Set getSeparateModeFrames();

        public Controller getController();

        public Component getSlidingModeComponent(String var1);
    }
}

