/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.windows.model;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.netbeans.core.windows.WindowManagerImpl;
import org.openide.windows.TopComponent;

final class TopComponentSubModel {
    private final List openedTopComponents = new ArrayList(10);
    private final List tcIDs = new ArrayList(10);
    private final int kind;
    private String selectedTopComponentID;
    private static final String IS_SLIDING = "isSliding";
    static final /* synthetic */ boolean $assertionsDisabled;

    public TopComponentSubModel(int n) {
        this.kind = n;
    }

    public List getTopComponents() {
        ArrayList arrayList = new ArrayList(this.openedTopComponents);
        ArrayList arrayList2 = new ArrayList(this.tcIDs);
        ArrayList<TopComponent> arrayList3 = new ArrayList<TopComponent>(arrayList2.size());
        Iterator iterator = arrayList2.iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            TopComponent topComponent = TopComponentSubModel.getTopComponent(string);
            if (topComponent != null) {
                arrayList3.add(topComponent);
                continue;
            }
            iterator.remove();
        }
        arrayList3.removeAll(this.openedTopComponents);
        arrayList.addAll(arrayList3);
        return arrayList;
    }

    public List getOpenedTopComponents() {
        return new ArrayList(this.openedTopComponents);
    }

    public boolean addOpenedTopComponent(TopComponent topComponent) {
        if (this.openedTopComponents.contains(topComponent)) {
            return false;
        }
        String string = TopComponentSubModel.getID(topComponent);
        int n = this.tcIDs.indexOf(string);
        int n2 = n < 0 || n > this.openedTopComponents.size() ? this.openedTopComponents.size() : n;
        TopComponent topComponent2 = TopComponentSubModel.getTopComponent(string);
        if (topComponent2 != topComponent) {
            String string2 = "Model in inconsistent state, generated TC ID=" + string + " for " + topComponent.getClass() + ":" + topComponent.hashCode() + " but" + " that ID is reserved for TC=" + topComponent2.getClass() + ":" + topComponent2.hashCode();
            if (!$assertionsDisabled) {
                throw new AssertionError((Object)string2);
            }
        }
        this.openedTopComponents.add(n2, topComponent);
        if (!this.tcIDs.contains(string)) {
            this.tcIDs.add(string);
        }
        if (this.selectedTopComponentID == null && !this.isNullSelectionAllowed()) {
            this.selectedTopComponentID = string;
        }
        if (this.kind == 2) {
            this.setSlidingProperty(topComponent);
        } else {
            this.clearSlidingProperty(topComponent);
        }
        return true;
    }

    public boolean insertOpenedTopComponent(TopComponent topComponent, int n) {
        if (n >= 0 && !this.openedTopComponents.isEmpty() && this.openedTopComponents.size() > n && this.openedTopComponents.get(n) == topComponent) {
            return false;
        }
        this.openedTopComponents.remove(topComponent);
        int n2 = n;
        if (n2 < 0) {
            n2 = 0;
        } else if (n2 > this.openedTopComponents.size()) {
            n2 = this.openedTopComponents.size();
        }
        String string = TopComponentSubModel.getID(topComponent);
        this.tcIDs.remove(string);
        this.openedTopComponents.add(n2, topComponent);
        if (n2 == 0) {
            this.tcIDs.add(0, string);
        } else {
            TopComponent topComponent2 = (TopComponent)this.openedTopComponents.get(n2 - 1);
            int n3 = this.tcIDs.indexOf(TopComponentSubModel.getID(topComponent2));
            this.tcIDs.add(n3 + 1, string);
        }
        if (this.selectedTopComponentID == null && !this.isNullSelectionAllowed()) {
            this.selectedTopComponentID = TopComponentSubModel.getID(topComponent);
        }
        if (this.kind == 2) {
            this.setSlidingProperty(topComponent);
        } else {
            this.clearSlidingProperty(topComponent);
        }
        return true;
    }

    public boolean addClosedTopComponent(TopComponent topComponent) {
        int n = this.openedTopComponents.indexOf(topComponent);
        String string = TopComponentSubModel.getID(topComponent);
        if (!this.tcIDs.contains(string)) {
            this.tcIDs.add(string);
        }
        if (n != -1) {
            this.openedTopComponents.remove(topComponent);
            if (this.selectedTopComponentID != null && this.selectedTopComponentID.equals(TopComponentSubModel.getID(topComponent))) {
                this.adjustSelectedTopComponent(n);
            }
        }
        if (this.kind == 2) {
            this.setSlidingProperty(topComponent);
        } else {
            this.clearSlidingProperty(topComponent);
        }
        return true;
    }

    public boolean addUnloadedTopComponent(String string) {
        if (!this.tcIDs.contains(string)) {
            this.tcIDs.add(string);
        }
        return true;
    }

    public boolean removeTopComponent(TopComponent topComponent) {
        boolean bl;
        String string = TopComponentSubModel.getID(topComponent);
        if (this.openedTopComponents.contains(topComponent)) {
            if (this.selectedTopComponentID != null && this.selectedTopComponentID.equals(string)) {
                int n = this.openedTopComponents.indexOf(TopComponentSubModel.getTopComponent(this.selectedTopComponentID));
                this.openedTopComponents.remove(topComponent);
                this.adjustSelectedTopComponent(n);
            } else {
                this.openedTopComponents.remove(topComponent);
            }
            this.tcIDs.remove(string);
            bl = true;
        } else if (this.tcIDs.contains(string)) {
            this.tcIDs.remove(string);
            bl = true;
        } else {
            bl = false;
        }
        this.clearSlidingProperty(topComponent);
        return bl;
    }

    public boolean containsTopComponent(TopComponent topComponent) {
        return this.openedTopComponents.contains(topComponent) || this.tcIDs.contains(TopComponentSubModel.getID(topComponent));
    }

    public boolean isEmpty() {
        return this.tcIDs.isEmpty();
    }

    private void adjustSelectedTopComponent(int n) {
        if (this.openedTopComponents.isEmpty() || this.isNullSelectionAllowed()) {
            this.selectedTopComponentID = null;
            return;
        }
        if (n > this.openedTopComponents.size() - 1) {
            n = this.openedTopComponents.size() - 1;
        }
        this.selectedTopComponentID = TopComponentSubModel.getID((TopComponent)this.openedTopComponents.get(n));
    }

    private boolean isNullSelectionAllowed() {
        return this.kind == 2;
    }

    public void setSelectedTopComponent(TopComponent topComponent) {
        if (topComponent != null && !this.openedTopComponents.contains(topComponent)) {
            return;
        }
        this.selectedTopComponentID = topComponent == null && this.isNullSelectionAllowed() ? null : TopComponentSubModel.getID(topComponent);
    }

    public void setUnloadedSelectedTopComponent(String string) {
        if (string != null && !this.getOpenedTopComponentsIDs().contains(string)) {
            return;
        }
        this.selectedTopComponentID = string;
    }

    public List getOpenedTopComponentsIDs() {
        ArrayList<String> arrayList = new ArrayList<String>(this.openedTopComponents.size());
        Iterator iterator = this.openedTopComponents.iterator();
        while (iterator.hasNext()) {
            arrayList.add(TopComponentSubModel.getID((TopComponent)iterator.next()));
        }
        return arrayList;
    }

    public List getClosedTopComponentsIDs() {
        ArrayList arrayList = new ArrayList(this.tcIDs);
        arrayList.removeAll(this.getOpenedTopComponentsIDs());
        return arrayList;
    }

    public List getTopComponentsIDs() {
        return new ArrayList(this.tcIDs);
    }

    public void removeClosedTopComponentID(String string) {
        this.tcIDs.remove(string);
    }

    public TopComponent getSelectedTopComponent() {
        return TopComponentSubModel.getTopComponent(this.selectedTopComponentID);
    }

    private static TopComponent getTopComponent(String string) {
        return WindowManagerImpl.getInstance().getTopComponentForID(string);
    }

    private static String getID(TopComponent topComponent) {
        return WindowManagerImpl.getInstance().findTopComponentID(topComponent);
    }

    private void setSlidingProperty(TopComponent topComponent) {
        topComponent.putClientProperty((Object)IS_SLIDING, (Object)Boolean.TRUE);
    }

    private void clearSlidingProperty(TopComponent topComponent) {
        topComponent.putClientProperty((Object)IS_SLIDING, null);
    }

    static {
        $assertionsDisabled = !TopComponentSubModel.class.desiredAssertionStatus();
    }
}

