/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.windows;

import java.awt.Frame;
import java.awt.Image;
import java.awt.Rectangle;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.net.URL;
import java.util.Iterator;
import java.util.Set;
import javax.swing.Action;
import javax.swing.SwingUtilities;
import org.netbeans.core.windows.Central;
import org.netbeans.core.windows.ModeImpl;
import org.netbeans.core.windows.PersistenceHandler;
import org.netbeans.core.windows.RecentViewList;
import org.netbeans.core.windows.RegistryImpl;
import org.netbeans.core.windows.SplitConstraint;
import org.netbeans.core.windows.TopComponentGroupImpl;
import org.netbeans.core.windows.UIModeHandler;
import org.netbeans.core.windows.actions.ActionUtils;
import org.netbeans.core.windows.persistence.PersistenceManager;
import org.netbeans.core.windows.persistence.PersistenceObserver;
import org.openide.ErrorManager;
import org.openide.nodes.Node;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.windows.Mode;
import org.openide.windows.TopComponent;
import org.openide.windows.TopComponentGroup;
import org.openide.windows.WindowManager;
import org.openide.windows.Workspace;

public final class WindowManagerImpl
extends WindowManager
implements Workspace {
    public static final String PROP_ACTIVE_MODE = "activeMode";
    public static final String PROP_MAXIMIZED_MODE = "maximizedMode";
    public static final String PROP_EDITOR_AREA_STATE = "editorAreaState";
    private static final Object LOCK_INIT;
    private static WindowManagerImpl defaultInstance;
    private final Central central = new Central();
    private final PropertyChangeSupport changeSupport = new PropertyChangeSupport((Object)this);
    private final RecentViewList recentViewList = new RecentViewList(this);
    private final UIModeHandler uiModeHandler = new UIModeHandler();
    private TopComponent persistenceShowingTC;
    private static final boolean NAME_HACK;
    private static final String ASSERTION_ERROR_MESSAGE = "WindowsAPI is required to be called from AWT thread only, see http://www.netbeans.org/download/dev/javadoc/OpenAPIs/org/openide/doc-files/threading.html";
    static final /* synthetic */ boolean $assertionsDisabled;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WindowManagerImpl() {
        Object object = LOCK_INIT;
        synchronized (object) {
            if (defaultInstance != null) {
                throw new IllegalStateException("Instance already exists");
            }
            defaultInstance = this;
        }
    }

    public static WindowManagerImpl getInstance() {
        if (defaultInstance != null) {
            return defaultInstance;
        }
        return (WindowManagerImpl)((Object)Lookup.getDefault().lookup(WindowManager.class));
    }

    public void topComponentRequestAttention(TopComponent topComponent) {
        ModeImpl modeImpl = (ModeImpl)this.findMode(topComponent);
        this.central.topComponentRequestAttention(modeImpl, topComponent);
    }

    public void topComponentCancelRequestAttention(TopComponent topComponent) {
        ModeImpl modeImpl = (ModeImpl)this.findMode(topComponent);
        this.central.topComponentCancelRequestAttention(modeImpl, topComponent);
    }

    public Frame getMainWindow() {
        WindowManagerImpl.assertEventDispatchThreadWeak();
        return this.central.getMainWindow();
    }

    public void updateUI() {
        WindowManagerImpl.assertEventDispatchThreadWeak();
        this.central.updateUI();
    }

    protected synchronized WindowManager.Component createTopComponentManager(TopComponent topComponent) {
        WindowManagerImpl.assertEventDispatchThreadWeak();
        return null;
    }

    public Workspace createWorkspace(String string, String string2) {
        WindowManagerImpl.assertEventDispatchThreadWeak();
        return this;
    }

    public Workspace findWorkspace(String string) {
        WindowManagerImpl.assertEventDispatchThreadWeak();
        return this;
    }

    public Workspace[] getWorkspaces() {
        WindowManagerImpl.assertEventDispatchThreadWeak();
        return new Workspace[]{this};
    }

    public void setWorkspaces(Workspace[] workspaceArray) {
        WindowManagerImpl.assertEventDispatchThreadWeak();
    }

    public Workspace getCurrentWorkspace() {
        WindowManagerImpl.assertEventDispatchThreadWeak();
        return this;
    }

    public TopComponentGroup findTopComponentGroup(String string) {
        WindowManagerImpl.assertEventDispatchThread();
        Iterator iterator = this.getTopComponentGroups().iterator();
        while (iterator.hasNext()) {
            TopComponentGroupImpl topComponentGroupImpl = (TopComponentGroupImpl)iterator.next();
            if (!topComponentGroupImpl.getName().equals(string)) continue;
            return topComponentGroupImpl;
        }
        return null;
    }

    public TopComponent findTopComponent(String string) {
        WindowManagerImpl.assertEventDispatchThreadWeak();
        return this.getTopComponentForID(string);
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.changeSupport.addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.changeSupport.removePropertyChangeListener(propertyChangeListener);
    }

    public String getName() {
        return "FakeWorkspace";
    }

    public String getDisplayName() {
        return NbBundle.getMessage((Class)WindowManagerImpl.class, (String)"LBL_FakeWorkspace");
    }

    public Set getModes() {
        return this.central.getModes();
    }

    public Rectangle getBounds() {
        if (this.getEditorAreaState() == 0) {
            return this.getMainWindowBoundsJoined();
        }
        return this.getMainWindowBoundsSeparated();
    }

    public void activate() {
    }

    public Mode createMode(String string, String string2, URL uRL) {
        if (this.getEditorAreaState() == 0) {
            return new WrapMode(this.createMode(string, 1, false, null));
        }
        return this.createMode(string, 0, false, new SplitConstraint[]{new SplitConstraint(1, 1, 0.2)});
    }

    public Mode findMode(String string) {
        return this.findModeImpl(string);
    }

    public Mode findMode(TopComponent topComponent) {
        if (topComponent == null) {
            return null;
        }
        Iterator iterator = this.getModes().iterator();
        while (iterator.hasNext()) {
            ModeImpl modeImpl = (ModeImpl)iterator.next();
            if (!modeImpl.containsTopComponent(topComponent)) continue;
            return modeImpl;
        }
        return null;
    }

    public void remove() {
    }

    public void addTopComponentGroup(TopComponentGroupImpl topComponentGroupImpl) {
        this.central.addTopComponentGroup(topComponentGroupImpl);
    }

    public void removeTopComponentGroup(TopComponentGroupImpl topComponentGroupImpl) {
        this.central.removeTopComponentGroup(topComponentGroupImpl);
    }

    public Set getTopComponentGroups() {
        return this.central.getTopComponentGroups();
    }

    public ModeImpl createMode(String string, int n, boolean bl, SplitConstraint[] splitConstraintArray) {
        ModeImpl modeImpl = (ModeImpl)this.findMode(string);
        if (modeImpl != null) {
            return modeImpl;
        }
        if (splitConstraintArray == null && n != 2) {
            if (n == 1) {
                return this.getDefaultEditorMode();
            }
            return this.getDefaultViewMode();
        }
        modeImpl = this.createModeImpl(string, n, bl);
        this.addMode(modeImpl, splitConstraintArray);
        return modeImpl;
    }

    public ModeImpl createSlidingMode(String string, boolean bl, String string2) {
        ModeImpl modeImpl = (ModeImpl)this.findMode(string);
        if (modeImpl != null) {
            return modeImpl;
        }
        modeImpl = this.createModeImpl(string, 2, bl);
        this.central.addSlidingMode(modeImpl, null, string2);
        return modeImpl;
    }

    ModeImpl createModeImpl(String string, int n, boolean bl) {
        if (string == null) {
            string = ModeImpl.getUnusedModeName();
        }
        int n2 = this.getEditorAreaState() == 0 ? 0 : 1;
        ModeImpl modeImpl = ModeImpl.createModeImpl(string, n2, n, bl);
        return modeImpl;
    }

    ModeImpl getDefaultEditorMode() {
        ModeImpl modeImpl = this.findModeImpl("editor");
        if (modeImpl == null) {
            ErrorManager.getDefault().notify(1, (Throwable)new IllegalStateException("Creating default editor mode. It shouldn't happen this way"));
            ModeImpl modeImpl2 = this.createModeImpl("editor", 1, true);
            this.addMode(modeImpl2, new SplitConstraint[0]);
            return modeImpl2;
        }
        return modeImpl;
    }

    ModeImpl getDefaultViewMode() {
        ModeImpl modeImpl = this.findModeImpl("explorer");
        if (modeImpl == null) {
            ErrorManager.getDefault().notify(1, (Throwable)new IllegalStateException("Creating default view mode. It shouldn't happen this way"));
            ModeImpl modeImpl2 = this.createModeImpl("explorer", 0, true);
            this.addMode(modeImpl2, new SplitConstraint[]{new SplitConstraint(0, 0, 0.7), new SplitConstraint(1, 0, 0.25)});
            return modeImpl2;
        }
        return modeImpl;
    }

    ModeImpl getDefaultSlidingMode() {
        ModeImpl modeImpl = this.findModeImpl("sliding");
        if (modeImpl == null) {
            ErrorManager.getDefault().notify(1, (Throwable)new IllegalStateException("Creating default sliding mode. It shouldn't happen this way"));
            ModeImpl modeImpl2 = this.createModeImpl("sliding", 2, true);
            this.addMode(modeImpl2, new SplitConstraint[]{new SplitConstraint(0, 0, 0.7), new SplitConstraint(1, 0, 0.25)});
            return modeImpl2;
        }
        return modeImpl;
    }

    private ModeImpl findModeImpl(String string) {
        if (string == null) {
            return null;
        }
        Iterator iterator = this.getModes().iterator();
        while (iterator.hasNext()) {
            ModeImpl modeImpl = (ModeImpl)iterator.next();
            if (!string.equals(modeImpl.getName())) continue;
            return modeImpl;
        }
        return null;
    }

    public TopComponent getSelectedTopComponent(Mode mode) {
        return this.central.getModeSelectedTopComponent((ModeImpl)mode);
    }

    public Rectangle getMainWindowBoundsJoined() {
        return this.central.getMainWindowBoundsJoined();
    }

    public void setMainWindowBoundsJoined(Rectangle rectangle) {
        this.central.setMainWindowBoundsJoined(rectangle);
    }

    public Rectangle getMainWindowBoundsSeparated() {
        return this.central.getMainWindowBoundsSeparated();
    }

    public void setMainWindowBoundsSeparated(Rectangle rectangle) {
        this.central.setMainWindowBoundsSeparated(rectangle);
    }

    public int getMainWindowFrameStateJoined() {
        return this.central.getMainWindowFrameStateJoined();
    }

    public void setMainWindowFrameStateJoined(int n) {
        this.central.setMainWindowFrameStateJoined(n);
    }

    public int getMainWindowFrameStateSeparated() {
        return this.central.getMainWindowFrameStateSeparated();
    }

    public void setMainWindowFrameStateSeparated(int n) {
        this.central.setMainWindowFrameStateSeparated(n);
    }

    public ModeImpl getActiveMode() {
        return this.central.getActiveMode();
    }

    public void setActiveMode(ModeImpl modeImpl) {
        this.central.setActiveMode(modeImpl);
    }

    public void setEditorAreaBounds(Rectangle rectangle) {
        this.central.setEditorAreaBounds(rectangle);
    }

    public Rectangle getEditorAreaBounds() {
        return this.central.getEditorAreaBounds();
    }

    public void setEditorAreaConstraints(SplitConstraint[] splitConstraintArray) {
        this.central.setEditorAreaConstraints(splitConstraintArray);
    }

    public SplitConstraint[] getEditorAreaConstraints() {
        return this.central.getEditorAreaConstraints();
    }

    public void setEditorAreaState(int n) {
        this.setEditorAreaStateImpl(n);
        this.uiModeHandler.setUIMode(n);
    }

    void setEditorAreaStateImpl(int n) {
        this.central.setEditorAreaState(n);
    }

    public int getEditorAreaState() {
        return this.central.getEditorAreaState();
    }

    public void setEditorAreaFrameState(int n) {
        this.central.setEditorAreaFrameState(n);
    }

    public int getEditorAreaFrameState() {
        return this.central.getEditorAreaFrameState();
    }

    public void setMaximizedMode(ModeImpl modeImpl) {
        this.central.setMaximizedMode(modeImpl);
    }

    public ModeImpl getMaximizedMode() {
        return this.central.getMaximizedMode();
    }

    public void setModeConstraints(ModeImpl modeImpl, SplitConstraint[] splitConstraintArray) {
        this.central.setModeConstraints(modeImpl, splitConstraintArray);
    }

    public SplitConstraint[] getModeConstraints(ModeImpl modeImpl) {
        return this.central.getModeConstraints(modeImpl);
    }

    private void addMode(ModeImpl modeImpl, SplitConstraint[] splitConstraintArray) {
        if (modeImpl.getKind() == 2) {
            this.central.addSlidingMode(modeImpl, null, "left");
        } else {
            this.central.addMode(modeImpl, splitConstraintArray);
        }
    }

    public void removeMode(ModeImpl modeImpl) {
        if (modeImpl.getKind() != 2) {
            this.central.removeMode(modeImpl);
        }
    }

    public void setToolbarConfigName(String string) {
        this.central.setToolbarConfigName(string);
    }

    public String getToolbarConfigName() {
        return this.central.getToolbarConfigName();
    }

    public void setVisible(boolean bl) {
        this.central.setVisible(bl);
    }

    public boolean isVisible() {
        return this.central.isVisible();
    }

    public void attachTopComponentToSide(TopComponent topComponent, ModeImpl modeImpl, String string) {
        this.central.attachTopComponentsToSide(new TopComponent[]{topComponent}, modeImpl, string);
    }

    boolean isTopComponentPersistentWhenClosed(TopComponent topComponent) {
        return PersistenceHandler.getDefault().isTopComponentPersistentWhenClosed(topComponent);
    }

    public TopComponent getTopComponentForID(String string) {
        return PersistenceHandler.getDefault().getTopComponentForID(string);
    }

    public boolean isTopComponentAllowedToMoveAnywhere(TopComponent topComponent) {
        return Boolean.TRUE.equals(topComponent.getClientProperty((Object)"TopComponentAllowDockAnywhere"));
    }

    public ModeImpl findModeForOpenedID(String string) {
        if (string == null) {
            return null;
        }
        Iterator iterator = this.getModes().iterator();
        while (iterator.hasNext()) {
            ModeImpl modeImpl = (ModeImpl)iterator.next();
            if (!modeImpl.getOpenedTopComponentsIDs().contains(string)) continue;
            return modeImpl;
        }
        return null;
    }

    public ModeImpl findModeForClosedID(String string) {
        if (string == null) {
            return null;
        }
        Iterator iterator = this.getModes().iterator();
        while (iterator.hasNext()) {
            ModeImpl modeImpl = (ModeImpl)iterator.next();
            if (!modeImpl.getClosedTopComponentsIDs().contains(string)) continue;
            return modeImpl;
        }
        return null;
    }

    public void setProjectName(String string) {
        this.central.setProjectName(string);
    }

    public String getTopComponentDisplayName(TopComponent topComponent) {
        if (topComponent == null) {
            return null;
        }
        String string = topComponent.getHtmlDisplayName();
        if (string == null) {
            string = topComponent.getDisplayName();
        }
        if (string == null) {
            string = topComponent.getName();
        }
        if (NAME_HACK && string != null) {
            if (string.endsWith("*")) {
                if (string.startsWith("<html>")) {
                    string = string.substring(6);
                }
                string = "<html><b>" + string.substring(0, string.length() - 2);
            } else {
                int n = string.indexOf("[r/o]");
                if (n > 0) {
                    if (string.startsWith("<html>")) {
                        string = string.substring(6);
                        n -= 6;
                    }
                    int n2 = "[r/o]".length();
                    String string2 = "<html><font color='#555555'><i>" + string.substring(0, n - 1);
                    if (n + n2 < string.length()) {
                        string2 = string2 + string.substring(n + n2);
                    }
                    string = string2;
                }
            }
        }
        return string;
    }

    Central getCentral() {
        return this.central;
    }

    public boolean isDragInProgress() {
        return this.central.isDragInProgress();
    }

    public String guessSlideSide(TopComponent topComponent) {
        return this.central.guessSlideSide(topComponent);
    }

    public void setRecentViewList(TopComponent[] topComponentArray) {
        this.recentViewList.setTopComponents(topComponentArray);
    }

    public TopComponent[] getRecentViewList() {
        return this.recentViewList.getTopComponents();
    }

    void doFirePropertyChange(final String string, final Object object, final Object object2) {
        if (SwingUtilities.isEventDispatchThread()) {
            this.changeSupport.firePropertyChange(string, object, object2);
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    WindowManagerImpl.this.changeSupport.firePropertyChange(string, object, object2);
                }
            });
        }
    }

    public PersistenceObserver getPersistenceObserver() {
        return PersistenceHandler.getDefault();
    }

    public void notifyTopComponentOpened(TopComponent topComponent) {
        this.componentOpenNotify(topComponent);
        WindowManagerImpl.notifyRegistryTopComponentOpened(topComponent);
    }

    public void notifyTopComponentClosed(TopComponent topComponent) {
        this.componentCloseNotify(topComponent);
        WindowManagerImpl.notifyRegistryTopComponentClosed(topComponent);
    }

    static void notifyRegistryTopComponentActivated(final TopComponent topComponent) {
        ((RegistryImpl)WindowManagerImpl.getDefault().getRegistry()).topComponentActivated(topComponent);
        if (SwingUtilities.isEventDispatchThread()) {
            WindowManagerImpl.getInstance().activateComponent(topComponent);
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    WindowManagerImpl.getInstance().activateComponent(topComponent);
                }
            });
        }
    }

    private static void notifyRegistryTopComponentOpened(TopComponent topComponent) {
        ((RegistryImpl)WindowManagerImpl.getDefault().getRegistry()).topComponentOpened(topComponent);
    }

    private static void notifyRegistryTopComponentClosed(TopComponent topComponent) {
        ((RegistryImpl)WindowManagerImpl.getDefault().getRegistry()).topComponentClosed(topComponent);
    }

    private static void notifyRegistrySelectedNodesChanged(TopComponent topComponent, Node[] nodeArray) {
        ((RegistryImpl)WindowManagerImpl.getDefault().getRegistry()).selectedNodesChanged(topComponent, nodeArray);
    }

    public void componentShowing(TopComponent topComponent) {
        if (topComponent != null && topComponent != this.persistenceShowingTC) {
            super.componentShowing(topComponent);
        }
    }

    void specialPersistenceCompShow(TopComponent topComponent) {
        this.componentShowing(topComponent);
        this.persistenceShowingTC = topComponent;
    }

    public void componentHidden(TopComponent topComponent) {
        if (topComponent != null) {
            super.componentHidden(topComponent);
            if (topComponent == this.persistenceShowingTC) {
                this.persistenceShowingTC = null;
            }
        }
    }

    protected void topComponentOpen(TopComponent topComponent) {
        ModeImpl modeImpl;
        WindowManagerImpl.assertEventDispatchThreadWeak();
        if (topComponent == null) {
            throw new IllegalArgumentException("Cannot open a null TopComponent");
        }
        ModeImpl modeImpl2 = this.getMode(topComponent);
        if (modeImpl2 == null) {
            modeImpl2 = this.getDefaultEditorMode();
            if (topComponent.getClientProperty((Object)"TopComponentAllowDockAnywhere") == null) {
                topComponent.putClientProperty((Object)"TopComponentAllowDockAnywhere", (Object)Boolean.TRUE);
            }
        }
        if ((modeImpl = this.getMaximizedMode()) != null && modeImpl2 != modeImpl && modeImpl2.getKind() != 2) {
            this.setMaximizedMode(null);
        }
        modeImpl2.addOpenedTopComponent(topComponent);
    }

    protected void topComponentClose(TopComponent topComponent) {
        WindowManagerImpl.assertEventDispatchThreadWeak();
        boolean bl = this.topComponentIsOpened(topComponent);
        if (!bl) {
            return;
        }
        ModeImpl modeImpl = this.getModeForOpenedTopComponent(topComponent);
        if (modeImpl != null) {
            modeImpl.close(topComponent);
        }
    }

    protected void topComponentRequestActive(TopComponent topComponent) {
        WindowManagerImpl.assertEventDispatchThreadWeak();
        ModeImpl modeImpl = this.getModeForOpenedTopComponent(topComponent);
        if (modeImpl != null) {
            this.central.activateModeTopComponent(modeImpl, topComponent);
        }
    }

    protected void topComponentRequestVisible(TopComponent topComponent) {
        WindowManagerImpl.assertEventDispatchThreadWeak();
        ModeImpl modeImpl = this.getModeForOpenedTopComponent(topComponent);
        if (modeImpl != null) {
            this.central.setModeSelectedTopComponent(modeImpl, topComponent);
        }
    }

    protected void topComponentDisplayNameChanged(TopComponent topComponent, String string) {
        WindowManagerImpl.assertEventDispatchThreadWeak();
        ModeImpl modeImpl = this.getModeForOpenedTopComponent(topComponent);
        if (modeImpl != null) {
            this.central.topComponentDisplayNameChanged(modeImpl, topComponent);
        }
    }

    protected void topComponentHtmlDisplayNameChanged(TopComponent topComponent, String string) {
        this.topComponentDisplayNameChanged(topComponent, null);
    }

    protected void topComponentToolTipChanged(TopComponent topComponent, String string) {
        WindowManagerImpl.assertEventDispatchThreadWeak();
        ModeImpl modeImpl = this.getModeForOpenedTopComponent(topComponent);
        if (modeImpl != null) {
            this.central.topComponentToolTipChanged(modeImpl, topComponent);
        }
    }

    protected void topComponentIconChanged(TopComponent topComponent, Image image) {
        WindowManagerImpl.assertEventDispatchThreadWeak();
        ModeImpl modeImpl = this.getModeForOpenedTopComponent(topComponent);
        if (modeImpl != null) {
            this.central.topComponentIconChanged(modeImpl, topComponent);
        }
    }

    protected void topComponentActivatedNodesChanged(TopComponent topComponent, Node[] nodeArray) {
        WindowManagerImpl.assertEventDispatchThreadWeak();
        WindowManagerImpl.notifyRegistrySelectedNodesChanged(topComponent, nodeArray);
    }

    protected boolean topComponentIsOpened(TopComponent topComponent) {
        WindowManagerImpl.assertEventDispatchThreadWeak();
        return this.getModeForOpenedTopComponent(topComponent) != null;
    }

    protected Action[] topComponentDefaultActions(TopComponent topComponent) {
        WindowManagerImpl.assertEventDispatchThreadWeak();
        return ActionUtils.createDefaultPopupActions(topComponent);
    }

    protected String topComponentID(TopComponent topComponent, String string) {
        WindowManagerImpl.assertEventDispatchThreadWeak();
        if (string == null) {
            ErrorManager.getDefault().notify(1, (Throwable)new IllegalStateException("Assertion failed. " + topComponent.getClass().getName() + ".preferredID method shouldn't be overriden to return null. " + "Please change your impl to return non-null string."));
        }
        return PersistenceManager.getDefault().getGlobalTopComponentID(topComponent, string);
    }

    private ModeImpl getMode(TopComponent topComponent) {
        return (ModeImpl)this.findMode(topComponent);
    }

    private ModeImpl getModeForOpenedTopComponent(TopComponent topComponent) {
        if (topComponent == null) {
            return null;
        }
        Iterator iterator = this.getModes().iterator();
        while (iterator.hasNext()) {
            ModeImpl modeImpl = (ModeImpl)iterator.next();
            if (!modeImpl.getOpenedTopComponents().contains(topComponent)) continue;
            return modeImpl;
        }
        return null;
    }

    public ModeImpl getPreviousModeForTopComponent(String string, ModeImpl modeImpl) {
        return this.getCentral().getModeTopComponentPreviousMode(string, modeImpl);
    }

    public void setPreviousModeForTopComponent(String string, ModeImpl modeImpl, ModeImpl modeImpl2) {
        this.getCentral().setModeTopComponentPreviousMode(string, modeImpl, modeImpl2);
    }

    static void assertEventDispatchThread() {
        if (!$assertionsDisabled && !SwingUtilities.isEventDispatchThread()) {
            throw new AssertionError((Object)ASSERTION_ERROR_MESSAGE);
        }
    }

    static void assertEventDispatchThreadWeak() {
        if (!SwingUtilities.isEventDispatchThread()) {
            ErrorManager.getDefault().notify(1, (Throwable)new IllegalStateException("Assertion failed. WindowsAPI is required to be called from AWT thread only, see http://www.netbeans.org/download/dev/javadoc/OpenAPIs/org/openide/doc-files/threading.html"));
        }
    }

    static {
        $assertionsDisabled = !WindowManagerImpl.class.desiredAssertionStatus();
        LOCK_INIT = new Object();
        NAME_HACK = Boolean.getBoolean("nb.tabnames.html");
    }

    private static class WrapMode
    implements Mode {
        private Mode wrap;

        public WrapMode(Mode mode) {
            this.wrap = mode;
        }

        public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
            this.wrap.addPropertyChangeListener(propertyChangeListener);
        }

        public boolean canDock(TopComponent topComponent) {
            return this.wrap.canDock(topComponent);
        }

        public boolean dockInto(TopComponent topComponent) {
            if (topComponent.getClientProperty((Object)"TopComponentAllowDockAnywhere") == null) {
                topComponent.putClientProperty((Object)"TopComponentAllowDockAnywhere", (Object)Boolean.TRUE);
            }
            return this.wrap.dockInto(topComponent);
        }

        public Rectangle getBounds() {
            return this.wrap.getBounds();
        }

        public String getDisplayName() {
            return this.wrap.getDisplayName();
        }

        public Image getIcon() {
            return this.wrap.getIcon();
        }

        public String getName() {
            return this.wrap.getName();
        }

        public TopComponent getSelectedTopComponent() {
            return this.wrap.getSelectedTopComponent();
        }

        public TopComponent[] getTopComponents() {
            return this.wrap.getTopComponents();
        }

        public Workspace getWorkspace() {
            return this.wrap.getWorkspace();
        }

        public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
            this.wrap.removePropertyChangeListener(propertyChangeListener);
        }

        public void setBounds(Rectangle rectangle) {
            this.wrap.setBounds(rectangle);
        }
    }
}

