/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.windows;

import java.awt.AWTKeyStroke;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.KeyEventDispatcher;
import java.awt.KeyEventPostProcessor;
import java.awt.KeyboardFocusManager;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.Set;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JMenuBar;
import javax.swing.KeyStroke;
import javax.swing.MenuElement;
import javax.swing.MenuSelectionManager;
import javax.swing.SwingUtilities;
import javax.swing.text.Keymap;
import org.netbeans.core.NbKeymap;
import org.netbeans.core.NbTopManager;
import org.netbeans.core.windows.WindowManagerImpl;
import org.netbeans.core.windows.view.ui.KeyboardPopupSwitcher;
import org.openide.actions.ActionManager;
import org.openide.util.Lookup;
import org.openide.util.Utilities;

final class ShortcutAndMenuKeyEventProcessor
implements KeyEventDispatcher,
KeyEventPostProcessor {
    private static ShortcutAndMenuKeyEventProcessor defaultInstance;
    private static boolean installed;
    private static Set defaultForward;
    private static Set defaultBackward;
    private boolean wasPopupDisplayed;
    private int lastModifiers;
    private char lastKeyChar;
    private boolean lastSampled = false;
    private boolean skipNextTyped = false;

    private ShortcutAndMenuKeyEventProcessor() {
    }

    private static synchronized ShortcutAndMenuKeyEventProcessor getDefault() {
        if (defaultInstance == null) {
            defaultInstance = new ShortcutAndMenuKeyEventProcessor();
        }
        return defaultInstance;
    }

    public static synchronized void install() {
        if (installed) {
            return;
        }
        ShortcutAndMenuKeyEventProcessor shortcutAndMenuKeyEventProcessor = ShortcutAndMenuKeyEventProcessor.getDefault();
        KeyboardFocusManager keyboardFocusManager = KeyboardFocusManager.getCurrentKeyboardFocusManager();
        keyboardFocusManager.addKeyEventDispatcher(shortcutAndMenuKeyEventProcessor);
        keyboardFocusManager.addKeyEventPostProcessor(shortcutAndMenuKeyEventProcessor);
        defaultForward = keyboardFocusManager.getDefaultFocusTraversalKeys(0);
        defaultBackward = keyboardFocusManager.getDefaultFocusTraversalKeys(1);
        keyboardFocusManager.setDefaultFocusTraversalKeys(0, Collections.singleton(AWTKeyStroke.getAWTKeyStroke(9, 0)));
        keyboardFocusManager.setDefaultFocusTraversalKeys(1, Collections.singleton(AWTKeyStroke.getAWTKeyStroke(9, 64)));
    }

    public static synchronized void uninstall() {
        if (!installed) {
            return;
        }
        ShortcutAndMenuKeyEventProcessor shortcutAndMenuKeyEventProcessor = ShortcutAndMenuKeyEventProcessor.getDefault();
        KeyboardFocusManager keyboardFocusManager = KeyboardFocusManager.getCurrentKeyboardFocusManager();
        keyboardFocusManager.removeKeyEventDispatcher(shortcutAndMenuKeyEventProcessor);
        keyboardFocusManager.removeKeyEventPostProcessor(shortcutAndMenuKeyEventProcessor);
        keyboardFocusManager.setDefaultFocusTraversalKeys(0, defaultForward);
        keyboardFocusManager.setDefaultFocusTraversalKeys(1, defaultBackward);
        defaultBackward = null;
        defaultForward = null;
    }

    public boolean postProcessKeyEvent(KeyEvent keyEvent) {
        if (keyEvent.isConsumed()) {
            return false;
        }
        if (this.processShortcut(keyEvent)) {
            return true;
        }
        Window window = SwingUtilities.windowForComponent(keyEvent.getComponent());
        if (window instanceof Dialog) {
            return false;
        }
        JFrame jFrame = (JFrame)WindowManagerImpl.getInstance().getMainWindow();
        if (window == jFrame) {
            return false;
        }
        JMenuBar jMenuBar = jFrame.getJMenuBar();
        if (jMenuBar == null) {
            return false;
        }
        boolean bl = keyEvent.getID() == 401;
        boolean bl2 = ShortcutAndMenuKeyEventProcessor.invokeProcessKeyBindingsForAllComponents(keyEvent, jFrame, bl);
        if (bl2) {
            keyEvent.consume();
        }
        return bl2;
    }

    public boolean dispatchKeyEvent(KeyEvent keyEvent) {
        MenuElement[] menuElementArray;
        int n;
        if (Utilities.getOperatingSystem() == 16 && (n = keyEvent.getModifiers()) == 4) {
            n = n & 0xFFFFFFFB | 8;
            keyEvent.setModifiers(n);
        }
        if (NbKeymap.getContext().length != 0) {
            if (keyEvent.getID() != 401) {
                keyEvent.consume();
                return true;
            }
            this.skipNextTyped = true;
            Component component = keyEvent.getComponent();
            if (!(component instanceof JComponent) || ((JComponent)component).getClientProperty("context-api-aware") == null) {
                this.processShortcut(keyEvent);
                return true;
            }
        }
        if (keyEvent.getID() == 401 && keyEvent.getModifiers() == 3 && (keyEvent.getKeyCode() == 19 || keyEvent.getKeyCode() == 3)) {
            Object object = keyEvent.getSource();
            if (object instanceof Component) {
                Window window = SwingUtilities.windowForComponent((Component)object);
                Component component = SwingUtilities.findFocusOwner(window);
                System.err.println("*** ShortcutAndMenuKeyEventProcessor: current focus owner = " + component);
            }
            keyEvent.consume();
            return true;
        }
        if (keyEvent.getID() == 400 && this.skipNextTyped) {
            keyEvent.consume();
            this.skipNextTyped = false;
            return true;
        }
        if (keyEvent.getID() == 402) {
            this.skipNextTyped = false;
        }
        if (keyEvent.getID() == 401) {
            this.lastKeyChar = keyEvent.getKeyChar();
            this.lastModifiers = keyEvent.getModifiers();
            this.lastSampled = true;
        }
        if ((menuElementArray = MenuSelectionManager.defaultManager().getSelectedPath()) == null || menuElementArray.length == 0) {
            this.wasPopupDisplayed = false;
            if (Utilities.isWindows() && keyEvent.getModifiers() == 1 && keyEvent.getKeyCode() == 121) {
                return this.processShortcut(keyEvent);
            }
            return KeyboardPopupSwitcher.processShortcut(keyEvent);
        }
        if (!this.wasPopupDisplayed && this.lastSampled && keyEvent.getID() == 400 && this.lastModifiers == 8 && keyEvent.getModifiers() == 8 && this.lastKeyChar == keyEvent.getKeyChar()) {
            this.wasPopupDisplayed = true;
            keyEvent.consume();
            return true;
        }
        this.wasPopupDisplayed = true;
        MenuSelectionManager.defaultManager().processKeyEvent(keyEvent);
        if (!keyEvent.isConsumed() && menuElementArray[0] instanceof JMenuBar) {
            keyEvent.setSource(WindowManagerImpl.getInstance().getMainWindow());
        }
        return keyEvent.isConsumed();
    }

    private boolean processShortcut(KeyEvent keyEvent) {
        NbTopManager.get();
        if (NbTopManager.isExiting()) {
            keyEvent.consume();
            return true;
        }
        KeyStroke keyStroke = KeyStroke.getKeyStrokeForEvent(keyEvent);
        Window window = SwingUtilities.windowForComponent(keyEvent.getComponent());
        if (window instanceof JFrame && ((JFrame)window).getRootPane().getClientProperty("netbeans.helpframe") != null) {
            return true;
        }
        if (window instanceof Dialog && !ShortcutAndMenuKeyEventProcessor.isTransmodalAction(keyStroke)) {
            return false;
        }
        ActionEvent actionEvent = new ActionEvent(keyEvent.getSource(), 1001, Utilities.keyToString((KeyStroke)keyStroke));
        Keymap keymap = (Keymap)Lookup.getDefault().lookup(Keymap.class);
        Action action = keymap.getAction(keyStroke);
        if (action != null && action.isEnabled()) {
            ActionManager actionManager = (ActionManager)Lookup.getDefault().lookup(ActionManager.class);
            actionManager.invokeAction(action, actionEvent);
            keyEvent.consume();
            return true;
        }
        return false;
    }

    private static boolean invokeProcessKeyBindingsForAllComponents(KeyEvent keyEvent, Container container, boolean bl) {
        try {
            Method method = JComponent.class.getDeclaredMethod("processKeyBindingsForAllComponents", KeyEvent.class, Container.class, Boolean.TYPE);
            if (method == null) {
                return false;
            }
            method.setAccessible(true);
            Boolean bl2 = (Boolean)method.invoke(null, keyEvent, container, bl ? Boolean.TRUE : Boolean.FALSE);
            return bl2;
        }
        catch (Exception exception) {
            return false;
        }
    }

    private static boolean isTransmodalAction(KeyStroke keyStroke) {
        Keymap keymap = (Keymap)Lookup.getDefault().lookup(Keymap.class);
        Action action = keymap.getAction(keyStroke);
        if (action == null) {
            return false;
        }
        Object object = action.getValue("OpenIDE-Transmodal-Action");
        return object != null && object.equals(Boolean.TRUE);
    }

    static {
        installed = false;
    }
}

