/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.windows;

import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.netbeans.core.windows.Constants;
import org.netbeans.core.windows.ModeImpl;
import org.netbeans.core.windows.model.ModelElement;
import org.openide.windows.TopComponent;

public class ModeStructureSnapshot {
    private final ElementSnapshot splitRootSnapshot;
    private final Set separateModeSnapshots;
    private final Set slidingModeSnapshots;

    public ModeStructureSnapshot(ElementSnapshot elementSnapshot, Set set, Set set2) {
        this.splitRootSnapshot = elementSnapshot;
        this.separateModeSnapshots = set;
        this.slidingModeSnapshots = set2;
    }

    public ElementSnapshot getSplitRootSnapshot() {
        return this.splitRootSnapshot;
    }

    public ModeSnapshot[] getSeparateModeSnapshots() {
        return this.separateModeSnapshots.toArray(new ModeSnapshot[0]);
    }

    public SlidingModeSnapshot[] getSlidingModeSnapshots() {
        return this.slidingModeSnapshots.toArray(new SlidingModeSnapshot[0]);
    }

    public ModeSnapshot findModeSnapshot(String string) {
        ModeSnapshot modeSnapshot = ModeStructureSnapshot.findModeSnapshotOfName(this.splitRootSnapshot, string);
        if (modeSnapshot != null) {
            return modeSnapshot;
        }
        Iterator iterator = this.separateModeSnapshots.iterator();
        while (iterator.hasNext()) {
            modeSnapshot = (ModeSnapshot)iterator.next();
            if (!string.equals(modeSnapshot.getName())) continue;
            return modeSnapshot;
        }
        iterator = this.slidingModeSnapshots.iterator();
        while (iterator.hasNext()) {
            modeSnapshot = (SlidingModeSnapshot)iterator.next();
            if (!string.equals(modeSnapshot.getName())) continue;
            return modeSnapshot;
        }
        return null;
    }

    private static ModeSnapshot findModeSnapshotOfName(ElementSnapshot elementSnapshot, String string) {
        EditorSnapshot editorSnapshot;
        ModeSnapshot modeSnapshot;
        if (elementSnapshot instanceof ModeSnapshot) {
            ModeSnapshot modeSnapshot2 = (ModeSnapshot)elementSnapshot;
            if (string.equals(modeSnapshot2.getName())) {
                return modeSnapshot2;
            }
        } else if (elementSnapshot instanceof SplitSnapshot) {
            SplitSnapshot splitSnapshot = (SplitSnapshot)elementSnapshot;
            Iterator iterator = splitSnapshot.getChildSnapshots().iterator();
            while (iterator.hasNext()) {
                ElementSnapshot elementSnapshot2 = (ElementSnapshot)iterator.next();
                ModeSnapshot modeSnapshot3 = ModeStructureSnapshot.findModeSnapshotOfName(elementSnapshot2, string);
                if (modeSnapshot3 == null) continue;
                return modeSnapshot3;
            }
        } else if (elementSnapshot instanceof EditorSnapshot && (modeSnapshot = ModeStructureSnapshot.findModeSnapshotOfName((editorSnapshot = (EditorSnapshot)elementSnapshot).getEditorAreaSnapshot(), string)) != null) {
            return modeSnapshot;
        }
        return null;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("\nModesSnapshot hashCode=" + Integer.toHexString(this.hashCode()));
        stringBuffer.append("\nSplit modes:\n");
        stringBuffer.append(ModeStructureSnapshot.dumpSnapshot(this.splitRootSnapshot, 0));
        stringBuffer.append("\nSeparate Modes:");
        stringBuffer.append(ModeStructureSnapshot.dumpSet(this.separateModeSnapshots));
        return stringBuffer.toString();
    }

    private static String dumpSnapshot(ElementSnapshot elementSnapshot, int n) {
        StringBuffer stringBuffer = new StringBuffer();
        String string = ModeStructureSnapshot.createIndentString(n);
        if (elementSnapshot instanceof SplitSnapshot) {
            SplitSnapshot splitSnapshot = (SplitSnapshot)elementSnapshot;
            stringBuffer.append(string + "split=" + splitSnapshot);
            ++n;
            Iterator iterator = splitSnapshot.getChildSnapshots().iterator();
            while (iterator.hasNext()) {
                ElementSnapshot elementSnapshot2 = (ElementSnapshot)iterator.next();
                stringBuffer.append("\n" + ModeStructureSnapshot.dumpSnapshot(elementSnapshot2, n));
            }
        } else if (elementSnapshot instanceof ModeSnapshot) {
            stringBuffer.append(string + "mode=" + elementSnapshot);
        } else if (elementSnapshot instanceof EditorSnapshot) {
            stringBuffer.append(string + "editor=" + elementSnapshot);
            stringBuffer.append(ModeStructureSnapshot.dumpSnapshot(((EditorSnapshot)elementSnapshot).getEditorAreaSnapshot(), ++n));
        }
        return stringBuffer.toString();
    }

    private static String createIndentString(int n) {
        StringBuffer stringBuffer = new StringBuffer(n);
        for (int i = 0; i < n; ++i) {
            stringBuffer.append(' ');
        }
        return stringBuffer.toString();
    }

    private static String dumpSet(Set set) {
        StringBuffer stringBuffer = new StringBuffer();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            stringBuffer.append("\nmode=" + iterator.next());
        }
        return stringBuffer.toString();
    }

    public static class EditorSnapshot
    extends ElementSnapshot {
        private final ElementSnapshot editorAreaSnapshot;
        private final double resizeWeight;

        public EditorSnapshot(ModelElement modelElement, SplitSnapshot splitSnapshot, ElementSnapshot elementSnapshot, double d) {
            super(modelElement, splitSnapshot);
            this.editorAreaSnapshot = elementSnapshot;
            this.resizeWeight = d;
        }

        public double getResizeWeight() {
            return this.resizeWeight;
        }

        public ElementSnapshot getEditorAreaSnapshot() {
            return this.editorAreaSnapshot;
        }

        public boolean isVisibleInSplit() {
            if (Constants.SWITCH_HIDE_EMPTY_DOCUMENT_AREA) {
                return this.editorAreaSnapshot.isVisibleInSplit();
            }
            return true;
        }

        public boolean hasVisibleDescendant() {
            return this.isVisibleInSplit();
        }

        public String toString() {
            return super.toString() + "\n" + this.editorAreaSnapshot;
        }
    }

    public static abstract class ElementSnapshot {
        private final ModelElement originator;
        private SplitSnapshot parent;

        public ElementSnapshot(ModelElement modelElement, SplitSnapshot splitSnapshot) {
            this.originator = modelElement;
            this.setParent(splitSnapshot);
        }

        public ModelElement getOriginator() {
            return this.originator;
        }

        public void setParent(SplitSnapshot splitSnapshot) {
            if (this.parent != null) {
                throw new IllegalStateException("Parent can be set only once, this.parent=" + this.parent + ", parent=" + splitSnapshot);
            }
            this.parent = splitSnapshot;
        }

        public SplitSnapshot getParent() {
            return this.parent;
        }

        public boolean originatorEquals(ElementSnapshot elementSnapshot) {
            return this.getClass().equals(elementSnapshot.getClass()) && elementSnapshot.originator == this.originator;
        }

        public abstract double getResizeWeight();

        public abstract boolean isVisibleInSplit();

        public abstract boolean hasVisibleDescendant();

        public String toString() {
            return "Snapshot[originatorHash=" + (this.originator != null ? Integer.toHexString(this.originator.hashCode()) : "null") + "]";
        }
    }

    public static class ModeSnapshot
    extends ElementSnapshot {
        private final ModeImpl mode;
        private final String name;
        private final int state;
        private final int kind;
        private final Rectangle bounds;
        private final int frameState;
        private final TopComponent selectedTopComponent;
        private final TopComponent[] openedTopComponents;
        private final double resizeWeight;

        public ModeSnapshot(ModelElement modelElement, SplitSnapshot splitSnapshot, ModeImpl modeImpl, double d) {
            super(modelElement, splitSnapshot);
            this.mode = modeImpl;
            this.name = modeImpl.getName();
            this.state = modeImpl.getState();
            this.kind = modeImpl.getKind();
            this.bounds = modeImpl.getBounds();
            this.frameState = modeImpl.getFrameState();
            this.selectedTopComponent = modeImpl.getSelectedTopComponent();
            this.openedTopComponents = modeImpl.getOpenedTopComponents().toArray(new TopComponent[0]);
            this.resizeWeight = d;
        }

        public boolean originatorEquals(ElementSnapshot elementSnapshot) {
            if (!super.originatorEquals(elementSnapshot)) {
                return false;
            }
            ModeSnapshot modeSnapshot = (ModeSnapshot)elementSnapshot;
            return this.getState() == modeSnapshot.getState();
        }

        public ModeImpl getMode() {
            return this.mode;
        }

        public String getName() {
            return this.name;
        }

        public int getState() {
            return this.state;
        }

        public int getKind() {
            return this.kind;
        }

        public Rectangle getBounds() {
            return this.bounds;
        }

        public int getFrameState() {
            return this.frameState;
        }

        public TopComponent getSelectedTopComponent() {
            return this.selectedTopComponent;
        }

        public TopComponent[] getOpenedTopComponents() {
            return this.openedTopComponents;
        }

        public double getResizeWeight() {
            return this.resizeWeight;
        }

        public boolean isVisibleInSplit() {
            if (this.getOpenedTopComponents().length == 0) {
                return false;
            }
            return this.getKind() != 0 || this.getState() != 1;
        }

        public boolean isVisibleSeparate() {
            if (this.getOpenedTopComponents().length == 0) {
                return false;
            }
            return this.getKind() != 1 && this.getState() != 0;
        }

        public boolean hasVisibleDescendant() {
            return this.isVisibleInSplit();
        }

        public String toString() {
            return super.toString() + "[name=" + this.mode.getName() + ", permanent=" + this.mode.isPermanent() + ", constraints=" + Arrays.asList(this.mode.getConstraints()) + "]";
        }
    }

    public static class SlidingModeSnapshot
    extends ModeSnapshot {
        private final String side;

        public SlidingModeSnapshot(ModeImpl modeImpl, String string) {
            super(null, null, modeImpl, 0.0);
            this.side = string;
        }

        public String getSide() {
            return this.side;
        }
    }

    public static class SplitSnapshot
    extends ElementSnapshot {
        private final int orientation;
        private final List childSnapshots = new ArrayList();
        private final Map childSnapshot2splitWeight = new HashMap();
        private final double resizeWeight;

        public SplitSnapshot(ModelElement modelElement, SplitSnapshot splitSnapshot, int n, List list, Map map, double d) {
            super(modelElement, splitSnapshot);
            this.orientation = n;
            this.childSnapshots.addAll(list);
            this.childSnapshot2splitWeight.putAll(map);
            this.resizeWeight = d;
        }

        public int getOrientation() {
            return this.orientation;
        }

        public List getVisibleChildSnapshots() {
            List list = this.getChildSnapshots();
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                ElementSnapshot elementSnapshot = (ElementSnapshot)iterator.next();
                if (elementSnapshot.hasVisibleDescendant()) continue;
                iterator.remove();
            }
            return list;
        }

        public List getChildSnapshots() {
            return new ArrayList(this.childSnapshots);
        }

        public double getChildSnapshotSplitWeight(ElementSnapshot elementSnapshot) {
            Double d = (Double)this.childSnapshot2splitWeight.get(elementSnapshot);
            return d == null ? -1.0 : d;
        }

        public double getResizeWeight() {
            return this.resizeWeight;
        }

        public boolean isVisibleInSplit() {
            int n = 0;
            Iterator iterator = this.getChildSnapshots().iterator();
            while (iterator.hasNext()) {
                ElementSnapshot elementSnapshot = (ElementSnapshot)iterator.next();
                if (!elementSnapshot.hasVisibleDescendant() || ++n < 2) continue;
                return true;
            }
            return false;
        }

        public boolean hasVisibleDescendant() {
            Iterator iterator = this.getChildSnapshots().iterator();
            while (iterator.hasNext()) {
                ElementSnapshot elementSnapshot = (ElementSnapshot)iterator.next();
                if (!elementSnapshot.hasVisibleDescendant()) continue;
                return true;
            }
            return false;
        }

        public String toString() {
            return super.toString() + "[orientation=" + (this.orientation == 1 ? "horizontal" : "vertical") + "]";
        }
    }
}

