/*
 * Decompiled with CFR 0.152.
 */
package tr.view.information;

import java.awt.BorderLayout;
import java.io.Serializable;
import java.util.Collection;
import java.util.logging.Logger;
import org.openide.ErrorManager;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.NbBundle;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;
import tr.model.information.Information;
import tr.view.Window;
import tr.view.information.InformationListTopComponent;
import tr.view.information.InformationPanel;
import tr.view.information.Resources;
import tr.view.information.TopicsListTopComponent;

public final class InformationTopComponent
extends Window
implements LookupListener {
    private static final Logger LOG = Logger.getLogger("tr.view.information");
    private static final String PREFERRED_ID = "InformationTopComponent";
    private static InformationTopComponent instance;
    private transient InformationPanel panel;
    private transient Lookup.Result result;

    private InformationTopComponent() {
        this.setName(NbBundle.getMessage(TopicsListTopComponent.class, (String)"CTL_InformationTopComponent"));
        this.setToolTipText(NbBundle.getMessage(TopicsListTopComponent.class, (String)"TTT_InformationTopComponent"));
        this.setIcon(Resources.ICON_INFORMATION.getImage());
        this.initComponents();
    }

    private void initComponents() {
        this.setLayout(new BorderLayout());
    }

    protected void componentOpened() {
        super.componentOpened();
        if (this.panel == null) {
            this.removeAll();
            this.panel = new InformationPanel();
            this.add(this.panel, "Center");
        }
        this.panel.initModel(null);
        InformationListTopComponent itc = InformationListTopComponent.findInstance();
        this.result = itc.getLookup().lookup(new Lookup.Template(Information.class));
        this.result.addLookupListener((LookupListener)this);
        this.result.allInstances();
    }

    protected void componentClosed() {
        super.componentClosed();
        this.result.removeLookupListener((LookupListener)this);
        this.result = null;
    }

    public synchronized void resultChanged(LookupEvent lookupEvent) {
        if (this.panel == null) {
            return;
        }
        Collection collection = this.result.allInstances();
        if (collection.isEmpty()) {
            this.panel.initModel(null);
        } else {
            this.panel.initModel((Information)collection.iterator().next());
        }
    }

    public static synchronized InformationTopComponent getDefault() {
        if (instance == null) {
            instance = new InformationTopComponent();
        }
        return instance;
    }

    public static synchronized InformationTopComponent findInstance() {
        TopComponent win = WindowManager.getDefault().findTopComponent(PREFERRED_ID);
        if (win == null) {
            ErrorManager.getDefault().log(16, "Cannot find Information component. It will not be located properly in the window system.");
            return InformationTopComponent.getDefault();
        }
        if (win instanceof InformationTopComponent) {
            return (InformationTopComponent)win;
        }
        ErrorManager.getDefault().log(16, "There seem to be multiple components with the 'InformationTopComponent' ID. That is a potential source of errors and unexpected behavior.");
        return InformationTopComponent.getDefault();
    }

    public int getPersistenceType() {
        return 0;
    }

    public Object writeReplace() {
        return new ResolvableHelper();
    }

    protected String preferredID() {
        return PREFERRED_ID;
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx("tr.view.information");
    }

    static final class ResolvableHelper
    implements Serializable {
        private static final long serialVersionUID = 1L;

        ResolvableHelper() {
        }

        public Object readResolve() {
            return InformationTopComponent.getDefault();
        }
    }
}

