/*
 * Decompiled with CFR 0.152.
 */
package tr.view.information;

import java.awt.Image;
import java.io.IOException;
import java.util.logging.Logger;
import javax.swing.Action;
import org.openide.actions.DeleteAction;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.actions.SystemAction;
import org.openide.util.lookup.Lookups;
import tr.model.Data;
import tr.model.DataLookup;
import tr.model.information.Information;
import tr.model.thought.Thought;
import tr.model.topic.TopicChangeCookie;
import tr.util.Observable;
import tr.util.Observer;
import tr.view.ReprocessAction;
import tr.view.ReprocessCookie;
import tr.view.information.Resources;
import tr.view.process.ProcessThoughtsAction;
import tr.view.topic.TopicChangeAction;

public class InformationNode
extends AbstractNode
implements Observer,
ReprocessCookie {
    private static final Logger LOG = Logger.getLogger("tr.view.information");
    private String name;
    private Action[] actions;

    public InformationNode(Information information) {
        super(Children.LEAF, Lookups.singleton((Object)information));
        this.name = information.getDescription();
        super.setName(this.name);
        information.addObserver((Observer)this);
    }

    private Information getInformation() {
        return (Information)this.getLookup().lookup(Information.class);
    }

    public Image getIcon(int type) {
        return Resources.ICON_INFORMATION.getImage();
    }

    public String getHtmlDisplayName() {
        return this.name;
    }

    public boolean canCut() {
        return false;
    }

    public boolean canCopy() {
        return false;
    }

    public boolean canDestroy() {
        return true;
    }

    public void destroy() throws IOException {
        Information information = this.getInformation();
        if (information == null) {
            return;
        }
        information.removeObserver((Observer)this);
        Data data = (Data)DataLookup.instance().lookup(Data.class);
        if (data == null) {
            return;
        }
        data.getInformationManager().remove((Observable)information);
        this.fireNodeDestroyed();
    }

    public boolean canRename() {
        return false;
    }

    public void setName(String name) {
        LOG.info("Should not be called.");
    }

    public void setDisplayName(String name) {
        LOG.info("Should not be called.");
    }

    public Action[] getActions(boolean popup) {
        if (this.actions == null) {
            this.actions = new Action[]{SystemAction.get(DeleteAction.class), null, SystemAction.get(TopicChangeAction.class), null, SystemAction.get(ReprocessAction.class)};
        }
        return this.actions;
    }

    public Node.Cookie getCookie(Class clazz) {
        if (clazz == ReprocessCookie.class) {
            return this;
        }
        if (clazz == TopicChangeCookie.class) {
            return this.getInformation();
        }
        return super.getCookie(clazz);
    }

    public void update(Observable observable, Object arguement) {
        LOG.info("Handle information change.");
        String oldName = this.name;
        String newName = this.getInformation().getDescription();
        if (!newName.equals(oldName)) {
            super.setName(newName);
            this.name = newName;
        }
    }

    public void reprocess() {
        Data data = (Data)DataLookup.instance().lookup(Data.class);
        if (data == null) {
            return;
        }
        Information info = this.getInformation();
        if (info == null) {
            return;
        }
        info.removeObserver((Observer)this);
        data.getInformationManager().remove((Observable)info);
        Thought thought = new Thought();
        thought.setDescription(info.getDescription());
        thought.setTopic(info.getTopic());
        thought.setNotes(info.getNotes());
        data.getThoughtManager().insert((Observable)thought, 0);
        try {
            Thread.currentThread();
            Thread.sleep(500L);
        }
        catch (InterruptedException ex) {
            // empty catch block
        }
        ProcessThoughtsAction pta = (ProcessThoughtsAction)SystemAction.get(ProcessThoughtsAction.class);
        pta.performAction();
    }
}

