/*
 * Decompiled with CFR 0.152.
 */
package tr.view.information;

import java.awt.event.ActionEvent;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.NbBundle;
import org.openide.windows.Mode;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;
import tr.global.InitialAction;
import tr.model.Data;
import tr.model.DataLookup;
import tr.view.WindowUtils;
import tr.view.information.InformationListTopComponent;
import tr.view.information.InformationTopComponent;
import tr.view.information.Resources;
import tr.view.information.TopicsListTopComponent;

public class InformationAction
extends AbstractAction
implements InitialAction {
    private static final Logger LOG = Logger.getLogger("tr.view.information");

    public InformationAction() {
        super(NbBundle.getMessage(InformationAction.class, (String)"CTL_InformationAction"));
        this.putValue("SmallIcon", Resources.ICON_INFORMATION);
        this.enableDisable();
        Lookup.Result r = DataLookup.instance().lookup(new Lookup.Template(Data.class));
        r.addLookupListener(new LookupListener(){

            public void resultChanged(LookupEvent lookupEvent) {
                InformationAction.this.enableDisable();
            }
        });
    }

    private void enableDisable() {
        Data data = (Data)DataLookup.instance().lookup(Data.class);
        this.setEnabled(data != null);
    }

    public void actionPerformed(ActionEvent evt) {
        Data data = (Data)DataLookup.instance().lookup(Data.class);
        if (data == null) {
            return;
        }
        WindowUtils.closeWindows();
        TopicsListTopComponent tcTopicsList = TopicsListTopComponent.findInstance();
        InformationListTopComponent tcInformationList = InformationListTopComponent.findInstance();
        InformationTopComponent tcInformation = InformationTopComponent.findInstance();
        Mode mode = WindowManager.getDefault().findMode("topics-list");
        if (mode == null) {
            LOG.severe("Mode: topics-list; was not found.");
        } else {
            mode.dockInto((TopComponent)tcTopicsList);
        }
        mode = WindowManager.getDefault().findMode("information-list");
        if (mode == null) {
            LOG.severe("Mode: information-list; was not found.");
        } else {
            mode.dockInto((TopComponent)tcInformationList);
        }
        mode = WindowManager.getDefault().findMode("information");
        if (mode == null) {
            LOG.severe("Mode: information; was not found.");
        } else {
            mode.dockInto((TopComponent)tcInformation);
        }
        tcTopicsList.open();
        tcInformationList.open();
        tcInformation.open();
        tcTopicsList.requestActive();
    }

    public String getID() {
        return "information";
    }

    public String getName() {
        return (String)this.getValue("Name");
    }
}

