/*
 * Decompiled with CFR 0.152.
 */
package tr.view.project;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.net.URL;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import org.jdesktop.layout.GroupLayout;
import org.openide.util.NbBundle;
import tr.global.Constants;
import tr.model.Data;
import tr.model.criteria.Criterion;
import tr.model.criteria.Value;
import tr.model.project.Project;
import tr.model.project.Sequencing;
import tr.model.topic.Topic;
import tr.prefs.projects.ProjectsPrefs;
import tr.runtime.Open;
import tr.swing.TextArea;
import tr.swing.editorpane.HyperEditorPane;
import tr.util.DateButton;
import tr.util.Observable;
import tr.util.Observer;
import tr.util.Utils;
import tr.view.criteria.CriterionComboBoxModel;
import tr.view.project.SequencingModel;
import tr.view.topic.TopicComboBox;
import tr.view.topic.TopicComboBoxModel;
import tr.view.topic.TopicListCellRenderer;

public final class ProjectPanel
extends JPanel
implements Observer {
    private static final Logger LOG = Logger.getLogger("tr.view.project");
    private DocumentListener docListenerDescription;
    private DocumentListener docListenerPurpose;
    private DocumentListener docListenerVision;
    private DocumentListener docListenerBrainstorm;
    private DocumentListener docListenerOrganise;
    private DocumentListener docListenerNotes;
    private FocusAdapter focusAdapterDescription;
    private ActionListener actionListenerTopic;
    private ActionListener actionListenerPriorityCombo;
    private ActionListener actionListenerSequencingCombo;
    private ActionListener actionListenerSequencingCheckBox;
    private ActionListener actionListenerCompleted;
    private PropertyChangeListener propChangeListenerStartDate;
    private PropertyChangeListener propChangeListenerDueDate;
    private PropertyChangeListener propChangeListenerCompletedDate;
    private HyperlinkListener hyperlinkListener;
    private Observer observerCriterion;
    private JLabel brainstormLabel;
    private JScrollPane brainstormScrollPane;
    private TextArea brainstormTextArea;
    private JCheckBox completedCheckBox;
    private DateButton completedDateButton;
    private DateButton createdDateButton;
    private JLabel createdDateLabel;
    private JLabel descriptionLabel;
    private JTextField descriptionText;
    private DateButton dueDateButton;
    private JLabel dueDateLabel;
    private HyperEditorPane notesEditorPane;
    private JLabel notesLabel;
    private JLabel organiseLabel;
    private JScrollPane organiseScrollPane;
    private TextArea organiseTextArea;
    private JComboBox priorityCombo;
    private JLabel priorityLabel;
    private JLabel purposeLabel;
    private JScrollPane purposeScrollPane;
    private TextArea purposeTextArea;
    private JCheckBox sequencingCheckBox;
    private JComboBox sequencingCombo;
    private JLabel sequencingLabel;
    private DateButton startDateButton;
    private JLabel startDateLabel;
    private JComboBox topicCombo;
    private JLabel topicLabel;
    private JLabel visionLabel;
    private JScrollPane visionScrollPane;
    private TextArea visionTextArea;
    private static final String DEFAULT_DESCRIPTION = "New Project";
    private final Data data;
    private Project project;
    private ComboBoxModel topicsModel;
    private boolean updating;

    public ProjectPanel(Data data) {
        this.data = data;
        this.initComponents();
        this.initModel(null);
    }

    public void addNotify() {
        super.addNotify();
        this.addListeners();
    }

    public void removeNotify() {
        this.removeListeners();
        super.removeNotify();
    }

    public void edit() {
        this.descriptionText.requestFocusInWindow();
    }

    private void initComponents() {
        this.descriptionLabel = new JLabel();
        this.descriptionText = new JTextField();
        this.topicLabel = new JLabel();
        this.topicsModel = new TopicComboBoxModel(false);
        this.topicCombo = new TopicComboBox(this.topicsModel);
        this.priorityLabel = new JLabel();
        this.priorityCombo = new JComboBox();
        this.purposeLabel = new JLabel();
        this.purposeScrollPane = new JScrollPane();
        this.purposeTextArea = new TextArea();
        this.visionLabel = new JLabel();
        this.visionScrollPane = new JScrollPane();
        this.visionTextArea = new TextArea();
        this.brainstormLabel = new JLabel();
        this.brainstormScrollPane = new JScrollPane();
        this.brainstormTextArea = new TextArea();
        this.organiseLabel = new JLabel();
        this.organiseScrollPane = new JScrollPane();
        this.organiseTextArea = new TextArea();
        this.notesLabel = new JLabel();
        this.notesEditorPane = new HyperEditorPane();
        this.sequencingLabel = new JLabel();
        this.sequencingCheckBox = new JCheckBox();
        this.sequencingCombo = new JComboBox();
        this.createdDateLabel = new JLabel();
        this.createdDateButton = new DateButton();
        this.startDateLabel = new JLabel();
        this.startDateButton = new DateButton();
        this.dueDateLabel = new JLabel();
        this.dueDateButton = new DateButton();
        this.completedCheckBox = new JCheckBox();
        this.completedDateButton = new DateButton();
        this.descriptionLabel.setHorizontalAlignment(11);
        this.descriptionLabel.setText(NbBundle.getMessage(ProjectPanel.class, (String)"ProjectPanel.description"));
        this.descriptionLabel.setMaximumSize(new Dimension(96, 16));
        this.descriptionLabel.setMinimumSize(new Dimension(96, 16));
        this.descriptionLabel.setPreferredSize(new Dimension(96, 16));
        this.topicLabel.setHorizontalAlignment(11);
        this.topicLabel.setText(NbBundle.getMessage(ProjectPanel.class, (String)"ProjectPanel.topic"));
        this.topicLabel.setMaximumSize(new Dimension(96, 16));
        this.topicLabel.setMinimumSize(new Dimension(96, 16));
        this.topicLabel.setPreferredSize(new Dimension(96, 16));
        this.topicCombo.setRenderer(new TopicListCellRenderer());
        this.topicCombo.setMaximumRowCount(30);
        this.priorityLabel.setHorizontalAlignment(11);
        this.priorityLabel.setText(NbBundle.getMessage(ProjectPanel.class, (String)"LBL_Priority"));
        this.priorityLabel.setFocusable(false);
        this.priorityLabel.setMaximumSize(new Dimension(96, 16));
        this.priorityLabel.setMinimumSize(new Dimension(96, 16));
        this.priorityLabel.setPreferredSize(new Dimension(96, 16));
        this.priorityCombo.setModel(this.getPriorityComboBoxModel());
        this.purposeLabel.setHorizontalAlignment(11);
        this.purposeLabel.setText(NbBundle.getMessage(ProjectPanel.class, (String)"ProjectPanel.purpose"));
        this.purposeLabel.setMaximumSize(new Dimension(96, 16));
        this.purposeLabel.setMinimumSize(new Dimension(96, 16));
        this.purposeLabel.setPreferredSize(new Dimension(96, 16));
        this.purposeTextArea.setColumns(20);
        this.purposeTextArea.setRows(1);
        this.purposeScrollPane.setViewportView((Component)this.purposeTextArea);
        this.visionLabel.setHorizontalAlignment(11);
        this.visionLabel.setText(NbBundle.getMessage(ProjectPanel.class, (String)"ProjectPanel.vision"));
        this.visionLabel.setMaximumSize(new Dimension(96, 16));
        this.visionLabel.setMinimumSize(new Dimension(96, 16));
        this.visionLabel.setPreferredSize(new Dimension(96, 16));
        this.visionTextArea.setColumns(20);
        this.visionTextArea.setRows(1);
        this.visionScrollPane.setViewportView((Component)this.visionTextArea);
        this.brainstormLabel.setHorizontalAlignment(11);
        this.brainstormLabel.setText(NbBundle.getMessage(ProjectPanel.class, (String)"ProjectPanel.brainstorming"));
        this.brainstormLabel.setMaximumSize(new Dimension(96, 16));
        this.brainstormLabel.setMinimumSize(new Dimension(96, 16));
        this.brainstormLabel.setPreferredSize(new Dimension(96, 16));
        this.brainstormTextArea.setColumns(20);
        this.brainstormTextArea.setRows(1);
        this.brainstormScrollPane.setViewportView((Component)this.brainstormTextArea);
        this.organiseLabel.setHorizontalAlignment(11);
        this.organiseLabel.setText(NbBundle.getMessage(ProjectPanel.class, (String)"ProjectPanel.organising"));
        this.organiseLabel.setMaximumSize(new Dimension(96, 16));
        this.organiseLabel.setMinimumSize(new Dimension(96, 16));
        this.organiseLabel.setPreferredSize(new Dimension(96, 16));
        this.organiseTextArea.setColumns(20);
        this.organiseTextArea.setRows(1);
        this.organiseScrollPane.setViewportView((Component)this.organiseTextArea);
        this.notesLabel.setHorizontalAlignment(11);
        this.notesLabel.setText(NbBundle.getMessage(ProjectPanel.class, (String)"ProjectPanel.notes"));
        this.notesLabel.setMaximumSize(new Dimension(96, 16));
        this.notesLabel.setMinimumSize(new Dimension(96, 16));
        this.notesLabel.setPreferredSize(new Dimension(96, 16));
        this.sequencingLabel.setHorizontalAlignment(11);
        this.sequencingLabel.setText(NbBundle.getMessage(ProjectPanel.class, (String)"ProjectPanel.sequencing"));
        this.sequencingLabel.setMaximumSize(new Dimension(96, 16));
        this.sequencingLabel.setMinimumSize(new Dimension(96, 16));
        this.sequencingLabel.setPreferredSize(new Dimension(96, 16));
        this.sequencingCheckBox.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.sequencingCheckBox.setMargin(new Insets(0, 0, 0, 0));
        this.sequencingCombo.setModel(new SequencingModel());
        this.createdDateLabel.setHorizontalAlignment(11);
        this.createdDateLabel.setText(NbBundle.getMessage(ProjectPanel.class, (String)"ProjectPanel.created"));
        this.createdDateLabel.setMaximumSize(new Dimension(96, 16));
        this.createdDateLabel.setMinimumSize(new Dimension(96, 16));
        this.createdDateLabel.setPreferredSize(new Dimension(96, 16));
        this.createdDateButton.setPreferredSize(new Dimension(144, Constants.BUTTON_HEIGHT));
        this.startDateLabel.setText(NbBundle.getMessage(ProjectPanel.class, (String)"ProjectPanel.start"));
        this.startDateButton.setPreferredSize(new Dimension(144, Constants.BUTTON_HEIGHT));
        this.startDateButton.setNoSelectionText("Select a date");
        this.dueDateLabel.setText(NbBundle.getMessage(ProjectPanel.class, (String)"ProjectPanel.due"));
        this.dueDateButton.setPreferredSize(new Dimension(150, Constants.BUTTON_HEIGHT));
        this.dueDateButton.setNoSelectionText("Select a date");
        this.completedCheckBox.setText(NbBundle.getMessage(ProjectPanel.class, (String)"ProjectPanel.completed"));
        this.completedCheckBox.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.completedCheckBox.setHorizontalTextPosition(10);
        this.completedCheckBox.setMargin(new Insets(0, 0, 0, 0));
        this.completedDateButton.setPreferredSize(new Dimension(150, Constants.BUTTON_HEIGHT));
        this.completedDateButton.setNoSelectionText("Select a date");
        GroupLayout layout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.descriptionLabel, -1, 96, Short.MAX_VALUE).add((Component)this.topicLabel, -2, 96, -2).add((Component)this.priorityLabel, -2, 96, -2).add((Component)this.purposeLabel, -1, 96, Short.MAX_VALUE).add((Component)this.visionLabel, -1, 96, Short.MAX_VALUE).add((Component)this.brainstormLabel, -1, 96, Short.MAX_VALUE).add((Component)this.organiseLabel, -1, 96, Short.MAX_VALUE).add((Component)this.sequencingLabel, -1, 96, Short.MAX_VALUE).add((Component)this.createdDateLabel, -1, 96, Short.MAX_VALUE).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.notesLabel, -1, 96, Short.MAX_VALUE).addPreferredGap(0))).add(6, 6, 6).add((GroupLayout.Group)layout.createParallelGroup(2).add((Component)this.notesEditorPane, -1, 775, Short.MAX_VALUE).add(1, (Component)this.purposeScrollPane, -1, 775, Short.MAX_VALUE).add(1, (Component)this.visionScrollPane, -1, 775, Short.MAX_VALUE).add(1, (GroupLayout.Group)layout.createSequentialGroup().addPreferredGap(0).add((Component)this.createdDateButton, -2, 144, -2).addPreferredGap(0).add((Component)this.startDateLabel).addPreferredGap(0).add((Component)this.startDateButton, -2, 144, -2).add(8, 8, 8).add((Component)this.dueDateLabel).addPreferredGap(0).add((Component)this.dueDateButton, -2, 144, -2).addPreferredGap(0).add((Component)this.completedCheckBox).addPreferredGap(0).add((Component)this.completedDateButton, -2, 144, -2)).add(1, (Component)this.topicCombo, -2, 254, -2).add(1, (Component)this.brainstormScrollPane, -1, 775, Short.MAX_VALUE).add(1, (Component)this.organiseScrollPane, -1, 775, Short.MAX_VALUE).add(1, (Component)this.priorityCombo, -2, 150, -2).add((Component)this.descriptionText, -1, 775, Short.MAX_VALUE).add(1, (GroupLayout.Group)layout.createSequentialGroup().add((Component)this.sequencingCheckBox).addPreferredGap(0).add((Component)this.sequencingCombo, -2, 171, -2))).addContainerGap()));
        layout.linkSize(new Component[]{this.brainstormLabel, this.createdDateLabel, this.descriptionLabel, this.notesLabel, this.organiseLabel, this.priorityLabel, this.purposeLabel, this.sequencingLabel, this.topicLabel, this.visionLabel}, 1);
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.descriptionText, -2, 22, -2).add((Component)this.descriptionLabel, -2, 22, -2)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.topicCombo, -2, -1, -2).add((Component)this.topicLabel, -2, 22, -2)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.priorityCombo, -2, -1, -2).add((Component)this.priorityLabel, -2, 22, -2)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.purposeScrollPane, -1, 22, Short.MAX_VALUE).add(4, 4, 4)).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.purposeLabel, -2, -1, -2).addPreferredGap(0))).add((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.visionScrollPane, -1, 22, Short.MAX_VALUE).add(4, 4, 4)).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.visionLabel, -2, -1, -2).addPreferredGap(0))).add((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.brainstormScrollPane, -1, 22, Short.MAX_VALUE).add(4, 4, 4)).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.brainstormLabel, -2, -1, -2).addPreferredGap(0))).add((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.organiseScrollPane, -1, 22, Short.MAX_VALUE).add(4, 4, 4)).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.organiseLabel, -2, -1, -2).addPreferredGap(0))).add((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add(29, 29, 29).add((Component)this.notesLabel, -2, -1, -2)).add(2, (GroupLayout.Group)layout.createSequentialGroup().addPreferredGap(0).add((Component)this.notesEditorPane, -1, 48, Short.MAX_VALUE))).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.sequencingCheckBox, -2, 22, -2).add((Component)this.sequencingLabel, -2, 22, -2).add((Component)this.sequencingCombo, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.createdDateButton, -2, -1, -2).add((Component)this.createdDateLabel, -2, 22, -2).add((Component)this.startDateLabel, -2, 22, -2).add((Component)this.startDateButton, -2, -1, -2).add((Component)this.dueDateLabel, -2, 22, -2).add((Component)this.dueDateButton, -2, -1, -2).add((Component)this.completedCheckBox, -2, 22, -2).add((Component)this.completedDateButton, -2, -1, -2)).addContainerGap()));
    }

    private ComboBoxModel getPriorityComboBoxModel() {
        Criterion criterion;
        if (this.data != null && (criterion = this.data.getPriorityCriterion()) != null) {
            return new CriterionComboBoxModel(criterion);
        }
        return new DefaultComboBoxModel();
    }

    private void descriptionTextFocusGained(FocusEvent evt) {
        if (this.descriptionText.getText().equals(DEFAULT_DESCRIPTION)) {
            this.descriptionText.setSelectionStart(0);
            this.descriptionText.setSelectionEnd(DEFAULT_DESCRIPTION.length());
        }
    }

    private void topicComboActionPerformed(ActionEvent evt) {
        if (this.updating || this.project == null) {
            return;
        }
        JComboBox combo = (JComboBox)evt.getSource();
        this.project.setTopic((Topic)combo.getSelectedItem());
    }

    private void priorityComboActionPerformed(ActionEvent evt) {
        if (this.updating || this.project == null) {
            return;
        }
        this.project.setPriority((Value)this.priorityCombo.getSelectedItem());
    }

    private void sequencingComboActionPerformed(ActionEvent evt) {
        if (this.updating || this.project == null) {
            return;
        }
        this.project.setSequenceType((Sequencing)this.sequencingCombo.getSelectedItem());
    }

    private void sequencingCheckBoxActionPerformed(ActionEvent evt) {
        if (this.updating || this.project == null) {
            return;
        }
        this.project.setSequencing(this.sequencingCheckBox.isSelected());
        this.sequencingCombo.setEnabled(this.sequencingCheckBox.isSelected());
    }

    private void completedCheckBoxActionPerformed(ActionEvent evt) {
        if (this.updating || this.project == null) {
            return;
        }
        if (this.completedCheckBox.isSelected() && !this.project.canSetDone(true)) {
            this.completedCheckBox.setSelected(false);
            String t = "";
            String m = "This project can not be set to \"done\" as it has actions or sub-projects that are not \"done\".";
            JOptionPane.showMessageDialog(null, m, t, 2);
        } else {
            this.project.setDone(this.completedCheckBox.isSelected());
            this.completedDateButton.setDate(this.project.getDoneDate());
        }
        this.completedDateButton.setEnabled(this.project.isDone());
    }

    private void startDateButtonPropertyChange(PropertyChangeEvent evt) {
        if (this.updating || this.project == null) {
            return;
        }
        this.project.setStartDate(this.startDateButton.getDate());
    }

    private void dueDateButtonPropertyChange(PropertyChangeEvent evt) {
        if (this.updating || this.project == null) {
            return;
        }
        this.project.setDueDate(this.dueDateButton.getDate());
    }

    private void completedDateButtonPropertyChange(PropertyChangeEvent evt) {
        if (this.updating || this.project == null) {
            return;
        }
        this.project.setDoneDate(this.completedDateButton.getDate());
    }

    private void notesEditorPaneHyperlinkAction(HyperlinkEvent evt) {
        URL url = evt.getURL();
        if (url == null) {
            return;
        }
        if (evt.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
            Open.open((URL)url);
        }
    }

    private void addListeners() {
        this.docListenerDescription = new DocumentListener(){

            public void changedUpdate(DocumentEvent arg0) {
                ProjectPanel.this.changedDescription();
            }

            public void insertUpdate(DocumentEvent arg0) {
                ProjectPanel.this.changedDescription();
            }

            public void removeUpdate(DocumentEvent arg0) {
                ProjectPanel.this.changedDescription();
            }
        };
        this.descriptionText.getDocument().addDocumentListener(this.docListenerDescription);
        this.actionListenerPriorityCombo = new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ProjectPanel.this.priorityComboActionPerformed(evt);
            }
        };
        this.priorityCombo.addActionListener(this.actionListenerPriorityCombo);
        this.docListenerPurpose = new DocumentListener(){

            public void changedUpdate(DocumentEvent arg0) {
                ProjectPanel.this.changedPurpose();
            }

            public void insertUpdate(DocumentEvent arg0) {
                ProjectPanel.this.changedPurpose();
            }

            public void removeUpdate(DocumentEvent arg0) {
                ProjectPanel.this.changedPurpose();
            }
        };
        this.purposeTextArea.getDocument().addDocumentListener(this.docListenerPurpose);
        this.docListenerBrainstorm = new DocumentListener(){

            public void changedUpdate(DocumentEvent arg0) {
                ProjectPanel.this.changedBrainstorm();
            }

            public void insertUpdate(DocumentEvent arg0) {
                ProjectPanel.this.changedBrainstorm();
            }

            public void removeUpdate(DocumentEvent arg0) {
                ProjectPanel.this.changedBrainstorm();
            }
        };
        this.brainstormTextArea.getDocument().addDocumentListener(this.docListenerBrainstorm);
        this.docListenerOrganise = new DocumentListener(){

            public void changedUpdate(DocumentEvent arg0) {
                ProjectPanel.this.changedOrganise();
            }

            public void insertUpdate(DocumentEvent arg0) {
                ProjectPanel.this.changedOrganise();
            }

            public void removeUpdate(DocumentEvent arg0) {
                ProjectPanel.this.changedOrganise();
            }
        };
        this.organiseTextArea.getDocument().addDocumentListener(this.docListenerOrganise);
        this.docListenerVision = new DocumentListener(){

            public void changedUpdate(DocumentEvent arg0) {
                ProjectPanel.this.changedVision();
            }

            public void insertUpdate(DocumentEvent arg0) {
                ProjectPanel.this.changedVision();
            }

            public void removeUpdate(DocumentEvent arg0) {
                ProjectPanel.this.changedVision();
            }
        };
        this.visionTextArea.getDocument().addDocumentListener(this.docListenerVision);
        this.docListenerNotes = new DocumentListener(){

            public void changedUpdate(DocumentEvent arg0) {
                ProjectPanel.this.changedNotes();
            }

            public void insertUpdate(DocumentEvent arg0) {
                ProjectPanel.this.changedNotes();
            }

            public void removeUpdate(DocumentEvent arg0) {
                ProjectPanel.this.changedNotes();
            }
        };
        this.notesEditorPane.addDocumentListener(this.docListenerNotes);
        this.focusAdapterDescription = new FocusAdapter(){

            public void focusGained(FocusEvent evt) {
                ProjectPanel.this.descriptionTextFocusGained(evt);
            }
        };
        this.descriptionText.addFocusListener(this.focusAdapterDescription);
        this.actionListenerTopic = new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ProjectPanel.this.topicComboActionPerformed(evt);
            }
        };
        this.topicCombo.addActionListener(this.actionListenerTopic);
        this.actionListenerSequencingCombo = new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ProjectPanel.this.sequencingComboActionPerformed(evt);
            }
        };
        this.sequencingCombo.addActionListener(this.actionListenerSequencingCombo);
        this.actionListenerCompleted = new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ProjectPanel.this.completedCheckBoxActionPerformed(evt);
            }
        };
        this.completedCheckBox.addActionListener(this.actionListenerCompleted);
        this.actionListenerSequencingCheckBox = new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ProjectPanel.this.sequencingCheckBoxActionPerformed(evt);
            }
        };
        this.sequencingCheckBox.addActionListener(this.actionListenerSequencingCheckBox);
        this.propChangeListenerStartDate = new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                ProjectPanel.this.startDateButtonPropertyChange(evt);
            }
        };
        this.startDateButton.addPropertyChangeListener(this.propChangeListenerStartDate);
        this.propChangeListenerDueDate = new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                ProjectPanel.this.dueDateButtonPropertyChange(evt);
            }
        };
        this.dueDateButton.addPropertyChangeListener(this.propChangeListenerDueDate);
        this.propChangeListenerCompletedDate = new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                ProjectPanel.this.completedDateButtonPropertyChange(evt);
            }
        };
        this.completedDateButton.addPropertyChangeListener(this.propChangeListenerCompletedDate);
        this.hyperlinkListener = new HyperlinkListener(){

            public void hyperlinkUpdate(HyperlinkEvent evt) {
                ProjectPanel.this.notesEditorPaneHyperlinkAction(evt);
            }
        };
        this.notesEditorPane.addHyperlinkListener(this.hyperlinkListener);
        this.observerCriterion = new Observer(){

            public void update(Observable observable, Object arguement) {
                ProjectPanel.this.showHideCriteria();
            }
        };
        this.data.getPriorityCriterion().addObserver(this.observerCriterion);
    }

    private void removeListeners() {
        this.descriptionText.getDocument().removeDocumentListener(this.docListenerDescription);
        this.purposeTextArea.getDocument().removeDocumentListener(this.docListenerPurpose);
        this.brainstormTextArea.getDocument().removeDocumentListener(this.docListenerBrainstorm);
        this.organiseTextArea.getDocument().removeDocumentListener(this.docListenerOrganise);
        this.visionTextArea.getDocument().removeDocumentListener(this.docListenerVision);
        this.notesEditorPane.removeDocumentListener(this.docListenerNotes);
        this.descriptionText.removeFocusListener(this.focusAdapterDescription);
        this.topicCombo.removeActionListener(this.actionListenerTopic);
        this.sequencingCombo.removeActionListener(this.actionListenerSequencingCombo);
        this.completedCheckBox.removeActionListener(this.actionListenerCompleted);
        this.sequencingCheckBox.removeActionListener(this.actionListenerSequencingCheckBox);
        this.startDateButton.removePropertyChangeListener(this.propChangeListenerStartDate);
        this.dueDateButton.removePropertyChangeListener(this.propChangeListenerDueDate);
        this.completedDateButton.removePropertyChangeListener(this.propChangeListenerCompletedDate);
        this.notesEditorPane.removeHyperlinkListener(this.hyperlinkListener);
        this.priorityCombo.removeActionListener(this.actionListenerPriorityCombo);
        this.data.getPriorityCriterion().removeObserver(this.observerCriterion);
        this.docListenerDescription = null;
        this.docListenerPurpose = null;
        this.docListenerVision = null;
        this.docListenerBrainstorm = null;
        this.docListenerOrganise = null;
        this.docListenerNotes = null;
        this.focusAdapterDescription = null;
        this.actionListenerTopic = null;
        this.actionListenerSequencingCombo = null;
        this.actionListenerSequencingCheckBox = null;
        this.actionListenerCompleted = null;
        this.propChangeListenerStartDate = null;
        this.propChangeListenerDueDate = null;
        this.propChangeListenerCompletedDate = null;
        this.hyperlinkListener = null;
        this.actionListenerPriorityCombo = null;
        this.observerCriterion = null;
    }

    public Project getModel() {
        return this.project;
    }

    public void initModel(Project project) {
        if (Utils.equal((Object)this.project, (Object)project)) {
            return;
        }
        if (this.project != null) {
            this.project.removeObserver((Observer)this);
        }
        this.project = project;
        if (this.project != null) {
            this.project.addObserver((Observer)this);
        }
        this.initView();
    }

    private void initView() {
        this.updating = true;
        if (this.project == null) {
            this.descriptionText.setText("");
            this.topicCombo.setSelectedItem(null);
            this.priorityCombo.setSelectedItem(null);
            this.purposeTextArea.setText("");
            this.visionTextArea.setText("");
            this.brainstormTextArea.setText("");
            this.organiseTextArea.setText("");
            this.notesEditorPane.setText("");
            this.sequencingCheckBox.setSelected(false);
            this.sequencingCombo.setSelectedItem(null);
            this.startDateButton.setDate(null);
            this.dueDateButton.setDate(null);
            this.createdDateButton.setDate(null);
            this.completedCheckBox.setSelected(false);
            this.completedDateButton.setDate(null);
            this.setEnabled(false);
        } else {
            this.descriptionText.setText(this.project.getDescription());
            this.topicCombo.setSelectedItem(this.project.getTopic());
            this.priorityCombo.setSelectedItem(this.project.getPriority());
            this.purposeTextArea.setText(this.project.getPurpose());
            this.visionTextArea.setText(this.project.getVision());
            this.brainstormTextArea.setText(this.project.getBrainstorming());
            this.organiseTextArea.setText(this.project.getOrganising());
            this.notesEditorPane.setText(this.project.getNotes());
            boolean sequence = ProjectsPrefs.isSequencing();
            this.sequencingLabel.setVisible(sequence);
            this.sequencingCheckBox.setVisible(sequence);
            this.sequencingCombo.setVisible(sequence);
            this.sequencingCheckBox.setSelected(this.project.isSequencing());
            this.sequencingCombo.setSelectedItem(this.project.getSequenceType());
            this.startDateButton.setDate(this.project.getStartDate());
            this.dueDateButton.setDate(this.project.getDueDate());
            this.createdDateButton.setDate(this.project.getCreated());
            this.completedCheckBox.setSelected(this.project.isDone());
            this.completedDateButton.setDate(this.project.getDoneDate());
            this.setEnabled(true);
        }
        this.updating = false;
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.descriptionLabel.setEnabled(enabled);
        this.descriptionText.setEnabled(enabled);
        this.topicLabel.setEnabled(enabled);
        this.topicCombo.setEnabled(enabled);
        this.purposeLabel.setEnabled(enabled);
        this.purposeTextArea.setEnabled(enabled);
        this.visionLabel.setEnabled(enabled);
        this.visionTextArea.setEnabled(enabled);
        this.brainstormLabel.setEnabled(enabled);
        this.brainstormTextArea.setEnabled(enabled);
        this.organiseLabel.setEnabled(enabled);
        this.organiseTextArea.setEnabled(enabled);
        this.notesLabel.setEnabled(enabled);
        this.notesEditorPane.setEnabled(enabled);
        this.notesEditorPane.setEditable(false);
        this.sequencingLabel.setEnabled(enabled);
        this.sequencingCheckBox.setEnabled(enabled);
        this.sequencingCombo.setEnabled(enabled && this.project.isSequencing());
        this.createdDateLabel.setEnabled(false);
        this.createdDateButton.setEnabled(false);
        this.startDateLabel.setEnabled(enabled);
        this.startDateButton.setEnabled(enabled);
        this.startDateLabel.setVisible(ProjectsPrefs.isIncludeStartDate());
        this.startDateButton.setVisible(ProjectsPrefs.isIncludeStartDate());
        this.dueDateLabel.setEnabled(enabled);
        this.dueDateButton.setEnabled(enabled);
        this.dueDateLabel.setVisible(ProjectsPrefs.isIncludeDueDate());
        this.dueDateButton.setVisible(ProjectsPrefs.isIncludeDueDate());
        this.completedCheckBox.setEnabled(enabled);
        this.completedDateButton.setEnabled(enabled && this.project.canSetDone(true));
        this.priorityLabel.setEnabled(enabled);
        this.priorityCombo.setEnabled(enabled);
        this.showHideCriteria();
    }

    private void showHideCriteria() {
        this.priorityLabel.setVisible(this.data.getPriorityCriterion().use);
        this.priorityCombo.setVisible(this.data.getPriorityCriterion().use);
    }

    public void focus() {
        this.descriptionText.requestFocus();
    }

    private void changedDescription() {
        if (this.updating || this.project == null) {
            return;
        }
        this.project.setDescription(this.descriptionText.getText());
    }

    private void changedPurpose() {
        if (this.updating || this.project == null) {
            return;
        }
        this.project.setPurpose(this.purposeTextArea.getText());
    }

    private void changedVision() {
        if (this.updating || this.project == null) {
            return;
        }
        this.project.setVision(this.visionTextArea.getText());
    }

    private void changedBrainstorm() {
        if (this.updating || this.project == null) {
            return;
        }
        this.project.setBrainstorming(this.brainstormTextArea.getText());
    }

    private void changedOrganise() {
        if (this.updating || this.project == null) {
            return;
        }
        this.project.setOrganising(this.organiseTextArea.getText());
    }

    private void changedNotes() {
        if (this.updating || this.project == null) {
            return;
        }
        this.project.setNotes(this.notesEditorPane.getText());
    }

    public void update(Observable observable, Object arguement) {
        if (this.project == null) {
            return;
        }
        if (!this.descriptionText.getText().equals(this.project.getDescription())) {
            this.descriptionText.setText(this.project.getDescription());
        }
        if (!Utils.equal((Object)this.project.getTopic(), (Object)this.topicCombo.getSelectedItem())) {
            this.topicCombo.setSelectedItem(this.project.getTopic());
        }
        if (this.completedCheckBox.isSelected() != this.project.isDone()) {
            this.completedCheckBox.setSelected(this.project.isDone());
            this.completedDateButton.setDate(this.project.getDoneDate());
            this.completedDateButton.setEnabled(this.project.canSetDone(true));
        }
    }
}

