/*
 * Decompiled with CFR 0.152.
 */
package tr.view.process.panels;

import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.ComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jdesktop.layout.GroupLayout;
import org.openide.util.NbBundle;
import tr.model.thought.Thought;
import tr.model.topic.Topic;
import tr.util.Observable;
import tr.util.Observer;
import tr.view.topic.TopicComboBox;
import tr.view.topic.TopicComboBoxModel;
import tr.view.topic.TopicListCellRenderer;

public class PanelThought
extends JPanel
implements Observer {
    private ActionListener actionListenerTopic;
    private DocumentListener docListenerDescription;
    private JTextField descriptionText;
    private JComboBox topicCombo;
    private JLabel topicLabel;
    private static final Logger LOG = Logger.getLogger("tr.view.process");
    private Thought thought;
    private TopicComboBoxModel topicsModel;
    private boolean updating;

    public PanelThought() {
        this.initComponents();
        this.initModel(null, 0);
    }

    public void addNotify() {
        super.addNotify();
        this.addListeners();
    }

    public void removeNotify() {
        this.removeListeners();
        super.removeNotify();
    }

    private void addListeners() {
        this.actionListenerTopic = new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PanelThought.this.topicChange();
            }
        };
        this.topicCombo.addActionListener(this.actionListenerTopic);
        this.docListenerDescription = new DocumentListener(){

            public void changedUpdate(DocumentEvent arg0) {
                PanelThought.this.changedDescription();
            }

            public void insertUpdate(DocumentEvent arg0) {
                PanelThought.this.changedDescription();
            }

            public void removeUpdate(DocumentEvent arg0) {
                PanelThought.this.changedDescription();
            }
        };
        this.descriptionText.getDocument().addDocumentListener(this.docListenerDescription);
    }

    private void removeListeners() {
        this.topicCombo.removeActionListener(this.actionListenerTopic);
        this.descriptionText.getDocument().removeDocumentListener(this.docListenerDescription);
        this.actionListenerTopic = null;
        this.docListenerDescription = null;
    }

    private void changedDescription() {
        if (this.updating || this.thought == null) {
            return;
        }
        this.thought.setDescription(this.descriptionText.getText());
    }

    private void topicChange() {
        if (this.updating || this.thought == null) {
            return;
        }
        this.thought.setTopic((Topic)this.topicCombo.getSelectedItem());
    }

    public synchronized void initModel(Thought thought, int count) {
        LOG.fine("Start");
        if (this.thought != null) {
            this.thought.removeObserver((Observer)this);
        }
        this.thought = thought;
        this.initView();
        if (this.thought != null) {
            this.thought.addObserver((Observer)this);
        }
        this.setTitle(count);
    }

    private synchronized void initView() {
        this.updating = true;
        if (this.thought == null) {
            this.descriptionText.setText("");
            this.topicCombo.setSelectedItem(Topic.getDefault());
        } else {
            this.descriptionText.setText(this.thought.getDescription());
            this.descriptionText.setForeground(this.thought.getTopic().getForeground());
            this.descriptionText.setBackground(this.thought.getTopic().getBackground());
            this.topicCombo.setSelectedItem(this.thought.getTopic());
        }
        this.updating = false;
        this.setEnabled(this.thought != null);
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.descriptionText.setEnabled(enabled);
        this.topicLabel.setEnabled(enabled);
        this.topicCombo.setEnabled(enabled);
    }

    private void setTitle(int n) {
        Border border = this.getBorder();
        if (border instanceof TitledBorder) {
            String t = n == 0 ? "Thought (0)" : "Thought (1 of " + n + ")";
            ((TitledBorder)border).setTitle(t);
        }
    }

    public void update(Observable observable, Object arg) {
        assert (observable instanceof Thought);
        if (arg == Thought.Change.DESCRIPTION) {
            if (!this.descriptionText.getText().equals(this.thought.getDescription())) {
                this.descriptionText.setText(this.thought.getDescription());
            }
        } else if (arg == Thought.Change.TOPIC) {
            this.topicCombo.setSelectedItem(this.thought.getTopic());
            this.descriptionText.setForeground(this.thought.getTopic().getForeground());
            this.descriptionText.setBackground(this.thought.getTopic().getBackground());
        }
    }

    private void initComponents() {
        this.descriptionText = new JTextField();
        this.topicLabel = new JLabel();
        this.topicsModel = new TopicComboBoxModel(false);
        this.topicCombo = new TopicComboBox((ComboBoxModel)this.topicsModel);
        this.setBorder(BorderFactory.createTitledBorder(NbBundle.getMessage(PanelThought.class, (String)"PanelThought.title")));
        this.topicLabel.setText(NbBundle.getMessage(PanelThought.class, (String)"PanelThought.topic"));
        this.topicCombo.setRenderer(new TopicListCellRenderer());
        this.topicCombo.setMaximumRowCount(30);
        GroupLayout layout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add(2, (GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((Component)this.descriptionText, -1, 198, Short.MAX_VALUE).addPreferredGap(0).add((Component)this.topicLabel).addPreferredGap(0).add((Component)this.topicCombo, -2, 200, -2).addContainerGap()));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.topicLabel).add((Component)this.descriptionText, -2, 22, -2).add((Component)this.topicCombo, -2, -1, -2)));
    }
}

