/*
 * Decompiled with CFR 0.152.
 */
package tr.view.process.panels;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URL;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import org.jdesktop.layout.GroupLayout;
import org.openide.util.NbBundle;
import tr.model.Data;
import tr.model.DataLookup;
import tr.model.IDGenerator;
import tr.model.Item.Item;
import tr.model.action.Action;
import tr.model.action.ActionStateDelegated;
import tr.model.action.ActionStateScheduled;
import tr.model.future.Future;
import tr.model.information.Information;
import tr.model.project.Project;
import tr.model.thought.Thought;
import tr.model.topic.Topic;
import tr.model.util.Manager;
import tr.runtime.Open;
import tr.swing.editorpane.HyperEditorPane;
import tr.util.DateButton;
import tr.util.Observable;
import tr.util.Observer;
import tr.view.action.prefs.ActionPrefs;
import tr.view.process.ProcessCookie;
import tr.view.process.ProcessNode;
import tr.view.process.ProcessNodeProvider;
import tr.view.process.panels.Actionable;
import tr.view.process.panels.PanelAction;
import tr.view.process.panels.PanelActionable;
import tr.view.process.panels.PanelSuccess;
import tr.view.process.panels.PanelThought;
import tr.view.project.ProjectsComboBox;
import tr.view.project.ProjectsComboBoxModel;

public class PanelProcess
extends JPanel
implements Observer,
ProcessCookie {
    private Observer actionableObserver;
    private ActionListener actionListenerDelete;
    private ActionListener actionListenerFuture;
    private ActionListener actionListenerInformation;
    private HyperlinkListener hyperlinkListener;
    private JComboBox addToProjectComboBox;
    private JLabel addToProjectLabel;
    private JLabel deleteLabel;
    private JRadioButton deleteRadioButton;
    private JLabel futureLabel;
    private JRadioButton futureRadioButton;
    private JLabel informationLabel;
    private JRadioButton informationRadioButton;
    private JCheckBox newProjectCheckBox;
    private ButtonGroup notActionableButtonGroup;
    private HyperEditorPane notesEditorPane;
    private JPanel panelAction;
    private PanelActionable panelActionable;
    private JPanel panelNotActionable;
    private JPanel panelProject;
    private PanelSuccess panelSuccess;
    private PanelThought panelThought;
    private DateButton tickleDateButton;
    private JLabel tickleDateLabel;
    private static final Logger LOG = Logger.getLogger("tr.view.process");
    private final Data data;
    private final Project projects;
    private final Project singleActions;
    private final Manager<Thought> thoughtManager;
    private final Manager<Topic> topicManager;
    private final Manager<Information> informationManager;
    private final Manager<Future> futureManager;
    private final Actionable actionable;
    private final PanelAction actionPanel;
    private Thought thought;
    private Action action;
    private ProcessNodeProvider processNodeProvider;

    public PanelProcess(ProcessNodeProvider processNodeProvider) {
        this.processNodeProvider = processNodeProvider;
        this.data = (Data)DataLookup.instance().lookup(Data.class);
        this.projects = this.data.getRootProjects();
        this.singleActions = this.data.getRootActions();
        this.topicManager = this.data.getTopicManager();
        this.informationManager = this.data.getInformationManager();
        this.futureManager = this.data.getFutureManager();
        this.thoughtManager = this.data.getThoughtManager();
        this.thoughtManager.addObserver((Observer)this);
        this.actionable = new Actionable();
        this.actionPanel = new PanelAction();
        this.initComponents();
        this.initModel();
    }

    public void addNotify() {
        super.addNotify();
        this.addListeners();
    }

    public void removeNotify() {
        this.removeListeners();
        super.removeNotify();
    }

    private void addListeners() {
        this.actionableObserver = new Observer(){

            public void update(Observable observable, Object arg) {
                PanelProcess.this.showHidePanels();
            }
        };
        this.actionable.addObserver(this.actionableObserver);
        this.hyperlinkListener = new HyperlinkListener(){

            public void hyperlinkUpdate(HyperlinkEvent evt) {
                PanelProcess.this.hyperlink(evt);
            }
        };
        this.notesEditorPane.addHyperlinkListener(this.hyperlinkListener);
        this.actionListenerDelete = new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PanelProcess.this.enableDisableNotActionable();
            }
        };
        this.deleteRadioButton.addActionListener(this.actionListenerDelete);
        this.actionListenerFuture = new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PanelProcess.this.enableDisableNotActionable();
            }
        };
        this.futureRadioButton.addActionListener(this.actionListenerFuture);
        this.actionListenerInformation = new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PanelProcess.this.enableDisableNotActionable();
            }
        };
        this.informationRadioButton.addActionListener(this.actionListenerInformation);
    }

    private void removeListeners() {
        this.actionable.removeObserver(this.actionableObserver);
        this.notesEditorPane.removeHyperlinkListener(this.hyperlinkListener);
        this.deleteRadioButton.removeActionListener(this.actionListenerDelete);
        this.futureRadioButton.removeActionListener(this.actionListenerFuture);
        this.informationRadioButton.removeActionListener(this.actionListenerInformation);
        this.actionableObserver = null;
        this.hyperlinkListener = null;
        this.actionListenerDelete = null;
        this.actionListenerFuture = null;
        this.actionListenerInformation = null;
    }

    private void hyperlink(HyperlinkEvent evt) {
        URL url = evt.getURL();
        if (url == null) {
            return;
        }
        if (evt.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
            Open.open((URL)url);
        }
    }

    private void enableDisableNotActionable() {
        this.tickleDateLabel.setEnabled(this.futureRadioButton.isSelected());
        this.tickleDateButton.setEnabled(this.futureRadioButton.isSelected());
        if (this.deleteRadioButton.isSelected()) {
            this.notesEditorPane.setEnabled(false);
            this.notesEditorPane.setEditable(false);
        } else {
            this.notesEditorPane.setEnabled(true);
        }
    }

    private Thought getNextUnprocessedThought() {
        for (Thought thought : this.thoughtManager.list()) {
            if (thought.isProcessed()) continue;
            return thought;
        }
        return null;
    }

    private int countUnprocessedThoughts() {
        int c = 0;
        for (Thought thought : this.thoughtManager.list()) {
            if (thought.isProcessed()) continue;
            ++c;
        }
        return c;
    }

    public synchronized void initModel() {
        this.thought = this.getNextUnprocessedThought();
        this.panelThought.initModel(this.thought, this.countUnprocessedThoughts());
        if (this.thought == null) {
            this.action = null;
            this.actionable.setActionable(true);
            this.panelActionable.initModel(null);
        } else {
            this.action = this.thought.getAction();
            if (this.action == null) {
                this.action = new Action((IDGenerator)this.data);
                this.action.setDescription(this.thought.getDescription());
                this.action.setTopic(this.thought.getTopic());
                this.action.setNotes(this.thought.getNotes());
                this.notesEditorPane.setText(this.thought.getNotes());
            } else {
                this.notesEditorPane.setText(this.action.getNotes());
            }
            this.actionable.setActionable(true);
            this.panelActionable.initModel(this.actionable);
        }
        this.panelSuccess.initModel(this.action);
        this.actionPanel.initModel(this.action);
        this.newProjectCheckBox.setSelected(false);
        this.addToProjectComboBox.setSelectedIndex(0);
        this.deleteRadioButton.setSelected(true);
        this.tickleDateButton.setDate(null);
        this.setEnabled(this.thought != null);
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.addToProjectLabel.setEnabled(enabled);
        this.addToProjectComboBox.setEnabled(enabled);
        this.newProjectCheckBox.setEnabled(enabled);
        this.processNodeProvider.provide(enabled ? new ProcessNode(this) : null);
        this.showHidePanels();
        if (enabled) {
            this.panelActionable.clickYes();
        }
    }

    private void showHidePanels() {
        if (this.actionable.isActionable()) {
            LOG.fine("Actionable");
            this.panelSuccess.setVisible(ActionPrefs.isShowSuccess());
            this.panelAction.setVisible(true);
            this.panelProject.setVisible(true);
            this.panelNotActionable.setVisible(false);
        } else {
            LOG.fine("Not Actionable");
            this.panelSuccess.setVisible(false);
            this.panelAction.setVisible(false);
            this.panelProject.setVisible(false);
            this.panelNotActionable.setVisible(true);
            this.enableDisableNotActionable();
        }
        this.invalidate();
        this.repaint();
    }

    private void initComponents() {
        this.notActionableButtonGroup = new ButtonGroup();
        this.panelThought = new PanelThought();
        this.panelActionable = new PanelActionable();
        this.panelAction = new JPanel();
        this.panelSuccess = new PanelSuccess();
        this.panelProject = new JPanel();
        this.newProjectCheckBox = new JCheckBox();
        this.addToProjectLabel = new JLabel();
        this.addToProjectComboBox = new ProjectsComboBox();
        this.panelNotActionable = new JPanel();
        this.deleteLabel = new JLabel();
        this.deleteRadioButton = new JRadioButton();
        this.futureRadioButton = new JRadioButton();
        this.futureLabel = new JLabel();
        this.informationRadioButton = new JRadioButton();
        this.informationLabel = new JLabel();
        this.tickleDateButton = new DateButton();
        this.notesEditorPane = new HyperEditorPane();
        this.tickleDateLabel = new JLabel();
        this.panelAction.setLayout(new BorderLayout());
        this.panelAction.setBorder(BorderFactory.createTitledBorder(NbBundle.getMessage(PanelProcess.class, (String)"PanelAction.title")));
        this.panelAction.add("Center", this.actionPanel);
        this.panelProject.setBorder(BorderFactory.createTitledBorder(NbBundle.getMessage(PanelProcess.class, (String)"PanelProject.title")));
        this.newProjectCheckBox.setText(NbBundle.getMessage(PanelProcess.class, (String)"PanelProject.createNew"));
        this.newProjectCheckBox.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.newProjectCheckBox.setHorizontalTextPosition(10);
        this.newProjectCheckBox.setMargin(new Insets(0, 0, 0, 0));
        this.addToProjectLabel.setText(NbBundle.getMessage(PanelProcess.class, (String)"PanelProject.addToProject"));
        GroupLayout panelProjectLayout = new GroupLayout((Container)this.panelProject);
        this.panelProject.setLayout((LayoutManager)panelProjectLayout);
        panelProjectLayout.setHorizontalGroup((GroupLayout.Group)panelProjectLayout.createParallelGroup(1).add((GroupLayout.Group)panelProjectLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)panelProjectLayout.createParallelGroup(1).add((Component)this.newProjectCheckBox, -2, 425, -2).add((GroupLayout.Group)panelProjectLayout.createSequentialGroup().add((Component)this.addToProjectLabel).add(17, 17, 17).add((Component)this.addToProjectComboBox, -2, 300, -2))).addContainerGap(127, Short.MAX_VALUE)));
        panelProjectLayout.setVerticalGroup((GroupLayout.Group)panelProjectLayout.createParallelGroup(1).add((GroupLayout.Group)panelProjectLayout.createSequentialGroup().add(17, 17, 17).add((Component)this.newProjectCheckBox).addPreferredGap(0).add((GroupLayout.Group)panelProjectLayout.createParallelGroup(3).add((Component)this.addToProjectLabel).add((Component)this.addToProjectComboBox, -2, 21, -2)).addContainerGap(-1, Short.MAX_VALUE)));
        this.panelNotActionable.setBorder(BorderFactory.createTitledBorder(NbBundle.getMessage(PanelProcess.class, (String)"PanelNotActionable")));
        this.deleteLabel.setIcon(new ImageIcon(this.getClass().getResource("/tr/view/process/panels/Trash16.gif")));
        this.notActionableButtonGroup.add(this.deleteRadioButton);
        this.deleteRadioButton.setText(NbBundle.getMessage(PanelProcess.class, (String)"PanelNotActionable.delete"));
        this.deleteRadioButton.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.deleteRadioButton.setMargin(new Insets(0, 0, 0, 0));
        this.notActionableButtonGroup.add(this.futureRadioButton);
        this.futureRadioButton.setText(NbBundle.getMessage(PanelProcess.class, (String)"PanelNotActionable.future"));
        this.futureRadioButton.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.futureRadioButton.setMargin(new Insets(0, 0, 0, 0));
        this.futureLabel.setIcon(new ImageIcon(this.getClass().getResource("/tr/view/process/panels/Future16.gif")));
        this.notActionableButtonGroup.add(this.informationRadioButton);
        this.informationRadioButton.setText(NbBundle.getMessage(PanelProcess.class, (String)"PanelNotActionable.information"));
        this.informationRadioButton.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.informationRadioButton.setMargin(new Insets(0, 0, 0, 0));
        this.informationLabel.setIcon(new ImageIcon(this.getClass().getResource("/tr/view/process/panels/Information16.gif")));
        this.tickleDateButton.setNoSelectionText("Select a date");
        this.tickleDateLabel.setText(NbBundle.getMessage(PanelProcess.class, (String)"PanelProcess.tickle"));
        GroupLayout panelNotActionableLayout = new GroupLayout((Container)this.panelNotActionable);
        this.panelNotActionable.setLayout((LayoutManager)panelNotActionableLayout);
        panelNotActionableLayout.setHorizontalGroup((GroupLayout.Group)panelNotActionableLayout.createParallelGroup(1).add((GroupLayout.Group)panelNotActionableLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)panelNotActionableLayout.createParallelGroup(1).add((Component)this.notesEditorPane, -1, 691, Short.MAX_VALUE).add((GroupLayout.Group)panelNotActionableLayout.createSequentialGroup().add((GroupLayout.Group)panelNotActionableLayout.createParallelGroup(1).add((Component)this.deleteLabel).add((Component)this.futureLabel).add((Component)this.informationLabel)).addPreferredGap(0).add((GroupLayout.Group)panelNotActionableLayout.createParallelGroup(1, false).add((Component)this.deleteRadioButton, -1, -1, Short.MAX_VALUE).add(2, (Component)this.informationRadioButton, -1, -1, Short.MAX_VALUE).add((GroupLayout.Group)panelNotActionableLayout.createSequentialGroup().add((Component)this.futureRadioButton).add(12, 12, 12).add((Component)this.tickleDateLabel))).add(2, 2, 2).add((Component)this.tickleDateButton, -2, 144, -2))).addContainerGap()));
        panelNotActionableLayout.setVerticalGroup((GroupLayout.Group)panelNotActionableLayout.createParallelGroup(1).add((GroupLayout.Group)panelNotActionableLayout.createSequentialGroup().add(18, 18, 18).add((GroupLayout.Group)panelNotActionableLayout.createParallelGroup(3).add((Component)this.deleteLabel, -2, 16, -2).add((Component)this.deleteRadioButton)).addPreferredGap(0).add((GroupLayout.Group)panelNotActionableLayout.createParallelGroup(3).add((Component)this.futureLabel).add((Component)this.futureRadioButton).add((Component)this.tickleDateLabel).add((Component)this.tickleDateButton, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)panelNotActionableLayout.createParallelGroup(3).add((Component)this.informationLabel).add((Component)this.informationRadioButton)).add(20, 20, 20).add((Component)this.notesEditorPane, -1, 78, Short.MAX_VALUE).addContainerGap()));
        GroupLayout layout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.panelAction, -1, 727, Short.MAX_VALUE).add((Component)this.panelSuccess, -1, 727, Short.MAX_VALUE).add((Component)this.panelProject, -1, -1, Short.MAX_VALUE).add((Component)this.panelActionable, -1, 727, Short.MAX_VALUE).add((Component)this.panelThought, -1, 727, Short.MAX_VALUE).add(2, (Component)this.panelNotActionable, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.panelThought, -2, -1, -2).addPreferredGap(0).add((Component)this.panelActionable, -2, -1, -2).addPreferredGap(0).add((Component)this.panelSuccess, -2, -1, -2).addPreferredGap(0).add((Component)this.panelAction, -2, 28, Short.MAX_VALUE).addPreferredGap(0).add((Component)this.panelProject, -2, -1, -2).addPreferredGap(0).add((Component)this.panelNotActionable, -1, 220, Short.MAX_VALUE)));
    }

    public String validateProcessing() {
        ActionStateScheduled state;
        if (!this.actionable.isActionable()) {
            return null;
        }
        boolean valid = true;
        StringBuffer sb = new StringBuffer();
        if (this.action.getDescription().trim().equals("")) {
            valid = false;
            sb.append("- An action description must be entered. \n");
        }
        if (this.action.isStateScheduled() && (state = (ActionStateScheduled)this.action.getState()).getDate() == null) {
            valid = false;
            sb.append("- A scheduled date must be entered. \n");
        }
        if (this.action.isStateDelegated() && (state = (ActionStateDelegated)this.action.getState()).getTo().trim().equals("")) {
            valid = false;
            sb.append("- A delegate must be entered. \n");
        }
        if (valid) {
            return null;
        }
        return sb.toString();
    }

    public void process() {
        if (this.thought == null || this.action == null) {
            return;
        }
        String problems = this.validateProcessing();
        if (problems != null) {
            String t = "Process Thought Validation";
            String m = "\nPlease fix the following problems:      \n\n" + problems + "\n\n";
            JOptionPane.showMessageDialog(null, m, t, 2);
            return;
        }
        if (this.actionable.isActionable()) {
            this.action.setThought(this.thought);
            this.action.setTopic(this.thought.getTopic());
            if (this.newProjectCheckBox.isSelected()) {
                Project project = new Project((IDGenerator)this.data);
                project.setThought(this.thought);
                project.setDescription(this.thought.getDescription());
                project.setTopic(this.thought.getTopic());
                project.setDone(false);
                project.setVision(this.action.getSuccess());
                project.add((Item)this.action);
                ProjectsComboBoxModel.ProjectItem parentItem = (ProjectsComboBoxModel.ProjectItem)this.addToProjectComboBox.getSelectedItem();
                if (parentItem == null || parentItem.project == null) {
                    this.projects.add((Item)project);
                } else {
                    project.setSequencing(parentItem.project.isSequencing());
                    project.setSequenceType(parentItem.project.getSequenceType());
                    parentItem.project.add((Item)project);
                }
            } else {
                ProjectsComboBoxModel.ProjectItem parentItem = (ProjectsComboBoxModel.ProjectItem)this.addToProjectComboBox.getSelectedItem();
                if (parentItem == null || parentItem.project == null) {
                    this.singleActions.add((Item)this.action);
                } else {
                    parentItem.project.add((Item)this.action);
                }
            }
        } else if (this.deleteRadioButton.isSelected()) {
            this.thoughtManager.remove((Observable)this.thought);
        } else if (this.informationRadioButton.isSelected()) {
            Information information = new Information();
            information.setTopic(this.thought.getTopic());
            information.setDescription(this.thought.getDescription());
            information.setNotes(this.notesEditorPane.getText());
            this.informationManager.add((Observable)information);
        } else if (this.futureRadioButton.isSelected()) {
            Future future = new Future();
            future.setThought(this.thought);
            future.setDescription(this.thought.getDescription());
            future.setTopic(this.thought.getTopic());
            future.setTickle(this.tickleDateButton.getDate());
            future.setNotes(this.notesEditorPane.getText());
            this.futureManager.add((Observable)future);
        }
        this.thought.setProcessed(true);
        this.initModel();
    }

    public void update(Observable observable, Object arg) {
        if (observable == this.thoughtManager && this.thought == null) {
            this.initModel();
        }
    }
}

