/*
 * Decompiled with CFR 0.152.
 */
package tr.view.process.panels;

import java.awt.Component;
import java.awt.Container;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.SwingUtilities;
import org.jdesktop.layout.GroupLayout;
import org.openide.util.NbBundle;
import tr.view.process.panels.Actionable;
import tr.view.topic.TopicComboBoxModel;

public class PanelActionable
extends JPanel {
    private ActionListener actionListenerYes;
    private ActionListener actionListenerNo;
    private ButtonGroup actionableButtonGroup;
    private JRadioButton noRadioButton;
    private JRadioButton yesRadioButton;
    private static final Logger LOG = Logger.getLogger("tr.view.process");
    private Actionable actionable;
    private TopicComboBoxModel topicsModel;
    private boolean updating;

    public PanelActionable() {
        this.initComponents();
        this.initModel(null);
    }

    public void addNotify() {
        super.addNotify();
        this.addListeners();
    }

    public void removeNotify() {
        this.removeListeners();
        super.removeNotify();
    }

    public void clickYes() {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                PanelActionable.this.yesRadioButton.doClick();
            }
        });
    }

    private void addListeners() {
        this.actionListenerYes = new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PanelActionable.this.yesActionPerformed(evt);
            }
        };
        this.yesRadioButton.addActionListener(this.actionListenerYes);
        this.actionListenerNo = new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PanelActionable.this.noActionPerformed(evt);
            }
        };
        this.noRadioButton.addActionListener(this.actionListenerNo);
    }

    private void removeListeners() {
        this.yesRadioButton.removeActionListener(this.actionListenerYes);
        this.noRadioButton.removeActionListener(this.actionListenerNo);
        this.actionListenerYes = null;
        this.actionListenerNo = null;
    }

    private void yesActionPerformed(ActionEvent evt) {
        if (this.updating || this.actionable == null) {
            return;
        }
        this.actionable.setActionable(true);
    }

    private void noActionPerformed(ActionEvent evt) {
        if (this.updating || this.actionable == null) {
            return;
        }
        this.actionable.setActionable(false);
    }

    public void initModel(Actionable actionable) {
        this.actionable = actionable;
        this.initView();
    }

    private void initView() {
        this.updating = true;
        if (this.actionable == null) {
            this.yesRadioButton.setSelected(true);
        } else {
            this.yesRadioButton.setSelected(this.actionable.isActionable());
        }
        this.updating = false;
        this.setEnabled(this.actionable != null);
    }

    public void setEnabled(boolean enable) {
        super.setEnabled(enable);
        this.yesRadioButton.setEnabled(enable);
        this.noRadioButton.setEnabled(enable);
    }

    private void initComponents() {
        this.actionableButtonGroup = new ButtonGroup();
        this.yesRadioButton = new JRadioButton();
        this.noRadioButton = new JRadioButton();
        this.setBorder(BorderFactory.createTitledBorder(NbBundle.getMessage(PanelActionable.class, (String)"PanelActionable.title")));
        this.actionableButtonGroup.add(this.yesRadioButton);
        this.yesRadioButton.setText(NbBundle.getMessage(PanelActionable.class, (String)"PanelActionable.yes"));
        this.yesRadioButton.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.yesRadioButton.setMargin(new Insets(0, 0, 0, 0));
        this.actionableButtonGroup.add(this.noRadioButton);
        this.noRadioButton.setText(NbBundle.getMessage(PanelActionable.class, (String)"PanelActionable.no"));
        this.noRadioButton.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.noRadioButton.setMargin(new Insets(0, 0, 0, 0));
        GroupLayout layout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((Component)this.yesRadioButton).add(27, 27, 27).add((Component)this.noRadioButton).addContainerGap(282, Short.MAX_VALUE)));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.yesRadioButton).add((Component)this.noRadioButton)).addContainerGap(-1, Short.MAX_VALUE)));
    }
}

