/*
 * Decompiled with CFR 0.152.
 */
package org.openide.text;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.VetoableChangeListener;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.Arrays;
import java.util.Date;
import javax.swing.text.EditorKit;
import javax.swing.text.StyledDocument;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileChangeAdapter;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.loaders.MultiDataObject;
import org.openide.loaders.OpenSupport;
import org.openide.nodes.CookieSet;
import org.openide.nodes.Node;
import org.openide.nodes.NodeAdapter;
import org.openide.nodes.NodeListener;
import org.openide.nodes.NodeOp;
import org.openide.text.CloneableEditor;
import org.openide.text.CloneableEditorSupport;
import org.openide.text.Line;
import org.openide.text.SimpleES;
import org.openide.util.Lookup;
import org.openide.util.Mutex;
import org.openide.util.NbBundle;
import org.openide.util.UserQuestionException;
import org.openide.util.WeakListeners;
import org.openide.util.lookup.AbstractLookup;
import org.openide.util.lookup.InstanceContent;
import org.openide.windows.CloneableOpenSupport;

public class DataEditorSupport
extends CloneableEditorSupport {
    static final ErrorManager ERR = ErrorManager.getDefault().getInstance("org.openide.text.DataEditorSupport");
    static final boolean ERR_LOG = ERR.isLoggable(1);
    private final DataObject obj;
    private NodeListener nodeL;

    public DataEditorSupport(DataObject dataObject, CloneableEditorSupport.Env env) {
        super(env, (Lookup)new DOEnvLookup(dataObject));
        this.obj = dataObject;
    }

    final CloneableEditorSupport.Env desEnv() {
        return (CloneableEditorSupport.Env)this.env;
    }

    public static CloneableEditorSupport create(DataObject dataObject, MultiDataObject.Entry entry, CookieSet cookieSet) {
        return new SimpleES(dataObject, entry, cookieSet);
    }

    public final DataObject getDataObject() {
        return this.obj;
    }

    protected String messageOpening() {
        return NbBundle.getMessage((Class)DataObject.class, (String)"CTL_ObjectOpen", (Object)this.obj.getPrimaryFile().getNameExt(), (Object)FileUtil.getFileDisplayName((FileObject)this.obj.getPrimaryFile()));
    }

    protected String messageOpened() {
        return NbBundle.getMessage((Class)DataObject.class, (String)"CTL_ObjectOpened", (Object)this.obj.getPrimaryFile().getNameExt(), (Object)FileUtil.getFileDisplayName((FileObject)this.obj.getPrimaryFile()));
    }

    protected String messageSave() {
        return NbBundle.getMessage((Class)DataObject.class, (String)"MSG_SaveFile", (Object)this.obj.getPrimaryFile().getNameExt());
    }

    protected String messageName() {
        if (!this.obj.isValid()) {
            return "";
        }
        return this.addFlagsToName(this.obj.getNodeDelegate().getDisplayName());
    }

    protected String messageHtmlName() {
        if (!this.obj.isValid()) {
            return null;
        }
        String string = this.obj.getNodeDelegate().getHtmlDisplayName();
        if (string != null) {
            if (!string.startsWith("<html>")) {
                string = "<html>" + string;
            }
            string = this.addFlagsToName(string);
        }
        return string;
    }

    private String addFlagsToName(String string) {
        int n = 3;
        if (this.isModified()) {
            n = !this.obj.getPrimaryFile().canWrite() ? 2 : 1;
        } else if (!this.obj.getPrimaryFile().canWrite()) {
            n = 0;
        }
        return NbBundle.getMessage((Class)DataObject.class, (String)"LAB_EditorName", (Object)new Integer(n), (Object)string);
    }

    protected String documentID() {
        if (!this.obj.isValid()) {
            return "";
        }
        return this.obj.getPrimaryFile().getName();
    }

    protected String messageToolTip() {
        return FileUtil.getFileDisplayName((FileObject)this.obj.getPrimaryFile());
    }

    protected String messageLine(Line line) {
        return NbBundle.getMessage((Class)DataObject.class, (String)"FMT_LineDisplayName2", (Object)this.obj.getPrimaryFile().getNameExt(), (Object)FileUtil.getFileDisplayName((FileObject)this.obj.getPrimaryFile()), (Object)new Integer(line.getLineNumber() + 1));
    }

    protected void initializeCloneableEditor(CloneableEditor cloneableEditor) {
        if (this.obj.isValid()) {
            Node node = this.obj.getNodeDelegate();
            cloneableEditor.setActivatedNodes(new Node[]{node});
            cloneableEditor.setIcon(node.getIcon(1));
            DataNodeListener dataNodeListener = new DataNodeListener(cloneableEditor);
            node.addNodeListener(NodeOp.weakNodeListener((NodeListener)dataNodeListener, (Object)node));
            this.nodeL = dataNodeListener;
        }
    }

    protected void notifyClosed() {
        this.nodeL = null;
        super.notifyClosed();
    }

    protected StyledDocument createStyledDocument(EditorKit editorKit) {
        StyledDocument styledDocument = super.createStyledDocument(editorKit);
        styledDocument.putProperty("title", FileUtil.getFileDisplayName((FileObject)this.obj.getPrimaryFile()));
        styledDocument.putProperty("stream", this.obj);
        return styledDocument;
    }

    protected boolean canClose() {
        if (this.desEnv().isModified() && this.isEnvReadOnly()) {
            Object object = DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Confirmation((Object)NbBundle.getMessage((Class)DataObject.class, (String)"MSG_FileReadOnlyClosing", (Object[])new Object[]{((Env)this.env).getFileImpl().getNameExt()}), 2, 2));
            return object == NotifyDescriptor.OK_OPTION;
        }
        return super.canClose();
    }

    public void saveDocument() throws IOException {
        if (this.desEnv().isModified() && this.isEnvReadOnly()) {
            IOException iOException = new IOException("File is read-only: " + ((Env)this.env).getFileImpl());
            ERR.annotate((Throwable)iOException, 256, null, NbBundle.getMessage((Class)DataObject.class, (String)"MSG_FileReadOnlySaving", (Object[])new Object[]{((Env)this.env).getFileImpl().getNameExt()}), null, null);
            throw iOException;
        }
        super.saveDocument();
    }

    boolean isEnvReadOnly() {
        CloneableEditorSupport.Env env = this.desEnv();
        return env instanceof Env && !((Env)env).getFileImpl().canWrite();
    }

    final DataObject getDataObjectHack2() {
        return this.obj;
    }

    final void callUpdateTitles() {
        this.updateTitles();
    }

    public static DataObject findDataObject(Line line) {
        if (line == null) {
            throw new NullPointerException();
        }
        return (DataObject)line.getLookup().lookup(DataObject.class);
    }

    private static class DOEnvLookup
    extends AbstractLookup
    implements PropertyChangeListener {
        private DataObject dobj;
        private InstanceContent ic;

        public DOEnvLookup(DataObject dataObject) {
            this(dataObject, new InstanceContent());
        }

        private DOEnvLookup(DataObject dataObject, InstanceContent instanceContent) {
            super((AbstractLookup.Content)instanceContent);
            this.ic = instanceContent;
            this.dobj = dataObject;
            dataObject.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this, (Object)dataObject));
            this.updateLookup();
        }

        private void updateLookup() {
            this.ic.set(Arrays.asList(this.dobj, this.dobj.getPrimaryFile()), null);
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            String string = propertyChangeEvent.getPropertyName();
            if (string == null || string == "primaryFile") {
                this.updateLookup();
            }
        }
    }

    private final class DataNodeListener
    extends NodeAdapter {
        CloneableEditor editor;

        DataNodeListener(CloneableEditor cloneableEditor) {
            this.editor = cloneableEditor;
        }

        public void propertyChange(final PropertyChangeEvent propertyChangeEvent) {
            Mutex.EVENT.writeAccess(new Runnable(){

                public void run() {
                    if ("displayName".equals(propertyChangeEvent.getPropertyName())) {
                        DataEditorSupport.this.callUpdateTitles();
                    }
                    if ("icon".equals(propertyChangeEvent.getPropertyName()) && DataEditorSupport.this.obj.isValid()) {
                        DataNodeListener.this.editor.setIcon(DataEditorSupport.this.obj.getNodeDelegate().getIcon(1));
                    }
                }
            });
        }
    }

    public static abstract class Env
    extends OpenSupport.Env
    implements CloneableEditorSupport.Env,
    Serializable,
    PropertyChangeListener,
    VetoableChangeListener {
        static final long serialVersionUID = -2945098431098324441L;
        private transient FileObject fileObject;
        transient FileLock fileLock;
        private transient boolean warned;

        public Env(DataObject dataObject) {
            super(dataObject);
        }

        private FileObject getFileImpl() {
            this.changeFile();
            return this.fileObject;
        }

        protected abstract FileObject getFile();

        protected abstract FileLock takeLock() throws IOException;

        protected final void changeFile() {
            boolean bl;
            FileObject fileObject = this.getFile();
            if (fileObject.equals(this.fileObject)) {
                return;
            }
            if (this.fileLock != null) {
                if (this.fileLock.isValid()) {
                    ERR.log("changeFile releaseLock: " + this.fileLock + " for " + this.fileObject);
                    this.fileLock.releaseLock();
                    bl = true;
                } else {
                    this.fileLock = null;
                    bl = false;
                }
            } else {
                bl = false;
            }
            this.fileObject = fileObject;
            ERR.log("changeFile: " + fileObject + " for " + this.fileObject);
            this.fileObject.addFileChangeListener((FileChangeListener)new EnvListener(this));
            if (bl) {
                try {
                    this.fileLock = this.takeLock();
                    ERR.log("changeFile takeLock: " + this.fileLock + " for " + this.fileObject);
                }
                catch (IOException iOException) {
                    ErrorManager.getDefault().notify(1, (Throwable)iOException);
                }
            }
        }

        public InputStream inputStream() throws IOException {
            FileObject fileObject = this.getFileImpl();
            if (!this.warned && fileObject.getSize() > 0x100000L) {
                class ME
                extends UserQuestionException {
                    private long size;
                    private final /* synthetic */ FileObject val$fo;

                    public ME(long l, FileObject fileObject) {
                        this.val$fo = fileObject;
                        super("The file is too big. " + l + " bytes.");
                        this.size = l;
                    }

                    public String getLocalizedMessage() {
                        Object[] objectArray = new Object[]{this.val$fo.getPath(), this.val$fo.getNameExt(), new Long(this.size), new Long(this.size / 1024L + 1L), new Long(this.size / 0x100000L), new Long(this.size / 0x40000000L)};
                        return NbBundle.getMessage((Class)(class$org$openide$loaders$DataObject == null ? (class$org$openide$loaders$DataObject = DataEditorSupport.class$("org.openide.loaders.DataObject")) : class$org$openide$loaders$DataObject), (String)"MSG_ObjectIsTooBig", (Object[])objectArray);
                    }

                    public void confirmed() {
                        Env.this.warned = true;
                    }
                }
                throw new ME(fileObject.getSize(), fileObject);
            }
            InputStream inputStream = this.getFileImpl().getInputStream();
            return inputStream;
        }

        public OutputStream outputStream() throws IOException {
            ERR.log("outputStream: " + this.fileLock + " for " + this.fileObject);
            if (this.fileLock == null || !this.fileLock.isValid()) {
                this.fileLock = this.takeLock();
            }
            ERR.log("outputStream after takeLock: " + this.fileLock + " for " + this.fileObject);
            try {
                return this.getFileImpl().getOutputStream(this.fileLock);
            }
            catch (IOException iOException) {
                if (this.fileLock == null || !this.fileLock.isValid()) {
                    this.fileLock = this.takeLock();
                }
                ERR.log("ugly workaround for #40552: " + this.fileLock + " for " + this.fileObject);
                return this.getFileImpl().getOutputStream(this.fileLock);
            }
        }

        public Date getTime() {
            this.getFileImpl().refresh(false);
            return this.getFileImpl().lastModified();
        }

        public String getMimeType() {
            return this.getFileImpl().getMIMEType();
        }

        public void markModified() throws IOException {
            if (this.fileLock == null || !this.fileLock.isValid()) {
                this.fileLock = this.takeLock();
            }
            ERR.log("markModified: " + this.fileLock + " for " + this.fileObject);
            if (!this.getFileImpl().canWrite()) {
                if (this.fileLock != null && this.fileLock.isValid()) {
                    this.fileLock.releaseLock();
                }
                throw new IOException("File " + this.getFileImpl().getNameExt() + " is read-only!");
            }
            this.getDataObject().setModified(true);
        }

        public void unmarkModified() {
            ERR.log("unmarkModified: " + this.fileLock + " for " + this.fileObject);
            if (this.fileLock != null && this.fileLock.isValid()) {
                this.fileLock.releaseLock();
                ERR.log("releaseLock: " + this.fileLock + " for " + this.fileObject);
            }
            this.getDataObject().setModified(false);
        }

        final void fileChanged(boolean bl, long l) {
            ERR.log("fileChanged: " + bl + " for " + this.fileObject);
            if (bl) {
                this.firePropertyChange("time", null, null);
            } else {
                this.firePropertyChange("time", null, new Date(l));
            }
        }

        final void fileRemoved(boolean bl) {
        }

        public CloneableOpenSupport findCloneableOpenSupport() {
            CloneableOpenSupport.Env env;
            CloneableOpenSupport cloneableOpenSupport = super.findCloneableOpenSupport();
            if (cloneableOpenSupport instanceof DataEditorSupport && (env = ((DataEditorSupport)cloneableOpenSupport).env) != this && env instanceof Env) {
                ((Env)env).warned = this.warned;
            }
            return cloneableOpenSupport;
        }

        private void readObject(ObjectInputStream objectInputStream) throws ClassNotFoundException, IOException {
            objectInputStream.defaultReadObject();
            this.warned = true;
        }
    }

    private static final class EnvListener
    extends FileChangeAdapter {
        private Reference env;

        public EnvListener(Env env) {
            this.env = new WeakReference<Env>(env);
        }

        public void fileDeleted(FileEvent fileEvent) {
            Env env = (Env)this.env.get();
            FileObject fileObject = fileEvent.getFile();
            if (env == null || env.getFileImpl() != fileObject) {
                fileObject.removeFileChangeListener((FileChangeListener)this);
                return;
            }
            fileObject.removeFileChangeListener((FileChangeListener)this);
            env.fileRemoved(true);
            fileObject.addFileChangeListener((FileChangeListener)this);
        }

        public void fileChanged(FileEvent fileEvent) {
            Env env = (Env)this.env.get();
            if (env == null || env.getFileImpl() != fileEvent.getFile()) {
                fileEvent.getFile().removeFileChangeListener((FileChangeListener)this);
                return;
            }
            if (fileEvent.getFile().isVirtual()) {
                fileEvent.getFile().removeFileChangeListener((FileChangeListener)this);
                env.fileRemoved(true);
                fileEvent.getFile().addFileChangeListener((FileChangeListener)this);
            } else {
                env.fileChanged(fileEvent.isExpected(), fileEvent.getTime());
            }
        }
    }
}

