/*
 * Decompiled with CFR 0.152.
 */
package org.openide.loaders;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectExistsException;
import org.openide.loaders.ExtensionList;
import org.openide.loaders.FileEntry;
import org.openide.loaders.MultiDataObject;
import org.openide.loaders.MultiFileLoader;
import org.openide.util.io.SafeException;

public abstract class UniFileLoader
extends MultiFileLoader {
    static final long serialVersionUID = -6190649471408985837L;
    public static final String PROP_EXTENSIONS = "extensions";

    protected UniFileLoader(Class clazz) {
        super(clazz);
    }

    protected UniFileLoader(String string) {
        super(string);
    }

    protected FileObject findPrimaryFile(FileObject fileObject) {
        if (fileObject.isFolder()) {
            return null;
        }
        return this.getExtensions().isRegistered(fileObject) ? fileObject : null;
    }

    protected abstract MultiDataObject createMultiObject(FileObject var1) throws DataObjectExistsException, IOException;

    protected MultiDataObject.Entry createPrimaryEntry(MultiDataObject multiDataObject, FileObject fileObject) {
        return new FileEntry(multiDataObject, fileObject);
    }

    protected MultiDataObject.Entry createSecondaryEntry(MultiDataObject multiDataObject, FileObject fileObject) {
        StringBuffer stringBuffer = new StringBuffer("Error in data system. Please reopen the bug #17014 with the following message: ");
        stringBuffer.append("\n  DataLoader:");
        stringBuffer.append(((Object)((Object)this)).getClass().getName());
        stringBuffer.append("\n  DataObject:");
        stringBuffer.append(multiDataObject);
        stringBuffer.append("\n  PrimaryEntry:");
        stringBuffer.append(multiDataObject.getPrimaryEntry());
        stringBuffer.append("\n  PrimaryFile:");
        stringBuffer.append(multiDataObject.getPrimaryFile());
        stringBuffer.append("\n  SecondaryFile:");
        stringBuffer.append(fileObject);
        stringBuffer.append("\n");
        throw new UnsupportedOperationException(stringBuffer.toString());
    }

    final DataObject checkCollision(DataObject dataObject, FileObject fileObject) {
        return null;
    }

    final void checkConsistency(MultiDataObject multiDataObject) {
    }

    final void checkFiles(MultiDataObject multiDataObject) {
    }

    public void setExtensions(ExtensionList extensionList) {
        this.putProperty(PROP_EXTENSIONS, extensionList, true);
    }

    public ExtensionList getExtensions() {
        ExtensionList extensionList = (ExtensionList)this.getProperty(PROP_EXTENSIONS);
        if (extensionList == null) {
            extensionList = new ExtensionList();
            this.putProperty(PROP_EXTENSIONS, extensionList, false);
        }
        return extensionList;
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        super.writeExternal(objectOutput);
        objectOutput.writeObject(this.getProperty(PROP_EXTENSIONS));
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        SafeException safeException;
        try {
            super.readExternal(objectInput);
            safeException = null;
        }
        catch (SafeException safeException2) {
            safeException = safeException2;
        }
        this.setExtensions((ExtensionList)objectInput.readObject());
        if (safeException != null) {
            throw safeException;
        }
    }
}

