/*
 * Decompiled with CFR 0.152.
 */
package org.openide.loaders;

import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.FocusEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.net.URL;
import java.util.LinkedList;
import java.util.ListIterator;
import java.util.ResourceBundle;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EtchedBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.text.EditorKit;
import javax.swing.text.html.HTMLEditorKit;
import javax.swing.text.html.StyleSheet;
import org.openide.awt.HtmlBrowser;
import org.openide.explorer.ExplorerManager;
import org.openide.explorer.view.BeanTreeView;
import org.openide.explorer.view.NodeTreeModel;
import org.openide.explorer.view.Visualizer;
import org.openide.filesystems.Repository;
import org.openide.loaders.DataFilter;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataNode;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataShadow;
import org.openide.loaders.TemplateWizard;
import org.openide.nodes.Children;
import org.openide.nodes.FilterNode;
import org.openide.nodes.Node;
import org.openide.util.AsyncGUIJob;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.Utilities;

final class TemplateWizard1
extends JPanel
implements DataFilter,
ExplorerManager.Provider,
PropertyChangeListener,
AsyncGUIJob {
    private static final String PROP_CONTENT_SELECTED_INDEX = "WizardPanel_contentSelectedIndex";
    private static final String PROP_CONTENT_DATA = "WizardPanel_contentData";
    private ChangeListener listener;
    private DataObject template;
    private DataFolder templatesRoot;
    private ExplorerManager manager;
    private InitData initData;
    private JLabel browserLabel;
    private JPanel browserPanel;
    private JLabel noBrowser;
    private JLabel templatesLabel;
    private TemplatesTreeView treeView;
    private HtmlBrowser browser;
    static /* synthetic */ Class class$org$openide$loaders$DataShadow;

    public TemplateWizard1() {
        this.initComponents();
        this.treeView = new TemplatesTreeView();
        this.treeView.setDefaultActionAllowed(false);
        this.treeView.setPopupAllowed(false);
        this.treeView.setSelectionMode(1);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(0, 0, 11, 0);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)((Object)this.treeView), gridBagConstraints);
        ResourceBundle resourceBundle = NbBundle.getBundle((Class)TemplateWizard1.class);
        this.setName(resourceBundle.getString("LAB_TemplateChooserPanelName"));
        this.putClientProperty(PROP_CONTENT_SELECTED_INDEX, new Integer(0));
        this.putClientProperty(PROP_CONTENT_DATA, new String[]{this.getName(), "..."});
        this.putClientProperty("LAB_SelectTemplateBorder", resourceBundle.getString("LAB_SelectTemplateBorder"));
        this.putClientProperty("LAB_SelectTemplateBorder_Mnemonic", resourceBundle.getString("LAB_SelectTemplateBorder_Mnemonic"));
        this.putClientProperty("LAB_TemplateDescriptionBorder", resourceBundle.getString("LAB_TemplateDescriptionBorder"));
        this.putClientProperty("LAB_TemplateDescriptionBorder_Mnemonic", resourceBundle.getString("LAB_TemplateDescriptionBorder_Mnemonic"));
        this.putClientProperty("ACSD_TemplatesTree", resourceBundle.getString("ACSD_TemplatesTree"));
        this.putClientProperty("ACSD_TemplateWizard1", resourceBundle.getString("ACSD_TemplateWizard1"));
        this.updateRootNode(null);
        this.templatesLabel.setLabelFor((Component)((Object)this.treeView));
        this.noBrowser.setText(resourceBundle.getString("MSG_InitDescription"));
        CardLayout cardLayout = (CardLayout)this.browserPanel.getLayout();
        cardLayout.show(this.browserPanel, "noBrowser");
        Utilities.attachInitJob((Component)this, (AsyncGUIJob)this);
    }

    public void addNotify() {
        this.templatesLabel.setText((String)this.getClientProperty("LAB_SelectTemplateBorder"));
        this.templatesLabel.setDisplayedMnemonic(((String)this.getClientProperty("LAB_SelectTemplateBorder_Mnemonic")).charAt(0));
        this.browserLabel.setText((String)this.getClientProperty("LAB_TemplateDescriptionBorder"));
        this.browserLabel.setDisplayedMnemonic(((String)this.getClientProperty("LAB_TemplateDescriptionBorder_Mnemonic")).charAt(0));
        this.treeView.getAccessibleContext().setAccessibleDescription((String)this.getClientProperty("ACSD_TemplatesTree"));
        this.getAccessibleContext().setAccessibleDescription((String)this.getClientProperty("ACSD_TemplateWizard1"));
        super.addNotify();
    }

    public ExplorerManager getExplorerManager() {
        if (this.manager == null) {
            this.manager = new ExplorerManager();
            this.manager.addPropertyChangeListener((PropertyChangeListener)this);
        }
        return this.manager;
    }

    public boolean requestDefaultFocus() {
        return this.treeView.requestDefaultFocus();
    }

    public Dimension getPreferredSize() {
        return TemplateWizard.PREF_DIM;
    }

    private void updateRootNode(DataFolder dataFolder) {
        Object object;
        if (dataFolder == null && (object = Repository.getDefault().getDefaultFileSystem().findResource("/Templates")) != null && object.isFolder()) {
            dataFolder = DataFolder.findFolder(object);
        }
        if (dataFolder.equals(this.templatesRoot)) {
            return;
        }
        this.templatesRoot = dataFolder;
        object = new DataShadowFilterChildren(dataFolder.getNodeDelegate());
        this.getExplorerManager().setRootContext((Node)new DataShadowFilterNode(dataFolder.getNodeDelegate(), (Children)object, dataFolder.getNodeDelegate().getDisplayName()));
    }

    private void updateDescription(DataObject dataObject) {
        URL uRL = null;
        if (dataObject != null) {
            uRL = TemplateWizard.getDescription(dataObject);
        }
        CardLayout cardLayout = (CardLayout)this.browserPanel.getLayout();
        if (uRL != null && this.getExplorerManager().getSelectedNodes().length != 0) {
            if (this.browser != null) {
                this.browser.setURL(uRL);
                if (!this.browser.isVisible()) {
                    cardLayout.show(this.browserPanel, "browser");
                }
            }
        } else {
            cardLayout.show(this.browserPanel, "noBrowser");
        }
    }

    private void initComponents() {
        this.browserPanel = new JPanel();
        this.noBrowser = new JLabel();
        this.templatesLabel = new JLabel();
        this.browserLabel = new JLabel();
        this.setLayout(new GridBagLayout());
        this.setPreferredSize(new Dimension(0, 0));
        this.browserPanel.setLayout(new CardLayout());
        this.noBrowser.setBackground(UIManager.getDefaults().getColor("EditorPane.background"));
        this.noBrowser.setHorizontalAlignment(0);
        this.noBrowser.setMinimumSize(new Dimension(0, 25));
        this.noBrowser.setOpaque(true);
        this.browserPanel.add((Component)this.noBrowser, "noBrowser");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weighty = 0.5;
        this.add((Component)this.browserPanel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 5, 0);
        this.add((Component)this.templatesLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 5, 0);
        this.add((Component)this.browserLabel, gridBagConstraints);
    }

    private void nameFocusGained(FocusEvent focusEvent) {
    }

    private void templatesTreeValueChanged(TreeSelectionEvent treeSelectionEvent) {
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (propertyChangeEvent.getPropertyName() == "selectedNodes" && this.listener != null) {
            this.listener.stateChanged(new ChangeEvent(this));
            this.updateDescription(this.template);
        }
    }

    private void packagesListValueChanged(ListSelectionEvent listSelectionEvent) {
    }

    public boolean acceptDataObject(DataObject dataObject) {
        if (dataObject instanceof DataFolder) {
            Object object = dataObject.getPrimaryFile().getAttribute("simple");
            return object == null || Boolean.TRUE.equals(object);
        }
        return dataObject.isTemplate();
    }

    public void construct() {
        this.initData = new InitData();
        this.initData.browser = new HtmlBrowser(false, false);
        this.initData.browser.setName("browser");
        this.initData.noDescMsg = NbBundle.getBundle((Class)TemplateWizard1.class).getString("MSG_NoDescription");
        this.initData.noDescBorder = new EtchedBorder();
        Component component = this.initData.browser.getBrowserComponent();
        if (!(component instanceof JEditorPane)) {
            return;
        }
        EditorKit editorKit = ((JEditorPane)component).getEditorKitForContentType("text/html");
        if (!(editorKit instanceof HTMLEditorKit)) {
            return;
        }
        HTMLEditorKit hTMLEditorKit = (HTMLEditorKit)editorKit;
        if (hTMLEditorKit.getStyleSheet().getStyleSheets() != null) {
            return;
        }
        StyleSheet styleSheet = new StyleSheet();
        Font font = new JTextArea().getFont();
        styleSheet.addRule("body { font-size: " + font.getSize() + "; font-family: " + font.getName() + "; }");
        styleSheet.addStyleSheet(hTMLEditorKit.getStyleSheet());
        hTMLEditorKit.setStyleSheet(styleSheet);
    }

    public void finished() {
        this.browser = this.initData.browser;
        this.browserLabel.setLabelFor((Component)this.browser);
        this.browser.getAccessibleContext().setAccessibleName(this.browserLabel.getText());
        this.browserPanel.add((Component)this.browser, "browser");
        this.updateDescription(this.template);
        this.noBrowser.setText(this.initData.noDescMsg);
        this.noBrowser.setBorder(this.initData.noDescBorder);
        this.initData = null;
    }

    void implReadSettings(Object object) {
        TemplateWizard templateWizard = (TemplateWizard)((Object)object);
        templateWizard.setTitle(NbBundle.getBundle((Class)TemplateWizard.class).getString("CTL_TemplateTitle"));
        this.updateRootNode(templateWizard.getTemplatesFolder());
        this.template = templateWizard.getTemplate();
        if (this.template != null && !this.template.isValid()) {
            this.template = null;
        }
        DataFolder dataFolder = templateWizard.getTemplatesFolder();
        final LinkedList<String> linkedList = new LinkedList<String>();
        for (DataObject dataObject = this.template; dataObject != null && dataObject != dataFolder; dataObject = dataObject.getFolder()) {
            String string = dataObject.getNodeDelegate().getName();
            linkedList.addFirst(string);
        }
        RequestProcessor.getDefault().post(new Runnable(){
            private Node selection;

            public void run() {
                if (this.selection == null) {
                    Node node = TemplateWizard1.this.getExplorerManager().getRootContext();
                    ListIterator listIterator = linkedList.listIterator();
                    while (listIterator.hasNext()) {
                        String string = (String)listIterator.next();
                        if ((node = node.getChildren().findChild(string)) != null) continue;
                        node = TemplateWizard1.this.getExplorerManager().getRootContext();
                        break;
                    }
                    this.selection = node;
                    SwingUtilities.invokeLater(this);
                } else {
                    try {
                        TemplateWizard1.this.getExplorerManager().setSelectedNodes(new Node[]{this.selection});
                    }
                    catch (PropertyVetoException propertyVetoException) {
                        // empty catch block
                    }
                }
            }
        }, 300, 1);
    }

    void implStoreSettings(Object object) {
        if (this.template != null) {
            TemplateWizard templateWizard = (TemplateWizard)((Object)object);
            if (templateWizard.getTemplate() != this.template) {
                Component component = templateWizard.targetChooser().getComponent();
                if (component instanceof JComponent) {
                    ((JComponent)component).putClientProperty(PROP_CONTENT_DATA, new String[]{component.getName()});
                    ((JComponent)component).putClientProperty(PROP_CONTENT_SELECTED_INDEX, new Integer(0));
                }
            } else {
                Component component = templateWizard.targetChooser().getComponent();
                if (component instanceof JComponent && ((JComponent)component).getClientProperty(PROP_CONTENT_DATA) == null) {
                    ((JComponent)component).putClientProperty(PROP_CONTENT_DATA, new String[]{component.getName()});
                    ((JComponent)component).putClientProperty(PROP_CONTENT_SELECTED_INDEX, new Integer(0));
                }
            }
            templateWizard.setTemplateImpl(this.template, false);
        }
    }

    boolean implIsValid() {
        boolean bl = false;
        Node[] nodeArray = this.getExplorerManager().getSelectedNodes();
        if (nodeArray.length == 1) {
            this.template = (DataObject)nodeArray[0].getCookie(DataObject.class);
            bl = this.template != null && this.template.isTemplate();
        }
        return bl;
    }

    void addChangeListener(ChangeListener changeListener) {
        if (this.listener != null) {
            throw new IllegalStateException();
        }
        this.listener = changeListener;
    }

    void removeChangeListener(ChangeListener changeListener) {
        this.listener = null;
    }

    private class DataShadowFilterChildren
    extends FilterNode.Children {
        public DataShadowFilterChildren(Node node) {
            super(node);
        }

        protected Node[] createNodes(Object object) {
            Node node = (Node)object;
            String string = node.getDisplayName();
            DataObject dataObject = null;
            DataShadow dataShadow = (DataShadow)node.getCookie(class$org$openide$loaders$DataShadow == null ? (class$org$openide$loaders$DataShadow = TemplateWizard1.class$("org.openide.loaders.DataShadow")) : class$org$openide$loaders$DataShadow);
            if (dataShadow != null) {
                DataNode dataNode = new DataNode(dataShadow, Children.LEAF);
                string = dataNode.getDisplayName();
                dataObject = dataShadow.getOriginal();
                node = dataObject.getNodeDelegate();
            }
            if (dataObject == null) {
                dataObject = (DataObject)node.getCookie(class$org$openide$loaders$DataObject == null ? (class$org$openide$loaders$DataObject = TemplateWizard1.class$("org.openide.loaders.DataObject")) : class$org$openide$loaders$DataObject);
            }
            if (dataObject != null) {
                if (dataObject.isTemplate()) {
                    return new Node[]{new DataShadowFilterNode(node, Children.LEAF, string)};
                }
                if (TemplateWizard1.this.acceptDataObject(dataObject)) {
                    return new Node[]{new DataShadowFilterNode(node, (Children)new DataShadowFilterChildren(node), string)};
                }
            }
            return new Node[0];
        }
    }

    private static class DataShadowFilterNode
    extends FilterNode {
        private String name;

        public DataShadowFilterNode(Node node, Children children, String string) {
            super(node, children);
            this.name = string;
            this.disableDelegation(4);
        }

        public String getDisplayName() {
            return this.name;
        }

        public boolean canRename() {
            return false;
        }
    }

    private static final class InitData {
        HtmlBrowser browser;
        String noDescMsg;
        Border noDescBorder;

        private InitData() {
        }
    }

    private static final class TemplatesModel
    extends NodeTreeModel {
        TemplatesModel() {
        }

        public int getChildCount(Object object) {
            Node node = Visualizer.findNode((Object)object);
            DataObject dataObject = (DataObject)node.getCookie(class$org$openide$loaders$DataObject == null ? (class$org$openide$loaders$DataObject = TemplateWizard1.class$("org.openide.loaders.DataObject")) : class$org$openide$loaders$DataObject);
            return dataObject == null || dataObject.isTemplate() ? 0 : super.getChildCount(object);
        }

        public boolean isLeaf(Object object) {
            Node node = Visualizer.findNode((Object)object);
            DataObject dataObject = (DataObject)node.getCookie(class$org$openide$loaders$DataObject == null ? (class$org$openide$loaders$DataObject = TemplateWizard1.class$("org.openide.loaders.DataObject")) : class$org$openide$loaders$DataObject);
            return dataObject == null || dataObject.isTemplate();
        }
    }

    private static final class TemplatesTreeView
    extends BeanTreeView {
        TemplatesTreeView() {
            this.tree.setEditable(false);
            this.setBorder((Border)UIManager.get("Nb.ScrollPane.border"));
        }

        protected NodeTreeModel createModel() {
            return new TemplatesModel();
        }
    }
}

