/*
 * Decompiled with CFR 0.152.
 */
package org.openide.loaders;

import [Ljava.lang.String;;
import java.applet.Applet;
import java.awt.Component;
import java.awt.MenuComponent;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectStreamClass;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import org.openide.ErrorManager;
import org.openide.cookies.InstanceCookie;
import org.openide.filesystems.FileObject;
import org.openide.loaders.MultiDataObject;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.SharedClassObject;
import org.openide.util.io.NbObjectInputStream;

public class InstanceSupport
implements InstanceCookie.Of {
    private MultiDataObject.Entry entry;
    private Throwable clazzException;
    private Class clazz;
    private Boolean applet;
    private Boolean bean;
    private static Class writeRepl;

    public InstanceSupport(MultiDataObject.Entry entry) {
        this.entry = entry;
    }

    MultiDataObject.Entry entry() {
        return this.entry;
    }

    public String instanceName() {
        String string = this.instanceOrigin().getPath();
        int n = string.lastIndexOf(46);
        if (n != -1 && n > string.lastIndexOf(47)) {
            string = string.substring(0, n);
        }
        return string.replace('/', '.');
    }

    public Class instanceClass() throws IOException, ClassNotFoundException {
        return this.instanceClass(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    final Class instanceClass(ClassLoader classLoader) throws IOException, ClassNotFoundException {
        if (this.clazzException != null) {
            if (this.clazzException instanceof IOException) {
                throw (IOException)this.clazzException;
            }
            if (!(this.clazzException instanceof ClassNotFoundException)) throw (ThreadDeath)this.clazzException;
            throw (ClassNotFoundException)this.clazzException;
        }
        if (this.clazz != null) {
            return this.clazz;
        }
        try {
            if (!this.isSerialized()) {
                this.clazz = this.findClass(this.instanceName(), classLoader);
                if (this.clazz != null) return this.clazz;
                throw new ClassNotFoundException(this.instanceName());
            }
            InputStream inputStream = this.instanceOrigin().getInputStream();
            try {
                Class clazz = this.clazz = this.readClass(inputStream);
                return clazz;
            }
            finally {
                inputStream.close();
            }
        }
        catch (IOException iOException) {
            ErrorManager.getDefault().annotate((Throwable)iOException, 0, "From file: " + this.entry.getFile(), null, null, null);
            this.clazzException = iOException;
            throw iOException;
        }
        catch (ClassNotFoundException classNotFoundException) {
            ErrorManager.getDefault().annotate((Throwable)classNotFoundException, 0, "From file: " + this.entry.getFile(), null, null, null);
            this.clazzException = classNotFoundException;
            throw classNotFoundException;
        }
        catch (RuntimeException runtimeException) {
            this.clazzException = new ClassNotFoundException("From file: " + this.entry.getFile() + " due to: " + runtimeException.toString());
            ErrorManager.getDefault().annotate(this.clazzException, (Throwable)runtimeException);
            throw (ClassNotFoundException)this.clazzException;
        }
        catch (LinkageError linkageError) {
            this.clazzException = new ClassNotFoundException("From file: " + this.entry.getFile() + " due to: " + linkageError.toString());
            ErrorManager.getDefault().annotate(this.clazzException, (Throwable)linkageError);
            throw (ClassNotFoundException)this.clazzException;
        }
    }

    public boolean instanceOf(Class clazz) {
        try {
            return clazz.isAssignableFrom(this.instanceClass());
        }
        catch (IOException iOException) {
            return false;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return false;
        }
    }

    public FileObject instanceOrigin() {
        return this.entry.getFile();
    }

    public Object instanceCreate() throws IOException, ClassNotFoundException {
        try {
            Class clazz;
            if (this.isSerialized()) {
                BufferedInputStream bufferedInputStream = new BufferedInputStream(this.instanceOrigin().getInputStream(), 1024);
                NbObjectInputStream nbObjectInputStream = new NbObjectInputStream((InputStream)bufferedInputStream);
                Object object = nbObjectInputStream.readObject();
                nbObjectInputStream.close();
                return object;
            }
            if (SharedClassObject.class.isAssignableFrom(clazz = this.instanceClass())) {
                return SharedClassObject.findObject((Class)clazz, (boolean)true);
            }
            return clazz.newInstance();
        }
        catch (IOException iOException) {
            ErrorManager.getDefault().annotate((Throwable)iOException, this.instanceName());
            throw iOException;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw classNotFoundException;
        }
        catch (Exception exception) {
            throw new ClassNotFoundException("Cannot instantiate " + this.instanceName() + " for " + this.entry.getFile(), exception);
        }
        catch (LinkageError linkageError) {
            throw new ClassNotFoundException("Cannot instantiate " + this.instanceName() + " for " + this.entry.getFile(), linkageError);
        }
    }

    public boolean isApplet() {
        if (this.applet != null) {
            return this.applet;
        }
        boolean bl = this.instanceOf(Applet.class);
        this.applet = bl ? Boolean.TRUE : Boolean.FALSE;
        return bl;
    }

    public boolean isExecutable() {
        try {
            Method method = this.instanceClass().getDeclaredMethod("main", String;.class);
            int n = method.getModifiers();
            return Modifier.isPublic(n) && Modifier.isStatic(n) && Void.TYPE.equals(method.getReturnType());
        }
        catch (Exception exception) {
            return false;
        }
        catch (LinkageError linkageError) {
            return false;
        }
    }

    public boolean isJavaBean() {
        if (this.bean != null) {
            return this.bean;
        }
        if (this.isSerialized()) {
            this.bean = Boolean.TRUE;
            return true;
        }
        try {
            Constructor constructor;
            Class clazz = this.instanceClass();
            int n = clazz.getModifiers();
            if (!Modifier.isPublic(n) || Modifier.isAbstract(n)) {
                this.bean = Boolean.FALSE;
                return false;
            }
            try {
                constructor = clazz.getConstructor(new Class[0]);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                this.bean = Boolean.FALSE;
                return false;
            }
            if (constructor == null || !Modifier.isPublic(constructor.getModifiers())) {
                this.bean = Boolean.FALSE;
                return false;
            }
            for (Class<?> clazz2 = clazz.getDeclaringClass(); clazz2 != null; clazz2 = clazz2.getDeclaringClass()) {
                if (!Modifier.isStatic(n)) {
                    return false;
                }
                n = clazz2.getModifiers();
                if (Modifier.isPublic(n)) continue;
                return false;
            }
        }
        catch (Exception exception) {
            this.bean = Boolean.FALSE;
            return true;
        }
        catch (LinkageError linkageError) {
            this.bean = Boolean.FALSE;
            return false;
        }
        this.bean = Boolean.TRUE;
        return true;
    }

    public boolean isInterface() {
        try {
            return this.instanceClass().isInterface();
        }
        catch (IOException iOException) {
            return false;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return false;
        }
    }

    public String toString() {
        return this.instanceName();
    }

    public static HelpCtx findHelp(InstanceCookie instanceCookie) {
        try {
            String[] stringArray;
            Object object;
            Class clazz = instanceCookie.instanceClass();
            if (Component.class.isAssignableFrom(clazz) || MenuComponent.class.isAssignableFrom(clazz)) {
                object = clazz.getName();
                stringArray = new String[]{"java.awt.", "javax.swing.", "javax.swing.border."};
                for (int i = 0; i < stringArray.length; ++i) {
                    if (!((String)object).startsWith(stringArray[i]) || ((String)object).substring(stringArray[i].length()).indexOf(46) != -1) continue;
                    return new HelpCtx((String)object);
                }
            }
            if ((object = instanceCookie.instanceCreate()) != null && object != instanceCookie && (stringArray = HelpCtx.findHelp((Object)object)) != HelpCtx.DEFAULT_HELP) {
                return stringArray;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    private boolean isSerialized() {
        return this.instanceOrigin().getExt().equals("ser");
    }

    private Class readClass(InputStream inputStream) throws IOException, ClassNotFoundException {
        class OIS
        extends ObjectInputStream {
            public OIS(InputStream inputStream) throws IOException {
                super(inputStream);
            }

            public Class resolveClass(ObjectStreamClass objectStreamClass) throws IOException, ClassNotFoundException {
                Class clazz = InstanceSupport.this.findClass(objectStreamClass.getName(), null);
                if (clazz == writeRepl) {
                    return clazz;
                }
                throw new ClassEx(clazz);
            }
        }
        OIS oIS = new OIS(new BufferedInputStream(inputStream));
        try {
            oIS.readObject();
            throw new ClassNotFoundException();
        }
        catch (ClassEx classEx) {
            return classEx.clazz;
        }
    }

    private Class findClass(String string, ClassLoader classLoader) throws ClassNotFoundException {
        try {
            Class<?> clazz;
            try {
                if (classLoader != null) {
                    clazz = classLoader.loadClass(string);
                } else {
                    ClassLoader classLoader2 = (ClassLoader)Lookup.getDefault().lookup(ClassLoader.class);
                    if (classLoader2 == null) {
                        classLoader2 = this.getClass().getClassLoader();
                    }
                    clazz = classLoader2.loadClass(string);
                }
            }
            catch (ClassNotFoundException classNotFoundException) {
                clazz = this.createClassLoader().loadClass(string);
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw classNotFoundException;
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (LinkageError linkageError) {
            throw new ClassNotFoundException(linkageError.toString(), linkageError);
        }
    }

    protected ClassLoader createClassLoader() {
        ClassLoader classLoader = (ClassLoader)Lookup.getDefault().lookup(ClassLoader.class);
        return classLoader;
    }

    static {
        try {
            writeRepl = Class.forName("org.openide.util.SharedClassObject$WriteReplace");
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private static class ClassEx
    extends IOException {
        public Class clazz;
        static final long serialVersionUID = 4810039297880922426L;

        public ClassEx(Class clazz) {
            this.clazz = clazz;
        }
    }

    public static class Instance
    implements InstanceCookie.Of {
        private Object obj;

        public Instance(Object object) {
            this.obj = object;
        }

        public String instanceName() {
            return this.obj.getClass().getName();
        }

        public Class instanceClass() {
            return this.obj.getClass();
        }

        public Object instanceCreate() {
            return this.obj;
        }

        public boolean instanceOf(Class clazz) {
            return clazz.isAssignableFrom(this.instanceClass());
        }
    }
}

