/*
 * Decompiled with CFR 0.152.
 */
package org.openide.loaders;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.IOException;
import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import org.openide.ErrorManager;
import org.openide.filesystems.FileAttributeEvent;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileRenameEvent;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataLoader;
import org.openide.loaders.DataLoaderPool;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectExistsException;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.loaders.DataObjectPool;
import org.openide.loaders.FolderListListener;
import org.openide.loaders.FolderOrder;
import org.openide.util.RequestProcessor;
import org.openide.util.TopologicalSortException;
import org.openide.util.Utilities;

final class FolderList
implements FileChangeListener,
DataObject.Container {
    static final long serialVersionUID = -592616022226761148L;
    private static final int LATER_PRIORITY = 5;
    private static final RequestProcessor PROCESSOR = new RequestProcessor("Folder recognizer");
    private static final Map map = new WeakHashMap(101);
    private static int REFRESH_TIME = -1;
    protected FileObject folder;
    private transient RequestProcessor.Task refreshTask;
    private volatile transient RequestProcessor.Task comparatorTask;
    private transient HashMap primaryFiles = null;
    private transient List order;
    private static final ErrorManager err = ErrorManager.getDefault().getInstance("org.openide.loaders.FolderList");
    private transient PropertyChangeSupport pcs;
    private transient boolean folderCreated = false;

    private FolderList(FileObject fileObject, boolean bl) {
        this.folder = fileObject;
        if (bl) {
            fileObject.addFileChangeListener(FileUtil.weakFileChangeListener((FileChangeListener)this, (Object)fileObject));
        }
    }

    public String toString() {
        return "FolderList{" + this.folder + "}";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static FolderList find(FileObject fileObject, boolean bl) {
        FolderList folderList = null;
        Class clazz = FolderList.class;
        synchronized (clazz) {
            Reference reference = (Reference)map.get(fileObject);
            FolderList folderList2 = folderList = reference == null ? null : (FolderList)reference.get();
            if (folderList == null && bl) {
                folderList = new FolderList(fileObject, true);
                map.put(fileObject, new SoftReference<FolderList>(folderList));
            }
        }
        return folderList;
    }

    public boolean isCreated() {
        return this.folderCreated;
    }

    public static boolean isFolderRecognizerThread() {
        return PROCESSOR.isRequestProcessorThread();
    }

    public static void changedFolderOrder(FileObject fileObject) {
        FolderList folderList = FolderList.find(fileObject, false);
        if (folderList != null) {
            folderList.changeComparator();
        }
    }

    public static void changedDataSystem(FileObject fileObject) {
        FolderList folderList = FolderList.find(fileObject, false);
        if (err.isLoggable(1)) {
            err.log("changedDataSystem: " + fileObject + " on " + Thread.currentThread());
        }
        if (folderList != null) {
            folderList.refresh();
        }
    }

    public DataObject[] getChildren() {
        List list = this.getChildrenList();
        DataObject[] dataObjectArray = new DataObject[list.size()];
        list.toArray(dataObjectArray);
        return dataObjectArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getChildrenList() {
        ListTask listTask;
        try {
            DataObjectPool.getPOOL().enterPriviledgedProcessor(PROCESSOR);
            listTask = this.getChildrenList(null);
            listTask.task.waitFinished();
        }
        finally {
            DataObjectPool.getPOOL().exitPriviledgedProcessor(PROCESSOR);
        }
        return listTask.result;
    }

    public void waitProcessingFinished() {
        RequestProcessor.Task task = this.comparatorTask;
        if (task != null) {
            task.waitFinished();
        }
        if ((task = this.refreshTask) != null) {
            task.waitFinished();
        }
    }

    public RequestProcessor.Task computeChildrenList(FolderListListener folderListListener) {
        return this.getChildrenList((FolderListListener)folderListListener).task;
    }

    private ListTask getChildrenList(FolderListListener folderListListener) {
        ListTask listTask = new ListTask(folderListListener);
        int n = Thread.currentThread().getPriority();
        listTask.task = PROCESSOR.post((Runnable)listTask, 0, n);
        return listTask;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void changeComparator() {
        RequestProcessor.Task[] taskArray;
        final boolean bl = err.isLoggable(1);
        if (bl) {
            err.log("changeComparator on " + this.folder);
        }
        final RequestProcessor.Task task = this.comparatorTask;
        RequestProcessor.Task[] taskArray2 = taskArray = new RequestProcessor.Task[1];
        synchronized (taskArray) {
            taskArray[0] = this.comparatorTask = PROCESSOR.post(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    RequestProcessor.Task[] taskArray2 = taskArray;
                    synchronized (taskArray) {
                        Object object;
                        if (task != null) {
                            task.waitFinished();
                        }
                        if (FolderList.this.primaryFiles != null) {
                            if (bl) {
                                err.log("changeComparator on " + FolderList.this.folder + ": get old");
                            }
                            if ((object = FolderList.this.getObjects(null)).size() != 0) {
                                FolderList.this.order = null;
                                if (bl) {
                                    err.log("changeComparator: get new");
                                }
                                List list = FolderList.this.getObjects(null);
                                if (bl) {
                                    err.log("changeComparator: fire change");
                                }
                                FolderList.this.fireChildrenChange(list, (Collection)object);
                            }
                        }
                        object = FolderList.this;
                        synchronized (object) {
                            if (FolderList.this.comparatorTask == taskArray[0]) {
                                FolderList.this.comparatorTask = null;
                            }
                        }
                        // ** MonitorExit[var1_1] (shouldn't be in output)
                        return;
                    }
                }
            }, 0, 1);
            // ** MonitorExit[var4_4] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refresh() {
        final long l = System.currentTimeMillis();
        final boolean bl = err.isLoggable(1);
        if (bl) {
            err.log("refresh on " + this.folder + " @" + l);
        }
        FolderList folderList = this;
        synchronized (folderList) {
            if (this.refreshTask == null) {
                this.refreshTask = PROCESSOR.post(new Runnable(){

                    public void run() {
                        RequestProcessor.Task task = FolderList.this.comparatorTask;
                        if (task != null) {
                            task.waitFinished();
                        }
                        if (bl) {
                            err.log("-- refresh on " + FolderList.this.folder + ": now=" + l);
                        }
                        if (FolderList.this.primaryFiles != null) {
                            FolderList.this.createBoth(null, true);
                        }
                    }
                }, FolderList.getRefreshTime(), 5);
            } else {
                this.refreshTask.schedule(FolderList.getRefreshTime());
            }
        }
    }

    private static int getRefreshTime() {
        if (REFRESH_TIME >= 0) {
            return REFRESH_TIME;
        }
        String string = System.getProperty("org.openide.loaders.FolderList.refresh.interval");
        if (string != null) {
            try {
                REFRESH_TIME = Integer.parseInt(string);
            }
            catch (NumberFormatException numberFormatException) {
                ErrorManager.getDefault().notify(1, (Throwable)numberFormatException);
            }
        }
        if (REFRESH_TIME < 0) {
            REFRESH_TIME = 10;
        }
        return REFRESH_TIME;
    }

    public void fileChanged(FileEvent fileEvent) {
        FileObject fileObject;
        boolean bl = err.isLoggable(1);
        if (bl) {
            err.log("fileChanged: " + fileEvent);
        }
        if ((fileObject = fileEvent.getFile()).isData() && fileObject.isValid()) {
            Object object;
            if (this.primaryFiles != null) {
                try {
                    object = DataObject.find(fileObject);
                    if (!this.primaryFiles.containsKey(((DataObject)object).getPrimaryFile())) {
                        this.refresh();
                    }
                }
                catch (DataObjectNotFoundException dataObjectNotFoundException) {
                    ErrorManager.getDefault().notify(1, (Throwable)dataObjectNotFoundException);
                }
            }
            if ((object = this.getComparator().getSortMode()) == DataFolder.SortMode.LAST_MODIFIED || object == DataFolder.SortMode.SIZE) {
                this.changeComparator();
            }
        }
    }

    public void fileDeleted(FileEvent fileEvent) {
        boolean bl = err.isLoggable(1);
        if (bl) {
            err.log("fileDeleted: " + fileEvent);
        }
        if (this.primaryFiles == null || this.primaryFiles.containsKey(fileEvent.getFile())) {
            this.refresh();
        }
    }

    public void fileDataCreated(FileEvent fileEvent) {
        boolean bl = err.isLoggable(1);
        if (bl) {
            err.log("fileDataCreated: " + fileEvent);
        }
        this.refresh();
    }

    public void fileFolderCreated(FileEvent fileEvent) {
        boolean bl = err.isLoggable(1);
        if (bl) {
            err.log("fileFolderCreated: " + fileEvent);
        }
        this.refresh();
    }

    public void fileRenamed(FileRenameEvent fileRenameEvent) {
        boolean bl = err.isLoggable(1);
        if (bl) {
            err.log("fileRenamed: " + fileRenameEvent);
        }
        this.refresh();
        this.changeComparator();
    }

    public void fileAttributeChanged(FileAttributeEvent fileAttributeEvent) {
        boolean bl = err.isLoggable(1);
        if (bl) {
            err.log("fileAttributeChanged: " + fileAttributeEvent);
        }
        if (fileAttributeEvent.getFile() == this.folder) {
            if (fileAttributeEvent.getName() == null) {
                this.changeComparator();
                return;
            }
            if ("OpenIDE-Folder-Order".equals(fileAttributeEvent.getName()) || "OpenIDE-Folder-SortMode".equals(fileAttributeEvent.getName()) || -1 != fileAttributeEvent.getName().indexOf("/")) {
                this.changeComparator();
            }
        }
    }

    private FolderOrder getComparator() {
        return FolderOrder.findFor(this.folder);
    }

    private List getObjects(FolderListListener folderListListener) {
        List list;
        boolean bl = err.isLoggable(1);
        if (bl) {
            err.log("getObjects on " + this.folder);
        }
        if (this.primaryFiles == null) {
            list = this.createBoth(folderListListener, false);
        } else if (this.order != null) {
            list = this.createObjects(this.order, this.primaryFiles, folderListListener);
        } else {
            list = this.createObjects(this.primaryFiles.keySet(), this.primaryFiles, folderListListener);
            list = this.carefullySort(list, this.getComparator());
            this.order = FolderList.createOrder(list);
        }
        return list;
    }

    private List carefullySort(List list, FolderOrder folderOrder) {
        boolean bl = err.isLoggable(1);
        if (bl) {
            err.log("carefullySort on " + this.folder);
        }
        Collections.sort(list, folderOrder);
        Map map = folderOrder.getOrderingConstraints(list);
        if (map == null) {
            return list;
        }
        if (bl) {
            err.log("carefullySort: partial orders");
        }
        try {
            return Utilities.topologicalSort((Collection)list, (Map)map);
        }
        catch (TopologicalSortException topologicalSortException) {
            List list2 = topologicalSortException.partialSort();
            if (err.isLoggable(16)) {
                err.log(16, "Note: folder " + this.folder + " cannot be consistently sorted due to ordering conflicts.");
                err.notify(1, (Throwable)topologicalSortException);
                err.log(16, "Using partial sort: " + list2);
            }
            return list2;
        }
    }

    private static List createOrder(List list) {
        int n = list.size();
        ArrayList<FileObject> arrayList = new ArrayList<FileObject>(n);
        for (int i = 0; i < n; ++i) {
            arrayList.add(((DataObject)list.get(i)).getPrimaryFile());
        }
        return arrayList;
    }

    private List createObjects(Collection collection, Map map, FolderListListener folderListListener) {
        boolean bl = err.isLoggable(1);
        if (bl) {
            err.log("createObjects on " + this.folder);
        }
        int n = collection.size();
        Iterator iterator = collection.iterator();
        ArrayList<DataObject> arrayList = new ArrayList<DataObject>(n);
        for (int i = 0; i < n; ++i) {
            DataObject dataObject;
            FileObject fileObject = (FileObject)iterator.next();
            if (!fileObject.isValid()) continue;
            SoftReference<DataObject> softReference = (SoftReference<DataObject>)map.get(fileObject);
            DataObject dataObject2 = dataObject = softReference != null ? (DataObject)((Reference)softReference).get() : null;
            if (dataObject == null) {
                try {
                    dataObject = DataObject.find(fileObject);
                    softReference = new SoftReference<DataObject>(dataObject);
                }
                catch (DataObjectNotFoundException dataObjectNotFoundException) {
                    ErrorManager.getDefault().notify(1, (Throwable)dataObjectNotFoundException);
                }
            }
            if (dataObject == null) continue;
            if (folderListListener == null) {
                arrayList.add(dataObject);
                continue;
            }
            folderListListener.process(dataObject, arrayList);
        }
        if (folderListListener != null) {
            folderListListener.finished(arrayList);
        }
        return arrayList;
    }

    private List createBoth(FolderListListener folderListListener, boolean bl) {
        boolean bl2 = err.isLoggable(1);
        if (bl2) {
            err.log("createBoth on " + this.folder);
        }
        HashMap<FileObject, WeakReference<DataObject>> hashMap = new HashMap<FileObject, WeakReference<DataObject>>();
        List<DataObject> list = new ArrayList();
        List<DataObject> list2 = new ArrayList();
        HashMap hashMap2 = this.primaryFiles == null ? new HashMap() : (HashMap)this.primaryFiles.clone();
        ArrayList<DataObject> arrayList = new ArrayList<DataObject>();
        DataLoaderPool dataLoaderPool = DataLoaderPool.getDefault();
        final HashSet hashSet = new HashSet();
        DataLoader.RecognizedFiles recognizedFiles = new DataLoader.RecognizedFiles(){

            public void markRecognized(FileObject fileObject) {
                if (fileObject != null) {
                    hashSet.add(fileObject);
                }
            }
        };
        Enumeration enumeration = this.folder.getChildren(false);
        while (enumeration.hasMoreElements()) {
            DataObject dataObject;
            FileObject fileObject = (FileObject)enumeration.nextElement();
            if (hashSet.contains(fileObject)) continue;
            try {
                dataObject = dataLoaderPool.findDataObject(fileObject, recognizedFiles);
            }
            catch (DataObjectExistsException dataObjectExistsException) {
                dataObject = dataObjectExistsException.getDataObject();
            }
            catch (IOException iOException) {
                dataObject = null;
                ErrorManager.getDefault().notify((Throwable)iOException);
            }
            if (dataObject == null) continue;
            dataObject.recognizedByFolder();
            FileObject fileObject2 = dataObject.getPrimaryFile();
            boolean bl3 = false;
            if (!hashMap.containsKey(fileObject2)) {
                boolean bl4;
                boolean bl5 = bl4 = this.primaryFiles == null;
                if (!bl4) {
                    Reference reference = (Reference)this.primaryFiles.get(fileObject2);
                    boolean bl6 = bl4 = reference == null;
                    if (!bl4) {
                        DataObject dataObject2 = (DataObject)reference.get();
                        boolean bl7 = bl4 = dataObject2 == null || dataObject2 != dataObject;
                        if (bl4) {
                            bl3 = true;
                        }
                    }
                }
                if (bl4) {
                    arrayList.add(dataObject);
                }
                list.add(dataObject);
                if (folderListListener == null) {
                    list2.add(dataObject);
                } else {
                    folderListListener.process(dataObject, list2);
                }
            }
            if (!bl3) {
                hashMap2.remove(fileObject2);
            }
            hashMap.put(fileObject2, new WeakReference<DataObject>(dataObject));
        }
        this.primaryFiles = hashMap;
        list = this.carefullySort(list, this.getComparator());
        this.order = FolderList.createOrder(list);
        list2 = list.size() == list2.size() ? list : this.carefullySort(list2, this.getComparator());
        if (bl) {
            this.fireChildrenChange(arrayList, hashMap2.keySet());
        }
        if (folderListListener != null) {
            folderListListener.finished(list2);
        }
        return list2;
    }

    private void fireChildrenChange(Collection collection, Collection collection2) {
        if (!(this.pcs == null || collection.isEmpty() && collection2.isEmpty())) {
            this.pcs.firePropertyChange("children", null, null);
        }
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (this.pcs != null) {
            this.pcs.removePropertyChangeListener(propertyChangeListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (this.pcs == null) {
            FolderList folderList = this;
            synchronized (folderList) {
                if (this.pcs == null) {
                    this.pcs = new PropertyChangeSupport(this);
                }
            }
        }
        this.pcs.addPropertyChangeListener(propertyChangeListener);
    }

    private final class ListTask
    implements Runnable {
        private FolderListListener filter;
        public List result;
        public RequestProcessor.Task task;

        public ListTask(FolderListListener folderListListener) {
            this.filter = folderListListener;
        }

        public void run() {
            boolean bl = err.isLoggable(1);
            if (bl) {
                err.log("ListTask.run 1 on " + FolderList.this.folder);
            }
            if (FolderList.this.comparatorTask != null) {
                FolderList.this.comparatorTask.waitFinished();
            }
            if (FolderList.this.refreshTask != null) {
                FolderList.this.refreshTask.waitFinished();
            }
            err.log("ListTask.run 2");
            this.result = FolderList.this.getObjects(this.filter);
            err.log("ListTask.run 3");
            FolderList.this.folderCreated = true;
        }

        public String toString() {
            return "ListTask@" + Integer.toHexString(System.identityHashCode(this)) + "[" + FolderList.this.folder + "]";
        }
    }
}

