/*
 * Decompiled with CFR 0.152.
 */
package org.openide.loaders;

import java.util.Iterator;
import javax.naming.Context;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.loaders.DefaultSettingsContext;
import org.openide.util.Lookup;

public final class Environment {
    private static Lookup.Result result;
    static /* synthetic */ Class class$javax$naming$Context;

    private Environment() {
    }

    public static Lookup find(DataObject dataObject) {
        while (dataObject != null) {
            Lookup lookup = Environment.findForOne(dataObject);
            if (lookup != null) {
                return lookup;
            }
            FileObject fileObject = dataObject.getPrimaryFile().getParent();
            if (fileObject == null) break;
            try {
                dataObject = DataObject.find(fileObject);
            }
            catch (DataObjectNotFoundException dataObjectNotFoundException) {
                break;
            }
        }
        return Lookup.EMPTY;
    }

    public static Context findSettingsContext(DataObject dataObject) {
        Iterator iterator = Environment.getProviders().allInstances().iterator();
        while (iterator.hasNext()) {
            Context context;
            Provider provider = (Provider)iterator.next();
            Lookup lookup = provider.getEnvironment(dataObject);
            if (lookup == null || (context = (Context)lookup.lookup(class$javax$naming$Context == null ? Environment.class$("javax.naming.Context") : class$javax$naming$Context)) == null) continue;
            return context;
        }
        return new DefaultSettingsContext(dataObject);
    }

    static Lookup findForOne(DataObject dataObject) {
        Iterator iterator = Environment.getProviders().allInstances().iterator();
        while (iterator.hasNext()) {
            Provider provider = (Provider)iterator.next();
            Lookup lookup = provider.getEnvironment(dataObject);
            if (lookup == null) continue;
            return lookup;
        }
        return null;
    }

    static Lookup.Result getProviders() {
        if (result == null) {
            result = Lookup.getDefault().lookup(new Lookup.Template(Provider.class));
        }
        return result;
    }

    public static interface Provider {
        public Lookup getEnvironment(DataObject var1);
    }
}

