/*
 * Decompiled with CFR 0.152.
 */
package org.openide.loaders;

import java.awt.Image;
import java.awt.datatransfer.Transferable;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Serializable;
import java.io.Writer;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.openide.ErrorManager;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.Repository;
import org.openide.filesystems.URLMapper;
import org.openide.loaders.BrokenDataShadow;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataLoader;
import org.openide.loaders.DataLoaderPool;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectExistsException;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.loaders.DataObjectPool;
import org.openide.loaders.LoaderTransfer;
import org.openide.loaders.MultiDataObject;
import org.openide.loaders.MultiFileLoader;
import org.openide.loaders.OperationEvent;
import org.openide.nodes.FilterNode;
import org.openide.nodes.Node;
import org.openide.nodes.NodeListener;
import org.openide.nodes.PropertySupport;
import org.openide.nodes.Sheet;
import org.openide.util.HelpCtx;
import org.openide.util.Mutex;
import org.openide.util.MutexException;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.Task;
import org.openide.util.Utilities;
import org.openide.util.datatransfer.ExTransferable;
import org.openide.xml.XMLUtil;

public class DataShadow
extends MultiDataObject
implements DataObject.Container {
    static final long serialVersionUID = 6305590675982925167L;
    private DataObject original;
    private OrigL origL = null;
    private LinkedList nodes = new LinkedList();
    static final String SHADOW_EXTENSION = "shadow";
    private static Map allDataShadows;
    private static Mutex MUTEX;
    private static RequestProcessor RP;
    private static volatile Task lastTask;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$java$lang$String;

    private static synchronized Map getDataShadowsSet() {
        if (allDataShadows == null) {
            allDataShadows = new HashMap();
        }
        return allDataShadows;
    }

    private static synchronized void enqueueDataShadow(DataShadow dataShadow) {
        Map map = DataShadow.getDataShadowsSet();
        FileObject fileObject = dataShadow.original.getPrimaryFile();
        DSWeakReference dSWeakReference = new DSWeakReference(dataShadow);
        Set<DSWeakReference> set = (Set<DSWeakReference>)map.get(fileObject);
        if (set == null) {
            set = Collections.singleton(dSWeakReference);
            DataShadow.getDataShadowsSet().put(fileObject, set);
        } else {
            if (!(set instanceof HashSet)) {
                set = new HashSet<DSWeakReference>(set);
                DataShadow.getDataShadowsSet().put(fileObject, set);
            }
            set.add(dSWeakReference);
        }
    }

    private static synchronized List getAllDataShadows() {
        if (allDataShadows == null || allDataShadows.isEmpty()) {
            return null;
        }
        ArrayList<DataShadow> arrayList = new ArrayList<DataShadow>(allDataShadows.size());
        Iterator iterator = allDataShadows.values().iterator();
        while (iterator.hasNext()) {
            Set set = (Set)iterator.next();
            Iterator iterator2 = set.iterator();
            while (iterator2.hasNext()) {
                Reference reference = (Reference)iterator2.next();
                DataShadow dataShadow = (DataShadow)reference.get();
                if (dataShadow == null) continue;
                arrayList.add(dataShadow);
            }
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void checkValidity(EventObject eventObject) {
        DataObject dataObject = null;
        if (eventObject instanceof OperationEvent) {
            dataObject = ((OperationEvent)eventObject).getObject();
        }
        HashSet hashSet = null;
        Serializable serializable = DataShadow.class;
        synchronized (serializable) {
            if (allDataShadows == null || allDataShadows.isEmpty()) {
                return;
            }
            if (dataObject != null) {
                hashSet = (HashSet)allDataShadows.get(dataObject.getPrimaryFile());
                if (hashSet == null) {
                    return;
                }
                hashSet = new HashSet(hashSet);
            }
        }
        serializable = null;
        if (eventObject instanceof OperationEvent.Rename || eventObject instanceof OperationEvent.Move) {
            serializable = ((OperationEvent)eventObject).getObject();
        }
        if (hashSet != null) {
            Iterator iterator = hashSet.iterator();
            while (iterator.hasNext()) {
                Reference reference = (Reference)iterator.next();
                DataShadow dataShadow = (DataShadow)reference.get();
                if (dataShadow == null) continue;
                dataShadow.refresh(dataShadow.original == serializable);
            }
            return;
        }
        List list = DataShadow.getAllDataShadows();
        if (list == null) {
            return;
        }
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            DataShadow dataShadow = (DataShadow)list.get(i);
            dataShadow.refresh(dataShadow.original == serializable);
        }
    }

    protected DataShadow(FileObject fileObject, DataObject dataObject, MultiFileLoader multiFileLoader) throws DataObjectExistsException {
        super(fileObject, multiFileLoader);
        this.init(dataObject);
    }

    protected DataShadow(FileObject fileObject, DataObject dataObject, DataLoader dataLoader) throws DataObjectExistsException {
        super(fileObject, dataLoader);
        this.init(dataObject);
    }

    private void init(DataObject dataObject) {
        if (dataObject == null) {
            throw new IllegalArgumentException();
        }
        this.setOriginal(dataObject);
        DataShadow.enqueueDataShadow(this);
    }

    private DataShadow(FileObject fileObject, DataObject dataObject) throws DataObjectExistsException {
        this(fileObject, dataObject, DataLoaderPool.getShadowLoader());
    }

    public static DataShadow create(DataFolder dataFolder, DataObject dataObject) throws IOException {
        return DataShadow.create(dataFolder, null, dataObject, SHADOW_EXTENSION);
    }

    public static DataShadow create(DataFolder dataFolder, String string, DataObject dataObject) throws IOException {
        return DataShadow.create(dataFolder, string, dataObject, SHADOW_EXTENSION);
    }

    public static DataShadow create(DataFolder dataFolder, final String string, final DataObject dataObject, final String string2) throws IOException {
        final FileObject fileObject = dataFolder.getPrimaryFile();
        final DataShadow[] dataShadowArray = new DataShadow[1];
        DataObjectPool.getPOOL().runAtomicAction(fileObject, new FileSystem.AtomicAction(){

            public void run() throws IOException {
                FileObject fileObject2 = DataShadow.writeOriginal(string, string2, fileObject, dataObject);
                final DataObject dataObject2 = DataObject.find(fileObject2);
                if (!(dataObject2 instanceof DataShadow)) {
                    throw new DataObjectNotFoundException(dataObject2.getPrimaryFile()){

                        public String getMessage() {
                            return super.getMessage() + ": " + dataObject2.getClass().getName();
                        }
                    };
                }
                dataShadowArray[0] = (DataShadow)dataObject2;
            }
        });
        return dataShadowArray[0];
    }

    private static FileObject writeOriginal(final String string, final String string2, final FileObject fileObject, final DataObject dataObject) throws IOException {
        try {
            return (FileObject)MUTEX.writeAccess(new Mutex.ExceptionAction(){

                public Object run() throws IOException {
                    FileObject fileObject2;
                    if (fileObject.isData()) {
                        fileObject2 = fileObject;
                    } else {
                        String string3;
                        if (string == null) {
                            String string22 = dataObject.getName().replace(':', '_').replace('/', '_');
                            string3 = FileUtil.findFreeFileName((FileObject)fileObject, (String)string22, (String)string2);
                        } else {
                            string3 = string;
                        }
                        fileObject2 = fileObject.createData(string3, string2);
                    }
                    DataShadow.writeShadowFile(fileObject2, dataObject.getPrimaryFile().getURL());
                    return fileObject2;
                }
            });
        }
        catch (MutexException mutexException) {
            throw (IOException)mutexException.getException();
        }
    }

    static void writeOriginal(final FileObject fileObject, final URL uRL) throws IOException {
        try {
            MUTEX.writeAccess(new Mutex.ExceptionAction(){

                public Object run() throws IOException {
                    DataShadow.writeShadowFile(fileObject, uRL);
                    return null;
                }
            });
        }
        catch (MutexException mutexException) {
            throw (IOException)mutexException.getException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void writeShadowFile(FileObject fileObject, URL uRL) throws IOException {
        FileLock fileLock = fileObject.lock();
        OutputStreamWriter outputStreamWriter = new OutputStreamWriter(fileObject.getOutputStream(fileLock), "UTF-8");
        try {
            outputStreamWriter.write(uRL.toExternalForm());
        }
        finally {
            ((Writer)outputStreamWriter).close();
            fileLock.releaseLock();
        }
    }

    protected static DataObject deserialize(FileObject fileObject) throws IOException {
        FileObject fileObject2;
        URI uRI;
        String[] stringArray = DataShadow.readOriginalFileAndFileSystem(fileObject);
        if (!$assertionsDisabled && stringArray[0] == null) {
            throw new AssertionError();
        }
        try {
            uRI = new URI(stringArray[0]);
        }
        catch (URISyntaxException uRISyntaxException) {
            uRI = null;
        }
        if (uRI != null && uRI.isAbsolute()) {
            fileObject2 = URLMapper.findFileObject((URL)uRI.toURL());
        } else {
            FileSystem fileSystem = "SystemFileSystem".equals(stringArray[1]) ? Repository.getDefault().getDefaultFileSystem() : fileObject.getFileSystem();
            fileObject2 = fileSystem.findResource(stringArray[0]);
        }
        if (fileObject2 != null) {
            return DataObject.find(fileObject2);
        }
        throw new FileNotFoundException(stringArray[0] + ':' + stringArray[1]);
    }

    static URL readURL(FileObject fileObject) throws IOException {
        URI uRI;
        String[] stringArray = DataShadow.readOriginalFileAndFileSystem(fileObject);
        if (!$assertionsDisabled && stringArray[0] == null) {
            throw new AssertionError();
        }
        try {
            uRI = new URI(stringArray[0]);
        }
        catch (URISyntaxException uRISyntaxException) {
            uRI = null;
        }
        if (uRI != null && uRI.isAbsolute()) {
            return uRI.toURL();
        }
        FileSystem fileSystem = "SystemFileSystem".equals(stringArray[1]) ? Repository.getDefault().getDefaultFileSystem() : fileObject.getFileSystem();
        return new URL(fileSystem.getRoot().getURL(), stringArray[0]);
    }

    private static String[] readOriginalFileAndFileSystem(final FileObject fileObject) throws IOException {
        if (fileObject.getSize() == 0L) {
            Object object = fileObject.getAttribute("originalFile");
            if (object instanceof String) {
                return new String[]{(String)object, (String)fileObject.getAttribute("originalFileSystem")};
            }
            if (object instanceof URL) {
                return new String[]{((URL)object).toExternalForm(), null};
            }
            throw new FileNotFoundException(fileObject.getPath());
        }
        try {
            return (String[])MUTEX.readAccess(new Mutex.ExceptionAction(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public Object run() throws IOException {
                    BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(fileObject.getInputStream(), "UTF-8"));
                    try {
                        String string = bufferedReader.readLine();
                        String string2 = bufferedReader.readLine();
                        String[] stringArray = new String[]{string, string2};
                        return stringArray;
                    }
                    finally {
                        bufferedReader.close();
                    }
                }
            });
        }
        catch (MutexException mutexException) {
            throw (IOException)mutexException.getException();
        }
    }

    private FileObject checkOriginal(DataObject dataObject) throws IOException {
        if (dataObject == null) {
            return null;
        }
        return DataShadow.deserialize(this.getPrimaryFile()).getPrimaryFile();
    }

    public DataObject getOriginal() {
        DataShadow.waitUpdatesProcessed();
        return this.original;
    }

    public DataObject[] getChildren() {
        return new DataObject[]{this.original};
    }

    protected Node createNodeDelegate() {
        return new ShadowNode(this);
    }

    public boolean isDeleteAllowed() {
        return this.getPrimaryFile().canWrite();
    }

    public boolean isCopyAllowed() {
        return true;
    }

    public boolean isMoveAllowed() {
        return this.getPrimaryFile().canWrite();
    }

    public boolean isRenameAllowed() {
        return this.getPrimaryFile().canWrite();
    }

    public HelpCtx getHelpCtx() {
        return this.original.getHelpCtx();
    }

    protected DataShadow handleCreateShadow(DataFolder dataFolder) throws IOException {
        if (this.original instanceof DataFolder) {
            DataFolder.testNesting((DataFolder)this.original, dataFolder);
        }
        return this.original.handleCreateShadow(dataFolder);
    }

    public Node.Cookie getCookie(Class clazz) {
        if (clazz.isInstance(this)) {
            return this;
        }
        return this.original.getCookie(this, clazz);
    }

    public void refresh() {
        this.refresh(false);
    }

    private void refresh(boolean bl) {
        try {
            FileObject fileObject;
            if (bl) {
                this.tryUpdate();
            }
            if ((fileObject = this.checkOriginal(this.original)) != null) {
                if (fileObject != this.original.getPrimaryFile()) {
                    this.setOriginal(DataObject.find(fileObject));
                }
                return;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            this.setValid(false);
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
    }

    private void tryUpdate() throws IOException {
        URL uRL = DataShadow.readURL(this.getPrimaryFile());
        if (uRL.equals(this.original.getPrimaryFile().getURL())) {
            return;
        }
        DataShadow.writeOriginal(null, null, this.getPrimaryFile(), this.original);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setOriginal(DataObject dataObject) {
        if (this.origL == null) {
            this.origL = new OrigL(this);
        }
        if (this.original != null) {
            this.original.removePropertyChangeListener(this.origL);
        }
        DataObject dataObject2 = this.original;
        dataObject.addPropertyChangeListener(this.origL);
        this.original = dataObject;
        ShadowNode[] shadowNodeArray = null;
        LinkedList linkedList = this.nodes;
        synchronized (linkedList) {
            shadowNodeArray = this.nodes.toArray(new ShadowNode[this.nodes.size()]);
        }
        try {
            for (int i = 0; i < shadowNodeArray.length; ++i) {
                shadowNodeArray[i].originalChanged();
            }
        }
        catch (IllegalStateException illegalStateException) {
            System.out.println("Please reopen the bug #18998 if you see this message.");
            System.out.println("Old:" + dataObject2 + (dataObject2 == null ? "" : " / " + dataObject2.isValid() + " / " + System.identityHashCode(dataObject2)));
            System.out.println("New:" + this.original + (this.original == null ? "" : " / " + this.original.isValid() + " / " + System.identityHashCode(this.original)));
            throw illegalStateException;
        }
    }

    private static void updateShadowOriginal(DataShadow dataShadow) {
        class Updator
        implements Runnable {
            DataShadow sh;
            FileObject primary;

            Updator() {
            }

            public void run() {
                DataObject dataObject;
                try {
                    dataObject = DataObject.find(this.primary);
                }
                catch (DataObjectNotFoundException dataObjectNotFoundException) {
                    dataObject = null;
                }
                if (dataObject != null) {
                    this.sh.setOriginal(dataObject);
                } else {
                    DataShadow.checkValidity(new OperationEvent(this.sh.original));
                }
                this.primary = null;
                this.sh = null;
            }
        }
        Updator updator = new Updator();
        updator.sh = dataShadow;
        updator.primary = updator.sh.original.getPrimaryFile();
        ERR.log("updateShadowOriginal: " + updator.sh + " primary " + updator.primary);
        lastTask = RP.post((Runnable)updator, 100, 2);
    }

    static final void waitUpdatesProcessed() {
        if (!RP.isRequestProcessorThread()) {
            lastTask.waitFinished();
        }
    }

    protected DataObject handleCopy(DataFolder dataFolder) throws IOException {
        if (this.original instanceof DataFolder) {
            DataFolder.testNesting((DataFolder)this.original, dataFolder);
        }
        return super.handleCopy(dataFolder);
    }

    protected FileObject handleMove(DataFolder dataFolder) throws IOException {
        if (this.original instanceof DataFolder) {
            DataFolder.testNesting((DataFolder)this.original, dataFolder);
        }
        return super.handleMove(dataFolder);
    }

    static {
        $assertionsDisabled = !DataShadow.class.desiredAssertionStatus();
        MUTEX = new Mutex();
        RP = new RequestProcessor("DataShadow validity check");
        lastTask = Task.EMPTY;
    }

    static final class DSWeakReference
    extends WeakReference
    implements Runnable {
        private int hash;
        private FileObject original;

        DSWeakReference(DataObject dataObject) {
            super(dataObject, Utilities.activeReferenceQueue());
            this.hash = dataObject.hashCode();
            if (dataObject instanceof DataShadow) {
                DataShadow dataShadow = (DataShadow)dataObject;
                this.original = dataShadow.original.getPrimaryFile();
            }
        }

        public int hashCode() {
            return this.hash;
        }

        public boolean equals(Object object) {
            Object t = this.get();
            if (t == null) {
                return false;
            }
            if (object instanceof DSWeakReference) {
                DSWeakReference dSWeakReference = (DSWeakReference)object;
                return t.equals(dSWeakReference.get());
            }
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            if (this.original != null) {
                Map map = DataShadow.getDataShadowsSet();
                synchronized (map) {
                    DataShadow.getDataShadowsSet().remove(this.original);
                }
            }
            Map map = BrokenDataShadow.getDataShadowsSet();
            synchronized (map) {
                BrokenDataShadow.getDataShadowsSet().remove(this);
            }
        }
    }

    private static class OrigL
    implements PropertyChangeListener {
        WeakReference shadow = null;

        public OrigL(DataShadow dataShadow) {
            this.shadow = new WeakReference<DataShadow>(dataShadow);
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            DataShadow dataShadow = (DataShadow)this.shadow.get();
            if (dataShadow != null && "valid".equals(propertyChangeEvent.getPropertyName())) {
                DataShadow.updateShadowOriginal(dataShadow);
            }
        }
    }

    protected static class ShadowNode
    extends FilterNode {
        private static MessageFormat format;
        private static MessageFormat descriptionFormat;
        private static final String ATTR_USEOWNNAME = "UseOwnName";
        private DataShadow obj;
        private Sheet sheet;
        private String originalFS;

        public ShadowNode(DataShadow dataShadow) {
            this(dataShadow, dataShadow.original.getNodeDelegate());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private ShadowNode(DataShadow dataShadow, Node node) {
            super(node);
            this.obj = dataShadow;
            LinkedList linkedList = this.obj.nodes;
            synchronized (linkedList) {
                this.obj.nodes.add(this);
            }
        }

        public Node cloneNode() {
            ShadowNode shadowNode = new ShadowNode(this.obj);
            return shadowNode;
        }

        public void setName(String string) {
            try {
                if (!string.equals(this.obj.getName())) {
                    this.obj.rename(string);
                    if (this.obj.original.getPrimaryFile().isRoot()) {
                        this.obj.getPrimaryFile().setAttribute(ATTR_USEOWNNAME, (Object)Boolean.TRUE);
                    }
                    this.fireDisplayNameChange(null, null);
                    this.fireNameChange(null, null);
                }
            }
            catch (IOException iOException) {
                throw new IllegalArgumentException(iOException.getMessage());
            }
        }

        public String getName() {
            return this.obj.getName();
        }

        public String getDisplayName() {
            if (format == null) {
                format = new MessageFormat(NbBundle.getBundle((Class)(class$org$openide$loaders$DataShadow == null ? (class$org$openide$loaders$DataShadow = DataShadow.class$("org.openide.loaders.DataShadow")) : class$org$openide$loaders$DataShadow)).getString("FMT_shadowName"));
            }
            String string = format.format(this.createArguments());
            try {
                return this.obj.getPrimaryFile().getFileSystem().getStatus().annotateName(string, this.obj.files());
            }
            catch (FileStateInvalidException fileStateInvalidException) {
                return string;
            }
        }

        public String getHtmlDisplayName() {
            if (format == null) {
                format = new MessageFormat(NbBundle.getBundle((Class)(class$org$openide$loaders$DataShadow == null ? (class$org$openide$loaders$DataShadow = DataShadow.class$("org.openide.loaders.DataShadow")) : class$org$openide$loaders$DataShadow)).getString("FMT_shadowName"));
            }
            try {
                String string = XMLUtil.toElementContent((String)format.format(this.createArguments()));
                FileSystem.Status status = this.obj.getPrimaryFile().getFileSystem().getStatus();
                if (status instanceof FileSystem.HtmlStatus) {
                    return ((FileSystem.HtmlStatus)status).annotateNameHtml(string, this.obj.files());
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return null;
        }

        private Object[] createArguments() {
            String string = this.obj.getName();
            String string2 = this.obj.original.isValid() ? this.obj.original.getNodeDelegate().getDisplayName() : "";
            Boolean bl = (Boolean)this.obj.getPrimaryFile().getAttribute(ATTR_USEOWNNAME);
            if (this.obj.original.getPrimaryFile().isRoot() && (bl == null || !bl.booleanValue())) {
                try {
                    string = this.obj.original.getPrimaryFile().getFileSystem().getDisplayName();
                }
                catch (FileStateInvalidException fileStateInvalidException) {
                    // empty catch block
                }
            }
            return new Object[]{string, super.getDisplayName(), ShadowNode.systemNameOrFileName(this.obj.getPrimaryFile()), ShadowNode.systemNameOrFileName(this.obj.original.getPrimaryFile()), string2};
        }

        private static String systemNameOrFileName(FileObject fileObject) {
            return FileUtil.getFileDisplayName((FileObject)fileObject);
        }

        public String getShortDescription() {
            if (descriptionFormat == null) {
                descriptionFormat = new MessageFormat(NbBundle.getBundle((Class)(class$org$openide$loaders$DataShadow == null ? (class$org$openide$loaders$DataShadow = DataShadow.class$("org.openide.loaders.DataShadow")) : class$org$openide$loaders$DataShadow)).getString("FMT_shadowHint"));
            }
            return descriptionFormat.format(this.createArguments());
        }

        public Image getIcon(int n) {
            Image image = this.rootIcon(n);
            if (image != null) {
                return image;
            }
            return super.getIcon(n);
        }

        public Image getOpenedIcon(int n) {
            Image image = this.rootIcon(n);
            if (image != null) {
                return image;
            }
            return super.getOpenedIcon(n);
        }

        private Image rootIcon(int n) {
            FileObject fileObject = this.obj.original.getPrimaryFile();
            if (fileObject.isRoot()) {
                try {
                    FileSystem fileSystem = fileObject.getFileSystem();
                    try {
                        Image image = Introspector.getBeanInfo(fileSystem.getClass()).getIcon(n);
                        return fileSystem.getStatus().annotateIcon(image, n, this.obj.original.files());
                    }
                    catch (IntrospectionException introspectionException) {
                        ErrorManager.getDefault().notify(1, (Throwable)introspectionException);
                    }
                }
                catch (FileStateInvalidException fileStateInvalidException) {
                    // empty catch block
                }
            }
            return null;
        }

        public boolean canDestroy() {
            return this.obj.isDeleteAllowed();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void destroy() throws IOException {
            LinkedList linkedList = this.obj.nodes;
            synchronized (linkedList) {
                this.obj.nodes.remove((Object)this);
            }
            this.obj.delete();
        }

        public final boolean canRename() {
            return this.obj.isRenameAllowed();
        }

        public final boolean canCopy() {
            return this.obj.isCopyAllowed();
        }

        public final boolean canCut() {
            return this.obj.isMoveAllowed();
        }

        public Node.Cookie getCookie(Class clazz) {
            Node.Cookie cookie = this.obj.getCookie(clazz);
            if (cookie != null) {
                return cookie;
            }
            return super.getCookie(clazz);
        }

        public Node.PropertySet[] getPropertySets() {
            Sheet sheet = this.sheet;
            if (sheet == null) {
                sheet = this.sheet = this.cloneSheet();
            }
            return sheet.toArray();
        }

        public Transferable clipboardCopy() throws IOException {
            ExTransferable exTransferable = ExTransferable.create((Transferable)super.clipboardCopy());
            exTransferable.put(LoaderTransfer.transferable(this.obj, 1));
            return exTransferable;
        }

        public Transferable clipboardCut() throws IOException {
            ExTransferable exTransferable = ExTransferable.create((Transferable)super.clipboardCut());
            exTransferable.put(LoaderTransfer.transferable(this.obj, 4));
            return exTransferable;
        }

        public Transferable drag() throws IOException {
            return this.clipboardCopy();
        }

        protected NodeListener createNodeListener() {
            return new PropL(this);
        }

        public boolean equals(Object object) {
            if (object instanceof ShadowNode) {
                ShadowNode shadowNode = (ShadowNode)((Object)object);
                return shadowNode.obj == this.obj;
            }
            return false;
        }

        public int hashCode() {
            return this.obj.hashCode();
        }

        private Sheet cloneSheet() {
            Node.PropertySet[] propertySetArray = this.getOriginal().getPropertySets();
            Sheet sheet = new Sheet();
            for (int i = 0; i < propertySetArray.length; ++i) {
                Sheet.Set set = new Sheet.Set();
                set.put(propertySetArray[i].getProperties());
                set.setName(propertySetArray[i].getName());
                set.setDisplayName(propertySetArray[i].getDisplayName());
                set.setShortDescription(propertySetArray[i].getShortDescription());
                this.modifySheetSet(set);
                sheet.put(set);
            }
            return sheet;
        }

        private void modifySheetSet(Sheet.Set set) {
            Object object = set.remove("name");
            if (object != null) {
                object = new PropertySupport.Name((Node)this);
                set.put(object);
                object = new Name();
                set.put(object);
            }
        }

        private void originalChanged() {
            DataObject dataObject = this.obj.original;
            if (dataObject.isValid()) {
                this.changeOriginal(dataObject.getNodeDelegate(), true);
            } else {
                DataShadow.updateShadowOriginal(this.obj);
            }
        }

        private final class Name
        extends PropertySupport.ReadWrite {
            public Name() {
                super("OriginalName", class$java$lang$String == null ? (class$java$lang$String = DataShadow.class$("java.lang.String")) : class$java$lang$String, DataObject.getString("PROP_ShadowOriginalName"), DataObject.getString("HINT_ShadowOriginalName"));
            }

            public Object getValue() {
                return ShadowNode.this.obj.original.getName();
            }

            public void setValue(Object object) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
                if (!this.canWrite()) {
                    throw new IllegalAccessException();
                }
                if (!(object instanceof String)) {
                    throw new IllegalArgumentException();
                }
                try {
                    DataObject dataObject = ShadowNode.this.obj.original;
                    dataObject.rename((String)object);
                    DataShadow.writeOriginal(null, null, ShadowNode.this.obj.getPrimaryFile(), dataObject);
                }
                catch (IOException iOException) {
                    throw new InvocationTargetException(iOException);
                }
            }

            public boolean canWrite() {
                return ShadowNode.this.obj.original.isRenameAllowed();
            }
        }

        private static class PropL
        extends FilterNode.NodeAdapter {
            public PropL(ShadowNode shadowNode) {
                super((FilterNode)shadowNode);
            }

            protected void propertyChange(FilterNode filterNode, PropertyChangeEvent propertyChangeEvent) {
                if ("propertySets".equals(propertyChangeEvent.getPropertyName())) {
                    ShadowNode shadowNode = (ShadowNode)filterNode;
                    shadowNode.sheet = null;
                }
                super.propertyChange(filterNode, propertyChangeEvent);
            }
        }
    }
}

