/*
 * Decompiled with CFR 0.152.
 */
package org.openide.loaders;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.beans.VetoableChangeSupport;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.openide.ErrorManager;
import org.openide.filesystems.FileAttributeEvent;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileRenameEvent;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileSystem;
import org.openide.loaders.DataFilter;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataLoader;
import org.openide.loaders.DataLoaderPool;
import org.openide.loaders.DataNode;
import org.openide.loaders.DataObjectExistsException;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.loaders.DataObjectPool;
import org.openide.loaders.DataShadow;
import org.openide.loaders.FolderList;
import org.openide.loaders.OperationEvent;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

public abstract class DataObject
implements Node.Cookie,
Serializable,
HelpCtx.Provider {
    private static final long serialVersionUID = 3328227388376142699L;
    public static final String PROP_TEMPLATE = "template";
    public static final String PROP_NAME = "name";
    public static final String PROP_HELP = "helpCtx";
    public static final String PROP_MODIFIED = "modified";
    public static final String PROP_COOKIE = "cookie";
    public static final String PROP_VALID = "valid";
    public static final String PROP_PRIMARY_FILE = "primaryFile";
    public static final String PROP_FILES = "files";
    static final String EA_ASSIGNED_LOADER = "NetBeansAttrAssignedLoader";
    static final String EA_ASSIGNED_LOADER_MODULE = "NetBeansAttrAssignedLoaderModule";
    private static ModifiedRegistry modified;
    private static Set syncModified;
    private boolean modif = false;
    private transient Node nodeDelegate;
    DataObjectPool.Item item;
    private DataLoader loader;
    private PropertyChangeSupport changeSupport;
    private VetoableChangeSupport vetoableChangeSupport;
    private static final Object listenersMethodLock;
    private Object nodeCreationLock = new Object();
    private static Object synchObject;
    private static Registry REGISTRY_INSTANCE;
    static final /* synthetic */ boolean $assertionsDisabled;

    public DataObject(FileObject fileObject, DataLoader dataLoader) throws DataObjectExistsException {
        this(fileObject, DataObjectPool.getPOOL().register(fileObject, dataLoader), dataLoader);
    }

    private DataObject(FileObject fileObject, DataObjectPool.Item item, DataLoader dataLoader) {
        this.item = item;
        this.loader = dataLoader;
        item.setDataObject(this);
    }

    protected void dispose() {
        DataObjectPool.Item item = this.item;
        if (item != null) {
            item.deregister(true);
            item.setDataObject(null);
            this.firePropertyChange(PROP_VALID, Boolean.TRUE, Boolean.FALSE);
        }
    }

    public void setValid(boolean bl) throws PropertyVetoException {
        if (!bl && this.isValid()) {
            this.markInvalid0();
        }
    }

    final void markInvalid0() throws PropertyVetoException {
        this.fireVetoableChange(PROP_VALID, Boolean.TRUE, Boolean.FALSE);
        this.dispose();
        this.setModified(false);
    }

    public final boolean isValid() {
        return this.item.isValid();
    }

    public final DataLoader getLoader() {
        return this.loader;
    }

    protected final void markFiles() throws IOException {
        Iterator iterator = this.files().iterator();
        while (iterator.hasNext()) {
            FileObject fileObject = (FileObject)iterator.next();
            this.loader.markFile(fileObject);
        }
    }

    public Set files() {
        return Collections.singleton(this.getPrimaryFile());
    }

    public final Node getNodeDelegate() {
        if (!this.isValid()) {
            IllegalStateException illegalStateException = new IllegalStateException("The data object " + this.getPrimaryFile() + " is invalid; you may not call getNodeDelegate on it any more; see #17020 and please fix your code");
            ErrorManager.getDefault().notify(1, (Throwable)illegalStateException);
        }
        if (this.nodeDelegate == null) {
            Children.MUTEX.readAccess(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    Object object = DataObject.this.nodeCreationLock;
                    synchronized (object) {
                        if (DataObject.this.nodeDelegate == null) {
                            DataObject.this.nodeDelegate = DataObject.this.createNodeDelegate();
                        }
                    }
                }
            });
            if (this.nodeDelegate == null) {
                throw new IllegalStateException("DataObject " + this + " has null node delegate");
            }
        }
        return this.nodeDelegate;
    }

    Node getClonedNodeDelegate(DataFilter dataFilter) {
        return this.getNodeDelegate().cloneNode();
    }

    Node getNodeDelegateOrNull() {
        return this.nodeDelegate;
    }

    protected Node createNodeDelegate() {
        return new DataNode(this, Children.LEAF);
    }

    protected FileLock takePrimaryFileLock() throws IOException {
        return this.getPrimaryFile().lock();
    }

    static boolean setTemplate(FileObject fileObject, boolean bl) throws IOException {
        boolean bl2 = false;
        Object object = fileObject.getAttribute(PROP_TEMPLATE);
        if (object instanceof Boolean && ((Boolean)object).booleanValue()) {
            bl2 = true;
        }
        if (bl2 == bl) {
            return false;
        }
        fileObject.setAttribute(PROP_TEMPLATE, (Object)(bl ? Boolean.TRUE : null));
        return true;
    }

    public final void setTemplate(boolean bl) throws IOException {
        if (!DataObject.setTemplate(this.getPrimaryFile(), bl)) {
            return;
        }
        this.firePropertyChange(PROP_TEMPLATE, !bl ? Boolean.TRUE : Boolean.FALSE, bl ? Boolean.TRUE : Boolean.FALSE);
    }

    public final boolean isTemplate() {
        Object object = this.getPrimaryFile().getAttribute(PROP_TEMPLATE);
        boolean bl = false;
        if (object instanceof Boolean) {
            bl = (Boolean)object;
        }
        return bl;
    }

    public abstract boolean isDeleteAllowed();

    public abstract boolean isCopyAllowed();

    public abstract boolean isMoveAllowed();

    public boolean isShadowAllowed() {
        return true;
    }

    public abstract boolean isRenameAllowed();

    public boolean isModified() {
        return this.modif;
    }

    public void setModified(boolean bl) {
        if (this.modif != bl) {
            this.modif = bl;
            if (bl) {
                syncModified.add(this);
            } else {
                syncModified.remove(this);
            }
            this.firePropertyChange(PROP_MODIFIED, !bl ? Boolean.TRUE : Boolean.FALSE, bl ? Boolean.TRUE : Boolean.FALSE);
        }
    }

    public abstract HelpCtx getHelpCtx();

    public final FileObject getPrimaryFile() {
        return this.item.primaryFile;
    }

    public static DataObject find(FileObject fileObject) throws DataObjectNotFoundException {
        if (fileObject == null) {
            throw new IllegalArgumentException("Called DataObject.find on null");
        }
        try {
            if (!fileObject.isValid()) {
                throw new FileStateInvalidException(fileObject.toString());
            }
            DataObject dataObject = DataObjectPool.getPOOL().find(fileObject);
            if (dataObject != null) {
                return dataObject;
            }
            DataLoaderPool dataLoaderPool = DataLoaderPool.getDefault();
            if (!$assertionsDisabled && dataLoaderPool == null) {
                throw new AssertionError((Object)("No DataLoaderPool found in " + Lookup.getDefault()));
            }
            dataObject = dataLoaderPool.findDataObject(fileObject);
            if (dataObject != null) {
                return dataObject;
            }
            throw new DataObjectNotFoundException(fileObject);
        }
        catch (DataObjectExistsException dataObjectExistsException) {
            return dataObjectExistsException.getDataObject();
        }
        catch (IOException iOException) {
            throw (DataObjectNotFoundException)new DataObjectNotFoundException(fileObject).initCause(iOException);
        }
    }

    public static Registry getRegistry() {
        return REGISTRY_INSTANCE;
    }

    public String getName() {
        return this.getPrimaryFile().getName();
    }

    public String toString() {
        return super.toString() + '[' + this.getPrimaryFile() + ']';
    }

    public final DataFolder getFolder() {
        FileObject fileObject = this.getPrimaryFile().getParent();
        return fileObject == null ? null : DataFolder.findFolder(fileObject);
    }

    public final DataObject copy(final DataFolder dataFolder) throws IOException {
        final DataObject[] dataObjectArray = new DataObject[1];
        this.invokeAtomicAction(dataFolder.getPrimaryFile(), new FileSystem.AtomicAction(){

            public void run() throws IOException {
                dataObjectArray[0] = DataObject.this.handleCopy(dataFolder);
            }
        }, null);
        DataObject.fireOperationEvent(new OperationEvent.Copy(dataObjectArray[0], this), 1);
        return dataObjectArray[0];
    }

    protected abstract DataObject handleCopy(DataFolder var1) throws IOException;

    public final void delete() throws IOException {
        this.invokeAtomicAction(this.getPrimaryFile(), new FileSystem.AtomicAction(){

            public void run() throws IOException {
                DataObject.this.handleDelete();
                DataObject.this.item.deregister(false);
                DataObject.this.item.setDataObject(null);
            }
        }, this.synchObject());
        this.firePropertyChange(PROP_VALID, Boolean.TRUE, Boolean.FALSE);
        DataObject.fireOperationEvent(new OperationEvent(this), 3);
    }

    protected abstract void handleDelete() throws IOException;

    public final void rename(String string) throws IOException {
        if (string != null && string.trim().length() == 0) {
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException(this.getName());
            String string2 = NbBundle.getMessage((Class)DataObject.class, (String)"MSG_NotValidName", (Object)this.getName());
            ErrorManager.getDefault().annotate((Throwable)illegalArgumentException, 1, null, string2, null, null);
            throw illegalArgumentException;
        }
        class Op
        implements FileSystem.AtomicAction {
            FileObject oldPf;
            FileObject newPf;
            String oldName;
            String newName;

            Op() {
            }

            public void run() throws IOException {
                this.oldName = DataObject.this.getName();
                if (this.oldName.equals(this.newName)) {
                    return;
                }
                this.oldPf = DataObject.this.getPrimaryFile();
                this.newPf = DataObject.this.handleRename(this.newName);
                if (this.oldPf != this.newPf) {
                    DataObject.this.item.changePrimaryFile(this.newPf);
                }
                this.newName = DataObject.this.getName();
            }
        }
        Op op = new Op();
        op.newName = string;
        this.invokeAtomicAction(this.getPrimaryFile().getParent(), op, this.synchObject());
        if (op.oldName.equals(op.newName)) {
            return;
        }
        if (op.oldPf != op.newPf) {
            this.firePropertyChange(PROP_PRIMARY_FILE, op.oldPf, op.newPf);
        }
        this.firePropertyChange(PROP_NAME, op.oldName, op.newName);
        DataObject.fireOperationEvent(new OperationEvent.Rename(this, op.oldName), 4);
    }

    protected abstract FileObject handleRename(String var1) throws IOException;

    public final void move(DataFolder dataFolder) throws IOException {
        class Op
        implements FileSystem.AtomicAction {
            FileObject old;
            private final /* synthetic */ DataFolder val$df;

            Op(DataFolder dataFolder) {
                this.val$df = dataFolder;
            }

            public void run() throws IOException {
                if (DataObject.this.getFolder() == null) {
                    return;
                }
                if (this.val$df.equals(DataObject.this.getFolder())) {
                    return;
                }
                this.old = DataObject.this.getPrimaryFile();
                FileObject fileObject = DataObject.this.handleMove(this.val$df);
                DataObject.this.item.changePrimaryFile(fileObject);
            }
        }
        Op op = new Op(dataFolder);
        this.invokeAtomicAction(dataFolder.getPrimaryFile(), op, this.synchObject());
        this.firePropertyChange(PROP_PRIMARY_FILE, op.old, this.getPrimaryFile());
        DataObject.fireOperationEvent(new OperationEvent.Move(this, op.old), 2);
    }

    protected abstract FileObject handleMove(DataFolder var1) throws IOException;

    protected DataShadow handleCreateShadow(DataFolder dataFolder) throws IOException {
        return DataShadow.create(dataFolder, this);
    }

    public final DataShadow createShadow(final DataFolder dataFolder) throws IOException {
        final DataShadow[] dataShadowArray = new DataShadow[1];
        this.invokeAtomicAction(dataFolder.getPrimaryFile(), new FileSystem.AtomicAction(){

            public void run() throws IOException {
                dataShadowArray[0] = DataObject.this.handleCreateShadow(dataFolder);
            }
        }, null);
        DataObject.fireOperationEvent(new OperationEvent.Copy(dataShadowArray[0], this), 5);
        return dataShadowArray[0];
    }

    public final DataObject createFromTemplate(DataFolder dataFolder) throws IOException {
        return this.createFromTemplate(dataFolder, null);
    }

    public final DataObject createFromTemplate(final DataFolder dataFolder, final String string) throws IOException {
        final DataObject[] dataObjectArray = new DataObject[1];
        this.invokeAtomicAction(dataFolder.getPrimaryFile(), new FileSystem.AtomicAction(){

            public void run() throws IOException {
                dataObjectArray[0] = DataObject.this.handleCreateFromTemplate(dataFolder, string);
            }
        }, null);
        DataObject.fireOperationEvent(new OperationEvent.Copy(dataObjectArray[0], this), 6);
        return dataObjectArray[0];
    }

    protected abstract DataObject handleCreateFromTemplate(DataFolder var1, String var2) throws IOException;

    private static void fireOperationEvent(OperationEvent operationEvent, int n) {
        DataLoaderPool.getDefault().fireOperationEvent(operationEvent, n);
    }

    Object synchObject() {
        return synchObject;
    }

    private void invokeAtomicAction(FileObject fileObject, FileSystem.AtomicAction atomicAction, Object object) throws IOException {
        class WrapRun
        implements FileSystem.AtomicAction {
            private final /* synthetic */ Object val$lockTheSession;
            private final /* synthetic */ FileSystem.AtomicAction val$action;

            WrapRun(Object object, FileSystem.AtomicAction atomicAction) {
                this.val$lockTheSession = object;
                this.val$action = atomicAction;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() throws IOException {
                Object object = this.val$lockTheSession;
                synchronized (object) {
                    this.val$action.run();
                }
            }
        }
        FileSystem.AtomicAction atomicAction2 = object != null ? new WrapRun(object, atomicAction) : atomicAction;
        if (Boolean.getBoolean("netbeans.dataobject.insecure.operation")) {
            DataObjectPool.getPOOL().runAtomicActionSimple(fileObject, atomicAction2);
            return;
        }
        if (this instanceof DataFolder) {
            DataObjectPool.getPOOL().runAtomicActionSimple(fileObject, atomicAction2);
        } else {
            DataObjectPool.getPOOL().runAtomicAction(fileObject, atomicAction2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        Object object = listenersMethodLock;
        synchronized (object) {
            if (this.changeSupport == null) {
                this.changeSupport = new PropertyChangeSupport(this);
            }
        }
        this.changeSupport.addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (this.changeSupport != null) {
            this.changeSupport.removePropertyChangeListener(propertyChangeListener);
        }
    }

    protected final void firePropertyChange(String string, Object object, Object object2) {
        if (this.changeSupport != null) {
            this.changeSupport.firePropertyChange(string, object, object2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addVetoableChangeListener(VetoableChangeListener vetoableChangeListener) {
        Object object = listenersMethodLock;
        synchronized (object) {
            if (this.vetoableChangeSupport == null) {
                this.vetoableChangeSupport = new VetoableChangeSupport(this);
            }
        }
        this.vetoableChangeSupport.addVetoableChangeListener(vetoableChangeListener);
    }

    public void removeVetoableChangeListener(VetoableChangeListener vetoableChangeListener) {
        if (this.vetoableChangeSupport != null) {
            this.vetoableChangeSupport.removeVetoableChangeListener(vetoableChangeListener);
        }
    }

    protected final void fireVetoableChange(String string, Object object, Object object2) throws PropertyVetoException {
        if (this.vetoableChangeSupport != null) {
            this.vetoableChangeSupport.fireVetoableChange(string, object, object2);
        }
    }

    public Node.Cookie getCookie(Class clazz) {
        if (clazz.isInstance(this)) {
            return this;
        }
        return null;
    }

    protected Node.Cookie getCookie(DataShadow dataShadow, Class clazz) {
        return this.getCookie(clazz);
    }

    public Object writeReplace() {
        return new Replace(this);
    }

    static String getString(String string) {
        return NbBundle.getMessage((Class)DataObject.class, (String)string);
    }

    void recognizedByFolder() {
    }

    void notifyFileRenamed(FileRenameEvent fileRenameEvent) {
        if (fileRenameEvent.getFile().equals(this.getPrimaryFile())) {
            this.firePropertyChange(PROP_NAME, fileRenameEvent.getName(), this.getName());
        }
    }

    void notifyFileDeleted(FileEvent fileEvent) {
    }

    void notifyFileChanged(FileEvent fileEvent) {
    }

    void notifyFileDataCreated(FileEvent fileEvent) {
    }

    void notifyAttributeChanged(FileAttributeEvent fileAttributeEvent) {
        String string;
        if (!EA_ASSIGNED_LOADER.equals(fileAttributeEvent.getName())) {
            return;
        }
        FileObject fileObject = fileAttributeEvent.getFile();
        if (!(fileObject == null || (string = (String)fileObject.getAttribute(EA_ASSIGNED_LOADER)) != null && string.equals(((Object)((Object)this.getLoader())).getClass().getName()))) {
            HashSet<FileObject> hashSet = new HashSet<FileObject>();
            hashSet.add(fileObject);
            if (!DataObjectPool.getPOOL().revalidate(hashSet).isEmpty()) {
                ErrorManager.getDefault().log(1, "It was not possible to invalidate data object: " + this);
            } else {
                FolderList.changedDataSystem(fileObject.getParent());
            }
        }
    }

    static {
        $assertionsDisabled = !DataObject.class.desiredAssertionStatus();
        modified = new ModifiedRegistry();
        syncModified = Collections.synchronizedSet(modified);
        listenersMethodLock = new Object();
        synchObject = new Object();
        REGISTRY_INSTANCE = new Registry();
    }

    public static interface Container
    extends Node.Cookie {
        public static final String PROP_CHILDREN = "children";

        public DataObject[] getChildren();

        public void addPropertyChangeListener(PropertyChangeListener var1);

        public void removePropertyChangeListener(PropertyChangeListener var1);
    }

    private static final class ModifiedRegistry
    extends HashSet {
        static final long serialVersionUID = -2861723614638919680L;
        private HashSet listeners;

        ModifiedRegistry() {
        }

        public final synchronized void addChangeListener(ChangeListener changeListener) {
            if (this.listeners == null) {
                this.listeners = new HashSet(5);
            }
            this.listeners.add(changeListener);
        }

        public final synchronized void removeChangeListener(ChangeListener changeListener) {
            if (this.listeners == null) {
                return;
            }
            this.listeners.remove(changeListener);
        }

        public boolean add(Object object) {
            boolean bl = super.add(object);
            if (bl) {
                this.fireChangeEvent(new ChangeEvent(this));
            }
            return bl;
        }

        public boolean remove(Object object) {
            boolean bl = super.remove(object);
            if (bl) {
                this.fireChangeEvent(new ChangeEvent(this));
            }
            return bl;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected final void fireChangeEvent(ChangeEvent changeEvent) {
            HashSet hashSet;
            if (this.listeners == null) {
                return;
            }
            Object object = this;
            synchronized (object) {
                hashSet = (HashSet)this.listeners.clone();
            }
            object = hashSet.iterator();
            while (object.hasNext()) {
                ((ChangeListener)object.next()).stateChanged(changeEvent);
            }
        }
    }

    public static final class Registry {
        private Registry() {
        }

        public void addChangeListener(ChangeListener changeListener) {
            modified.addChangeListener(changeListener);
        }

        public void removeChangeListener(ChangeListener changeListener) {
            modified.removeChangeListener(changeListener);
        }

        public Set getModifiedSet() {
            return Collections.unmodifiableSet(syncModified);
        }

        public DataObject[] getModified() {
            return syncModified.toArray(new DataObject[0]);
        }
    }

    private static final class Replace
    implements Serializable {
        private FileObject fo;
        private transient DataObject obj;
        private static final long serialVersionUID = -627843044348243058L;

        public Replace(DataObject dataObject) {
            this.obj = dataObject;
            this.fo = dataObject.getPrimaryFile();
        }

        public Object readResolve() {
            return this.obj;
        }

        private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
            objectInputStream.defaultReadObject();
            if (this.fo == null) {
                throw new FileNotFoundException();
            }
            this.obj = DataObject.find(this.fo);
        }
    }
}

