/*
 * Decompiled with CFR 0.152.
 */
package org.openide.actions;

import java.io.IOException;
import java.util.Set;
import org.openide.ErrorManager;
import org.openide.actions.NewTemplateAction;
import org.openide.loaders.DataObject;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.UserCancelException;
import org.openide.util.actions.NodeAction;

public class InstantiateAction
extends NodeAction {
    static final long serialVersionUID = 1482795804240508824L;

    protected boolean enable(Node[] nodeArray) {
        if (nodeArray.length != 1) {
            return false;
        }
        DataObject dataObject = (DataObject)nodeArray[0].getCookie(DataObject.class);
        return dataObject != null && dataObject.isTemplate();
    }

    protected void performAction(Node[] nodeArray) {
        DataObject dataObject = (DataObject)nodeArray[0].getCookie(DataObject.class);
        if (dataObject != null && dataObject.isTemplate()) {
            try {
                InstantiateAction.instantiateTemplate(dataObject);
            }
            catch (UserCancelException userCancelException) {
            }
            catch (IOException iOException) {
                ErrorManager.getDefault().notify((Throwable)iOException);
            }
        }
    }

    public String getName() {
        return NbBundle.getMessage((Class)DataObject.class, (String)"Instantiate");
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(InstantiateAction.class);
    }

    public static Set instantiateTemplate(DataObject dataObject) throws IOException {
        return NewTemplateAction.getWizard(null).instantiate(dataObject);
    }
}

