/*
 * Decompiled with CFR 0.152.
 */
package org.openide.actions;

import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JMenuItem;
import org.openide.ErrorManager;
import org.openide.awt.JInlineMenu;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileSystem;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataShadow;
import org.openide.nodes.Node;
import org.openide.util.ContextAwareAction;
import org.openide.util.Enumerations;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.WeakListeners;
import org.openide.util.actions.Presenter;
import org.openide.util.actions.SystemAction;
import org.openide.util.lookup.Lookups;
import org.openide.util.lookup.ProxyLookup;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;

public class FileSystemAction
extends SystemAction
implements ContextAwareAction,
Presenter.Menu,
Presenter.Popup {
    static JMenuItem[] NONE;
    static final /* synthetic */ boolean $assertionsDisabled;

    private static Node[] nodes(Lookup lookup) {
        Collection collection = lookup != null ? lookup.lookup(new Lookup.Template(Node.class)).allInstances() : Collections.EMPTY_LIST;
        return collection.toArray(new Node[collection.size()]);
    }

    static JMenuItem[] createMenu(boolean bl, Lookup lookup) {
        Node[] nodeArray = FileSystemAction.nodes(lookup);
        if (nodeArray == null) {
            nodeArray = WindowManager.getDefault().getRegistry().getActivatedNodes();
        }
        HashMap hashMap = new HashMap();
        if (nodeArray != null) {
            LinkedHashSet linkedHashSet;
            Object object;
            Serializable serializable;
            for (int i = 0; i < nodeArray.length; ++i) {
                serializable = (DataObject)nodeArray[i].getCookie(class$org$openide$loaders$DataObject == null ? FileSystemAction.class$("org.openide.loaders.DataObject") : class$org$openide$loaders$DataObject);
                while (serializable instanceof DataShadow) {
                    serializable = ((DataShadow)serializable).getOriginal();
                }
                if (serializable == null) continue;
                try {
                    object = ((DataObject)serializable).getPrimaryFile().getFileSystem();
                    linkedHashSet = (Set)hashMap.get(object);
                    if (linkedHashSet == null) {
                        linkedHashSet = new LinkedHashSet();
                        hashMap.put(object, linkedHashSet);
                    }
                    linkedHashSet.addAll(((DataObject)serializable).files());
                    continue;
                }
                catch (FileStateInvalidException fileStateInvalidException) {
                    // empty catch block
                }
            }
            if (hashMap.size() == 0 || hashMap.size() > 1) {
                return FileSystemAction.createMenu(Enumerations.empty(), bl, lookup);
            }
            Iterator iterator = hashMap.entrySet().iterator();
            serializable = new LinkedList();
            object = new LinkedHashSet();
            while (iterator.hasNext()) {
                linkedHashSet = iterator.next();
                FileSystem fileSystem = (FileSystem)linkedHashSet.getKey();
                Set set = (Set)linkedHashSet.getValue();
                LinkedList linkedList = new LinkedList();
                Iterator iterator2 = set.iterator();
                while (iterator2.hasNext()) {
                    linkedList.add(iterator2.next());
                }
                Iterator iterator3 = linkedList.iterator();
                while (iterator3.hasNext()) {
                    FileObject fileObject = (FileObject)iterator3.next();
                    try {
                        if (fileObject.getFileSystem() == fileSystem) continue;
                        iterator3.remove();
                    }
                    catch (FileStateInvalidException fileStateInvalidException) {
                        iterator3.remove();
                    }
                }
                object.addAll(linkedList);
                ((LinkedList)serializable).addAll(Arrays.asList(fileSystem.getActions((Set)object)));
            }
            return FileSystemAction.createMenu(Collections.enumeration(serializable), bl, (Lookup)FileSystemAction.createProxyLookup(lookup, (Set)object));
        }
        return NONE;
    }

    private static ProxyLookup createProxyLookup(Lookup lookup, Set set) {
        return new ProxyLookup(new Lookup[]{lookup, Lookups.fixed((Object[])set.toArray(new FileObject[set.size()]))});
    }

    static JMenuItem[] createMenu(Enumeration enumeration, boolean bl, Lookup lookup) {
        Object object;
        enumeration = Enumerations.removeDuplicates((Enumeration)enumeration);
        ArrayList<JMenuItem> arrayList = new ArrayList<JMenuItem>();
        while (enumeration.hasMoreElements()) {
            object = (JMenuItem[])enumeration.nextElement();
            if (lookup != null && object instanceof ContextAwareAction) {
                object = ((ContextAwareAction)object).createContextAwareInstance(lookup);
            }
            boolean bl2 = false;
            try {
                bl2 = object.isEnabled();
            }
            catch (RuntimeException runtimeException) {
                ErrorManager errorManager = ErrorManager.getDefault();
                errorManager.annotate((Throwable)runtimeException, 0, "Guilty action: " + object.getClass().getName(), null, null, null);
                errorManager.notify((Throwable)runtimeException);
            }
            if (!bl2) continue;
            JMenuItem jMenuItem = null;
            if (bl) {
                if (object instanceof Presenter.Popup) {
                    jMenuItem = ((Presenter.Popup)object).getPopupPresenter();
                }
            } else if (object instanceof Presenter.Menu) {
                jMenuItem = ((Presenter.Menu)object).getMenuPresenter();
            }
            if (jMenuItem == null) continue;
            arrayList.add(jMenuItem);
        }
        object = new JMenuItem[arrayList.size()];
        arrayList.toArray((T[])object);
        return object;
    }

    public JMenuItem getMenuPresenter() {
        return new Menu(false, null);
    }

    public JMenuItem getPopupPresenter() {
        return new Menu(true, null);
    }

    public String getName() {
        return NbBundle.getMessage((Class)DataObject.class, (String)"ACT_FileSystemAction");
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(FileSystemAction.class);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (!$assertionsDisabled) {
            throw new AssertionError((Object)("ActionEvt: " + actionEvent));
        }
    }

    public Action createContextAwareInstance(Lookup lookup) {
        return new DelegateAction(lookup);
    }

    static {
        $assertionsDisabled = !FileSystemAction.class.desiredAssertionStatus();
        NONE = new JMenuItem[0];
    }

    private static final class DelegateAction
    extends AbstractAction
    implements Presenter.Menu,
    Presenter.Popup {
        private Lookup lookup;
        static final /* synthetic */ boolean $assertionsDisabled;

        public DelegateAction(Lookup lookup) {
            this.lookup = lookup;
        }

        public JMenuItem getMenuPresenter() {
            return new Menu(false, this.lookup);
        }

        public JMenuItem getPopupPresenter() {
            return new Menu(true, this.lookup);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (!$assertionsDisabled) {
                throw new AssertionError(actionEvent);
            }
        }

        static {
            $assertionsDisabled = !(class$org$openide$actions$FileSystemAction == null ? (class$org$openide$actions$FileSystemAction = FileSystemAction.class$("org.openide.actions.FileSystemAction")) : class$org$openide$actions$FileSystemAction).desiredAssertionStatus();
        }
    }

    private static class Menu
    extends JInlineMenu
    implements PropertyChangeListener {
        private boolean popup;
        private JMenuItem[] last = NONE;
        private Lookup lookup;
        static final long serialVersionUID = 2650151487189209766L;
        boolean needsChange = false;

        Menu(boolean bl, Lookup lookup) {
            this.popup = bl;
            this.lookup = lookup;
            this.changeMenuItems(FileSystemAction.createMenu(bl, lookup));
            if (lookup == null) {
                TopComponent.Registry registry = WindowManager.getDefault().getRegistry();
                registry.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this, (Object)registry));
            }
        }

        synchronized void changeMenuItems(JMenuItem[] jMenuItemArray) {
            this.removeListeners(this.last);
            this.addListeners(jMenuItemArray);
            this.last = jMenuItemArray;
            this.setMenuItems(jMenuItemArray);
        }

        private void addListeners(JMenuItem[] jMenuItemArray) {
            int n = jMenuItemArray.length;
            for (int i = 0; i < n; ++i) {
                jMenuItemArray[i].addPropertyChangeListener(this);
            }
        }

        private void removeListeners(JMenuItem[] jMenuItemArray) {
            int n = jMenuItemArray.length;
            for (int i = 0; i < n; ++i) {
                jMenuItemArray[i].removePropertyChangeListener(this);
            }
        }

        public void addNotify() {
            if (this.needsChange) {
                this.changeMenuItems(FileSystemAction.createMenu(this.popup, this.lookup));
                this.needsChange = false;
            }
            super.addNotify();
        }

        public void removeNotify() {
            this.removeListeners(this.last);
            this.last = NONE;
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            String string = propertyChangeEvent.getPropertyName();
            if (string == null || string.equals("enabled") || string.equals("activatedNodes")) {
                this.needsChange = true;
            }
        }
    }
}

