/*
 * Decompiled with CFR 0.152.
 */
package tr.view.topic;

import java.util.Collections;
import java.util.List;
import java.util.Vector;
import javax.swing.DefaultComboBoxModel;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import tr.model.Data;
import tr.model.DataLookup;
import tr.model.topic.Topic;
import tr.model.util.Manager;
import tr.util.Observable;
import tr.util.Observer;

public class TopicComboBoxModel
extends DefaultComboBoxModel
implements Observer {
    private Manager<Topic> topicManager;
    private List<Topic> topics;
    private boolean all;
    private transient Lookup.Result result;

    public TopicComboBoxModel(boolean all) {
        this.all = all;
        this.initialise();
    }

    private void initialise() {
        Data data = (Data)DataLookup.instance().lookup(Data.class);
        if (data == null) {
            this.topics = new Vector<Topic>();
            return;
        }
        if (this.topicManager != null) {
            this.topicManager.removeObserver((Observer)this);
        }
        this.topicManager = data.getTopicManager();
        this.topicManager.addObserver((Observer)this);
        this.topics = this.topicManager.list();
        Collections.sort(this.topics);
        if (this.all) {
            Topic all = new Topic();
            all.setName("All");
            this.topics.add(0, all);
        }
        if (this.result == null) {
            this.result = DataLookup.instance().lookup(new Lookup.Template(Data.class));
            this.result.addLookupListener(new LookupListener(){

                public void resultChanged(LookupEvent lookupEvent) {
                    TopicComboBoxModel.this.update(null, null);
                }
            });
        }
    }

    public Object getElementAt(int index) {
        return this.topics.get(index);
    }

    public int getSize() {
        return this.topics.size();
    }

    public void update(Observable o, Object arg) {
        this.initialise();
        this.fireContentsChanged(this, 0, this.getSize());
    }
}

