/*
 * Decompiled with CFR 0.152.
 */
package tr.view.collect.screen;

import java.util.List;
import java.util.Vector;
import javax.swing.Icon;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellRenderer;
import tr.model.Data;
import tr.model.thought.Thought;
import tr.model.topic.Topic;
import tr.model.util.Manager;
import tr.swing.StyledString;
import tr.swing.StyledStringRenderer;
import tr.util.Observable;
import tr.util.Observer;
import tr.view.Resources;

public class CollectThoughtsTableModel
extends AbstractTableModel
implements Observer {
    public static final String[] HEADINGS = new String[]{"", " Description", " Topic"};
    public static final Class[] CLASSES = new Class[]{Icon.class, StyledString.class, Topic.class};
    public static final int[] MAX_WIDTHS = new int[]{17, -1, 400};
    public static final int[] MIN_WIDTHS = new int[]{17, -1, -1};
    public static final int[] PREF_WIDTHS = new int[]{17, -1, 250};
    public TableCellRenderer[] renderers = new TableCellRenderer[]{null, new StyledStringRenderer(), new StyledStringRenderer()};
    private final Manager<Thought> thoughtManager;
    private List<Thought> unprocessedThoughts;
    private Thought thought;
    private Topic topic;
    private StyledString ss;

    public CollectThoughtsTableModel(Data data) {
        this.thoughtManager = data.getThoughtManager();
        this.thoughtManager.addObserver((Observer)this);
        this.initModel();
    }

    private void initModel() {
        this.unprocessedThoughts = new Vector<Thought>();
        for (Thought thought : this.thoughtManager.list()) {
            if (thought.isProcessed()) continue;
            this.unprocessedThoughts.add(thought);
        }
    }

    public Thought getValueAt(int row) {
        return this.unprocessedThoughts.get(row);
    }

    public int getColumnCount() {
        return CLASSES.length;
    }

    public String getColumnName(int column) {
        return HEADINGS[column];
    }

    public int getRowCount() {
        return this.unprocessedThoughts.size();
    }

    public Class getColumnClass(int column) {
        return CLASSES[column];
    }

    public Object getValueAt(int row, int column) {
        switch (column) {
            case 0: {
                return Resources.ICON_G_THOUGHT;
            }
            case 1: {
                this.thought = this.unprocessedThoughts.get(row);
                this.topic = this.thought.getTopic();
                this.ss = new StyledString();
                this.ss.setString(this.thought.getDescription());
                this.ss.setForeground(this.topic.getForeground());
                this.ss.setBackground(this.topic.getBackground());
                return this.ss;
            }
            case 2: {
                this.thought = this.unprocessedThoughts.get(row);
                this.topic = this.thought.getTopic();
                this.ss = new StyledString();
                this.ss.setString(this.topic.getName());
                this.ss.setBackground(this.topic.getBackground());
                this.ss.setForeground(this.topic.getForeground());
                return this.ss;
            }
        }
        return null;
    }

    public boolean isCellEditable(int row, int column) {
        return false;
    }

    public void update(Observable o, Object arg) {
        this.initModel();
        this.fireTableDataChanged();
    }
}

