/*
 * Decompiled with CFR 0.152.
 */
package tr.view.collect.dialog;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.KeyStroke;
import org.jdesktop.swingx.util.WindowUtils;
import org.openide.util.NbBundle;
import tr.model.Data;
import tr.model.thought.Thought;
import tr.util.Observable;
import tr.view.collect.dialog.ThoughtDialogPanel;

public class ThoughtDialog
extends JDialog {
    private Mode mode;
    private Data data;
    private ThoughtDialogPanel thoughtPanel;
    private Thought thought;
    private JButton okButton;
    private JButton cancelButton;

    public ThoughtDialog(Data data) {
        super((Frame)null, true);
        this.data = data;
        this.construct();
    }

    private void construct() {
        this.setDefaultCloseOperation(2);
        ActionListener cancelListener = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ThoughtDialog.this.cancel();
            }
        };
        KeyStroke stroke = KeyStroke.getKeyStroke(27, 0);
        JRootPane rootPane = this.getRootPane();
        rootPane.registerKeyboardAction(cancelListener, stroke, 2);
        this.thoughtPanel = new ThoughtDialogPanel();
        this.thoughtPanel.setPreferredSize(new Dimension(700, 500));
        this.cancelButton = new JButton("Cancel");
        this.cancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ThoughtDialog.this.cancel();
            }
        });
        this.okButton = new JButton("OK");
        this.okButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ThoughtDialog.this.ok();
            }
        });
        JPanel buttons = new JPanel(new FlowLayout(2, 2, 2));
        buttons.setPreferredSize(new Dimension(0, 36));
        buttons.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 36));
        buttons.add(new JLabel("   "));
        buttons.add(this.cancelButton);
        buttons.add(this.okButton);
        this.add((Component)this.thoughtPanel, "Center");
        this.add((Component)buttons, "South");
        this.pack();
        this.setLocation(WindowUtils.getPointForCentering((Window)this));
    }

    private void setMode(Mode mode) {
        this.mode = mode;
        if (mode == Mode.CREATE) {
            this.setTitle(NbBundle.getMessage(this.getClass(), (String)"create"));
        } else {
            this.setTitle(NbBundle.getMessage(this.getClass(), (String)"modify"));
        }
    }

    private boolean isValid(Thought thought) {
        return thought.getDescription().trim().length() != 0;
    }

    private void ok() {
        this.thought.setDescription(this.thoughtPanel.getDescription());
        this.thought.setTopic(this.thoughtPanel.getTopic());
        this.thought.setNotes(this.thoughtPanel.getNotes());
        if (!this.isValid(this.thought)) {
            Toolkit.getDefaultToolkit().beep();
            return;
        }
        if (this.mode == Mode.MODIFY) {
            this.setVisible(false);
            this.dispose();
        } else {
            this.data.getThoughtManager().add((Observable)this.thought);
            this.thought = new Thought();
            this.thoughtPanel.setDescription(this.thought.getDescription());
            this.thoughtPanel.setNotes(this.thought.getNotes());
            this.thoughtPanel.focus();
        }
    }

    private void cancel() {
        this.setVisible(false);
        this.dispose();
    }

    private void showDialog() {
        this.getRootPane().setDefaultButton(this.okButton);
        this.setVisible(true);
    }

    public void showCreateDialog() {
        this.thought = new Thought();
        this.thoughtPanel.setDescription(this.thought.getDescription());
        this.thoughtPanel.setTopic(this.thought.getTopic());
        this.thoughtPanel.setNotes(this.thought.getNotes());
        this.setMode(Mode.CREATE);
        this.showDialog();
    }

    public void showModifyDialog(Thought thought) {
        if (thought == null) {
            return;
        }
        this.thought = thought;
        this.thoughtPanel.setDescription(thought.getDescription());
        this.thoughtPanel.setTopic(thought.getTopic());
        this.thoughtPanel.setNotes(thought.getNotes());
        this.setMode(Mode.MODIFY);
        this.showDialog();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum Mode {
        CREATE,
        MODIFY;

    }
}

