/*
 * Decompiled with CFR 0.152.
 */
package tr.view.collect;

import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.NbBundle;
import org.openide.util.actions.CallableSystemAction;
import tr.global.InitialAction;
import tr.model.Data;
import tr.model.DataLookup;
import tr.view.Resources;
import tr.view.collect.dialog.ThoughtDialog;

public class AddThoughtsAction
extends CallableSystemAction
implements InitialAction {
    private final Lookup.Result result;

    public AddThoughtsAction() {
        this.setIcon(Resources.ICON_G_ADD_THOUGHTS);
        this.result = DataLookup.instance().lookup(new Lookup.Template(Data.class));
        this.result.addLookupListener(new LookupListener(){

            public void resultChanged(LookupEvent lookupEvent) {
                AddThoughtsAction.this.setEnabled(AddThoughtsAction.this.result.allInstances().size() > 0);
            }
        });
    }

    public String getID() {
        return "AddThoughtsAction";
    }

    protected boolean asynchronous() {
        return false;
    }

    public String getName() {
        return NbBundle.getMessage(((Object)((Object)this)).getClass(), (String)"CTL_AddThoughtsAction");
    }

    public HelpCtx getHelpCtx() {
        return HelpCtx.DEFAULT_HELP;
    }

    public void performAction() {
        Data data = (Data)DataLookup.instance().lookup(Data.class);
        if (data != null) {
            new ThoughtDialog(data).showCreateDialog();
        }
    }
}

