/*
 * Decompiled with CFR 0.152.
 */
package tr.extract.exports.actions;

import java.io.File;
import java.net.URL;
import java.util.List;
import java.util.Vector;
import tr.extract.Extract;
import tr.extract.Param;
import tr.extract.ParamBoolean;
import tr.extract.ParamContext;
import tr.extract.ParamList;
import tr.extract.ParamTopic;
import tr.extract.ParamsDialog;
import tr.model.Data;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExportText
extends Extract {
    public String getID() {
        return "actions-text";
    }

    public String getName() {
        return this.getString("CTL_ExportTextAction");
    }

    public List<Param> getParams() {
        Vector<Param> params = new Vector<Param>(27);
        params.add((Param)new ParamTopic("topic", this.getString("param-topic")));
        params.add((Param)new ParamContext("context", this.getString("param-context")));
        Vector<Param.Item> uptoItems = new Vector<Param.Item>(6);
        uptoItems.add(new Param.Item(this.getString("today"), "today"));
        uptoItems.add(new Param.Item(this.getString("tomorrow"), "tomorrow"));
        uptoItems.add(new Param.Item(this.getString("one-week"), "one-week"));
        uptoItems.add(new Param.Item(this.getString("two-weeks"), "two-weeks"));
        uptoItems.add(new Param.Item(this.getString("three-weeks"), "three-weeks"));
        uptoItems.add(new Param.Item(this.getString("four-weeks"), "four-weeks"));
        params.add((Param)new ParamList("upto", this.getString("param-upto"), uptoItems));
        params.add((Param)new ParamBoolean("include-done", this.getString("param-include-done")));
        params.add((Param)new ParamBoolean("include-inactive", this.getString("param-include-inactive")));
        params.add((Param)new ParamBoolean("include-doasap", this.getString("param-include-doasap")));
        params.add((Param)new ParamBoolean("include-scheduled", this.getString("param-include-scheduled")));
        params.add((Param)new ParamBoolean("include-delegated", this.getString("param-include-delegated")));
        Vector<Param.Item> separatorItems = new Vector<Param.Item>(3);
        separatorItems.add(new Param.Item(this.getString("comma"), "comma"));
        separatorItems.add(new Param.Item(this.getString("semicolon"), "semicolon"));
        separatorItems.add(new Param.Item(this.getString("tab"), "tab"));
        params.add((Param)new ParamList("separator", this.getString("param-separator"), separatorItems));
        Vector<Param.Item> dateFormatItems = new Vector<Param.Item>(2);
        dateFormatItems.add(new Param.Item("YYYYMMDDhhmmss", "f1"));
        dateFormatItems.add(new Param.Item("DAY DD MMM YYYY hh:mm:ss", "f2"));
        params.add((Param)new ParamList("date-format", this.getString("param-date-format"), dateFormatItems));
        Vector<Param.Item> fieldItems = new Vector<Param.Item>(18);
        fieldItems.add(new Param.Item("", "none"));
        fieldItems.add(new Param.Item(this.getString("key"), "field-key"));
        fieldItems.add(new Param.Item(this.getString("desc"), "field-desc"));
        fieldItems.add(new Param.Item(this.getString("notes"), "field-notes"));
        fieldItems.add(new Param.Item(this.getString("created-date"), "field-created"));
        fieldItems.add(new Param.Item(this.getString("done"), "field-done"));
        fieldItems.add(new Param.Item(this.getString("done-date"), "field-done-date"));
        fieldItems.add(new Param.Item(this.getString("thought-key"), "field-thought-key"));
        fieldItems.add(new Param.Item(this.getString("thought-desc"), "field-thought-desc"));
        fieldItems.add(new Param.Item(this.getString("project-key"), "field-parent-key"));
        fieldItems.add(new Param.Item(this.getString("project-desc"), "field-parent-desc"));
        fieldItems.add(new Param.Item(this.getString("topic-key"), "field-topic-key"));
        fieldItems.add(new Param.Item(this.getString("topic-desc"), "field-topic-desc"));
        fieldItems.add(new Param.Item(this.getString("context-key"), "field-context-key"));
        fieldItems.add(new Param.Item(this.getString("context-desc"), "field-context-desc"));
        fieldItems.add(new Param.Item(this.getString("status"), "field-state"));
        fieldItems.add(new Param.Item(this.getString("action-date"), "field-action-date"));
        fieldItems.add(new Param.Item(this.getString("delegated-to"), "field-delegated-to"));
        params.add((Param)new ParamList("field-1", this.getString("param-field-1"), fieldItems));
        params.add((Param)new ParamList("field-2", this.getString("param-field-2"), fieldItems));
        params.add((Param)new ParamList("field-3", this.getString("param-field-3"), fieldItems));
        params.add((Param)new ParamList("field-4", this.getString("param-field-4"), fieldItems));
        params.add((Param)new ParamList("field-5", this.getString("param-field-5"), fieldItems));
        params.add((Param)new ParamList("field-6", this.getString("param-field-6"), fieldItems));
        params.add((Param)new ParamList("field-7", this.getString("param-field-7"), fieldItems));
        params.add((Param)new ParamList("field-8", this.getString("param-field-8"), fieldItems));
        params.add((Param)new ParamList("field-9", this.getString("param-field-9"), fieldItems));
        params.add((Param)new ParamList("field-10", this.getString("param-field-10"), fieldItems));
        params.add((Param)new ParamList("field-11", this.getString("param-field-11"), fieldItems));
        params.add((Param)new ParamList("field-12", this.getString("param-field-12"), fieldItems));
        params.add((Param)new ParamList("field-13", this.getString("param-field-13"), fieldItems));
        params.add((Param)new ParamList("field-14", this.getString("param-field-14"), fieldItems));
        params.add((Param)new ParamList("field-15", this.getString("param-field-15"), fieldItems));
        params.add((Param)new ParamList("field-16", this.getString("param-field-16"), fieldItems));
        params.add((Param)new ParamList("field-17", this.getString("param-field-17"), fieldItems));
        return params;
    }

    public void process(Data data) throws Exception {
        List<Param> params = this.getParams();
        String title = this.getDialogTitleExport(this.getName());
        ParamsDialog dlg = new ParamsDialog(title, this.getID(), params);
        if (dlg.showDialog() == 2) {
            return;
        }
        File xmlfile = this.getTmpFile("data.xml");
        this.extractData(data, xmlfile);
        URL xslURL = ((Object)((Object)this)).getClass().getResource("actions-text.xsl");
        File outfile = this.getOutFile("actions-" + this.getTimeStamp() + ".txt");
        this.transformXSL(xmlfile, xslURL, params, outfile);
        this.openTextFile(outfile);
    }
}

